/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.sdklib.AndroidVersion;
import com.android.tools.configurations.Configuration;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.NlTreeWriterKt;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.model.StudioAndroidModuleInfo;
import com.android.tools.idea.rendering.RenderServiceUtilsKt;
import com.android.tools.idea.rendering.StudioRenderService;
import com.android.tools.idea.rendering.parsers.PsiXmlFile;
import com.android.tools.idea.rendering.parsers.PsiXmlTag;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.android.tools.lint.checks.AnnotationDetectorKt;
import com.android.tools.rendering.RenderResult;
import com.android.tools.rendering.RenderService;
import com.android.tools.rendering.RenderTask;
import com.android.tools.rendering.parsers.RenderXmlFile;
import com.android.tools.rendering.parsers.RenderXmlTag;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewEditorImpl
extends ViewEditor {
    private final Configuration myConfiguration;
    private final NlModel myModel;
    private final SceneManager mySceneManager;
    private final Scene myScene;
    @VisibleForTesting
    private Collection<ViewInfo> myRootViews;

    public ViewEditorImpl(@NotNull SceneView sceneView) {
        this(sceneView.getSceneManager().getModel(), sceneView.getScene());
    }

    public ViewEditorImpl(@NotNull NlModel model, @Nullable Scene scene) {
        this.myConfiguration = model.getConfiguration();
        this.myModel = model;
        this.myScene = scene;
        this.mySceneManager = scene != null ? scene.getSceneManager() : null;
    }

    @Override
    @Nullable
    public AndroidVersion getCompileSdkVersion() {
        return StudioAndroidModuleInfo.getInstance((AndroidFacet)this.myModel.getFacet()).getBuildSdkVersion();
    }

    @Override
    @NotNull
    public AndroidVersion getMinSdkVersion() {
        return StudioAndroidModuleInfo.getInstance((AndroidFacet)this.myModel.getFacet()).getMinSdkVersion();
    }

    @Override
    @NotNull
    public AndroidVersion getTargetSdkVersion() {
        return StudioAndroidModuleInfo.getInstance((AndroidFacet)this.myModel.getFacet()).getTargetSdkVersion();
    }

    @Override
    @NotNull
    public Configuration getConfiguration() {
        return this.myConfiguration;
    }

    @Override
    @NotNull
    public NlModel getModel() {
        return this.myModel;
    }

    @Override
    @NotNull
    public LayoutlibSceneManager getSceneBuilder() {
        assert (this.mySceneManager != null) : "ViewEditorImpl incorrectly configured";
        return (LayoutlibSceneManager)this.mySceneManager;
    }

    @Override
    @NotNull
    public Collection<ViewInfo> getRootViews() {
        if (this.myRootViews != null) {
            return this.myRootViews;
        }
        RenderResult result = this.getSceneBuilder().getRenderResult();
        if (result == null) {
            return Collections.emptyList();
        }
        return result.getRootViews();
    }

    @VisibleForTesting
    public void setRootViews(@NotNull Collection<ViewInfo> rootViews) {
        this.myRootViews = rootViews;
    }

    @Override
    @NotNull
    public CompletableFuture<Map<NlComponent, Dimension>> measureChildren(@NotNull NlComponent parent, @Nullable RenderTask.AttributeFilter filter2) {
        if (!parent.getBackend().isValid()) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        if (parent.getChildCount() == 0) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        HashMap tagToComponent = Maps.newHashMapWithExpectedSize((int)parent.getChildCount());
        for (NlComponent child : parent.getChildren()) {
            tagToComponent.put(child.getTagDeprecated(), child);
        }
        NlModel model = this.myModel;
        XmlFile xmlFile = model.getFile();
        Module module = model.getModule();
        RenderService renderService = StudioRenderService.getInstance((Project)module.getProject());
        CompletableFuture taskFuture = RenderServiceUtilsKt.taskBuilderWithHtmlLogger(renderService, model.getBuildTarget(), this.getConfiguration()).withPsiFile((RenderXmlFile)new PsiXmlFile(xmlFile)).build();
        XmlTag parentTag = parent.getTagDeprecated();
        return taskFuture.thenCompose(task -> {
            if (task == null) {
                return CompletableFuture.completedFuture(Collections.emptyMap());
            }
            return ((CompletableFuture)task.measureChildren((RenderXmlTag)new PsiXmlTag(parentTag), filter2).whenCompleteAsync((map2, ex) -> task.dispose(), (Executor)AppExecutorUtil.getAppExecutorService())).thenApply(map2 -> {
                if (map2 == null) {
                    return Collections.emptyMap();
                }
                HashMap unweightedSizes = Maps.newHashMap();
                for (Map.Entry entry : map2.entrySet()) {
                    ViewInfo viewInfo = (ViewInfo)entry.getValue();
                    viewInfo = RenderService.getSafeBounds((ViewInfo)viewInfo);
                    Dimension size = new Dimension(viewInfo.getRight() - viewInfo.getLeft(), viewInfo.getBottom() - viewInfo.getTop());
                    NlComponent child = (NlComponent)tagToComponent.get(entry.getKey());
                    if (child == null) continue;
                    unweightedSizes.put(child, size);
                }
                return unweightedSizes;
            });
        });
    }

    @VisibleForTesting
    static boolean isPublicAndUnRestricted(@NotNull PsiClass psiClass) {
        PsiModifierList modifiers = psiClass.getModifierList();
        if (modifiers == null) {
            return false;
        }
        if (!modifiers.hasModifierProperty("public")) {
            return false;
        }
        for (PsiAnnotation annotation : modifiers.getAnnotations()) {
            if (!AnnotationDetectorKt.RESTRICT_TO_ANNOTATION.isEquals(annotation.getQualifiedName())) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Scene getScene() {
        assert (this.myScene != null) : "ViewEditorImpl incorrectly configured";
        return this.myScene;
    }

    @Override
    public boolean canInsertChildren(@NotNull NlComponent parent, @NotNull List<NlComponent> children, int index) {
        return this.getModel().getTreeWriter().canAddComponents(children, parent, ViewEditorImpl.getChild(parent, index));
    }

    @Override
    public void insertChildren(@NotNull NlComponent parent, @NotNull List<NlComponent> children, int index, @NotNull InsertType insertType) {
        NlTreeWriterKt.addComponentsAndSelectedIfCreated(this.getModel().getTreeWriter(), children, parent, ViewEditorImpl.getChild(parent, index), insertType, this.myScene.getDesignSurface().getSelectionModel());
    }

    @Nullable
    private static NlComponent getChild(@NotNull NlComponent parent, int index) {
        return 0 <= index && index < parent.getChildCount() ? parent.getChild(index) : null;
    }

    @Override
    public boolean moduleDependsOnAppCompat() {
        return DependencyManagementUtil.dependsOnAppCompat((Module)this.myModel.getModule());
    }
}

