/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.actions.ViewAction;
import com.android.tools.idea.uibuilder.handlers.BuiltinViewHandlerProvider;
import com.android.tools.idea.uibuilder.handlers.MergeDelegateHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerProvider;
import com.android.tools.idea.uibuilder.menu.MenuViewHandlerManager;
import com.android.tools.idea.uibuilder.model.ClassResolutionUtilsKt;
import com.android.tools.idea.uibuilder.model.NlComponentHelper;
import com.android.tools.idea.uibuilder.statelist.ItemHandler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
public final class ViewHandlerManager
implements Disposable {
    @VisibleForTesting
    static final ExtensionPointName<ViewHandlerProvider> EP_NAME = ExtensionPointName.create((String)"com.android.tools.idea.uibuilder.handlers.viewHandlerProvider");
    private static final String HANDLER_CLASS_SUFFIX = "Handler";
    private static final Runnable SUPER_CLASS_LOOKUP = () -> {};
    private final Project myProject;
    private final Map<String, ViewHandler> myHandlers = Collections.synchronizedMap(Maps.newHashMap());
    private final Map<ViewHandler, List<ViewAction>> myToolbarActions = Maps.newHashMap();
    private final Map<ViewHandler, List<ViewAction>> myMenuActions = Maps.newHashMap();
    public static final ViewHandler NONE = new ViewHandler();
    public static final ViewHandler TEMP = new ViewHandler();

    @NotNull
    public static ViewHandlerManager get(@NotNull Project project) {
        ViewHandlerManager manager = (ViewHandlerManager)project.getService(ViewHandlerManager.class);
        assert (manager != null);
        return manager;
    }

    @NotNull
    public static ViewHandlerManager get(@NotNull AndroidFacet facet) {
        return ViewHandlerManager.get(facet.getModule().getProject());
    }

    public ViewHandlerManager(@NotNull Project project) {
        this.myProject = project;
    }

    @Nullable
    public ViewHandler getHandler(@NotNull NlComponent component, @NotNull Runnable handlerUpdated) {
        ViewHandler handler = this.getHandlerOrDefault(component, handlerUpdated);
        return handler != NONE && handler != TEMP ? handler : null;
    }

    @NotNull
    public ViewHandler getHandlerOrDefault(@NotNull NlComponent component, @NotNull Runnable handlerUpdated) {
        String tag;
        switch (tag = component.getTagName()) {
            case "item": {
                ViewHandler handler = MenuViewHandlerManager.getHandler(component);
                if (handler != null) {
                    return handler;
                }
                return new ItemHandler();
            }
            case "merge": {
                ViewHandler groupHandler;
                String parentTag = component.getAttribute("http://schemas.android.com/tools", "parentTag");
                if (parentTag != null && (groupHandler = this.getHandlerOrDefault(parentTag, handlerUpdated)) instanceof ViewGroupHandler) {
                    return new MergeDelegateHandler((ViewGroupHandler)groupHandler);
                }
                return this.getHandlerOrDefault("merge", handlerUpdated);
            }
        }
        return this.getHandlerOrDefault(tag, handlerUpdated);
    }

    @Nullable
    public ViewHandler getHandler(@NotNull String viewTag, @NotNull Runnable handlerUpdated) {
        ViewHandler handler = this.getHandlerOrDefault(viewTag, handlerUpdated);
        return handler != NONE && handler != TEMP ? handler : null;
    }

    @NotNull
    public ViewHandler getHandlerOrDefault(@NotNull String viewTag, @NotNull Runnable handlerUpdated) {
        ViewHandler handler = this.myHandlers.get(viewTag);
        if (handler == null || handler == TEMP && handlerUpdated == SUPER_CLASS_LOOKUP) {
            String tag;
            if (viewTag.indexOf(46) != -1 && !(tag = NlComponentHelper.INSTANCE.viewClassToTag(viewTag)).equals(viewTag)) {
                handler = this.getHandlerOrDefault(tag, handlerUpdated);
                this.myHandlers.put(viewTag, handler);
                return handler;
            }
            handler = this.createHandler(viewTag, handlerUpdated);
            this.myHandlers.put(viewTag, handler);
        }
        return handler;
    }

    public void registerHandler(@NotNull String viewTag, @NotNull ViewHandler handler) {
        this.myHandlers.put(viewTag, handler);
    }

    @Nullable
    public ViewGroupHandler findLayoutHandler(@NotNull NlComponent component, boolean strict, @NotNull Runnable handlerUpdated) {
        NlComponent curr = component;
        if (strict) {
            curr = curr.getParent();
        }
        while (curr != null) {
            ViewHandler handler = this.getHandler(curr, handlerUpdated);
            if (handler instanceof ViewGroupHandler) {
                return (ViewGroupHandler)handler;
            }
            curr = curr.getParent();
        }
        return null;
    }

    @NotNull
    private ViewHandler createHandler(@NotNull String viewTag, @NotNull Runnable handlerUpdated) {
        ViewHandler builtInHandler = BuiltinViewHandlerProvider.INSTANCE.findHandler(viewTag);
        if (builtInHandler != null) {
            return builtInHandler;
        }
        ViewHandler extensionHandler = EP_NAME.getExtensionList((AreaInstance)this.myProject).stream().map(extension -> extension.findHandler(viewTag)).filter(Objects::nonNull).limit(2L).reduce(null, (a, b) -> {
            if (a != null && b != null) {
                Logger.getInstance(ViewHandler.class).warn("Multiple ViewHandlers returned by extensions for tag " + viewTag);
                return a;
            }
            return a != null ? a : b;
        });
        if (extensionHandler != null) {
            return extensionHandler;
        }
        Logger.getInstance(ViewHandler.class).debug("No built-in or extension defined ViewHandlers found for " + viewTag);
        try {
            String defaultHandlerPkgPrefix = "com.android.tools.idea.uibuilder.handlers.";
            String handlerClass = defaultHandlerPkgPrefix + viewTag + HANDLER_CLASS_SUFFIX;
            Class<?> cls = Class.forName(handlerClass);
            return (ViewHandler)cls.newInstance();
        }
        catch (Exception exception) {
            if (handlerUpdated == SUPER_CLASS_LOOKUP || !ApplicationManager.getApplication().isDispatchThread()) {
                return this.createViaIndexLookup(viewTag, null);
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> this.createViaIndexLookup(viewTag, handlerUpdated));
            return TEMP;
        }
    }

    @NotNull
    private ViewHandler createViaIndexLookup(@NotNull String viewTag, @Nullable Runnable handlerUpdated) {
        if (this.myProject.isDisposed()) {
            return NONE;
        }
        Logger.getInstance(ViewHandler.class).debug("Looking for user code defined handlers for " + viewTag);
        return (ViewHandler)ReadAction.nonBlocking(() -> {
            if (this.myProject.isDisposed()) {
                return NONE;
            }
            try {
                PsiClass[] viewClasses = ClassResolutionUtilsKt.findClassesForViewTag(this.myProject, viewTag);
                if (viewClasses.length > 0) {
                    String handlerName = viewTag + HANDLER_CLASS_SUFFIX;
                    PsiClass[] handlerClasses = JavaPsiFacade.getInstance((Project)this.myProject).findClasses(handlerName, GlobalSearchScope.allScope((Project)this.myProject));
                    if (handlerClasses.length == 0) {
                        for (PsiClass cls : viewClasses) {
                            String fqn;
                            PsiClass superClass = cls.getSuperClass();
                            if (superClass == null || (fqn = superClass.getQualifiedName()) == null) continue;
                            ViewHandler handler = this.getHandlerOrDefault(NlComponentHelper.INSTANCE.viewClassToTag(fqn), SUPER_CLASS_LOOKUP);
                            if (handler == TEMP) {
                                Logger.getInstance(ViewHandler.class).warn("Unexpectedly got: TEMP for: " + viewTag);
                                handler = NONE;
                            }
                            if (handler != NONE && handlerUpdated != null) {
                                handlerUpdated.run();
                            }
                            this.myHandlers.put(viewTag, handler);
                            return handler;
                        }
                    } else {
                        for (PsiClass cls : handlerClasses) {
                            Logger.getInstance(ViewHandler.class).debug(String.format("Found view handler %s  of type %s", cls.getQualifiedName(), cls.getClass().getName()));
                        }
                    }
                }
            }
            catch (IndexNotReadyException ignore) {
                this.myHandlers.put(viewTag, NONE);
                return NONE;
            }
            this.myHandlers.put(viewTag, NONE);
            return NONE;
        }).executeSynchronously();
    }

    @UiThread
    @NotNull
    public List<ViewAction> getToolbarActions(@NotNull ViewHandler handler) {
        List<ViewAction> actions2 = this.myToolbarActions.get(handler);
        if (actions2 == null) {
            actions2 = new ArrayList<ViewAction>();
            handler.addToolbarActions(actions2);
            this.myToolbarActions.put(handler, actions2);
        }
        return actions2;
    }

    @UiThread
    @NotNull
    public List<ViewAction> getPopupMenuActions(@NotNull SceneComponent component, @NotNull ViewHandler handler) {
        List<ViewAction> actions2 = this.myMenuActions.get(handler);
        if (actions2 == null && handler.addPopupMenuActions(component, actions2 = new ArrayList<ViewAction>())) {
            this.myMenuActions.put(handler, actions2);
        }
        return actions2;
    }

    public void dispose() {
        this.myHandlers.clear();
    }

    @TestOnly
    void clearCache() {
        this.myHandlers.clear();
    }
}

