/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.tools.adtui.common.AdtSecondaryPanel;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.draw.ColorSet;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.uibuilder.api.CustomPanel;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.ScrollToViewFocusListener;
import com.android.tools.idea.uibuilder.handlers.constraint.SingleWidgetView;
import com.android.tools.idea.uibuilder.handlers.constraint.WidgetConstraintModel;
import com.android.tools.idea.uibuilder.handlers.constraint.WidgetConstraintSection;
import com.android.tools.idea.uibuilder.handlers.constraint.WidgetSection;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.BlueprintColorSet;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSliderUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WidgetConstraintPanel
extends AdtSecondaryPanel
implements CustomPanel {
    private static final String PANEL_TITLE = "Constraint Widget";
    private static final String HORIZONTAL_TOOL_TIP_TEXT = "Horizontal Bias";
    private static final String VERTICAL_TOOL_TIP_TEXT = "Vertical Bias";
    private static final Color mSliderColor = new JBColor(0xC9C9C9, 2369063);
    private static final int PANEL_WIDTH = 280;
    private static final int PANEL_HEIGHT = 215;
    private static final int PANEL_TITLE_HEIGHT = 20;
    private static final Color STROKE_COLOR = JBColor.namedColor((String)"UIDesigner.stroke.acceleratorForeground", (Color)new JBColor(0x8A8A8A, 0x808080));
    private static final Color HIGH_STROKE_COLOR = JBColor.namedColor((String)"UIDesigner.highStroke.foreground", (Color)new JBColor(0xB0B0B0, 7303537));
    private static final Color THUMB_CIRCLE_COLOR = JBColor.namedColor((String)"UIDesigner.percent.foreground", (Color)new JBColor((Color)Gray._192, (Color)Gray._128));
    private final AdtSecondaryPanel myCustomPanel = new AdtSecondaryPanel((LayoutManager)new BorderLayout());
    @NotNull
    private final SingleWidgetView mMain;
    protected JLabel mTitle;
    private final JSlider mVerticalSlider = new JSlider(1);
    private final JSlider mHorizontalSlider = new JSlider(0);
    @NotNull
    private final WidgetSection myConstraintSection;
    private final InspectorColorSet mColorSet = new InspectorColorSet();
    private static final int UNCONNECTED = -1;
    private static final int SLIDER_DEFAULT = 50;
    public static final String VERTICAL_BIAS_SLIDER = "verticalBiasSlider";
    public static final String HORIZONTAL_BIAS_SLIDER = "horizontalBiasSlider";
    private final WidgetConstraintModel myWidgetModel = this.getWidgetModel(() -> this.configureUI());
    private boolean myInitialized;
    @NotNull
    MouseListener mDoubleClickListener = new MouseAdapter(this){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                ((JSlider)e.getSource()).setValue(50);
            }
        }
    };

    protected WidgetConstraintModel getWidgetModel(Runnable modelUpdate) {
        return new WidgetConstraintModel(modelUpdate);
    }

    public WidgetConstraintPanel(@NotNull List<NlComponent> components) {
        super(null);
        this.mMain = new SingleWidgetView(this.mColorSet, this.myWidgetModel);
        this.mMain.setOpaque(false);
        this.mMain.setBackground((Color)StudioColorsKt.getSecondaryPanelBackground());
        this.myConstraintSection = new WidgetConstraintSection(this.myWidgetModel);
        this.myConstraintSection.setOpaque(false);
        this.setPreferredSize((Dimension)JBUI.size((int)280, (int)215));
        this.mVerticalSlider.setMajorTickSpacing(50);
        this.mHorizontalSlider.setMajorTickSpacing(50);
        this.mHorizontalSlider.setToolTipText(HORIZONTAL_TOOL_TIP_TEXT);
        this.mVerticalSlider.setToolTipText(VERTICAL_TOOL_TIP_TEXT);
        this.mVerticalSlider.setName(VERTICAL_BIAS_SLIDER);
        this.mHorizontalSlider.setName(HORIZONTAL_BIAS_SLIDER);
        this.myWidgetModel.setComponent(components.isEmpty() ? null : components.get(0));
        this.mVerticalSlider.addFocusListener(new ScrollToViewFocusListener(this.mVerticalSlider));
        this.mHorizontalSlider.addFocusListener(new ScrollToViewFocusListener(this.mHorizontalSlider));
        this.mTitle = new JLabel(PANEL_TITLE);
        this.mTitle.setSize((Dimension)JBUI.size((int)280, (int)20));
        this.mTitle.setBorder((Border)JBUI.Borders.emptyLeft((int)8));
        this.add(this.mTitle);
        this.add(this.mVerticalSlider);
        this.add(this.mMain);
        this.add(this.mHorizontalSlider);
        this.mVerticalSlider.setUI(new WidgetSliderUI(this.mVerticalSlider, this.mColorSet));
        this.mHorizontalSlider.setUI(new WidgetSliderUI(this.mHorizontalSlider, this.mColorSet));
        this.mHorizontalSlider.setBackground((Color)StudioColorsKt.getSecondaryPanelBackground());
        this.mVerticalSlider.setBackground((Color)StudioColorsKt.getSecondaryPanelBackground());
        this.mHorizontalSlider.setForeground(mSliderColor);
        this.mVerticalSlider.setForeground(mSliderColor);
        this.mHorizontalSlider.addChangeListener(e -> this.myWidgetModel.setHorizontalBias(this.mHorizontalSlider.getValue()));
        this.mVerticalSlider.addChangeListener(e -> this.myWidgetModel.setVerticalBias(this.mVerticalSlider.getValue()));
        this.mHorizontalSlider.addMouseListener(this.mDoubleClickListener);
        this.mVerticalSlider.addMouseListener(this.mDoubleClickListener);
        this.configureUI();
        this.myCustomPanel.add((Component)((Object)this), (Object)"North");
        this.myCustomPanel.add((Component)((Object)this.myConstraintSection), (Object)"Center");
        this.myCustomPanel.add((Component)((Object)new MySeparator()), (Object)"South");
        ConstraintUtilities.registerAttributeHelp(this.mVerticalSlider, this.myWidgetModel::getVerticalBiasAttribute);
        ConstraintUtilities.registerAttributeHelp(this.mHorizontalSlider, this.myWidgetModel::getHorizontalBiasAttribute);
        this.myInitialized = true;
    }

    public void doLayout() {
        int width = this.getWidth();
        int height = this.getHeight();
        Dimension mainSize = this.mMain.getPreferredSize();
        Dimension HSliderSize = this.mHorizontalSlider.getPreferredSize();
        Dimension VSliderSize = this.mVerticalSlider.getPreferredSize();
        int mainX = (width - mainSize.width) / 2;
        int mainY = (height - mainSize.height) / 2;
        this.mMain.setBounds(mainX, mainY, mainSize.width, mainSize.height);
        this.mHorizontalSlider.setBounds((width - HSliderSize.width) / 2, mainY + mainSize.height, HSliderSize.width, HSliderSize.height);
        this.mVerticalSlider.setBounds(mainX - VSliderSize.width, (height - VSliderSize.height) / 2, VSliderSize.width, VSliderSize.height);
    }

    public void updateUI() {
        super.updateUI();
        if (this.myInitialized) {
            this.setPreferredSize((Dimension)JBUI.size((int)280, (int)215));
            this.mTitle.setSize((Dimension)JBUI.size((int)280, (int)20));
            this.mTitle.setBorder((Border)JBUI.Borders.emptyLeft((int)8));
            this.mVerticalSlider.setUI(new WidgetSliderUI(this.mVerticalSlider, this.mColorSet));
            this.mHorizontalSlider.setUI(new WidgetSliderUI(this.mHorizontalSlider, this.mColorSet));
        }
    }

    @Override
    @NotNull
    public JPanel getPanel() {
        return this.myCustomPanel;
    }

    @Override
    public void useComponent(@Nullable NlComponent component, @Nullable DesignSurface<?> surface2) {
        this.myWidgetModel.setSurface(surface2);
        this.myWidgetModel.setComponent(component);
        this.myConstraintSection.configureUi();
    }

    @Override
    public void refresh() {
        this.configureUI();
    }

    private void configureUI() {
        float bias;
        boolean showHorizontalSlider;
        NlComponent component = this.myWidgetModel.getComponent();
        if (component == null) {
            return;
        }
        int top = this.myWidgetModel.getMargin(2);
        int left = this.myWidgetModel.getMargin(0);
        int right = this.myWidgetModel.getMargin(1);
        int bottom = this.myWidgetModel.getMargin(3);
        String ratioString = this.myWidgetModel.getRatioString();
        boolean baseline = this.myWidgetModel.hasBaseline();
        boolean showVerticalSlider = bottom != -1 && top != -1;
        boolean bl = showHorizontalSlider = left != -1 && right != -1;
        if (showHorizontalSlider) {
            bias = this.myWidgetModel.getHorizontalBias();
            this.mHorizontalSlider.setValue((int)(bias * 100.0f));
            this.mHorizontalSlider.setInverted(ConstraintUtilities.isInRTL(component));
        }
        if (showVerticalSlider) {
            bias = this.myWidgetModel.getVerticalBias();
            this.mVerticalSlider.setValue(100 - (int)(bias * 100.0f));
        }
        this.mVerticalSlider.setEnabled(showVerticalSlider);
        this.mHorizontalSlider.setEnabled(showHorizontalSlider);
        this.mHorizontalSlider.invalidate();
        this.mVerticalSlider.invalidate();
        this.mVerticalSlider.setToolTipText(showVerticalSlider ? VERTICAL_TOOL_TIP_TEXT : null);
        this.mHorizontalSlider.setToolTipText(showHorizontalSlider ? HORIZONTAL_TOOL_TIP_TEXT : null);
        int widthValue = this.myWidgetModel.convertFromNL("layout_width");
        int heightValue = this.myWidgetModel.convertFromNL("layout_height");
        this.mMain.configureUi(bottom, top, left, right, baseline, widthValue, heightValue, ratioString);
        this.myConstraintSection.configureUi();
    }

    static class InspectorColorSet
    extends BlueprintColorSet {
        InspectorColorSet() {
            this.mDrawBackground = false;
            this.mDrawWidgetInfos = true;
            this.mInspectorBackgroundColor = StudioColorsKt.getSecondaryPanelBackground();
            this.mInspectorFillColor = StudioColorsKt.getSecondaryPanelBackground();
            this.mInspectorHighlightsStrokeColor = HIGH_STROKE_COLOR;
            this.mInspectorStrokeColor = STROKE_COLOR;
            this.mInspectorConstraintColor = new JBColor(4489688, 4751560);
        }
    }

    static class WidgetSliderUI
    extends BasicSliderUI {
        private final JBDimension THUMB_SIZE = JBUI.size((int)18);
        private final int TRACK_THICKNESS = JBUI.scale((int)5);
        private final int ARC_SIZE = JBUI.scale((int)2);
        private final int SLIDER_LENGTH = JBUI.scale((int)120);
        private final Dimension V_SIZE;
        private final Dimension H_SIZE;
        @NotNull
        private Font SMALL_FONT;
        private ColorSet mColorSet;

        WidgetSliderUI(JSlider s, ColorSet colorSet) {
            super(s);
            this.V_SIZE = new Dimension(this.THUMB_SIZE.width, this.SLIDER_LENGTH);
            this.H_SIZE = new Dimension(this.SLIDER_LENGTH, this.THUMB_SIZE.height);
            this.SMALL_FONT = new Font("Helvetica", 0, JBUI.scaleFontSize((float)10.0f));
            this.mColorSet = colorSet;
        }

        @Override
        public Dimension getPreferredHorizontalSize() {
            return this.H_SIZE;
        }

        @Override
        public Dimension getPreferredVerticalSize() {
            return this.V_SIZE;
        }

        @Override
        @NotNull
        protected Dimension getThumbSize() {
            return this.THUMB_SIZE;
        }

        @Override
        public void paintTrack(Graphics g) {
            if (this.slider.isEnabled()) {
                g.setColor(this.slider.getForeground());
                int trackThickness = this.TRACK_THICKNESS;
                if (this.slider.getOrientation() == 1) {
                    int offset = this.trackRect.width / 2 - trackThickness / 2;
                    g.fillRoundRect(this.trackRect.x + offset, this.trackRect.y, trackThickness, this.trackRect.height, this.ARC_SIZE, this.ARC_SIZE);
                } else {
                    int offset = this.trackRect.height / 2 - trackThickness / 2;
                    g.fillRoundRect(this.trackRect.x, this.trackRect.y + offset, this.trackRect.width, trackThickness, this.ARC_SIZE, this.ARC_SIZE);
                }
            }
        }

        @Override
        protected Color getShadowColor() {
            return this.mColorSet.getInspectorStrokeColor();
        }

        @Override
        protected Color getHighlightColor() {
            return this.mColorSet.getInspectorStrokeColor();
        }

        @Override
        @NotNull
        protected Color getFocusColor() {
            return JBColor.BLACK;
        }

        @Override
        public void paintThumb(Graphics g) {
            String percentText = this.slider.getOrientation() == 1 ? Integer.toString(100 - this.slider.getValue()) : Integer.toString(this.slider.getValue());
            if (!this.slider.isEnabled()) {
                return;
            }
            g.setColor(this.mColorSet.getInspectorFillColor().brighter());
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.fillRoundRect(this.thumbRect.x, this.thumbRect.y, this.thumbRect.width - 1, this.thumbRect.height - 1, this.thumbRect.width, this.thumbRect.height);
            g.setColor(THUMB_CIRCLE_COLOR);
            g.drawRoundRect(this.thumbRect.x, this.thumbRect.y, this.thumbRect.width - 1, this.thumbRect.height - 1, this.thumbRect.width, this.thumbRect.height);
            g.setColor(this.mColorSet.getInspectorHighlightsStrokeColor());
            int x = this.thumbRect.x + this.thumbRect.width / 2;
            int y = this.thumbRect.y + this.thumbRect.height / 2;
            g.setFont(this.SMALL_FONT);
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D bounds2 = fm.getStringBounds(percentText, g);
            double tw = bounds2.getWidth();
            g.drawString(percentText, (int)((double)x - tw / 2.0), y + fm.getAscent() / 2);
        }
    }

    private static class MySeparator
    extends AdtSecondaryPanel {
        MySeparator() {
            super((LayoutManager)new BorderLayout());
            this.add(new JSeparator(0), "Center");
        }

        public void updateUI() {
            super.updateUI();
            this.setBorder(JBUI.Borders.empty((int)4));
        }
    }
}

