/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.ColorSet;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawRegion;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawConnectionUtils;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class DrawVerticalGuideline
extends DrawRegion {
    private static final int GAP = 40;
    private int myBegin;
    private int myEnd;
    private float myPercent;
    private int myOriginX;
    private int myOriginY;
    private int myOriginWidth;
    private boolean myIsSelected;
    protected Font mFont = new Font("Helvetica", 0, 14);

    public DrawVerticalGuideline(String s) {
        super(s);
        this.myBegin = -1;
        this.myEnd = -1;
        this.myPercent = 0.5f;
    }

    public DrawVerticalGuideline(int x, int y, int height, int originX, int originY, int originWidth, int begin, int end, float percent, boolean selected) {
        super(x, y, x, height);
        this.myBegin = begin;
        this.myEnd = end;
        this.myPercent = percent;
        this.myOriginX = originX;
        this.myOriginY = originY;
        this.myOriginWidth = originWidth;
        this.myIsSelected = selected;
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        ColorSet colorSet = sceneContext.getColorSet();
        Stroke stroke = g.getStroke();
        if (this.myIsSelected) {
            g.setColor(colorSet.getSelectedFrames());
        } else {
            g.setColor(colorSet.getFrames());
        }
        g.setStroke(DrawConnectionUtils.sDashedStroke);
        g.drawLine(this.x, this.y, this.x, this.y + this.height);
        g.setStroke(stroke);
        int gap = 48;
        if (this.myIsSelected) {
            if (this.myBegin != -1) {
                DrawConnectionUtils.drawHorizontalMarginIndicator(g, String.valueOf(this.myBegin), false, this.myOriginX, this.x, this.myOriginY + 40);
            } else if (this.myEnd != -1) {
                DrawConnectionUtils.drawHorizontalMarginIndicator(g, String.valueOf(this.myEnd), false, this.x, this.myOriginX + this.myOriginWidth, this.myOriginY + 40);
            } else {
                String percent = String.valueOf((int)(this.myPercent * 100.0f)) + " %";
                g.setColor(colorSet.getFrames());
                DrawConnectionUtils.drawRoundRectText(g, this.mFont, colorSet.getText(), percent, this.x, this.y + gap);
            }
        }
    }

    public static void add(DisplayList list, SceneContext transform, float left, float top, float bottom) {
        DrawVerticalGuideline.add(list, transform, left, top, bottom, -1.0f, -1.0f, -1.0f, -1, -1, 1.0f, false);
    }

    public static void add(DisplayList list, SceneContext transform, float left, float top, float bottom, float originX, float originY, float originWidth, int begin, int end, float percent, boolean selected) {
        int l = transform.getSwingXDip(left);
        int t = transform.getSwingYDip(top);
        int h = transform.getSwingDimensionDip(bottom - top);
        int ox = transform.getSwingXDip(originX);
        int oy = transform.getSwingYDip(originY);
        int ow = transform.getSwingDimensionDip(originWidth);
        list.add(new DrawVerticalGuideline(l, t, h, ox, oy, ow, begin, end, percent, selected));
    }
}

