/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.annotations.concurrency.AnyThread;
import com.android.annotations.concurrency.UiThread;
import com.android.tools.adtui.common.AdtSecondaryPanel;
import com.android.tools.adtui.workbench.ToolContent;
import com.android.tools.adtui.workbench.ToolWindowCallback;
import com.android.tools.configurations.Configuration;
import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.DnDTransferComponent;
import com.android.tools.idea.common.model.DnDTransferItem;
import com.android.tools.idea.common.model.ItemTransferable;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.NlTreeWriter;
import com.android.tools.idea.common.model.NlTreeWriterKt;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.uibuilder.actions.ComponentHelpAction;
import com.android.tools.idea.uibuilder.analytics.NlUsageTracker;
import com.android.tools.idea.uibuilder.palette.CategoryList;
import com.android.tools.idea.uibuilder.palette.DataModel;
import com.android.tools.idea.uibuilder.palette.DependencyManager;
import com.android.tools.idea.uibuilder.palette.ItemList;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.android.tools.idea.uibuilder.palette.PreviewProvider;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.type.LayoutEditorFileType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbModeBlockedFunctionality;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@UiThread
public class PalettePanel
extends AdtSecondaryPanel
implements Disposable,
UiDataProvider,
ToolContent<DesignSurface<?>> {
    private static final int DOWNLOAD_WIDTH = 16;
    private static final int VERTICAL_SCROLLING_UNIT_INCREMENT = 50;
    private static final int VERTICAL_SCROLLING_BLOCK_INCREMENT = 25;
    private final Project myProject;
    private final DependencyManager myDependencyManager;
    private final DataModel myDataModel;
    private final CopyProvider myCopyProvider;
    private final CategoryList myCategoryList;
    private final JScrollPane myCategoryScrollPane;
    private final ItemList myItemList;
    private final AddToDesignAction myAddToDesignAction;
    private final FavoriteAction myFavoriteAction;
    private final ComponentHelpAction myAndroidDocAction;
    private final MaterialDocAction myMaterialDocAction;
    private final ActionGroup myActionGroup;
    private final KeyListener myFilterKeyListener;
    @NotNull
    private WeakReference<DesignSurface<?>> myDesignSurface = new WeakReference<Object>(null);
    private LayoutEditorFileType myLayoutType;
    private ToolWindowCallback myToolWindow;
    private Palette.Group myLastSelectedGroup;

    public PalettePanel(@NotNull Project project, @NotNull Disposable parentDisposable) {
        this(project, new DependencyManager(project), parentDisposable);
    }

    @VisibleForTesting
    PalettePanel(@NotNull Project project, @NotNull DependencyManager dependencyManager, @NotNull Disposable parentDisposable) {
        super((LayoutManager)new BorderLayout());
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myProject = project;
        this.myDependencyManager = dependencyManager;
        this.myDataModel = new DataModel(this, this.myDependencyManager);
        this.myDependencyManager.addDependencyChangeListener(() -> this.repaint());
        this.myCopyProvider = new CopyProviderImpl();
        Disposer.register((Disposable)this, (Disposable)dependencyManager);
        this.myCategoryList = new CategoryList();
        this.myItemList = new ItemList(this.myDependencyManager);
        this.myAddToDesignAction = new AddToDesignAction();
        this.myFavoriteAction = new FavoriteAction();
        this.myAndroidDocAction = new ComponentHelpAction(this::getSelectedTagName);
        this.myMaterialDocAction = new MaterialDocAction();
        this.myActionGroup = this.createPopupActionGroup();
        this.myCategoryScrollPane = PalettePanel.createScrollPane((JComponent)((Object)this.myCategoryList));
        this.add(this.myCategoryScrollPane, "West");
        this.add(PalettePanel.createScrollPane((JComponent)((Object)this.myItemList)), "Center");
        this.myFilterKeyListener = this.createFilterKeyListener();
        KeyListener keyListener2 = this.createKeyListener();
        this.myCategoryList.addListSelectionListener(event -> this.categorySelectionChanged());
        this.myCategoryList.setModel(this.myDataModel.getCategoryListModel());
        this.myCategoryList.addKeyListener(keyListener2);
        this.myCategoryList.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)0, (int)0, (int)1));
        PreviewProvider provider = new PreviewProvider(() -> (DesignSurface)this.myDesignSurface.get(), this.myDependencyManager);
        this.myItemList.setModel(this.myDataModel.getItemListModel());
        this.myItemList.setTransferHandler(new ItemTransferHandler(provider, () -> this.myItemList.getSelectedValue()));
        if (!GraphicsEnvironment.isHeadless()) {
            this.myItemList.setDragEnabled(true);
        }
        this.myItemList.addMouseListener(this.createItemListMouseListener());
        this.myItemList.addKeyListener(keyListener2);
        this.registerKeyboardActions();
        this.myLastSelectedGroup = DataModel.COMMON;
    }

    @NotNull
    @TestOnly
    AnAction getAddToDesignAction() {
        return this.myAddToDesignAction;
    }

    @NotNull
    @TestOnly
    AnAction getAndroidDocAction() {
        return this.myAndroidDocAction;
    }

    @NotNull
    @TestOnly
    AnAction getMaterialDocAction() {
        return this.myMaterialDocAction;
    }

    @NotNull
    private static JScrollPane createScrollPane(@NotNull JComponent component) {
        JScrollPane scrollPane2 = ScrollPaneFactory.createScrollPane((Component)component, (int)20, (int)31);
        scrollPane2.getVerticalScrollBar().setUnitIncrement(50);
        scrollPane2.getVerticalScrollBar().setBlockIncrement(25);
        scrollPane2.setBorder(BorderFactory.createEmptyBorder());
        return scrollPane2;
    }

    @NotNull
    private MouseListener createItemListMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent event) {
                if (event.isPopupTrigger()) {
                    this.showPopupMenu(event);
                }
            }

            @Override
            public void mouseReleased(@NotNull MouseEvent event) {
                if (event.isPopupTrigger()) {
                    this.showPopupMenu(event);
                } else if (SwingUtilities.isLeftMouseButton(event) && !event.isControlDown()) {
                    this.mouseClick(event);
                }
            }

            private void mouseClick(@NotNull MouseEvent event) {
                int width;
                Rectangle rect = PalettePanel.this.myItemList.getCellBounds(0, 0);
                int n = width = rect != null ? rect.width : PalettePanel.this.myItemList.getWidth();
                if (event.getX() < width - JBUI.scale((int)16) || event.getX() >= PalettePanel.this.myItemList.getWidth()) {
                    return;
                }
                int index = PalettePanel.this.myItemList.locationToIndex(event.getPoint());
                Palette.Item item = (Palette.Item)PalettePanel.this.myItemList.getModel().getElementAt(index);
                PalettePanel.this.myDependencyManager.ensureLibraryIsIncluded(item);
            }

            private void showPopupMenu(@NotNull MouseEvent event) {
                if (PalettePanel.this.myItemList.isEmpty()) {
                    return;
                }
                PalettePanel.this.myItemList.setSelectedIndex(PalettePanel.this.myItemList.locationToIndex(event.getPoint()));
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)PalettePanel.this.myItemList));
                JBPopupFactory.getInstance().createActionGroupPopup(null, PalettePanel.this.myActionGroup, dataContext, null, true).show(new RelativePoint(event));
            }
        };
    }

    @NotNull
    private KeyListener createKeyListener() {
        return new KeyAdapter(){

            @Override
            public void keyTyped(@NotNull KeyEvent event) {
                if (Character.isAlphabetic(event.getKeyChar())) {
                    PalettePanel.this.startFiltering(String.valueOf(event.getKeyChar()));
                }
            }
        };
    }

    private void registerKeyboardActions() {
        this.myItemList.registerKeyboardAction(event -> this.keyboardActionPerformed(event, this.myAddToDesignAction), KeyStroke.getKeyStroke(10, 0), 1);
        this.myItemList.registerKeyboardAction(event -> this.keyboardActionPerformed(event, this.myAndroidDocAction), KeyStroke.getKeyStroke(112, 64), 1);
    }

    private void startFiltering(@NotNull String initialSearchString) {
        if (this.myToolWindow != null) {
            this.myToolWindow.startFiltering(initialSearchString);
        }
    }

    private void keyboardActionPerformed(@NotNull ActionEvent event, @NotNull AnAction action2) {
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)this));
        InputEvent inputEvent = event.getSource() instanceof InputEvent ? (InputEvent)event.getSource() : null;
        action2.actionPerformed(AnActionEvent.createEvent((AnAction)action2, (DataContext)dataContext, null, (String)"ToolwindowPopup", (ActionUiKind)ActionUiKind.POPUP, (InputEvent)inputEvent));
    }

    @NotNull
    private ActionGroup createPopupActionGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)this.myAddToDesignAction);
        group.add((AnAction)this.myFavoriteAction);
        group.addSeparator();
        group.add((AnAction)this.myAndroidDocAction);
        group.add((AnAction)this.myMaterialDocAction);
        return group;
    }

    @Nullable
    private String getSelectedTagName() {
        Palette.Item item = (Palette.Item)this.myItemList.getSelectedValue();
        return item != null ? item.getTagName() : null;
    }

    private void categorySelectionChanged() {
        Palette.Group newSelection = (Palette.Group)this.myCategoryList.getSelectedValue();
        if (newSelection == null) {
            this.myLastSelectedGroup = DataModel.COMMON;
            this.myCategoryList.setSelectedIndex(0);
            return;
        }
        this.myDataModel.categorySelectionChanged(newSelection);
        this.myLastSelectedGroup = newSelection;
        this.myItemList.setSelectedIndex(0);
        this.myItemList.setEmptyText(PalettePanel.generateEmptyText(newSelection));
    }

    @NotNull
    private static Pair<String, String> generateEmptyText(@NotNull Palette.Group group) {
        if (group == DataModel.COMMON) {
            return Pair.create((Object)"No favorites", (Object)"Right click to add");
        }
        if (group == DataModel.RESULTS) {
            return Pair.create((Object)"No matches found", (Object)"");
        }
        return Pair.create((Object)"Empty group", (Object)"");
    }

    @NotNull
    public JComponent getComponent() {
        return this;
    }

    @NotNull
    public JComponent getFocusedComponent() {
        return this.myCategoryList;
    }

    @AnyThread
    @NotNull
    @VisibleForTesting
    public CategoryList getCategoryList() {
        return this.myCategoryList;
    }

    @AnyThread
    @NotNull
    @VisibleForTesting
    public ItemList getItemList() {
        return this.myItemList;
    }

    public LayoutEditorFileType getLayoutEditorFileType() {
        return this.myLayoutType;
    }

    public void requestFocus() {
        this.myCategoryList.requestFocus();
    }

    public void registerCallbacks(@NotNull ToolWindowCallback toolWindow) {
        this.myToolWindow = toolWindow;
    }

    public boolean supportsFiltering() {
        return true;
    }

    public void setFilter(@NotNull String filter2) {
        this.myDataModel.setFilterPattern(filter2);
        Palette.Group newSelection = this.myDataModel.getCategoryListModel().contains(this.myLastSelectedGroup) ? this.myLastSelectedGroup : null;
        this.myCategoryList.clearSelection();
        this.myCategoryList.setSelectedValue(newSelection, true);
    }

    @NotNull
    public KeyListener getFilterKeyListener() {
        return this.myFilterKeyListener;
    }

    @NotNull
    private KeyListener createFilterKeyListener() {
        return new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent event) {
                if (PalettePanel.this.myDataModel.hasFilterPattern() && event.getKeyCode() == 10 && event.getModifiers() == 0 && PalettePanel.this.myItemList.getModel().getSize() == 1) {
                    PalettePanel.this.myItemList.requestFocus();
                }
            }
        };
    }

    @NotNull
    CompletableFuture<Void> setToolContextAsyncImpl(@Nullable DesignSurface<?> designSurface2) {
        CompletionStage<Object> result;
        assert (designSurface2 == null || designSurface2 instanceof NlDesignSurface);
        Module module = PalettePanel.getModule(designSurface2);
        if (designSurface2 != null && module != null && this.myLayoutType != designSurface2.getLayoutType()) {
            AndroidFacet facet = AndroidFacet.getInstance((Module)module);
            assert (facet != null);
            assert (designSurface2.getLayoutType() instanceof LayoutEditorFileType);
            this.myLayoutType = (LayoutEditorFileType)designSurface2.getLayoutType();
            result = this.myDataModel.setLayoutTypeAsync(facet, this.myLayoutType).thenRunAsync(() -> {
                if (this.myDataModel.getCategoryListModel().hasExplicitGroups()) {
                    this.setCategoryListVisible(true);
                    this.myCategoryList.setSelectedIndex(0);
                } else {
                    this.setCategoryListVisible(false);
                    this.myDataModel.categorySelectionChanged(DataModel.COMMON);
                    this.myItemList.setSelectedIndex(0);
                }
            }, (Executor)EdtExecutorService.getInstance());
        } else {
            result = CompletableFuture.completedFuture(null);
        }
        this.myDesignSurface = new WeakReference(designSurface2);
        return result;
    }

    public void setToolContext(@Nullable DesignSurface<?> designSurface2) {
        this.setToolContextAsyncImpl(designSurface2);
    }

    private void setCategoryListVisible(boolean visible) {
        this.myCategoryScrollPane.setVisible(visible);
    }

    @Nullable
    private static Module getModule(@Nullable DesignSurface<?> designSurface2) {
        Configuration configuration = designSurface2 != null && designSurface2.getLayoutType().isEditable() ? (Configuration)designSurface2.getConfigurations().stream().findFirst().orElse(null) : null;
        ConfigurationManager manager = configuration != null ? ConfigurationManager.getFromConfiguration(configuration) : null;
        return manager != null ? manager.getModule() : null;
    }

    public void dispose() {
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        sink.set(PlatformDataKeys.COPY_PROVIDER, (Object)this.myCopyProvider);
    }

    private class CopyProviderImpl
    implements CopyProvider {
        private CopyProviderImpl() {
        }

        public void performCopy(@NotNull DataContext dataContext) {
            Palette.Item item = (Palette.Item)PalettePanel.this.myItemList.getSelectedValue();
            if (item != null && !PalettePanel.this.myDependencyManager.needsLibraryLoad(item)) {
                DnDTransferComponent component = new DnDTransferComponent(item.getTagName(), item.getXml(), 0, 0);
                CopyPasteManager.getInstance().setContents((Transferable)new ItemTransferable(new DnDTransferItem(component)));
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public boolean isCopyEnabled(@NotNull DataContext dataContext) {
            Palette.Item item = (Palette.Item)PalettePanel.this.myItemList.getSelectedValue();
            return item != null && !PalettePanel.this.myDependencyManager.needsLibraryLoad(item);
        }

        public boolean isCopyVisible(@NotNull DataContext dataContext) {
            return true;
        }
    }

    private class AddToDesignAction
    extends AnAction {
        private AddToDesignAction() {
            super("Add to Design");
            this.setShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(10, 0)));
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            this.addComponentToModel(false);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void update(@NotNull AnActionEvent event) {
            event.getPresentation().setEnabled(this.addComponentToModel(true));
        }

        private boolean addComponentToModel(boolean checkOnly) {
            NlComponent root;
            List<NlComponent> toAdd;
            Palette.Item item = (Palette.Item)PalettePanel.this.myItemList.getSelectedValue();
            if (item == null) {
                return false;
            }
            DesignSurface surface2 = (DesignSurface)PalettePanel.this.myDesignSurface.get();
            if (surface2 == null) {
                return false;
            }
            NlModel model = surface2.getModel();
            NlTreeWriter treeWriter2 = model.getTreeWriter();
            if (model == null) {
                return false;
            }
            ImmutableList<NlComponent> roots = model.getTreeReader().getComponents();
            if (roots.isEmpty()) {
                return false;
            }
            SceneView sceneView = surface2.getFocusedSceneView();
            if (sceneView == null) {
                return false;
            }
            DnDTransferComponent dndComponent = new DnDTransferComponent(item.getTagName(), item.getXml(), 0, 0);
            DnDTransferItem dndItem = new DnDTransferItem(dndComponent);
            InsertType insertType = treeWriter2.determineInsertType(DragType.COPY, dndItem, checkOnly, true);
            if (checkOnly && insertType == InsertType.CREATE_PREVIEW) {
                insertType = InsertType.CHECK_PREVIEW;
            }
            if (!treeWriter2.canAddComponents(toAdd = treeWriter2.createComponents(dndItem, insertType), root = (NlComponent)roots.get(0), null, checkOnly)) {
                return false;
            }
            if (!checkOnly) {
                NlTreeWriterKt.addComponentsAndSelectedIfCreated(treeWriter2, toAdd, root, null, insertType, sceneView.getSurface().getSelectionModel());
                surface2.getSelectionModel().setSelection(toAdd);
                surface2.getLayeredPane().requestFocus();
            }
            return true;
        }
    }

    private class FavoriteAction
    extends ToggleAction {
        private FavoriteAction() {
            super("Favorite");
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            Palette.Item item = (Palette.Item)PalettePanel.this.myItemList.getSelectedValue();
            return item != null && PalettePanel.this.myDataModel.isFavoriteItem(item);
        }

        public void setSelected(@NotNull AnActionEvent event, boolean state) {
            Palette.Item item = (Palette.Item)PalettePanel.this.myItemList.getSelectedValue();
            if (item != null) {
                if (state) {
                    PalettePanel.this.myDataModel.addFavoriteItem(item);
                } else {
                    PalettePanel.this.myDataModel.removeFavoriteItem(item);
                }
            }
        }
    }

    private class MaterialDocAction
    extends AnAction {
        private static final String MATERIAL_DEFAULT_REFERENCE = "https://d.android.com/r/studio-ui/designer/material/components";

        private MaterialDocAction() {
            super("Material Guidelines");
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            String reference = this.getReference();
            if (!reference.isEmpty()) {
                BrowserUtil.browse((String)reference);
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void update(@NotNull AnActionEvent event) {
            event.getPresentation().setEnabled(!this.getReference().isEmpty());
        }

        private String getReference() {
            Palette.Item item = (Palette.Item)PalettePanel.this.myItemList.getSelectedValue();
            if (item == null) {
                return "";
            }
            String reference = item.getMaterialReference();
            if (reference == null) {
                reference = MATERIAL_DEFAULT_REFERENCE;
            }
            return StringUtil.notNullize((String)reference);
        }
    }

    private class ItemTransferHandler
    extends TransferHandler {
        private final PreviewProvider myPreviewProvider;
        private final Supplier<Palette.Item> myItemSupplier;

        private ItemTransferHandler(@NotNull PreviewProvider provider, Supplier<Palette.Item> itemSupplier) {
            this.myPreviewProvider = provider;
            this.myItemSupplier = itemSupplier;
        }

        @Override
        public int getSourceActions(@NotNull JComponent component) {
            return 3;
        }

        @Override
        @Nullable
        protected Transferable createTransferable(@NotNull JComponent component) {
            Palette.Item item = this.myItemSupplier.get();
            if (item == null) {
                return null;
            }
            DumbService dumbService = DumbService.getInstance((Project)PalettePanel.this.myProject);
            if (dumbService.isDumb()) {
                dumbService.showDumbModeNotificationForFunctionality("Dragging from the Palette is not available while indices are updating.", DumbModeBlockedFunctionality.Android);
                return null;
            }
            PreviewProvider.ImageAndDimension imageAndSize = this.myPreviewProvider.createPreview(component, item);
            BufferedImage image = imageAndSize.getImage();
            Dimension size = imageAndSize.getDimension();
            this.setDragImage(image);
            if (SystemInfo.isWindows) {
                this.setDragImageOffset(new Point(image.getWidth() / 2, image.getHeight() / 2));
            } else {
                this.setDragImageOffset(new Point(-image.getWidth() / 2, -image.getHeight() / 2));
            }
            DnDTransferComponent dndComponent = new DnDTransferComponent(item.getTagName(), item.getXml(), size.width, size.height);
            ItemTransferable transferable = new ItemTransferable(new DnDTransferItem(dndComponent));
            if (PalettePanel.this.myToolWindow != null) {
                PalettePanel.this.myToolWindow.autoHide();
            }
            return transferable;
        }

        @Override
        protected void exportDone(@NotNull JComponent source, @Nullable Transferable data, int action2) {
            if (action2 == 0 || data == null) {
                return;
            }
            DnDTransferComponent component = this.getDndComponent(data);
            if (component == null) {
                return;
            }
            if (PalettePanel.this.myToolWindow != null) {
                PalettePanel.this.myToolWindow.stopFiltering();
            }
            NlUsageTracker.getInstance((DesignSurface)PalettePanel.this.myDesignSurface.get()).logDropFromPalette(component.getTag(), component.getRepresentation(), this.getGroupName(), PalettePanel.this.myDataModel.getMatchCount());
        }

        @NotNull
        private String getGroupName() {
            Palette.Group group = (Palette.Group)PalettePanel.this.myCategoryList.getSelectedValue();
            return group != null ? group.getName() : "";
        }

        @Nullable
        private DnDTransferComponent getDndComponent(@NotNull Transferable data) {
            try {
                ImmutableList<DnDTransferComponent> components;
                DnDTransferItem item = (DnDTransferItem)data.getTransferData(ItemTransferable.DESIGNER_FLAVOR);
                if (item != null && (components = item.getComponents()).size() == 1) {
                    return (DnDTransferComponent)components.get(0);
                }
            }
            catch (UnsupportedFlavorException | IOException ex) {
                Logger.getInstance(PalettePanel.class).warn("Could not un-serialize a transferable", (Throwable)ex);
            }
            return null;
        }
    }
}

