/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.resources.ResourceFolderType;
import com.android.tools.configurations.Configuration;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.rendering.AndroidBuildTargetReference;
import com.android.tools.idea.rendering.RenderServiceUtilsKt;
import com.android.tools.idea.rendering.StudioRenderService;
import com.android.tools.idea.rendering.parsers.PsiXmlFile;
import com.android.tools.idea.uibuilder.palette.DependencyManager;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.android.tools.rendering.RenderResult;
import com.android.tools.rendering.RenderService;
import com.android.tools.rendering.RenderTask;
import com.android.tools.rendering.imagepool.ImagePool;
import com.android.tools.rendering.parsers.RenderXmlFile;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001:\u00011B#\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J*\u0010\u0017\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u001b0\u00190\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0003J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010!0\u00182\u0006\u0010\"\u001a\u00020#H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\u001a2\u0006\u0010%\u001a\u00020&H\u0002J0\u0010.\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010!\u0012\u0006\u0012\u0004\u0018\u00010&0\u00190\u00182\b\u0010/\u001a\u0004\u0018\u00010!2\u0006\u00100\u001a\u00020\u001dH\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0016\u0010'\u001a\u0004\u0018\u00010(8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0016\u0010+\u001a\u0004\u0018\u00010\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u00062"}, d2={"Lcom/android/tools/idea/uibuilder/palette/PreviewProvider;", "", "myDesignSurfaceSupplier", "Ljava/util/function/Supplier;", "Lcom/android/tools/idea/common/surface/DesignSurface;", "myDependencyManager", "Lcom/android/tools/idea/uibuilder/palette/DependencyManager;", "<init>", "(Ljava/util/function/Supplier;Lcom/android/tools/idea/uibuilder/palette/DependencyManager;)V", "renderTimeoutMillis", "", "getRenderTimeoutMillis$annotations", "()V", "getRenderTimeoutMillis", "()J", "setRenderTimeoutMillis", "(J)V", "createPreview", "Lcom/android/tools/idea/uibuilder/palette/PreviewProvider$ImageAndDimension;", "component", "Ljavax/swing/JComponent;", "item", "Lcom/android/tools/idea/uibuilder/palette/Palette$Item;", "renderDragImage", "Ljava/util/concurrent/CompletableFuture;", "Lkotlin/Pair;", "Ljava/awt/image/BufferedImage;", "Ljava/util/concurrent/Future;", "constructPreviewXml", "", "scene", "Lcom/android/tools/idea/common/surface/SceneView;", "getRenderTask", "Lcom/android/tools/rendering/RenderTask;", "configuration", "Lcom/android/tools/configurations/Configuration;", "extractImage", "result", "Lcom/android/tools/rendering/RenderResult;", "currentScale", "", "getCurrentScale", "()Ljava/lang/Double;", "sceneView", "getSceneView", "()Lcom/android/tools/idea/common/surface/SceneView;", "renderImage", "renderTask", "xml", "ImageAndDimension", "intellij.android.designer"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPreviewProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreviewProvider.kt\ncom/android/tools/idea/uibuilder/palette/PreviewProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,235:1\n1#2:236\n*E\n"})
public final class PreviewProvider {
    @NotNull
    private final Supplier<DesignSurface<?>> myDesignSurfaceSupplier;
    @NotNull
    private final DependencyManager myDependencyManager;
    private long renderTimeoutMillis;
    public static final int $stable = 8;

    public PreviewProvider(@NotNull Supplier<DesignSurface<?>> myDesignSurfaceSupplier, @NotNull DependencyManager myDependencyManager) {
        Intrinsics.checkNotNullParameter(myDesignSurfaceSupplier, (String)"myDesignSurfaceSupplier");
        Intrinsics.checkNotNullParameter((Object)myDependencyManager, (String)"myDependencyManager");
        this.myDesignSurfaceSupplier = myDesignSurfaceSupplier;
        this.myDependencyManager = myDependencyManager;
        this.renderTimeoutMillis = 600L;
    }

    public final long getRenderTimeoutMillis() {
        return this.renderTimeoutMillis;
    }

    public final void setRenderTimeoutMillis(long l) {
        this.renderTimeoutMillis = l;
    }

    @VisibleForTesting
    public static /* synthetic */ void getRenderTimeoutMillis$annotations() {
    }

    @NotNull
    public final ImageAndDimension createPreview(@NotNull JComponent component, @NotNull Palette.Item item) {
        Image image;
        Pair pair;
        Pair pair2;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Dimension size = null;
        Image image2 = null;
        ScaleContext scaleContext = ScaleContext.Companion.create((Component)component);
        CompletableFuture<Pair<BufferedImage, Future<?>>> future = this.myDependencyManager.needsLibraryLoad(item) ? null : this.renderDragImage(item);
        try {
            CompletableFuture<Pair<BufferedImage, Future<?>>> completableFuture = future;
            pair2 = completableFuture != null ? completableFuture.get(this.renderTimeoutMillis, TimeUnit.MILLISECONDS) : null;
        }
        catch (Exception exception) {
            pair2 = null;
        }
        if ((pair = pair2) == null) {
            pair = new Pair(null, null);
        }
        Pair pair3 = pair;
        BufferedImage renderedItem = (BufferedImage)pair3.component1();
        Future disposal = (Future)pair3.component2();
        if (renderedItem == null) {
            Icon icon2 = item.getIcon();
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"getIcon(...)");
            Icon icon3 = icon2;
            image = IconLoader.toImage((Icon)icon3, (ScaleContext)scaleContext);
        } else {
            image = ImageUtil.ensureHiDPI((Image)renderedItem, (ScaleContext)scaleContext);
        }
        Image image3 = image2 = image;
        Intrinsics.checkNotNull((Object)image3);
        int width = ImageUtil.getRealWidth((Image)image3);
        int height = ImageUtil.getRealHeight((Image)image2);
        Double d = this.getCurrentScale();
        image2 = ImageUtil.scaleImage((Image)image2, (double)(d != null ? d : 1.0));
        size = new Dimension(width, height);
        boolean inUserScale = !SystemInfo.isWindows || !StartupUiUtil.isJreHiDPI((Component)component);
        BufferedImage bufferedImage = ImageUtil.toBufferedImage((Image)image2, (boolean)inUserScale);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"toBufferedImage(...)");
        BufferedImage bufferedImage2 = bufferedImage;
        return new ImageAndDimension(bufferedImage2, size, (Future)future, disposal);
    }

    @VisibleForTesting
    private final CompletableFuture<Pair<BufferedImage, Future<?>>> renderDragImage(Palette.Item item) {
        Object object;
        SceneView scene;
        block3: {
            block2: {
                scene = this.getSceneView();
                object = scene;
                if (object == null) break block2;
                SceneView it = object;
                boolean bl = false;
                String string = this.constructPreviewXml(it, item);
                object = string;
                if (string != null) break block3;
            }
            CompletableFuture<Pair<BufferedImage, Future<?>>> completableFuture = CompletableFuture.completedFuture(new Pair(null, null));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        Object xml = object;
        CompletionStage completionStage = ((CompletableFuture)this.getRenderTask(scene.getSceneManager().getModel().getConfiguration()).thenCompose(arg_0 -> PreviewProvider.renderDragImage$lambda$2(arg_0 -> PreviewProvider.renderDragImage$lambda$1(this, (String)xml, arg_0), arg_0))).thenApply(arg_0 -> PreviewProvider.renderDragImage$lambda$5(arg_0 -> PreviewProvider.renderDragImage$lambda$4(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    private final String constructPreviewXml(SceneView scene, Palette.Item item) {
        XmlTag xmlTag;
        NlModel model = scene.getSceneManager().getModel();
        XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)model.getProject());
        String string = item.getDragPreviewXml();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDragPreviewXml(...)");
        String xml = string;
        if (Intrinsics.areEqual((Object)xml, (Object)"")) {
            return null;
        }
        try {
            xmlTag = elementFactory.createTagFromText((CharSequence)xml);
        }
        catch (IncorrectOperationException exception) {
            return null;
        }
        XmlTag xmlTag2 = xmlTag;
        Intrinsics.checkNotNull((Object)xmlTag2);
        XmlTag tag = xmlTag2;
        NlComponent nlComponent = (NlComponent)ActionsKt.runWriteAction(() -> PreviewProvider.constructPreviewXml$lambda$6(model, tag));
        if (nlComponent == null) {
            return null;
        }
        NlComponent component = nlComponent;
        XmlTag xmlTag3 = component.getTag();
        if (xmlTag3 == null) {
            return null;
        }
        XmlTag componentTag = xmlTag3;
        String string2 = "<LinearLayout\n    xmlns:android=\"http://schemas.android.com/apk/res/android\"\n    xmlns:app=\"http://schemas.android.com/apk/res-auto\"\n    android:id=\"@+id/%1$s\"\n    android:layout_width=\"match_parent\"\n    android:layout_height=\"wrap_content\"\n    android:orientation=\"vertical\">\n  %2$s\n</LinearLayout>\n";
        Object[] objectArray = new Object[]{"TopLevelContainer", componentTag.getText()};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        return string3;
    }

    private final CompletableFuture<RenderTask> getRenderTask(Configuration configuration) {
        Module module = ConfigurationManager.getFromConfiguration((Configuration)configuration).getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"getModule(...)");
        Module module2 = module;
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module2);
        if (androidFacet == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        AndroidFacet facet = androidFacet;
        Project project = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RenderService renderService = StudioRenderService.Companion.getInstance(project);
        CompletableFuture completableFuture = RenderServiceUtilsKt.taskBuilderWithHtmlLogger(renderService, AndroidBuildTargetReference.Companion.gradleOnly(facet), configuration).build();
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"build(...)");
        return completableFuture;
    }

    private final BufferedImage extractImage(RenderResult result) {
        BufferedImage bufferedImage;
        ImagePool.Image image = result.getRenderedImage();
        Intrinsics.checkNotNullExpressionValue((Object)image, (String)"getRenderedImage(...)");
        ImagePool.Image image2 = image;
        if (!image2.isValid()) {
            return null;
        }
        ImmutableList immutableList = result.getRootViews();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"getRootViews(...)");
        Object object = (ViewInfo)CollectionsKt.firstOrNull((List)((List)immutableList));
        if (object == null || (object = object.getChildren()) == null || (object = (ViewInfo)CollectionsKt.firstOrNull((List)object)) == null) {
            return null;
        }
        Object view = object;
        if (image2.getHeight() < view.getBottom() || image2.getWidth() < view.getRight() || view.getBottom() <= view.getTop() || view.getRight() <= view.getLeft()) {
            return null;
        }
        SceneView sceneView = this.getSceneView();
        if (sceneView == null) {
            return null;
        }
        SceneView scene = sceneView;
        int shadowIncrement = 1 + Coordinates.getSwingDimension(scene, 6);
        BufferedImage bufferedImage2 = image2.getCopy();
        if (bufferedImage2 == null) {
            return null;
        }
        BufferedImage imageCopy = bufferedImage2;
        try {
            bufferedImage = imageCopy.getSubimage(view.getLeft(), view.getTop(), Math.min(view.getRight() + shadowIncrement, image2.getWidth()), Math.min(view.getBottom() + shadowIncrement, image2.getHeight()));
        }
        catch (RasterFormatException ignore) {
            bufferedImage = null;
        }
        return bufferedImage;
    }

    private final Double getCurrentScale() {
        DesignSurface<?> designSurface2 = this.myDesignSurfaceSupplier.get();
        if (designSurface2 != null) {
            DesignSurface<?> it = designSurface2;
            boolean bl = false;
            Object object = it.getFocusedSceneView();
            float sceneScale = object != null && (object = ((SceneView)object).getSceneManager()) != null ? ((SceneManager)object).getSceneScalingFactor() : 1.0f;
            return it.getZoomController().getScale() * it.getZoomController().getScreenScalingFactor() / (double)sceneScale;
        }
        return null;
    }

    private final SceneView getSceneView() {
        DesignSurface<?> designSurface2 = this.myDesignSurfaceSupplier.get();
        return designSurface2 != null ? designSurface2.getFocusedSceneView() : null;
    }

    private final CompletableFuture<Pair<RenderTask, RenderResult>> renderImage(RenderTask renderTask, String xml) {
        if (renderTask == null) {
            CompletableFuture<Pair<RenderTask, RenderResult>> completableFuture = CompletableFuture.completedFuture(new Pair(null, null));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        Object object = ActionsKt.runReadAction(() -> PreviewProvider.renderImage$lambda$8(renderTask, xml));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
        PsiFile file2 = (PsiFile)object;
        boolean bl = file2 instanceof XmlFile;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        renderTask.setXmlFile((RenderXmlFile)new PsiXmlFile((XmlFile)file2));
        renderTask.setTransparentBackground();
        renderTask.setDecorations(false);
        renderTask.setRenderingMode(SessionParams.RenderingMode.V_SCROLL);
        renderTask.getContext().setFolderType(ResourceFolderType.LAYOUT);
        renderTask.inflate();
        CompletionStage completionStage = renderTask.render().thenApply(arg_0 -> PreviewProvider.renderImage$lambda$10(arg_0 -> PreviewProvider.renderImage$lambda$9(renderTask, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    private static final CompletionStage renderDragImage$lambda$1(PreviewProvider this$0, String $xml, RenderTask renderTask) {
        return this$0.renderImage(renderTask, $xml);
    }

    private static final CompletionStage renderDragImage$lambda$2(Function1 $tmp0, Object p0) {
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final Pair renderDragImage$lambda$4(PreviewProvider this$0, Pair pair) {
        BufferedImage bufferedImage;
        RenderResult renderResult;
        RenderTask renderTask = (RenderTask)pair.component1();
        RenderResult renderResult2 = renderResult = (RenderResult)pair.component2();
        if (renderResult2 != null) {
            RenderResult it = renderResult2;
            boolean bl = false;
            bufferedImage = this$0.extractImage(it);
        } else {
            bufferedImage = null;
        }
        BufferedImage image = bufferedImage;
        RenderTask renderTask2 = renderTask;
        Future disposal = renderTask2 != null ? renderTask2.dispose() : null;
        return new Pair((Object)image, (Object)disposal);
    }

    private static final Pair renderDragImage$lambda$5(Function1 $tmp0, Object p0) {
        return (Pair)$tmp0.invoke(p0);
    }

    private static final NlComponent constructPreviewXml$lambda$6(NlModel $model, XmlTag $tag) {
        return $model.getTreeWriter().createComponent($tag, null, null, InsertType.CREATE_PREVIEW);
    }

    private static final PsiFile renderImage$lambda$8(RenderTask $renderTask, String $xml) {
        return PsiFileFactory.getInstance((Project)$renderTask.getContext().getModule().getProject()).createFileFromText("preview.xml", (FileType)XmlFileType.INSTANCE, (CharSequence)$xml);
    }

    private static final Pair renderImage$lambda$9(RenderTask $renderTask, RenderResult result) {
        return new Pair((Object)$renderTask, (Object)result);
    }

    private static final Pair renderImage$lambda$10(Function1 $tmp0, Object p0) {
        return (Pair)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/uibuilder/palette/PreviewProvider$ImageAndDimension;", "", "image", "Ljava/awt/image/BufferedImage;", "dimension", "Ljava/awt/Dimension;", "rendering", "Ljava/util/concurrent/Future;", "disposal", "<init>", "(Ljava/awt/image/BufferedImage;Ljava/awt/Dimension;Ljava/util/concurrent/Future;Ljava/util/concurrent/Future;)V", "getImage", "()Ljava/awt/image/BufferedImage;", "getDimension", "()Ljava/awt/Dimension;", "getRendering", "()Ljava/util/concurrent/Future;", "getDisposal", "intellij.android.designer"})
    @StabilityInferred(parameters=0)
    public static final class ImageAndDimension {
        @NotNull
        private final BufferedImage image;
        @NotNull
        private final Dimension dimension;
        @Nullable
        private final Future<?> rendering;
        @Nullable
        private final Future<?> disposal;
        public static final int $stable = 8;

        public ImageAndDimension(@NotNull BufferedImage image, @NotNull Dimension dimension, @Nullable Future<?> rendering, @Nullable Future<?> disposal) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
            this.image = image;
            this.dimension = dimension;
            this.rendering = rendering;
            this.disposal = disposal;
        }

        @NotNull
        public final BufferedImage getImage() {
            return this.image;
        }

        @NotNull
        public final Dimension getDimension() {
            return this.dimension;
        }

        @Nullable
        public final Future<?> getRendering() {
            return this.rendering;
        }

        @Nullable
        public final Future<?> getDisposal() {
            return this.disposal;
        }
    }
}

