/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scout;

import com.android.AndroidXConstants;
import com.android.ide.common.resources.ResourcesUtil;
import com.android.support.AndroidxName;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.android.tools.rendering.parsers.AttributeSnapshot;
import com.intellij.openapi.module.Module;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class ScoutDirectConvert {
    public static final int VERTICAL = 1;
    public static final int HORIZONTAL = 2;
    public static final int BOTH = 3;
    static Convert[] ourConverts = new Convert[]{new Convert("layout_above", Dir.TOP, false, 1, "layout_constraintBottom_toTopOf"), new Convert("layout_below", Dir.BOTTOM, false, 1, "layout_constraintTop_toBottomOf"), new Convert("layout_toEndOf", Dir.END, false, 2, "layout_constraintStart_toEndOf"), new Convert("layout_toStartOf", Dir.START, false, 2, "layout_constraintEnd_toStartOf"), new Convert("layout_toLeftOf", Dir.LEFT, false, 2, "layout_constraintRight_toLeftOf"), new Convert("layout_toRightOf", Dir.RIGHT, false, 2, "layout_constraintLeft_toRightOf"), new Convert("layout_alignRight", Dir.NONE, false, 2, "layout_constraintRight_toRightOf"), new Convert("layout_alignLeft", Dir.NONE, false, 2, "layout_constraintLeft_toLeftOf"), new Convert("layout_alignEnd", Dir.NONE, false, 2, "layout_constraintEnd_toEndOf"), new Convert("layout_alignStart", Dir.NONE, false, 2, "layout_constraintStart_toStartOf"), new Convert("layout_alignBaseline", Dir.NONE, false, 1, "layout_constraintBaseline_toBaselineOf"), new Convert("layout_alignBottom", Dir.NONE, false, 1, "layout_constraintBottom_toBottomOf"), new Convert("layout_alignParentBottom", Dir.NONE, true, 1, "layout_constraintBottom_toBottomOf"), new Convert("layout_alignParentEnd", Dir.NONE, true, 2, "layout_constraintEnd_toEndOf"), new Convert("layout_alignParentLeft", Dir.NONE, true, 2, "layout_constraintLeft_toLeftOf"), new Convert("layout_alignParentRight", Dir.NONE, true, 2, "layout_constraintRight_toRightOf"), new Convert("layout_alignParentStart", Dir.NONE, true, 2, "layout_constraintStart_toStartOf"), new Convert("layout_alignParentTop", Dir.NONE, true, 1, "layout_constraintTop_toTopOf"), new Convert("layout_alignTop", Dir.NONE, false, 1, "layout_constraintTop_toTopOf"), new Convert("layout_centerHorizontal", Dir.NONE, true, 2, "layout_constraintLeft_toLeftOf", "layout_constraintRight_toRightOf"), new Convert("layout_centerInParent", Dir.NONE, true, 3, "layout_constraintTop_toTopOf", "layout_constraintBottom_toBottomOf", "layout_constraintLeft_toLeftOf", "layout_constraintRight_toRightOf"), new Convert("layout_centerVertical", Dir.NONE, true, 1, "layout_constraintTop_toTopOf", "layout_constraintBottom_toBottomOf")};
    static HashMap<String, Convert> ourRelativeLayoutAttr = new HashMap();

    public static boolean directProcess(NlComponent layout) {
        if (!layout.getTagDeprecated().getName().equals("RelativeLayout")) {
            return false;
        }
        layout.getTagDeprecated().setName(DependencyManagementUtil.mapAndroidxName((Module)layout.getModel().getModule(), (AndroidxName)AndroidXConstants.CLASS_CONSTRAINT_LAYOUT));
        ScoutDirectConvert.convert(layout);
        return true;
    }

    public static void convert(NlComponent component) {
        HashMap<String, NlComponent> idMap = new HashMap<String, NlComponent>();
        for (NlComponent child : component.getChildren()) {
            idMap.put(child.getId(), child);
        }
        for (NlComponent child : component.getChildren()) {
            ArrayList<String[]> createList = new ArrayList<String[]>();
            ArrayList<String[]> delList = new ArrayList<String[]>();
            List<AttributeSnapshot> list = child.getAttributes();
            boolean verticalConstrained = false;
            boolean horizontallyConstrained = false;
            for (AttributeSnapshot attr2 : list) {
                Convert a = ourRelativeLayoutAttr.get(attr2.name);
                if (a == null) continue;
                verticalConstrained |= (a.mConstrained & 1) > 0;
                horizontallyConstrained |= (a.mConstrained & 2) > 0;
                if (!a.mAttachToParent) {
                    delList.add(new String[]{"http://schemas.android.com/apk/res/android", attr2.name});
                    createList.add(new String[]{"http://schemas.android.com/apk/res-auto", a.mConstraintAttributes[0], attr2.value});
                    if (a.mMddTargetMargin == Dir.NONE) continue;
                    String id = attr2.value != null ? ResourcesUtil.stripPrefixFromId((String)attr2.value) : null;
                    NlComponent ref = (NlComponent)idMap.get(id);
                    switch (a.mMddTargetMargin.ordinal()) {
                        case 0: {
                            ScoutDirectConvert.fixMargin(child, ref, "layout_marginRight", "layout_marginLeft", createList);
                            ScoutDirectConvert.fixMargin(child, ref, "layout_marginEnd", "layout_marginStart", createList);
                            break;
                        }
                        case 1: {
                            ScoutDirectConvert.fixMargin(child, ref, "layout_marginLeft", "layout_marginRight", createList);
                            ScoutDirectConvert.fixMargin(child, ref, "layout_marginStart", "layout_marginEnd", createList);
                            break;
                        }
                        case 2: {
                            ScoutDirectConvert.fixMargin(child, ref, "layout_marginBottom", "layout_marginTop", createList);
                            break;
                        }
                        case 3: {
                            ScoutDirectConvert.fixMargin(child, ref, "layout_marginTop", "layout_marginBottom", createList);
                            break;
                        }
                        case 4: {
                            ScoutDirectConvert.fixMargin(child, ref, "layout_marginEnd", "layout_marginStart", createList);
                            ScoutDirectConvert.fixMargin(child, ref, "layout_marginRight", "layout_marginLeft", createList);
                            break;
                        }
                        case 5: {
                            ScoutDirectConvert.fixMargin(child, ref, "layout_marginStart", "layout_marginEnd", createList);
                            ScoutDirectConvert.fixMargin(child, ref, "layout_marginLeft", "layout_marginRight", createList);
                            break;
                        }
                    }
                    continue;
                }
                delList.add(new String[]{"http://schemas.android.com/apk/res/android", attr2.name});
                for (int i = 0; i < a.mConstraintAttributes.length; ++i) {
                    createList.add(new String[]{"http://schemas.android.com/apk/res-auto", a.mConstraintAttributes[i], "parent"});
                }
            }
            if (!verticalConstrained) {
                createList.add(new String[]{"http://schemas.android.com/apk/res-auto", "layout_constraintTop_toTopOf", "parent"});
            }
            if (!horizontallyConstrained) {
                createList.add(new String[]{"http://schemas.android.com/apk/res-auto", "layout_constraintStart_toStartOf", "parent"});
            }
            AttributesTransaction transaction = child.startAttributeTransaction();
            for (String[] attr3 : delList) {
                transaction.removeAttribute(attr3[0], attr3[1]);
                transaction.setAttribute(attr3[0], attr3[1], null);
            }
            for (String[] attr3 : createList) {
                transaction.setAttribute(attr3[0], attr3[1], attr3[2]);
            }
            transaction.commit();
        }
    }

    private static void fixMargin(NlComponent child, NlComponent ref, String srcMargin, String refMargin, List<String[]> creatList) {
        String marginStr = ref.getLiveAttribute("http://schemas.android.com/apk/res/android", refMargin);
        int targetMargin = ConstraintComponentUtilities.getDpValue(ref, marginStr);
        if (targetMargin != 0) {
            int childMargin = ConstraintComponentUtilities.getDpValue(child, srcMargin);
            if (childMargin == 0) {
                creatList.add(new String[]{"http://schemas.android.com/apk/res/android", srcMargin, marginStr});
            } else {
                int margin = targetMargin + childMargin;
                creatList.add(new String[]{"http://schemas.android.com/apk/res/android", srcMargin, String.format(Locale.US, "%ddp", margin)});
            }
        }
    }

    static {
        for (int i = 0; i < ourConverts.length; ++i) {
            ourRelativeLayoutAttr.put(ScoutDirectConvert.ourConverts[i].mRelativeAttribute, ourConverts[i]);
        }
    }

    static class Convert {
        String mRelativeAttribute;
        String[] mConstraintAttributes;
        boolean mAttachToParent;
        Dir mMddTargetMargin;
        int mConstrained;

        public Convert(String attribute, Dir addTargetMargin, boolean parent, int constraint, String ... constraintAttributes) {
            this.mRelativeAttribute = attribute;
            this.mAttachToParent = parent;
            this.mConstrained = constraint;
            this.mConstraintAttributes = constraintAttributes;
            this.mMddTargetMargin = addTargetMargin;
        }
    }

    static enum Dir {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM,
        START,
        END,
        NONE;

    }
}

