/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceListener;
import com.android.tools.idea.uibuilder.api.AccessoryPanelInterface;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.surface.AccessoryPanelListener;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AccessoryPanel
extends JPanel
implements DesignSurfaceListener,
ModelListener {
    private final boolean myHandlesVisibility;
    private final List<AccessoryPanelListener> myListeners = new ArrayList<AccessoryPanelListener>();
    private NlDesignSurface mySurface;
    private NlModel myModel;
    private AccessoryPanelInterface myCachedPanel;
    private HashMap<NlComponent, AccessoryPanelInterface> myPanels = new HashMap();
    private Type myType;
    private boolean myInitialSelectionChangeFired;

    public AccessoryPanel(@NotNull Type type, boolean handlesVisibility) {
        super(new BorderLayout());
        this.setBorder((Border)JBUI.Borders.empty());
        this.myType = type;
        this.myHandlesVisibility = handlesVisibility;
    }

    public void setSurface(@Nullable NlDesignSurface surface2) {
        if (this.mySurface != null) {
            this.mySurface.removeListener(this);
            this.setModel(null);
        }
        this.removeCurrentPanel();
        this.mySurface = surface2;
        this.myInitialSelectionChangeFired = false;
        if (surface2 == null) {
            this.setModel(null);
        } else {
            this.setModel(this.mySurface.getModel());
            this.mySurface.addListener(this);
            this.componentSelectionChanged(surface2, Collections.emptyList());
        }
    }

    public void addAccessoryPanelListener(@NotNull AccessoryPanelListener listener2) {
        this.myListeners.add(listener2);
    }

    public void removeAccessoryPanelListener(@NotNull AccessoryPanelListener listener2) {
        this.myListeners.remove(listener2);
    }

    @Override
    public void modelDerivedDataChanged(@NotNull NlModel model) {
        ApplicationManager.getApplication().invokeLater(() -> {
            this.updatePanel();
            if (this.myCachedPanel != null) {
                this.myCachedPanel.updateAfterModelDerivedDataChanged();
            }
        });
    }

    @Override
    public void modelActivated(@NotNull NlModel model) {
        ApplicationManager.getApplication().invokeLater(() -> this.updatePanel());
    }

    private void updatePanel() {
        if (this.mySurface == null || this.myInitialSelectionChangeFired) {
            return;
        }
        NlComponent root = AccessoryPanel.getSingleRootComponent(this.mySurface);
        if (root == null) {
            return;
        }
        this.componentSelectionChanged(this.mySurface, this.mySurface.getSelectionModel().getSelection());
        this.myInitialSelectionChangeFired = true;
    }

    public void setModel(@Nullable NlModel model) {
        if (this.myModel != null) {
            this.myModel.removeListener(this);
        }
        if (model != null) {
            model.addListener(this);
        }
        this.myModel = model;
    }

    @Nullable
    private static NlComponent findSharedParent(@NotNull List<NlComponent> newSelection) {
        NlComponent parent = null;
        for (NlComponent selected : newSelection) {
            if (parent == null) {
                parent = selected.getParent();
                if (newSelection.size() != 1 || !selected.isRoot() || parent != null && !parent.isRoot()) continue;
                return AccessoryPanel.skipDataBindingLayout(selected);
            }
            if (parent == selected.getParent()) continue;
            parent = null;
            break;
        }
        return AccessoryPanel.skipDataBindingLayout(parent);
    }

    @Nullable
    private static NlComponent getSingleRootComponent(@NotNull DesignSurface<?> surface2) {
        List<NlModel> models = surface2.getModels();
        if (models.isEmpty()) {
            return null;
        }
        NlModel mainModel = models.get(0);
        ImmutableList<NlComponent> roots = mainModel.getTreeReader().getComponents();
        if (roots.size() != 1) {
            return null;
        }
        return AccessoryPanel.skipDataBindingLayout((NlComponent)roots.get(0));
    }

    @Nullable
    private static NlComponent skipDataBindingLayout(@Nullable NlComponent root) {
        if (root == null) {
            return null;
        }
        if (!"layout".equals(root.getTagName())) {
            return root;
        }
        List<NlComponent> roots = root.getChildren().stream().filter(component -> !"data".equals(component.getTagName())).toList();
        if (roots.size() != 1) {
            return null;
        }
        return roots.get(0);
    }

    @Override
    public void componentSelectionChanged(@NotNull DesignSurface<?> surface2, @NotNull @NotNull List<? extends @NotNull NlComponent> newSelection) {
        NlComponent parent = AccessoryPanel.findSharedParent(newSelection);
        if (parent == null && newSelection.isEmpty() && (parent = AccessoryPanel.getSingleRootComponent(surface2)) != null) {
            newSelection = Collections.singletonList(parent);
        }
        if (parent == null) {
            this.removeCurrentPanel();
            return;
        }
        ViewHandler handler = ViewHandlerManager.get(surface2.getProject()).getHandler(parent, () -> {});
        if (handler instanceof ViewGroupHandler) {
            ViewGroupHandler viewGroupHandler = (ViewGroupHandler)handler;
            if (!viewGroupHandler.needsAccessoryPanel(this.myType)) {
                this.removeCurrentPanel();
                this.notifyListeners();
                return;
            }
            AccessoryPanelInterface panel = this.myPanels.get(parent);
            if (panel == null) {
                panel = viewGroupHandler.createAccessoryPanel(surface2, this.myType, parent);
                this.myPanels.put(parent, panel);
                this.removeCurrentPanel();
            }
            if (panel != null) {
                if (panel != this.myCachedPanel) {
                    this.removeCurrentPanel();
                    this.myCachedPanel = panel;
                    this.add(this.myCachedPanel.getPanel());
                    this.notifyListeners();
                }
                panel.updateAccessoryPanelWithSelection(this.myType, newSelection);
                if (this.myHandlesVisibility) {
                    this.setVisible(true);
                }
            }
        }
    }

    @Nullable
    public AccessoryPanelInterface getCurrentPanel() {
        return this.myCachedPanel;
    }

    private void notifyListeners() {
        ArrayList<AccessoryPanelListener> copy = new ArrayList<AccessoryPanelListener>(this.myListeners);
        copy.forEach(listener2 -> listener2.panelChange(this.myCachedPanel));
    }

    private void removeCurrentPanel() {
        if (this.myCachedPanel != null) {
            this.remove(this.myCachedPanel.getPanel());
            this.myCachedPanel.deactivate();
            this.myCachedPanel = null;
        }
        if (this.myHandlesVisibility) {
            this.setVisible(false);
        }
    }

    public static enum Type {
        SOUTH_PANEL,
        EAST_PANEL;

    }
}

