/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.resources.ResourceType;
import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssueSource;
import com.android.tools.idea.common.error.NlComponentIssueSource;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlAttributesReader;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.ui.resourcechooser.util.ResourceChooserHelperKt;
import com.android.tools.idea.ui.resourcemanager.ResourcePickerDialog;
import com.android.tools.idea.uibuilder.lint.LintUtilKt;
import com.android.tools.idea.uibuilder.surface.AccessibilityLintIntegratorKt;
import com.android.tools.idea.validator.ValidatorData;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.visuallint.analyzers.AtfAnalyzerKt;
import com.intellij.lang.annotation.HighlightSeverity;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u00013B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\u0018\u0010.\u001a\u00020+2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000fR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010 R\u0016\u0010$\u001a\u0004\u0018\u00010%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020\rX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u000f\u00a8\u00064"}, d2={"Lcom/android/tools/idea/uibuilder/surface/NlAtfIssue;", "Lcom/android/tools/idea/common/error/Issue;", "result", "Lcom/android/tools/idea/validator/ValidatorData$Issue;", "issueSource", "Lcom/android/tools/idea/common/error/NlComponentIssueSource;", "eventListener", "Lcom/android/tools/idea/uibuilder/surface/NlAtfIssue$EventListener;", "<init>", "(Lcom/android/tools/idea/validator/ValidatorData$Issue;Lcom/android/tools/idea/common/error/NlComponentIssueSource;Lcom/android/tools/idea/uibuilder/surface/NlAtfIssue$EventListener;)V", "getResult", "()Lcom/android/tools/idea/validator/ValidatorData$Issue;", "summary", "", "getSummary", "()Ljava/lang/String;", "description", "getDescription", "severity", "Lcom/intellij/lang/annotation/HighlightSeverity;", "getSeverity", "()Lcom/intellij/lang/annotation/HighlightSeverity;", "source", "Lcom/android/tools/idea/common/error/IssueSource;", "getSource", "()Lcom/android/tools/idea/common/error/IssueSource;", "category", "getCategory", "fixes", "Ljava/util/stream/Stream;", "Lcom/android/tools/idea/common/error/Issue$Fix;", "getFixes", "()Ljava/util/stream/Stream;", "suppresses", "Lcom/android/tools/idea/common/error/Issue$Suppress;", "getSuppresses", "hyperlinkListener", "Ljavax/swing/event/HyperlinkListener;", "getHyperlinkListener", "()Ljavax/swing/event/HyperlinkListener;", "srcClass", "getSrcClass", "applyFixWrapper", "", "fix", "Lcom/android/tools/idea/validator/ValidatorData$Fix;", "applySetViewAttributeFixWithEmptySuggestedValue", "model", "Lcom/android/tools/idea/common/model/NlModel;", "viewAttribute", "Lcom/android/tools/idea/validator/ValidatorData$ViewAttribute;", "EventListener", "intellij.android.designer"})
@StabilityInferred(parameters=0)
public final class NlAtfIssue
extends Issue {
    @NotNull
    private final ValidatorData.Issue result;
    @Nullable
    private final EventListener eventListener;
    @NotNull
    private final IssueSource source;
    @NotNull
    private final String category;
    @NotNull
    private final String srcClass;
    public static final int $stable = 8;

    public NlAtfIssue(@NotNull ValidatorData.Issue result, @NotNull NlComponentIssueSource issueSource, @Nullable EventListener eventListener) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)issueSource, (String)"issueSource");
        this.result = result;
        this.eventListener = eventListener;
        this.source = issueSource;
        this.category = Category.A11Y.getName();
        String string = this.result.mSourceClass;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mSourceClass");
        this.srcClass = string;
    }

    public /* synthetic */ NlAtfIssue(ValidatorData.Issue issue, NlComponentIssueSource nlComponentIssueSource, EventListener eventListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            eventListener = null;
        }
        this(issue, nlComponentIssueSource, eventListener);
    }

    @NotNull
    public final ValidatorData.Issue getResult() {
        return this.result;
    }

    @Override
    @NotNull
    public String getSummary() {
        return AtfAnalyzerKt.summarize(this.result);
    }

    @Override
    @NotNull
    public String getDescription() {
        return AtfAnalyzerKt.describe(this.result);
    }

    @Override
    @NotNull
    public HighlightSeverity getSeverity() {
        HighlightSeverity highlightSeverity;
        ValidatorData.Level level = this.result.mLevel;
        switch (level == null ? -1 : WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
            case 1: {
                HighlightSeverity highlightSeverity2 = HighlightSeverity.ERROR;
                highlightSeverity = highlightSeverity2;
                Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity2, (String)"ERROR");
                break;
            }
            case 2: {
                HighlightSeverity highlightSeverity3 = HighlightSeverity.WARNING;
                highlightSeverity = highlightSeverity3;
                Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity3, (String)"WARNING");
                break;
            }
            default: {
                HighlightSeverity highlightSeverity4 = HighlightSeverity.INFORMATION;
                highlightSeverity = highlightSeverity4;
                Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity4, (String)"INFORMATION");
            }
        }
        return highlightSeverity;
    }

    @Override
    @NotNull
    public IssueSource getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public String getCategory() {
        return this.category;
    }

    @Override
    @NotNull
    public Stream<Issue.Fix> getFixes() {
        ValidatorData.Fix fix;
        IssueSource source = this.getSource();
        if (source instanceof NlAttributesHolder && (fix = this.result.mFix) != null) {
            ValidatorData.Fix it = fix;
            boolean bl = false;
            String string = it.getDescription();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescription(...)");
            Issue.Fix fix2 = new Issue.Fix("Fix", string, () -> NlAtfIssue._get_fixes_$lambda$1$lambda$0(this, it));
            Stream<Issue.Fix> stream = Stream.of(fix2);
            Intrinsics.checkNotNullExpressionValue(stream, (String)"of(...)");
            return stream;
        }
        Stream<Issue.Fix> stream = Stream.empty();
        Intrinsics.checkNotNullExpressionValue(stream, (String)"empty(...)");
        return stream;
    }

    @Override
    @NotNull
    public Stream<Issue.Suppress> getSuppresses() {
        IssueSource source = this.getSource();
        if (!(source instanceof NlAttributesHolder)) {
            Stream<Issue.Suppress> stream = Stream.empty();
            Intrinsics.checkNotNullExpressionValue(stream, (String)"empty(...)");
            return stream;
        }
        Issue.Suppress ignore = new Issue.Suppress("Suppress", "Suppress this check if it is false positive.", () -> NlAtfIssue._get_suppresses_$lambda$3(source, this));
        Stream<Issue.Suppress> stream = Stream.of(ignore);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"of(...)");
        return stream;
    }

    @Override
    @Nullable
    public HyperlinkListener getHyperlinkListener() {
        CharSequence charSequence = this.result.mHelpfulUrl;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        return LintUtilKt.createDefaultHyperLinkListener();
    }

    @NotNull
    public final String getSrcClass() {
        return this.srcClass;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void applyFixWrapper(ValidatorData.Fix fix) {
        IssueSource issueSource = this.getSource();
        Intrinsics.checkNotNull((Object)issueSource, (String)"null cannot be cast to non-null type com.android.tools.idea.common.error.NlComponentIssueSource");
        NlComponentIssueSource source = (NlComponentIssueSource)issueSource;
        if (fix instanceof ValidatorData.SetViewAttributeFix) {
            String string = ((ValidatorData.SetViewAttributeFix)fix).mSuggestedValue;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mSuggestedValue");
            if (((CharSequence)string).length() == 0) {
                NlComponent nlComponent = source.getComponent();
                Object object = nlComponent;
                if (nlComponent == null) return;
                NlModel nlModel = ((NlComponent)object).getModel();
                object = nlModel;
                if (nlModel == null) return;
                Object it = object;
                boolean bl = false;
                ValidatorData.ViewAttribute viewAttribute = ((ValidatorData.SetViewAttributeFix)fix).mViewAttribute;
                Intrinsics.checkNotNullExpressionValue((Object)viewAttribute, (String)"mViewAttribute");
                this.applySetViewAttributeFixWithEmptySuggestedValue((NlModel)it, viewAttribute);
                return;
            }
        }
        AccessibilityLintIntegratorKt.applyFixImpl(fix, source);
    }

    private final void applySetViewAttributeFixWithEmptySuggestedValue(NlModel model, ValidatorData.ViewAttribute viewAttribute) {
        IssueSource source = this.getSource();
        AndroidFacet androidFacet = model.getFacet();
        EnumSet<Enum> enumSet = EnumSet.of((Enum)ResourceType.STRING);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
        ResourcePickerDialog dialog = ResourceChooserHelperKt.createResourcePickerDialog((String)"Pick a Resource", null, (AndroidFacet)androidFacet, (Set)enumSet, null, (boolean)false, (boolean)false, (boolean)false, null);
        if (dialog.showAndGet() && source instanceof NlComponentIssueSource) {
            String string = dialog.getResourceName();
            if (string == null) {
                return;
            }
            String resourceName = string;
            NlComponentIssueSource nlComponentIssueSource = (NlComponentIssueSource)source;
            String string2 = viewAttribute.mNamespaceUri;
            String string3 = viewAttribute.mAttributeName;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"mAttributeName");
            nlComponentIssueSource.setAttribute(string2, string3, resourceName);
        }
    }

    private static final void _get_fixes_$lambda$1$lambda$0(NlAtfIssue this$0, ValidatorData.Fix $it) {
        block0: {
            this$0.applyFixWrapper($it);
            EventListener eventListener = this$0.eventListener;
            if (eventListener == null) break block0;
            eventListener.onApplyFixButtonClicked(this$0.result);
        }
    }

    private static final void _get_suppresses_$lambda$3(IssueSource $source, NlAtfIssue this$0) {
        block0: {
            String it = ((NlAttributesReader)((Object)$source)).getAttribute("http://schemas.android.com/tools", "ignore");
            boolean bl = false;
            CharSequence charSequence = it;
            Object attr2 = charSequence == null || charSequence.length() == 0 ? this$0.result.mSourceClass : it + "," + this$0.result.mSourceClass;
            ((NlAttributesHolder)((Object)$source)).setAttribute("http://schemas.android.com/tools", "ignore", (String)attr2);
            EventListener eventListener = this$0.eventListener;
            if (eventListener == null) break block0;
            eventListener.onIgnoreButtonClicked(this$0.result);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0007\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/uibuilder/surface/NlAtfIssue$EventListener;", "", "onApplyFixButtonClicked", "", "issue", "Lcom/android/tools/idea/validator/ValidatorData$Issue;", "onIgnoreButtonClicked", "intellij.android.designer"})
    public static interface EventListener {
        public void onApplyFixButtonClicked(@NotNull ValidatorData.Issue var1);

        public void onIgnoreButtonClicked(@NotNull ValidatorData.Issue var1);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ValidatorData.Level.values().length];
            try {
                nArray[ValidatorData.Level.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValidatorData.Level.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

