/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.configurations.Configuration;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.SceneInteraction;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.InteractionHandlerBase;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.tools.idea.uibuilder.surface.interaction.CanvasResizeInteraction;
import com.android.tools.idea.uibuilder.surface.interaction.MarqueeInteraction;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0014J$\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\b\u0001\u0010\u000b\u001a\u00020\tH\u0016J$\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\b\u0001\u0010\u000b\u001a\u00020\tH\u0016R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/uibuilder/surface/NlInteractionHandler;", "Lcom/android/tools/idea/common/surface/InteractionHandlerBase;", "surface", "Lcom/android/tools/idea/common/surface/DesignSurface;", "<init>", "(Lcom/android/tools/idea/common/surface/DesignSurface;)V", "createInteractionOnPressed", "Lcom/android/tools/idea/common/surface/Interaction;", "mouseX", "", "mouseY", "modifiersEx", "getViewInResizeZone", "Lcom/android/tools/idea/common/surface/SceneView;", "createInteractionOnDrag", "getCursorWhenNoInteraction", "Ljava/awt/Cursor;", "intellij.android.designer"})
@StabilityInferred(parameters=0)
public class NlInteractionHandler
extends InteractionHandlerBase {
    @NotNull
    private final DesignSurface<?> surface;
    public static final int $stable = 8;

    public NlInteractionHandler(@NotNull DesignSurface<?> surface2) {
        Intrinsics.checkNotNullParameter(surface2, (String)"surface");
        super(surface2);
        this.surface = surface2;
    }

    @Override
    @Nullable
    public Interaction createInteractionOnPressed(int mouseX, int mouseY, int modifiersEx) {
        SceneView sceneView = this.getViewInResizeZone(mouseX, mouseY);
        if (sceneView != null) {
            SceneView view = sceneView;
            boolean bl = false;
            Configuration configuration = view.getSceneManager().getModel().getConfiguration();
            DesignSurface<?> designSurface2 = this.surface;
            Intrinsics.checkNotNull(designSurface2, (String)"null cannot be cast to non-null type com.android.tools.idea.uibuilder.surface.NlDesignSurface");
            return new CanvasResizeInteraction((NlDesignSurface)designSurface2, (ScreenView)view, configuration);
        }
        SceneView sceneView2 = this.surface.getSceneViewAtOrPrimary(mouseX, mouseY);
        if (sceneView2 == null) {
            return null;
        }
        SceneView view = sceneView2;
        ScreenView screenView = (ScreenView)view;
        SelectionModel selectionModel = screenView.getSelectionModel();
        NlComponent component = Coordinates.findComponent(screenView, mouseX, mouseY);
        if (component == null) {
            if (!selectionModel.isEmpty()) {
                component = selectionModel.getPrimary();
            } else {
                return null;
            }
        }
        Interaction interaction = null;
        if (!selectionModel.isEmpty()) {
            ViewGroupHandler handler;
            NlComponent parent;
            NlComponent primary;
            NlComponent nlComponent = primary = screenView.getSelectionModel().getPrimary();
            NlComponent nlComponent2 = parent = nlComponent != null ? nlComponent.getParent() : null;
            if (parent != null && (handler = NlComponentHelperKt.getLayoutHandler(parent, NlInteractionHandler::createInteractionOnPressed$lambda$1)) != null) {
                interaction = handler.createInteraction(screenView, mouseX, mouseY, primary);
            }
        }
        if (interaction == null) {
            ViewGroupHandler viewGroupHandler;
            NlComponent nlComponent = component;
            ViewGroupHandler viewGroupHandler2 = viewGroupHandler = nlComponent != null ? NlComponentHelperKt.getLayoutHandler(nlComponent, NlInteractionHandler::createInteractionOnPressed$lambda$2) : null;
            if (viewGroupHandler != null) {
                NlComponent nlComponent3 = component;
                Intrinsics.checkNotNull((Object)nlComponent3);
                interaction = viewGroupHandler.createInteraction(screenView, mouseX, mouseY, nlComponent3);
            }
        }
        if (interaction == null) {
            interaction = new SceneInteraction(screenView);
        }
        return interaction;
    }

    @Nullable
    protected SceneView getViewInResizeZone(int mouseX, int mouseY) {
        boolean bl;
        SceneView sceneView;
        SceneView sceneView2;
        if (this.surface.getSceneManagers().size() != 1) {
            return null;
        }
        SceneView sceneViewUnderMouse = this.surface.getSceneViewAt(mouseX, mouseY);
        if (sceneViewUnderMouse != null) {
            return null;
        }
        SceneView sceneView3 = (SceneView)CollectionsKt.firstOrNull(((SceneManager)CollectionsKt.single(this.surface.getSceneManagers())).getSceneViews());
        if (sceneView3 == null) {
            return null;
        }
        SceneView sceneView4 = sceneView2 = (sceneView = sceneView3);
        boolean bl2 = false;
        if (!sceneView4.isResizeable() || !sceneView4.getScene().isResizeAvailable()) {
            bl = false;
        } else {
            Dimension size = sceneView4.getScaledContentSize();
            Rectangle resizeZone = new Rectangle(sceneView4.getX() + size.width, sceneView4.getY() + size.height, 48, 48);
            bl = resizeZone.contains(mouseX, mouseY);
        }
        return bl ? sceneView2 : null;
    }

    @Override
    @Nullable
    public Interaction createInteractionOnDrag(int mouseX, int mouseY, @JdkConstants.InputEventMask int modifiersEx) {
        if (this.surface.getSceneViewAt(mouseX, mouseY) == null) {
            SceneView sceneView = this.surface.getFocusedSceneView();
            if (sceneView == null) {
                return null;
            }
            SceneView focusedSceneView = sceneView;
            return new MarqueeInteraction(focusedSceneView, (Function0<Unit>)((Function0)() -> NlInteractionHandler.createInteractionOnDrag$lambda$4(this)));
        }
        return null;
    }

    @Override
    @Nullable
    public Cursor getCursorWhenNoInteraction(int mouseX, int mouseY, @JdkConstants.InputEventMask int modifiersEx) {
        if (this.getViewInResizeZone(mouseX, mouseY) != null) {
            return Cursor.getPredefinedCursor(5);
        }
        return super.getCursorWhenNoInteraction(mouseX, mouseY, modifiersEx);
    }

    private static final void createInteractionOnPressed$lambda$1() {
    }

    private static final void createInteractionOnPressed$lambda$2() {
    }

    private static final Unit createInteractionOnDrag$lambda$4(NlInteractionHandler this$0) {
        this$0.surface.repaint();
        return Unit.INSTANCE;
    }
}

