/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface.interaction;

import com.android.resources.Density;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.configurations.Configuration;
import com.android.tools.configurations.ConfigurationUtilKt;
import com.android.tools.configurations.Configurations;
import com.android.tools.configurations.ConversionUtil;
import com.android.tools.configurations.DeviceSize;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.InteractionEvent;
import com.android.tools.idea.common.surface.InteractionInformation;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.MouseDraggedEvent;
import com.android.tools.idea.common.surface.MousePressedEvent;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.analytics.ResizeTracker;
import com.android.tools.idea.uibuilder.graphics.NlConstants;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CanvasResizeInteraction
implements Interaction {
    private static final int MAX_ANDROID_SIZE_DP = 1500;
    private static final int MIN_ANDROID_SIZE_DP = 10;
    @NotNull
    private final NlDesignSurface myDesignSurface;
    @NotNull
    private final ScreenView myScreenView;
    @NotNull
    private final Configuration myConfiguration;
    private final Device myOriginalDevice;
    private final State myOriginalDeviceState;
    private final MergingUpdateQueue myUpdateQueue;
    private final int myMaxAndroidSizePx;
    private final int myMinAndroidSizePx;
    private int myCurrentAndroidWidth;
    private int myCurrentAndroidHeight;
    private final int myCurrentDpi;
    private int myCurrentX;
    private int myCurrentY;
    private InteractionInformation myStartInfo;
    private final int myResizeTriggerThreshold = JBUI.scale((int)200);
    private final Update myPositionUpdate = new Update("CanvasResizePositionUpdate"){

        public void run() {
            Configurations.updateScreenSize((Configuration)CanvasResizeInteraction.this.myConfiguration, (int)CanvasResizeInteraction.this.myCurrentAndroidWidth, (int)CanvasResizeInteraction.this.myCurrentAndroidHeight);
        }
    };

    public CanvasResizeInteraction(@NotNull NlDesignSurface designSurface2, @NotNull ScreenView screenView, @NotNull Configuration configuration) {
        this.myDesignSurface = designSurface2;
        this.myScreenView = screenView;
        this.myConfiguration = configuration;
        this.myUpdateQueue = new MergingUpdateQueue("layout.editor.canvas.resize", 10, true, null, (Disposable)this.myDesignSurface);
        this.myUpdateQueue.setRestartTimerOnAdd(true);
        this.myOriginalDevice = configuration.getCachedDevice();
        this.myOriginalDeviceState = configuration.getDeviceState();
        this.myCurrentDpi = configuration.getDensity().getDpiValue();
        this.myMaxAndroidSizePx = (int)(1500.0 * (double)this.myCurrentDpi / (double)Density.DEFAULT_DENSITY);
        this.myMinAndroidSizePx = (int)(10.0 * (double)this.myCurrentDpi / (double)Density.DEFAULT_DENSITY);
        DeviceSize deviceSize = ConfigurationUtilKt.deviceSizePx((Configuration)this.myScreenView.getConfiguration());
        this.myCurrentAndroidWidth = deviceSize.getWidth();
        this.myCurrentAndroidHeight = deviceSize.getHeight();
    }

    @Override
    public void begin(@NotNull InteractionEvent event) {
        if (event instanceof MousePressedEvent) {
            MouseEvent mouseEvent = (MouseEvent)((MousePressedEvent)event).getEventObject();
            this.myStartInfo = event.getInfo();
            int x = mouseEvent.getX();
            int y = mouseEvent.getY();
            this.myCurrentX = x;
            this.myCurrentY = y;
            this.myDesignSurface.setResizeMode(true);
        }
    }

    @Override
    public void update(@NotNull InteractionEvent event) {
        if (event instanceof MouseDraggedEvent) {
            MouseEvent mouseEvent = (MouseEvent)((MouseDraggedEvent)event).getEventObject();
            int x = mouseEvent.getX();
            int y = mouseEvent.getY();
            if (this.myOriginalDevice.isScreenRound()) {
                int startY;
                int deltaY;
                int startX = this.myStartInfo.getX();
                int deltaX = x - startX;
                if (deltaX > (deltaY = y - (startY = this.myStartInfo.getY()))) {
                    y = startY + deltaX;
                } else {
                    x = startX + deltaY;
                }
            }
            this.myCurrentX = x;
            this.myCurrentY = y;
            int swingWidth = this.myCurrentX - this.myScreenView.getX();
            int swingHeight = this.myCurrentY - this.myScreenView.getY();
            int androidWidth = Coordinates.getAndroidDimension(this.myScreenView, swingWidth);
            int androidHeight = Coordinates.getAndroidDimension(this.myScreenView, swingHeight);
            this.myCurrentAndroidWidth = Math.max(this.myMinAndroidSizePx, Math.min(androidWidth, this.myMaxAndroidSizePx));
            this.myCurrentAndroidHeight = Math.max(this.myMinAndroidSizePx, Math.min(androidHeight, this.myMaxAndroidSizePx));
            Dimension viewSize = this.myDesignSurface.getViewSize();
            int maxX = Coordinates.getSwingX((SceneView)this.myScreenView, this.myMaxAndroidSizePx) + 50;
            int maxY = Coordinates.getSwingY((SceneView)this.myScreenView, this.myMaxAndroidSizePx) + 50;
            if (this.myCurrentX < maxX && this.myCurrentY < maxY && ((double)(this.myCurrentX + this.myResizeTriggerThreshold * 2) > viewSize.getWidth() || (double)(this.myCurrentY + this.myResizeTriggerThreshold * 2) > viewSize.getHeight())) {
                this.myDesignSurface.setScrollableViewMinSize(new Dimension(this.myCurrentX + this.myResizeTriggerThreshold, this.myCurrentY + this.myResizeTriggerThreshold));
                this.myDesignSurface.validateScrollArea();
            }
            this.myUpdateQueue.queue(this.myPositionUpdate);
        }
    }

    @Override
    public void commit(@NotNull InteractionEvent event) {
        this.myDesignSurface.setResizeMode(false);
        this.myDesignSurface.setScrollableViewMinSize(new Dimension(0, 0));
        DeviceSize deviceSize = ConfigurationUtilKt.deviceSizePx((Configuration)this.myScreenView.getConfiguration());
        if (this.myCurrentAndroidWidth == deviceSize.getWidth() && this.myCurrentAndroidHeight == deviceSize.getHeight()) {
            return;
        }
        ResizeTracker tracker = ResizeTracker.getTracker(this.myScreenView.getSceneManager());
        Configurations.updateScreenSize((Configuration)this.myConfiguration, (int)this.myCurrentAndroidWidth, (int)this.myCurrentAndroidHeight);
        int androidXDp = ConversionUtil.INSTANCE.pxToDp(this.myCurrentAndroidWidth, this.myCurrentDpi);
        int androidYDp = ConversionUtil.INSTANCE.pxToDp(this.myCurrentAndroidHeight, this.myCurrentDpi);
        if (tracker != null) {
            tracker.reportResizeStopped(this.myScreenView.getSceneManager(), androidXDp, androidYDp, this.myCurrentDpi);
        }
    }

    @Override
    public void cancel(@NotNull InteractionEvent event) {
        this.myConfiguration.setEffectiveDevice(this.myOriginalDevice, this.myOriginalDeviceState);
    }

    @Override
    @Nullable
    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(5);
    }

    @Override
    @NotNull
    public synchronized List<Layer> createOverlays() {
        ImmutableList.Builder layers = ImmutableList.builder();
        layers.add((Object)new ResizeOutlineLayer());
        return layers.build();
    }

    private class ResizeOutlineLayer
    extends Layer {
        private ResizeOutlineLayer() {
        }

        @Override
        public void paint(@NotNull Graphics2D g2d) {
            int screenViewX = CanvasResizeInteraction.this.myScreenView.getX();
            int screenViewY = CanvasResizeInteraction.this.myScreenView.getY();
            int currentSwingWidth = Coordinates.getSwingDimension((SceneView)CanvasResizeInteraction.this.myScreenView, CanvasResizeInteraction.this.myCurrentAndroidWidth);
            int currentSwingHeight = Coordinates.getSwingDimension((SceneView)CanvasResizeInteraction.this.myScreenView, CanvasResizeInteraction.this.myCurrentAndroidHeight);
            if (currentSwingWidth > 0 && currentSwingHeight > 0) {
                boolean atMaxHeight;
                Graphics2D graphics = (Graphics2D)g2d.create();
                graphics.setStroke(NlConstants.THICK_SOLID_STROKE);
                boolean atMinWidth = CanvasResizeInteraction.this.myCurrentAndroidWidth == CanvasResizeInteraction.this.myMinAndroidSizePx;
                boolean atMinHeight = CanvasResizeInteraction.this.myCurrentAndroidHeight == CanvasResizeInteraction.this.myMinAndroidSizePx;
                boolean atMaxWidth = CanvasResizeInteraction.this.myCurrentAndroidWidth == CanvasResizeInteraction.this.myMaxAndroidSizePx;
                boolean bl = atMaxHeight = CanvasResizeInteraction.this.myCurrentAndroidHeight == CanvasResizeInteraction.this.myMaxAndroidSizePx;
                if (atMinWidth || atMinHeight || atMaxWidth || atMaxHeight) {
                    graphics.setColor((Color)JBColor.RED);
                } else {
                    graphics.setColor(NlConstants.RESIZING_CONTOUR_COLOR);
                }
                graphics.drawRect(screenViewX - 1, screenViewY - 1, currentSwingWidth, currentSwingHeight);
                graphics.dispose();
            }
        }
    }
}

