/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface.sizepolicy;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.tools.idea.uibuilder.surface.sizepolicy.ContentSizePolicy;
import com.android.tools.rendering.RenderResult;
import java.awt.Dimension;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/uibuilder/surface/sizepolicy/ImageContentSizePolicy;", "Lcom/android/tools/idea/uibuilder/surface/sizepolicy/ContentSizePolicy;", "sizePolicyDelegate", "<init>", "(Lcom/android/tools/idea/uibuilder/surface/sizepolicy/ContentSizePolicy;)V", "cachedDimension", "Ljava/awt/Dimension;", "measure", "", "screenView", "Lcom/android/tools/idea/uibuilder/surface/ScreenView;", "outDimension", "intellij.android.designer"})
@StabilityInferred(parameters=0)
public final class ImageContentSizePolicy
implements ContentSizePolicy {
    @NotNull
    private final ContentSizePolicy sizePolicyDelegate;
    @Nullable
    private Dimension cachedDimension;
    public static final int $stable = 8;

    public ImageContentSizePolicy(@NotNull ContentSizePolicy sizePolicyDelegate) {
        Intrinsics.checkNotNullParameter((Object)sizePolicyDelegate, (String)"sizePolicyDelegate");
        this.sizePolicyDelegate = sizePolicyDelegate;
    }

    @Override
    public void measure(@NotNull ScreenView screenView, @NotNull Dimension outDimension) {
        Dimension contentSize;
        RenderResult result;
        Intrinsics.checkNotNullParameter((Object)screenView, (String)"screenView");
        Intrinsics.checkNotNullParameter((Object)outDimension, (String)"outDimension");
        RenderResult renderResult = result = screenView.getSceneManager().getRenderResult();
        Dimension dimension = contentSize = renderResult != null ? renderResult.getRootViewDimensions() : null;
        if (contentSize != null) {
            try {
                outDimension.setSize(Coordinates.pxToDp((SceneView)screenView, contentSize.width), Coordinates.pxToDp((SceneView)screenView, contentSize.height));
                if (this.cachedDimension == null) {
                    this.cachedDimension = new Dimension(outDimension);
                } else {
                    Dimension dimension2 = this.cachedDimension;
                    Intrinsics.checkNotNull((Object)dimension2);
                    dimension2.setSize(outDimension);
                }
                return;
            }
            catch (AssertionError assertionError) {
                // empty catch block
            }
        }
        if (this.cachedDimension != null) {
            outDimension.setSize(this.cachedDimension);
            return;
        }
        this.sizePolicyDelegate.measure(screenView, outDimension);
    }

    @Override
    public boolean hasContentSize(@NotNull ScreenView screenView) {
        return ContentSizePolicy.super.hasContentSize(screenView);
    }
}

