/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.visual;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.configurations.Configuration;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.type.DesignerEditorFileTypeKt;
import com.android.tools.idea.configurations.ConfigurationForFile;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.rendering.AndroidBuildTargetReference;
import com.android.tools.idea.uibuilder.model.NlComponentRegistrar;
import com.android.tools.idea.uibuilder.type.LayoutFileType;
import com.android.tools.idea.uibuilder.visual.CustomConfigurationUtilsKt;
import com.android.tools.idea.uibuilder.visual.ModelsProviderConfigurationListenerKt;
import com.android.tools.idea.uibuilder.visual.VisualizationModelsProvider;
import com.android.tools.idea.uibuilder.visual.colorblindmode.ColorBlindMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/uibuilder/visual/ColorBlindModeModelsProvider;", "Lcom/android/tools/idea/uibuilder/visual/VisualizationModelsProvider;", "<init>", "()V", "createNlModels", "", "Lcom/android/tools/idea/common/model/NlModel;", "parent", "Lcom/intellij/openapi/Disposable;", "file", "Lcom/intellij/psi/PsiFile;", "buildTarget", "Lcom/android/tools/idea/rendering/AndroidBuildTargetReference;", "intellij.android.designer"})
@StabilityInferred(parameters=1)
public final class ColorBlindModeModelsProvider
implements VisualizationModelsProvider {
    @NotNull
    public static final ColorBlindModeModelsProvider INSTANCE = new ColorBlindModeModelsProvider();
    public static final int $stable;

    private ColorBlindModeModelsProvider() {
    }

    @Override
    @NotNull
    public List<NlModel> createNlModels(@NotNull Disposable parent, @NotNull PsiFile file2, @NotNull AndroidBuildTargetReference buildTarget) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)buildTarget, (String)"buildTarget");
        if (!Intrinsics.areEqual((Object)DesignerEditorFileTypeKt.typeOf(file2), (Object)LayoutFileType.INSTANCE)) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile2 = virtualFile;
        ConfigurationManager configurationManager = ConfigurationManager.getOrCreateInstance((Module)buildTarget.getModule());
        Intrinsics.checkNotNullExpressionValue((Object)configurationManager, (String)"getOrCreateInstance(...)");
        ConfigurationManager configurationManager2 = configurationManager;
        ConfigurationForFile configurationForFile = configurationManager2.getConfiguration(virtualFile2);
        Intrinsics.checkNotNullExpressionValue((Object)configurationForFile, (String)"getConfiguration(...)");
        ConfigurationForFile defaultConfig = configurationForFile;
        List models = new ArrayList();
        for (ColorBlindMode mode : ColorBlindMode.getEntries()) {
            ConfigurationForFile config = defaultConfig.clone();
            config.setImageTransformation(mode.getImageTransform());
            NlModel model = new NlModel.Builder(parent, buildTarget, virtualFile2, (Configuration)config).withComponentRegistrar(NlComponentRegistrar.INSTANCE).build();
            model.getDisplaySettings().setTooltip(CustomConfigurationUtilsKt.toHtmlTooltip((Configuration)defaultConfig));
            model.getDisplaySettings().setDisplayName(mode.getDisplayName());
            models.add(model);
            ModelsProviderConfigurationListenerKt.registerModelsProviderConfigurationListener(model, (Configuration)defaultConfig, (Configuration)config, 3326);
        }
        return models;
    }

    @Override
    @NotNull
    public ActionGroup createActions() {
        return VisualizationModelsProvider.super.createActions();
    }
}

