/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.visual;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.ide.common.resources.Locale;
import com.android.resources.NightMode;
import com.android.resources.UiMode;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.configurations.AdaptiveIconShape;
import com.android.tools.configurations.Configuration;
import com.android.tools.configurations.ConfigurationListener;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.uibuilder.visual.CustomConfigurationUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/uibuilder/visual/ModelsProviderConfigurationListener;", "Lcom/android/tools/configurations/ConfigurationListener;", "model", "Lcom/android/tools/idea/common/model/NlModel;", "sourceConfig", "Lcom/android/tools/configurations/Configuration;", "responseConfig", "attributesMask", "", "<init>", "(Lcom/android/tools/idea/common/model/NlModel;Lcom/android/tools/configurations/Configuration;Lcom/android/tools/configurations/Configuration;I)V", "changed", "", "flags", "intellij.android.designer"})
@StabilityInferred(parameters=0)
public final class ModelsProviderConfigurationListener
implements ConfigurationListener {
    @NotNull
    private final NlModel model;
    @NotNull
    private final Configuration sourceConfig;
    @NotNull
    private final Configuration responseConfig;
    private final int attributesMask;
    public static final int $stable = 8;

    public ModelsProviderConfigurationListener(@NotNull NlModel model, @NotNull Configuration sourceConfig, @NotNull Configuration responseConfig, int attributesMask) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)sourceConfig, (String)"sourceConfig");
        Intrinsics.checkNotNullParameter((Object)responseConfig, (String)"responseConfig");
        this.model = model;
        this.sourceConfig = sourceConfig;
        this.responseConfig = responseConfig;
        this.attributesMask = attributesMask;
    }

    public boolean changed(int flags) {
        int effectiveFlags = flags & this.attributesMask;
        if ((effectiveFlags & 0x800) != 0) {
            AdaptiveIconShape adaptiveIconShape = this.sourceConfig.getAdaptiveShape();
            Intrinsics.checkNotNullExpressionValue((Object)adaptiveIconShape, (String)"getAdaptiveShape(...)");
            AdaptiveIconShape adaptiveShape = adaptiveIconShape;
            this.responseConfig.setAdaptiveShape(adaptiveShape);
        }
        if ((effectiveFlags & 2) != 0) {
            Device device = this.sourceConfig.getDevice();
            this.responseConfig.setDevice(device, false);
        }
        if ((effectiveFlags & 4) != 0) {
            State state = this.sourceConfig.getDeviceState();
            if (state == null) {
                return false;
            }
            State sourceState = state;
            this.responseConfig.setDeviceStateName(sourceState.getName());
        }
        if ((effectiveFlags & 0x80) != 0) {
            UiMode uiMode = this.sourceConfig.getUiMode();
            Intrinsics.checkNotNullExpressionValue((Object)uiMode, (String)"getUiMode(...)");
            UiMode uiMode2 = uiMode;
            this.responseConfig.setUiMode(uiMode2);
        }
        if ((effectiveFlags & 0x40) != 0) {
            NightMode nightMode = this.sourceConfig.getNightMode();
            Intrinsics.checkNotNullExpressionValue((Object)nightMode, (String)"getNightMode(...)");
            NightMode nightMode2 = nightMode;
            this.responseConfig.setNightMode(nightMode2);
        }
        if ((effectiveFlags & 8) != 0) {
            String string = this.sourceConfig.getTheme();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTheme(...)");
            String theme = string;
            this.responseConfig.setTheme(theme);
        }
        if ((effectiveFlags & 0x20) != 0) {
            IAndroidTarget target = this.sourceConfig.getTarget();
            this.responseConfig.setTarget(target);
        }
        if ((effectiveFlags & 0x10) != 0) {
            Locale locale = this.sourceConfig.getLocale();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getLocale(...)");
            Locale locale2 = locale;
            this.responseConfig.setLocale(locale2);
        }
        if ((effectiveFlags & 0x400) != 0) {
            float fontScale = this.sourceConfig.getFontScale();
            this.responseConfig.setFontScale(fontScale);
        }
        this.model.getDisplaySettings().setTooltip(CustomConfigurationUtilsKt.toHtmlTooltip(this.responseConfig));
        return true;
    }
}

