/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.visual;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.common.error.IssueModel;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceHelper;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.visual.visuallint.ViewVisualLintIssueProvider;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintService;
import com.android.tools.rendering.RenderResult;
import com.android.tools.visuallint.VisualLintBaseConfigIssues;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011J\u001c\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\u0006\u0010\u0019\u001a\u00020\u0011J\u0006\u0010\u001a\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/uibuilder/visual/VisualizationFormVisualLintHandler;", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "issueModel", "Lcom/android/tools/idea/common/error/IssueModel;", "<init>", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/common/error/IssueModel;)V", "myBaseConfigIssues", "Lcom/android/tools/visuallint/VisualLintBaseConfigIssues;", "lintIssueProvider", "Lcom/android/tools/idea/uibuilder/visual/visuallint/ViewVisualLintIssueProvider;", "getLintIssueProvider", "()Lcom/android/tools/idea/uibuilder/visual/visuallint/ViewVisualLintIssueProvider;", "clearIssueProvider", "", "clearIssueProviderAndBaseConfigurationIssue", "afterRenderCompleted", "manager", "Lcom/android/tools/idea/uibuilder/scene/LayoutlibSceneManager;", "isCancelled", "Lkotlin/Function0;", "", "onActivate", "onDeactivate", "intellij.android.designer"})
@StabilityInferred(parameters=0)
public final class VisualizationFormVisualLintHandler {
    @NotNull
    private final Project project;
    @NotNull
    private final IssueModel issueModel;
    @NotNull
    private final VisualLintBaseConfigIssues myBaseConfigIssues;
    @NotNull
    private final ViewVisualLintIssueProvider lintIssueProvider;
    public static final int $stable = 8;

    public VisualizationFormVisualLintHandler(@NotNull Disposable parentDisposable, @NotNull Project project, @NotNull IssueModel issueModel) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)issueModel, (String)"issueModel");
        this.project = project;
        this.issueModel = issueModel;
        this.myBaseConfigIssues = new VisualLintBaseConfigIssues();
        this.lintIssueProvider = new ViewVisualLintIssueProvider(parentDisposable);
        this.issueModel.addIssueProvider(this.lintIssueProvider);
    }

    @NotNull
    public final ViewVisualLintIssueProvider getLintIssueProvider() {
        return this.lintIssueProvider;
    }

    public final void clearIssueProvider() {
        this.lintIssueProvider.clear();
        this.issueModel.updateErrorsList();
    }

    public final void clearIssueProviderAndBaseConfigurationIssue() {
        this.lintIssueProvider.clear();
        this.issueModel.updateErrorsList();
        this.myBaseConfigIssues.clear();
    }

    public final void afterRenderCompleted(@NotNull LayoutlibSceneManager manager, @NotNull Function0<Boolean> isCancelled) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(isCancelled, (String)"isCancelled");
        if (((Boolean)isCancelled.invoke()).booleanValue() || manager.getModel().isDisposed()) {
            return;
        }
        NlModel model = manager.getModel();
        RenderResult result = manager.getRenderResult();
        if (result != null) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> VisualizationFormVisualLintHandler.afterRenderCompleted$lambda$0(this, result, model));
        }
    }

    public final void onActivate() {
        VisualLintService.Companion.getInstance(this.project).removeAllIssueProviders();
        this.issueModel.addIssueProvider(this.lintIssueProvider);
        this.issueModel.updateErrorsList();
    }

    public final void onDeactivate() {
        NlDesignSurface nlDesignSurface;
        this.issueModel.removeIssueProvider(this.lintIssueProvider);
        this.lintIssueProvider.clear();
        this.issueModel.updateErrorsList();
        FileEditor fileEditor = FileEditorManager.getInstance((Project)this.project).getSelectedEditor();
        DesignSurface<?> designSurface2 = fileEditor != null ? DesignSurfaceHelper.getDesignSurface(fileEditor) : null;
        NlDesignSurface nlDesignSurface2 = nlDesignSurface = designSurface2 instanceof NlDesignSurface ? (NlDesignSurface)designSurface2 : null;
        if (nlDesignSurface != null) {
            nlDesignSurface.updateErrorDisplay();
        }
    }

    private static final void afterRenderCompleted$lambda$0(VisualizationFormVisualLintHandler this$0, RenderResult $result, NlModel $model) {
        VisualLintService.analyzeAfterModelUpdate$default(VisualLintService.Companion.getInstance(this$0.project), this$0.lintIssueProvider, $result, $model, this$0.myBaseConfigIssues, false, 16, null);
    }
}

