/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.visual;

import com.android.tools.idea.uibuilder.visual.ConfigurationSet;
import com.android.tools.idea.uibuilder.visual.ConfigurationSetProvider;
import com.android.tools.idea.uibuilder.visual.CustomConfigurationSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@Service
@State(name="VisualizationTool", storages={@Storage(value="visualizationTool.xml", roamingType=RoamingType.DISABLED)})
public final class VisualizationToolSettings
implements PersistentStateComponent<MyState> {
    private GlobalState myGlobalState = new GlobalState();

    public static VisualizationToolSettings getInstance() {
        return (VisualizationToolSettings)ApplicationManager.getApplication().getService(VisualizationToolSettings.class);
    }

    @NotNull
    public GlobalState getGlobalState() {
        return this.myGlobalState;
    }

    public MyState getState() {
        MyState state = new MyState();
        state.setState(this.myGlobalState);
        return state;
    }

    public void loadState(@NotNull MyState state) {
        this.myGlobalState = state.getState();
    }

    public static class GlobalState {
        private boolean myFirstTimeOpen = true;
        private boolean myVisible = false;
        private boolean myShowDecoration = false;
        @NotNull
        private String myConfigurationSetId = ConfigurationSetProvider.defaultSet.getId();
        @NotNull
        private Map<String, CustomConfigurationSet> myCustomConfigurationSets = new LinkedHashMap<String, CustomConfigurationSet>();

        public boolean isFirstTimeOpen() {
            return this.myFirstTimeOpen;
        }

        public void setFirstTimeOpen(boolean firstTimeOpen) {
            this.myFirstTimeOpen = firstTimeOpen;
        }

        public boolean isVisible() {
            return this.myVisible;
        }

        public void setVisible(boolean visible) {
            this.myVisible = visible;
        }

        public boolean getShowDecoration() {
            return this.myShowDecoration;
        }

        public void setShowDecoration(boolean showDecoration) {
            this.myShowDecoration = showDecoration;
        }

        @NotNull
        public String getConfigurationSetId() {
            return this.myConfigurationSetId;
        }

        public void setConfigurationSetId(@NotNull String configurationSetId) {
            this.myConfigurationSetId = configurationSetId;
        }

        @NotNull
        public Map<String, CustomConfigurationSet> getCustomConfigurationSets() {
            return this.myCustomConfigurationSets;
        }

        public void setCustomConfigurationSets(@NotNull Map<String, CustomConfigurationSet> customConfigurationSets) {
            this.myCustomConfigurationSets = customConfigurationSets;
        }

        @Transient
        @NotNull
        public ConfigurationSet getLastSelectedConfigurationSet() {
            ConfigurationSet set = ConfigurationSetProvider.getConfigurationById(this.myConfigurationSetId);
            if (set == null || !set.getVisible()) {
                set = ConfigurationSetProvider.defaultSet;
                this.myConfigurationSetId = ConfigurationSetProvider.defaultSet.getId();
            }
            return set;
        }

        @Transient
        public void setLastSelectedConfigurationSet(@NotNull ConfigurationSet configurationSet) {
            this.myConfigurationSetId = configurationSet.getId();
        }
    }

    public static class MyState {
        private GlobalState myGlobalState = new GlobalState();

        public GlobalState getState() {
            return this.myGlobalState;
        }

        public void setState(GlobalState state) {
            this.myGlobalState = state;
        }
    }
}

