/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.visuallint.analyzers;

import android.graphics.RectF;
import android.view.View;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.Button;
import android.widget.TextView;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.configurations.Configuration;
import com.android.tools.rendering.RenderResult;
import com.android.tools.visuallint.VisualLintAnalyzer;
import com.android.tools.visuallint.VisualLintErrorType;
import com.android.utils.HtmlBuilder;
import com.google.common.collect.ImmutableList;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J.\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0012H\u0002J@\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u0012H\u0002J(\u0010%\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u001fH\u0002J \u0010(\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u0012H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006+"}, d2={"Lcom/android/tools/visuallint/analyzers/OverlapAnalyzer;", "Lcom/android/tools/visuallint/VisualLintAnalyzer;", "<init>", "()V", "type", "Lcom/android/tools/visuallint/VisualLintErrorType;", "getType", "()Lcom/android/tools/visuallint/VisualLintErrorType;", "findIssues", "", "Lcom/android/tools/visuallint/VisualLintAnalyzer$VisualLintIssueContent;", "renderResult", "Lcom/android/tools/rendering/RenderResult;", "configuration", "Lcom/android/tools/configurations/Configuration;", "findOverlapOfTextViewIssues", "", "view", "Lcom/android/ide/common/rendering/api/ViewInfo;", "backgroundBounds", "Ljava/awt/Rectangle;", "foregroundBounds", "issueList", "", "createIssueContent", "firstView", "secondView", "isPartiallyHidden", "", "firstViewInfo", "i", "", "firstBounds", "secondViewInfo", "j", "secondBounds", "parentViewInfo", "isFirstViewUnderneath", "firstViewIndex", "secondViewIndex", "getTextBounds", "textBounds", "parent", "intellij.android.visual-lint"})
@SourceDebugExtension(value={"SMAP\nOverlapAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OverlapAnalyzer.kt\ncom/android/tools/visuallint/analyzers/OverlapAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,226:1\n1869#2,2:227\n774#2:229\n865#2,2:230\n1869#2,2:232\n*S KotlinDebug\n*F\n+ 1 OverlapAnalyzer.kt\ncom/android/tools/visuallint/analyzers/OverlapAnalyzer\n*L\n56#1:227,2\n69#1:229\n69#1:230,2\n208#1:232,2\n*E\n"})
public final class OverlapAnalyzer
extends VisualLintAnalyzer {
    @NotNull
    public static final OverlapAnalyzer INSTANCE = new OverlapAnalyzer();

    private OverlapAnalyzer() {
    }

    @Override
    @NotNull
    public VisualLintErrorType getType() {
        return VisualLintErrorType.OVERLAP;
    }

    @Override
    @NotNull
    public List<VisualLintAnalyzer.VisualLintIssueContent> findIssues(@NotNull RenderResult renderResult, @NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)renderResult, (String)"renderResult");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        List issues = new ArrayList();
        ImmutableList immutableList = renderResult.getRootViews();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"getRootViews(...)");
        ArrayDeque viewsToAnalyze = new ArrayDeque((Collection)immutableList);
        Rectangle backgroundBounds = new Rectangle(0, 0, 0, 0);
        Rectangle foregroundBounds = new Rectangle(0, 0, 0, 0);
        while (!((Collection)viewsToAnalyze).isEmpty()) {
            ViewInfo view = (ViewInfo)viewsToAnalyze.removeLast();
            List list = view.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ViewInfo it = (ViewInfo)element$iv;
                boolean bl = false;
                viewsToAnalyze.addLast((Object)it);
            }
            Intrinsics.checkNotNull((Object)view);
            this.findOverlapOfTextViewIssues(view, backgroundBounds, foregroundBounds, issues);
        }
        return issues;
    }

    /*
     * Unable to fully structure code
     */
    private final void findOverlapOfTextViewIssues(ViewInfo view, Rectangle backgroundBounds, Rectangle foregroundBounds, List<VisualLintAnalyzer.VisualLintIssueContent> issueList) {
        v0 = view.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getChildren(...)");
        $this$filter$iv = v0;
        $i$f$filter = false;
        var8_8 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (ViewInfo)element$iv$iv;
            $i$a$-filter-OverlapAnalyzer$findOverlapOfTextViewIssues$children$1 = false;
            if (it.getAccessibilityObject() != null) ** GOTO lbl-1000
            if (it.getCookie() != null) {
                var15_16 = it.getViewObject();
                v1 = var15_16 instanceof View != false ? (View)var15_16 : null;
                v2 = v1 != null ? v1.getVisibility() == 0 : false;
                ** if (!v2) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                v3 = true;
                ** GOTO lbl21
            }
lbl-1000:
            // 2 sources

            {
                v3 = false;
            }
lbl21:
            // 2 sources

            if (!v3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        children = (List)destination$iv$iv;
        var7_7 = ((Collection)children).size();
        for (i = 0; i < var7_7; ++i) {
            firstView = (ViewInfo)children.get(i);
            Intrinsics.checkNotNull((Object)firstView);
            if (!VisualLintAnalyzer.Companion.checkIsClass(firstView, TextView.class)) continue;
            var10_11 = ((Collection)children).size();
            for (j = 0; j < var10_11; ++j) {
                secondView = (ViewInfo)children.get(j);
                if (Intrinsics.areEqual((Object)firstView, (Object)secondView)) continue;
                Intrinsics.checkNotNull((Object)secondView);
                if (!this.isPartiallyHidden(firstView, i, backgroundBounds, secondView, j, foregroundBounds, view)) continue;
                issueList.add(this.createIssueContent(firstView, secondView));
            }
        }
    }

    private final VisualLintAnalyzer.VisualLintIssueContent createIssueContent(ViewInfo firstView, ViewInfo secondView) {
        String firstName = VisualLintAnalyzer.Companion.nameWithId(firstView);
        String secondName = VisualLintAnalyzer.Companion.nameWithId(secondView);
        String summary = firstName + " is covered by " + secondName;
        Function1 content = arg_0 -> OverlapAnalyzer.createIssueContent$lambda$2(firstName, secondName, arg_0);
        return new VisualLintAnalyzer.VisualLintIssueContent(firstView, summary, null, content, 4, null);
    }

    private final boolean isPartiallyHidden(ViewInfo firstViewInfo, int i, Rectangle firstBounds, ViewInfo secondViewInfo, int j, Rectangle secondBounds, ViewInfo parentViewInfo) {
        if (!this.isFirstViewUnderneath(firstViewInfo, i, secondViewInfo, j)) {
            return false;
        }
        this.getTextBounds(firstViewInfo, firstBounds, parentViewInfo);
        if (firstBounds.width == 0 || firstBounds.height == 0) {
            return false;
        }
        secondBounds.setBounds(secondViewInfo.getLeft(), secondViewInfo.getTop(), secondViewInfo.getRight() - secondViewInfo.getLeft(), secondViewInfo.getBottom() - secondViewInfo.getTop());
        Rectangle intersection = firstBounds.intersection(secondBounds);
        if (intersection.isEmpty()) {
            return false;
        }
        double coveredRatio = 1.0 * (double)intersection.width * (double)intersection.height / (double)(firstBounds.width * firstBounds.height);
        return coveredRatio >= 0.5;
    }

    private final boolean isFirstViewUnderneath(ViewInfo firstViewInfo, int firstViewIndex, ViewInfo secondViewInfo, int secondViewIndex) {
        if (!(firstViewInfo.getAccessibilityObject() instanceof AccessibilityNodeInfo) && !(secondViewInfo.getAccessibilityObject() instanceof AccessibilityNodeInfo)) {
            View secondView;
            Object object = firstViewInfo.getViewObject();
            View firstView = object instanceof View ? (View)object : null;
            Object object2 = secondViewInfo.getViewObject();
            View view = secondView = object2 instanceof View ? (View)object2 : null;
            if (firstView != null && secondView != null) {
                float secondElevation;
                float firstElevation = firstView.getElevation();
                if (firstElevation < (secondElevation = secondView.getElevation())) {
                    return true;
                }
                if (firstElevation > secondElevation) {
                    return false;
                }
            }
        }
        if (secondViewInfo.getAccessibilityObject() != null && VisualLintAnalyzer.Companion.checkIsClass(secondViewInfo, Button.class)) {
            return false;
        }
        return firstViewIndex < secondViewIndex;
    }

    private final void getTextBounds(ViewInfo view, Rectangle textBounds, ViewInfo parent) {
        int width = view.getRight() - view.getLeft();
        int height = view.getBottom() - view.getTop();
        textBounds.setBounds(view.getLeft(), view.getTop(), width, height);
        Object object = view.getAccessibilityObject();
        AccessibilityNodeInfo accessibilityNodeInfo = object instanceof AccessibilityNodeInfo ? (AccessibilityNodeInfo)object : null;
        Object[] data = accessibilityNodeInfo != null && (object = accessibilityNodeInfo.getExtras()) != null ? (RectF[])object.getParcelableArray("android.view.accessibility.extra.DATA_TEXT_CHARACTER_LOCATION_KEY", RectF.class) : null;
        accessibilityNodeInfo = data;
        if (accessibilityNodeInfo == null || ((AccessibilityNodeInfo)accessibilityNodeInfo).length == 0) {
            return;
        }
        int left = 0;
        left = Integer.MAX_VALUE;
        int right = 0;
        right = Integer.MIN_VALUE;
        int top = 0;
        top = Integer.MAX_VALUE;
        int bottom = 0;
        bottom = Integer.MIN_VALUE;
        Iterable $this$forEach$iv = ArraysKt.filterNotNull((Object[])data);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RectF it = (RectF)element$iv;
            boolean bl = false;
            left = Math.min(left, (int)it.left);
            right = Math.max(right, (int)Math.ceil(it.right));
            top = Math.min(top, (int)it.top);
            bottom = Math.max(bottom, (int)Math.ceil(it.bottom));
        }
        if (right >= left && bottom >= top) {
            Object object2 = parent.getAccessibilityObject();
            AccessibilityNodeInfo accessibilityNodeInfo2 = object2 instanceof AccessibilityNodeInfo ? (AccessibilityNodeInfo)object2 : null;
            if (accessibilityNodeInfo2 == null || (accessibilityNodeInfo2 = accessibilityNodeInfo2.getBoundsInScreen()) == null) {
                return;
            }
            AccessibilityNodeInfo parentBounds = accessibilityNodeInfo2;
            textBounds.setBounds(left - parentBounds.left, top - parentBounds.top, right - left, bottom - top);
        }
    }

    private static final HtmlBuilder createIssueContent$lambda$2(String $firstName, String $secondName, int count) {
        return new HtmlBuilder().add("Content of " + $firstName + " is partially covered by " + $secondName + " in " + VisualLintAnalyzer.Companion.previewConfigurations(count) + ".").newline().add("This may affect text readability. Fix this issue by adjusting widget positioning.");
    }
}

