/*
 * Decompiled with CFR 0.152.
 */
package shark.internal.hppc;

import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shark.internal.hppc.HPPC;
import shark.internal.hppc.LongLongPair;
import shark.internal.hppc.TuplesKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0000\u0018\u00002\u00020\u0001:\u00012B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J \u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\u000e\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001aJ\u000e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 J\u000e\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$J\u0011\u0010%\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001aH\u0086\u0002J\u000e\u0010&\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001aJ\u000e\u0010'\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u0003J\u0010\u0010(\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001aH\u0002J\u0018\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u000bH\u0002J\u0006\u0010,\u001a\u00020\u0015J\u000e\u0010-\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001aJ\u0019\u0010.\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020\u001aH\u0086\u0002J\u0010\u00100\u001a\u00020\u00152\u0006\u00101\u001a\u00020\u0003H\u0002R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lshark/internal/hppc/LongLongScatterMap;", "", "expectedElements", "", "(I)V", "assigned", "hasEmptyKey", "", "isEmpty", "()Z", "keys", "", "loadFactor", "", "mask", "resizeAt", "size", "getSize", "()I", "values", "allocateBuffers", "", "arraySize", "allocateThenInsertThenRehash", "slot", "pendingKey", "", "pendingValue", "containsKey", "key", "ensureCapacity", "entrySequence", "Lkotlin/sequences/Sequence;", "Lshark/internal/hppc/LongLongPair;", "forEach", "forEachCallback", "Lshark/internal/hppc/LongLongScatterMap$ForEachCallback;", "get", "getSlot", "getSlotValue", "hashKey", "rehash", "fromKeys", "fromValues", "release", "remove", "set", "value", "shiftConflictingKeys", "gapSlotArg", "ForEachCallback", "shark-graph"})
public final class LongLongScatterMap {
    private long[] keys;
    private long[] values;
    private int assigned;
    private int mask;
    private int resizeAt;
    private boolean hasEmptyKey;
    private double loadFactor;

    public final boolean isEmpty() {
        return this.getSize() == 0;
    }

    public final long set(long key, long value) {
        int mask = this.mask;
        if (key == 0L) {
            this.hasEmptyKey = true;
            long previousValue = this.values[mask + 1];
            this.values[mask + 1] = value;
            return previousValue;
        }
        long[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        long existing = keys[slot];
        while (existing != 0L) {
            if (existing == key) {
                long previousValue = this.values[slot];
                this.values[slot] = value;
                return previousValue;
            }
            slot = slot + 1 & mask;
            existing = keys[slot];
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key, value);
        } else {
            keys[slot] = key;
            this.values[slot] = value;
        }
        int n = this.assigned;
        this.assigned = n + 1;
        return 0L;
    }

    public final long remove(long key) {
        int mask = this.mask;
        if (key == 0L) {
            this.hasEmptyKey = false;
            long previousValue = this.values[mask + 1];
            this.values[mask + 1] = 0L;
            return previousValue;
        }
        long[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        long existing = keys[slot];
        while (existing != 0L) {
            if (existing == key) {
                long previousValue = this.values[slot];
                this.shiftConflictingKeys(slot);
                return previousValue;
            }
            slot = slot + 1 & mask;
            existing = keys[slot];
        }
        return 0L;
    }

    public final int getSlot(long key) {
        if (key == 0L) {
            return this.hasEmptyKey ? this.mask + 1 : -1;
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        long existing = keys[slot];
        while (existing != 0L) {
            if (existing == key) {
                return slot;
            }
            slot = slot + 1 & mask;
            existing = keys[slot];
        }
        return -1;
    }

    public final long getSlotValue(int slot) {
        return this.values[slot];
    }

    public final long get(long key) {
        int slot = this.getSlot(key);
        boolean bl = slot != -1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Unknown key " + key;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return this.getSlotValue(slot);
    }

    public final void forEach(@NotNull ForEachCallback forEachCallback) {
        Intrinsics.checkParameterIsNotNull((Object)forEachCallback, (String)"forEachCallback");
        int max = this.mask + 1;
        int slot = -1;
        block0: while (true) {
            if (slot < max) {
                long existing = 0L;
                ++slot;
                while (slot < max) {
                    existing = this.keys[slot];
                    if (existing != 0L) {
                        forEachCallback.onEntry(existing, this.values[slot]);
                        continue block0;
                    }
                    ++slot;
                }
            }
            if (slot != max || !this.hasEmptyKey) break;
            ++slot;
            forEachCallback.onEntry(0L, this.values[max]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Sequence<LongLongPair> entrySequence() {
        void slot;
        int max = this.mask + 1;
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = -1;
        return SequencesKt.generateSequence((Function0)((Function0)new Function0<LongLongPair>(this, (Ref.IntRef)slot, max){
            final /* synthetic */ LongLongScatterMap this$0;
            final /* synthetic */ Ref.IntRef $slot;
            final /* synthetic */ int $max;

            @Nullable
            public final LongLongPair invoke() {
                if (this.$slot.element < this.$max) {
                    long existing = 0L;
                    int n = this.$slot.element;
                    this.$slot.element = n + 1;
                    while (this.$slot.element < this.$max) {
                        existing = LongLongScatterMap.access$getKeys$p(this.this$0)[this.$slot.element];
                        if (existing != 0L) {
                            return TuplesKt.to(existing, LongLongScatterMap.access$getValues$p(this.this$0)[this.$slot.element]);
                        }
                        n = this.$slot.element;
                        this.$slot.element = n + 1;
                    }
                }
                if (this.$slot.element == this.$max && LongLongScatterMap.access$getHasEmptyKey$p(this.this$0)) {
                    int n = this.$slot.element;
                    this.$slot.element = n + 1;
                    return TuplesKt.to(0L, LongLongScatterMap.access$getValues$p(this.this$0)[this.$max]);
                }
                return null;
            }
            {
                this.this$0 = longLongScatterMap;
                this.$slot = intRef;
                this.$max = n;
                super(0);
            }
        }));
    }

    public final boolean containsKey(long key) {
        if (key == 0L) {
            return this.hasEmptyKey;
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        long existing = keys[slot];
        while (existing != 0L) {
            if (existing == key) {
                return true;
            }
            slot = slot + 1 & mask;
            existing = keys[slot];
        }
        return false;
    }

    public final void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.allocateBuffers(HPPC.INSTANCE.minBufferSize(4, this.loadFactor));
    }

    public final int getSize() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    public final void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt) {
            long[] prevKeys = this.keys;
            long[] prevValues = this.values;
            this.allocateBuffers(HPPC.INSTANCE.minBufferSize(expectedElements, this.loadFactor));
            if (!this.isEmpty()) {
                this.rehash(prevKeys, prevValues);
            }
        }
    }

    private final int hashKey(long key) {
        return HPPC.INSTANCE.mixPhi(key);
    }

    private final void rehash(long[] fromKeys, long[] fromValues) {
        long[] keys = this.keys;
        long[] values = this.values;
        int mask = this.mask;
        long existing = 0L;
        int from = fromKeys.length - 1;
        keys[keys.length - 1] = fromKeys[from];
        values[values.length - 1] = fromValues[from];
        while (--from >= 0) {
            existing = fromKeys[from];
            if (existing == 0L) continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != 0L) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
            values[slot] = fromValues[from];
        }
    }

    private final void allocateBuffers(int arraySize) {
        long[] prevKeys = this.keys;
        long[] prevValues = this.values;
        try {
            int emptyElementSlot = 1;
            this.keys = new long[arraySize + emptyElementSlot];
            this.values = new long[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            this.values = prevValues;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.ROOT;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ROOT");
            Locale locale2 = locale;
            String string = "Not enough memory to allocate buffers for rehashing: %d -> %d";
            Object[] objectArray = new Object[]{this.mask + 1, arraySize};
            boolean bl = false;
            String string2 = String.format(locale2, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
            throw (Throwable)new RuntimeException(string2, e);
        }
        this.resizeAt = HPPC.INSTANCE.expandAtCount(arraySize, this.loadFactor);
        this.mask = arraySize - 1;
    }

    private final void allocateThenInsertThenRehash(int slot, long pendingKey, long pendingValue) {
        long[] prevKeys = this.keys;
        long[] prevValues = this.values;
        this.allocateBuffers(HPPC.INSTANCE.nextBufferSize(this.mask + 1, this.getSize(), this.loadFactor));
        prevKeys[slot] = pendingKey;
        prevValues[slot] = pendingValue;
        this.rehash(prevKeys, prevValues);
    }

    private final void shiftConflictingKeys(int gapSlotArg) {
        int slot;
        long existing;
        int gapSlot = gapSlotArg;
        long[] keys = this.keys;
        long[] values = this.values;
        int mask = this.mask;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != 0L) {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = values[slot];
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0L;
        values[gapSlot] = 0L;
        int n = this.assigned;
        this.assigned = n + -1;
    }

    public LongLongScatterMap(int expectedElements) {
        this.keys = new long[0];
        this.values = new long[0];
        this.loadFactor = 0.75;
        this.ensureCapacity(expectedElements);
    }

    public /* synthetic */ LongLongScatterMap(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 4;
        }
        this(n);
    }

    public LongLongScatterMap() {
        this(0, 1, null);
    }

    public static final /* synthetic */ long[] access$getKeys$p(LongLongScatterMap $this) {
        return $this.keys;
    }

    public static final /* synthetic */ void access$setKeys$p(LongLongScatterMap $this, long[] lArray) {
        $this.keys = lArray;
    }

    public static final /* synthetic */ long[] access$getValues$p(LongLongScatterMap $this) {
        return $this.values;
    }

    public static final /* synthetic */ void access$setValues$p(LongLongScatterMap $this, long[] lArray) {
        $this.values = lArray;
    }

    public static final /* synthetic */ boolean access$getHasEmptyKey$p(LongLongScatterMap $this) {
        return $this.hasEmptyKey;
    }

    public static final /* synthetic */ void access$setHasEmptyKey$p(LongLongScatterMap $this, boolean bl) {
        $this.hasEmptyKey = bl;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Lshark/internal/hppc/LongLongScatterMap$ForEachCallback;", "", "onEntry", "", "key", "", "value", "shark-graph"})
    public static interface ForEachCallback {
        public void onEntry(long var1, long var3);
    }
}

