/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.test;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.test.ComposeTimeoutException;
import androidx.compose.ui.test.MainTestClock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.test.TestCoroutineScheduler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u000e\b!\u0018\u00002\u00020\u0001B@\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012'\u0010\u0006\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0018\u001a\u00020\tH\u0016J\u0018\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0013H\u0016J\u001e\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u00052\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00130\bH\u0016J\u0010\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\u0006\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006!"}, d2={"Landroidx/compose/ui/test/AbstractMainTestClock;", "Landroidx/compose/ui/test/MainTestClock;", "testScheduler", "Lkotlinx/coroutines/test/TestCoroutineScheduler;", "frameDelayMillis", "", "runOnUiThread", "Lkotlin/Function1;", "Lkotlin/Function0;", "", "Lkotlin/ParameterName;", "name", "action", "<init>", "(Lkotlinx/coroutines/test/TestCoroutineScheduler;JLkotlin/jvm/functions/Function1;)V", "currentTime", "getCurrentTime", "()J", "autoAdvance", "", "getAutoAdvance", "()Z", "setAutoAdvance", "(Z)V", "advanceTimeByFrame", "advanceTimeBy", "milliseconds", "ignoreFrameDuration", "advanceTimeUntil", "timeoutMillis", "condition", "advanceScheduler", "millis", "ui-test"})
@StabilityInferred(parameters=0)
public abstract class AbstractMainTestClock
implements MainTestClock {
    @NotNull
    private final TestCoroutineScheduler testScheduler;
    private final long frameDelayMillis;
    @NotNull
    private final Function1<Function0<Unit>, Unit> runOnUiThread;
    private boolean autoAdvance;
    public static final int $stable = 8;

    public AbstractMainTestClock(@NotNull TestCoroutineScheduler testScheduler, long frameDelayMillis, @NotNull Function1<? super Function0<Unit>, Unit> runOnUiThread) {
        Intrinsics.checkNotNullParameter((Object)testScheduler, (String)"testScheduler");
        Intrinsics.checkNotNullParameter(runOnUiThread, (String)"runOnUiThread");
        this.testScheduler = testScheduler;
        this.frameDelayMillis = frameDelayMillis;
        this.runOnUiThread = runOnUiThread;
        this.autoAdvance = true;
    }

    @Override
    public long getCurrentTime() {
        return this.testScheduler.getCurrentTime();
    }

    @Override
    public boolean getAutoAdvance() {
        return this.autoAdvance;
    }

    @Override
    public void setAutoAdvance(boolean bl) {
        this.autoAdvance = bl;
    }

    @Override
    public void advanceTimeByFrame() {
        this.advanceScheduler(this.frameDelayMillis);
    }

    @Override
    public void advanceTimeBy(long milliseconds, boolean ignoreFrameDuration) {
        long actualDelay = ignoreFrameDuration ? milliseconds : (long)Math.ceil((double)milliseconds / (double)this.frameDelayMillis) * this.frameDelayMillis;
        this.advanceScheduler(actualDelay);
    }

    @Override
    public void advanceTimeUntil(long timeoutMillis, @NotNull Function0<Boolean> condition) {
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        long startTime = this.getCurrentTime();
        this.runOnUiThread.invoke(() -> AbstractMainTestClock.advanceTimeUntil$lambda$0(condition, this, startTime, timeoutMillis));
    }

    private final void advanceScheduler(long millis) {
        this.runOnUiThread.invoke(() -> AbstractMainTestClock.advanceScheduler$lambda$1(this, millis));
    }

    private static final Unit advanceTimeUntil$lambda$0(Function0 $condition, AbstractMainTestClock this$0, long $startTime, long $timeoutMillis) {
        while (!((Boolean)$condition.invoke()).booleanValue()) {
            this$0.advanceScheduler(this$0.frameDelayMillis);
            if (this$0.getCurrentTime() - $startTime <= $timeoutMillis) continue;
            throw new ComposeTimeoutException("Condition still not satisfied after " + $timeoutMillis + " ms");
        }
        return Unit.INSTANCE;
    }

    private static final Unit advanceScheduler$lambda$1(AbstractMainTestClock this$0, long $millis) {
        this$0.testScheduler.advanceTimeBy($millis);
        this$0.testScheduler.runCurrent();
        return Unit.INSTANCE;
    }
}

