/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.TestApplicationManager;
import com.intellij.testFramework.TestLoggerFactory;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.system.CpuArch;
import com.intellij.util.system.OS;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.CidrCodeInsightFixtureMarker;
import com.jetbrains.cidr.CidrDebuggingFixtureMarker;
import com.jetbrains.cidr.CidrLog;
import com.jetbrains.cidr.CidrProjectDependentFixtureBase;
import com.jetbrains.cidr.CidrProjectFixtureBase;
import com.jetbrains.cidr.CidrTestDataFixture;
import com.jetbrains.cidr.CidrTestProject;
import com.jetbrains.cidr.CidrTestProjects;
import com.jetbrains.cidr.execution.CidrExecutionFixture;
import java.io.File;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.ListAssert;
import org.hamcrest.number.OrderingComparison;
import org.intellij.lang.annotations.JdkConstants;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Assume;

public abstract class CidrTestCaseBase<PROJECT_FIXTURE extends CidrProjectFixtureBase, EXECUTION_FIXTURE extends CidrExecutionFixture<PROJECT_FIXTURE>, DEBUGGING_FIXTURE extends CidrDebuggingFixtureMarker, CODE_INSIGHT_FIXTURE extends CidrCodeInsightFixtureMarker>
extends UsefulTestCase
implements CidrProjectDependentFixtureBase {
    private static volatile boolean platformInitialized = false;
    private final List<String> myAllAllowedRoots = new ArrayList<String>();
    protected CidrTestDataFixture myTestDataFixture;
    protected PROJECT_FIXTURE myProjectFixture;
    protected EXECUTION_FIXTURE myExecutionFixture;
    protected DEBUGGING_FIXTURE myDebuggingFixture;
    protected CODE_INSIGHT_FIXTURE myCodeInsightFixture;

    @Override
    protected Duration getCoroutineTimeout() {
        return Duration.ofMinutes(10L);
    }

    @Override
    protected boolean runFromCoroutine() {
        return true;
    }

    @Nullable
    protected DEBUGGING_FIXTURE createDebuggingFixture() {
        return null;
    }

    protected static void waitForTaskAndDispatchEvents(@NotNull ThrowableRunnable<Throwable> task2) throws ExecutionException, InterruptedException {
        if (task2 == null) {
            CidrTestCaseBase.$$$reportNull$$$0(0);
        }
        try {
            CidrTestCaseBase.waitForTaskAndDispatchEvents(task2, Integer.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static void waitForTaskAndDispatchEvents(@NotNull ThrowableRunnable<Throwable> task2, long timeout, @NotNull TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        void unit;
        if (task2 == null) {
            CidrTestCaseBase.$$$reportNull$$$0(1);
        }
        if (timeUnit == null) {
            CidrTestCaseBase.$$$reportNull$$$0(2);
        }
        CompletableFuture taskCompletedFuture = new CompletableFuture();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                task2.run();
            }
            catch (Throwable thr) {
                taskCompletedFuture.completeExceptionally(thr);
            }
            finally {
                taskCompletedFuture.complete(true);
            }
        });
        CidrTestCaseBase.waitAndDispatchEvents(taskCompletedFuture, timeout, (TimeUnit)unit);
    }

    public static void waitAndDispatchEvents(@NotNull Future<?> future) throws ExecutionException, InterruptedException {
        if (future == null) {
            CidrTestCaseBase.$$$reportNull$$$0(3);
        }
        try {
            CidrTestCaseBase.waitAndDispatchEvents(future, Integer.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    protected CidrTestCaseBase() {
        this.initTestFramework();
    }

    public void initTestFramework() {
        Logger.setFactory(TestLoggerFactory.class);
        if (!platformInitialized) {
            platformInitialized = true;
            this.initPlatform();
        }
    }

    private void initPlatform() {
        try {
            TestApplicationManager app = TestApplicationManager.getInstance();
            ShutDownTracker.getInstance().registerShutdownTask(() -> {
                try {
                    CidrProjectFixtureBase.cleanupStatics();
                    ApplicationManager.getApplication().invokeAndWait(() -> app.dispose());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    CidrLog.LOG.error((Throwable)e);
                }
            });
            this.initApplication();
        }
        catch (Throwable e) {
            this.platformInitializationFailed(e);
        }
    }

    protected void platformInitializationFailed(@NotNull Throwable e) {
        if (e == null) {
            CidrTestCaseBase.$$$reportNull$$$0(4);
        }
        System.err.println("Application initialization issue, exiting.");
        e.printStackTrace();
        try {
            Logger.getInstance((String)("#" + CidrTestCaseBase.class.getPackage().getName())).error("Application initialization issue, exiting.", e);
        }
        finally {
            System.exit(1);
        }
    }

    protected void initApplication() {
    }

    @Override
    protected void runTestRunnable(@NotNull ThrowableRunnable<Throwable> testRunnable) throws Throwable {
        if (testRunnable == null) {
            CidrTestCaseBase.$$$reportNull$$$0(5);
        }
        if (this.shouldRunInWriteAction()) {
            WriteAction.runAndWait(testRunnable);
        } else {
            super.runTestRunnable(testRunnable);
        }
    }

    protected boolean shouldRunInWriteAction() {
        return false;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Path currentDir = Paths.get(System.getProperty("user.dir"), new String[0]).toAbsolutePath();
        Path tmpDir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).toAbsolutePath();
        long freeSpaceBytesInCurrentDir = Files.getFileStore(currentDir).getUsableSpace();
        long freeSpaceBytesInTmp = Files.getFileStore(tmpDir).getUsableSpace();
        long minimumFreeSpaceMegabytes = 700L;
        long minimumFreeSpaceBytes = 734003200L;
        String errorMessage = "Not enough free space in %s to run a test (less than %d MB), %d B";
        Assert.assertThat((String)String.format("Not enough free space in %s to run a test (less than %d MB), %d B", currentDir, 700L, freeSpaceBytesInCurrentDir), (Object)freeSpaceBytesInCurrentDir, OrderingComparison.greaterThanOrEqualTo(734003200L));
        Assert.assertThat((String)String.format("Not enough free space in %s to run a test (less than %d MB), %d B", tmpDir, 700L, freeSpaceBytesInTmp), (Object)freeSpaceBytesInTmp, OrderingComparison.greaterThanOrEqualTo(734003200L));
        this.opaqueSetAllowedModules();
        this.setUpFixtures();
    }

    protected void opaqueSetAllowedModules() {
    }

    public void registerAllowedRoots(List<String> roots, @NotNull Disposable disposable) {
        if (disposable == null) {
            CidrTestCaseBase.$$$reportNull$$$0(6);
        }
        final ArrayList<String> newRoots = new ArrayList<String>(roots);
        newRoots.removeAll(this.myAllAllowedRoots);
        String[] newRootsArray = ArrayUtilRt.toStringArray(newRoots);
        VfsRootAccess.allowRootAccess((Disposable)disposable, (String[])newRootsArray);
        this.myAllAllowedRoots.addAll(newRoots);
        Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

            public void dispose() {
                CidrTestCaseBase.this.myAllAllowedRoots.removeAll(newRoots);
            }
        });
    }

    protected void setUpFixtures() throws Exception {
        this.myTestDataFixture = this.createTestDataFixture();
        this.myProjectFixture = this.createProjectFixture();
        if (this.myProjectFixture != null) {
            ((CidrProjectFixtureBase)this.myProjectFixture).setUp(this.getClass().getName(), this.getName());
            ((CidrProjectFixtureBase)this.myProjectFixture).addProjectDependentFixture(this);
            ((CidrProjectFixtureBase)this.myProjectFixture).setCleanProjectOption(this.shouldCleanProject());
            ArrayList<String> allowedRoots = new ArrayList<String>();
            ((CidrProjectFixtureBase)this.myProjectFixture).collectAllowedRoots(allowedRoots);
            ((ListAssert)((ListAssert)Assumptions.assumeThat(allowedRoots).as("allowed vfs roots", new Object[0])).doesNotContainNull()).doesNotContain(new String[]{""});
            this.registerAllowedRoots(allowedRoots, this.getTestRootDisposable());
            this.myExecutionFixture = this.createExecutionFixture();
            if (this.myExecutionFixture != null) {
                ((CidrExecutionFixture)((Object)this.myExecutionFixture)).setUp();
            }
            if (this.myExecutionFixture != null) {
                this.myDebuggingFixture = this.createDebuggingFixture();
                if (this.myDebuggingFixture != null) {
                    this.myDebuggingFixture.setUp();
                }
            }
            this.myCodeInsightFixture = this.createCodeInsightFixture();
            if (this.myCodeInsightFixture != null) {
                this.myCodeInsightFixture.setUp();
            }
        }
    }

    @NotNull
    protected CidrTestDataFixture createTestDataFixture() {
        return new CidrTestDataFixture(null);
    }

    @Nullable
    protected PROJECT_FIXTURE createProjectFixture() {
        return null;
    }

    @Nullable
    protected EXECUTION_FIXTURE createExecutionFixture() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static void waitAndDispatchEvents(@NotNull Future<?> future, long timeout, @NotNull TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        void unit;
        if (future == null) {
            CidrTestCaseBase.$$$reportNull$$$0(7);
        }
        if (timeUnit == null) {
            CidrTestCaseBase.$$$reportNull$$$0(8);
        }
        ThreadingAssertions.assertEventDispatchThread();
        long timeoutNs = unit.toNanos(timeout);
        long startTimeNs = System.nanoTime();
        while (System.nanoTime() - startTimeNs < timeoutNs) {
            try {
                future.get(50L, TimeUnit.MILLISECONDS);
                return;
            }
            catch (TimeoutException ex) {
                PlatformTestUtil.dispatchAllInvocationEventsInIdeEventQueue();
            }
        }
        throw new TimeoutException();
    }

    @Nullable
    protected CODE_INSIGHT_FIXTURE createCodeInsightFixture() {
        return null;
    }

    @Override
    protected boolean shouldContainTempFiles() {
        return false;
    }

    protected CidrProjectFixtureBase.CleanProjectOption shouldCleanProject() {
        return CidrProjectFixtureBase.CleanProjectOption.DO_NOT_CLEAN;
    }

    @Override
    protected void tearDown() throws Exception {
        RunAll.runAll(() -> {
            if (this.myCodeInsightFixture != null) {
                this.myCodeInsightFixture.tearDown();
            }
        }, () -> {
            if (this.myDebuggingFixture != null) {
                this.myDebuggingFixture.tearDown();
            }
        }, () -> {
            if (this.myExecutionFixture != null) {
                ((CidrExecutionFixture)((Object)((Object)this.myExecutionFixture))).tearDown();
            }
        }, () -> {
            if (this.myProjectFixture != null) {
                ((CidrProjectFixtureBase)this.myProjectFixture).removeProjectDependentFixture(this);
            }
        }, () -> {
            if (this.myProjectFixture != null) {
                ((CidrProjectFixtureBase)this.myProjectFixture).tearDown();
            }
        }, () -> {
            if (this.myTestDataFixture != null) {
                this.myTestDataFixture.tearDown();
            }
        }, () -> super.tearDown());
    }

    public static TestApplicationManager getTestApplication() {
        return TestApplicationManager.getInstance();
    }

    @NotNull
    public Project getProject() {
        Project project = ((CidrProjectFixtureBase)this.myProjectFixture).getProject();
        if (project == null) {
            CidrTestCaseBase.$$$reportNull$$$0(9);
        }
        return project;
    }

    protected File getTestDataDir() {
        return this.myTestDataFixture.getTestDataDir();
    }

    protected File getTestDataFile(String testDataRelativePath) {
        return this.myTestDataFixture.getTestDataFile(testDataRelativePath);
    }

    protected File getTestDataProjectsDir() {
        return this.myTestDataFixture.getTestDataProjectsDir();
    }

    protected File getTestDataProjectsFile(String testDataRelativePath) {
        return this.myTestDataFixture.getTestDataProjectsFile(testDataRelativePath);
    }

    public VirtualFile createTempDir() {
        return this.myTestDataFixture.createTempDir();
    }

    public File createTempIODir() {
        return this.myTestDataFixture.createTempIODir();
    }

    public VirtualFile createTempFile() {
        return this.myTestDataFixture.createTempFile();
    }

    public File createTempIOFile() {
        return this.myTestDataFixture.createTempIOFile();
    }

    public VirtualFile createTempFile(String content) {
        return this.myTestDataFixture.createTempFile(content);
    }

    public VirtualFile createFile(VirtualFile dir, String name, String content) {
        return this.myTestDataFixture.createFile(dir, name, content);
    }

    public static void assertMatches(String string, @RegExp String pattern) {
        CidrTestCaseBase.assertMatches(string, pattern, 0);
    }

    public static void assertDoesntMatch(String string, @RegExp String pattern) {
        CidrTestCaseBase.assertDoesntMatch(string, pattern, 0);
    }

    public static void assertMatches(String string, @RegExp String pattern, @JdkConstants.PatternFlags int flags) {
        if (!Pattern.compile(pattern, flags).matcher(string).matches()) {
            CidrTestCaseBase.assertEquals((String)("Text: " + string + "\nShould match pattern: " + pattern), (String)pattern.replace("\\n", "\n"), (String)string);
        }
    }

    public static void assertContains(@NotNull String text, @NotNull String subString, @NotNull String message) {
        if (text == null) {
            CidrTestCaseBase.$$$reportNull$$$0(10);
        }
        if (subString == null) {
            CidrTestCaseBase.$$$reportNull$$$0(11);
        }
        if (message == null) {
            CidrTestCaseBase.$$$reportNull$$$0(12);
        }
        CidrTestCaseBase.assertTrue((String)("Text: '" + text + "'\nShould contain substring: " + subString + ". " + message), (boolean)text.contains(subString));
    }

    public static void assertContains(@NotNull String text, @NotNull String subString) {
        if (text == null) {
            CidrTestCaseBase.$$$reportNull$$$0(13);
        }
        if (subString == null) {
            CidrTestCaseBase.$$$reportNull$$$0(14);
        }
        CidrTestCaseBase.assertContains(text, subString, "");
    }

    public static void assertDoesntMatch(String string, @RegExp String pattern, @JdkConstants.PatternFlags int flags) {
        CidrTestCaseBase.assertFalse((String)("Text: " + string + "\nShould not match pattern: " + pattern), (boolean)Pattern.compile(pattern, flags).matcher(string).matches());
    }

    @NotNull
    public static SystemAssumption assumeLocalSystem() {
        SystemAssumption systemAssumption = SystemAssumption.LOCAL_INSTANCE;
        if (systemAssumption == null) {
            CidrTestCaseBase.$$$reportNull$$$0(15);
        }
        return systemAssumption;
    }

    @NotNull
    public SystemAssumption assumeSystem() {
        return CidrTestCaseBase.assumeLocalSystem();
    }

    @NotNull
    public static ArchitectureAssumption assumeLocalArchitecture() {
        ArchitectureAssumption architectureAssumption = ArchitectureAssumption.LOCAL_INSTANCE;
        if (architectureAssumption == null) {
            CidrTestCaseBase.$$$reportNull$$$0(16);
        }
        return architectureAssumption;
    }

    @NotNull
    public ArchitectureAssumption assumeArchitecture() {
        return CidrTestCaseBase.assumeLocalArchitecture();
    }

    public static void printPsiStructure(PsiElement e) {
        System.err.println(CidrTestCaseBase.psiStructure(e));
    }

    public static String psiStructure(PsiElement e) {
        return DebugUtil.psiToString((PsiElement)e, (boolean)true);
    }

    public static void waitForSwing() {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        Semaphore s = new Semaphore();
        s.down();
        ApplicationManager.getApplication().invokeLater(() -> s.up());
        try {
            s.waitForUnsafe();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        UIUtil.invokeAndWaitIfNeeded(() -> {});
    }

    public void waitForDebuggerAndSwingEvents() {
        this.myDebuggingFixture.waitForDebuggerAndSwingEvents();
    }

    @Nullable
    public VirtualFile findTestProjectSubFile(@NotNull String relativePath) {
        if (relativePath == null) {
            CidrTestCaseBase.$$$reportNull$$$0(17);
        }
        return ((CidrProjectFixtureBase)this.myProjectFixture).findProjectSubFile(relativePath);
    }

    protected void initProject(@NotNull String projectFileRelativePath) throws Exception {
        if (projectFileRelativePath == null) {
            CidrTestCaseBase.$$$reportNull$$$0(18);
        }
        ((CidrProjectFixtureBase)this.myProjectFixture).initProject(projectFileRelativePath);
    }

    protected void initProject(@NotNull String projectFileRelativePath, @NotNull String folderToCopy) throws Exception {
        if (projectFileRelativePath == null) {
            CidrTestCaseBase.$$$reportNull$$$0(19);
        }
        if (folderToCopy == null) {
            CidrTestCaseBase.$$$reportNull$$$0(20);
        }
        ((CidrProjectFixtureBase)this.myProjectFixture).initProject(projectFileRelativePath, folderToCopy, true);
    }

    @NotNull
    public VirtualFile getTestProjectRoot() {
        VirtualFile virtualFile = ((CidrProjectFixtureBase)this.myProjectFixture).getProjectDir();
        if (virtualFile == null) {
            CidrTestCaseBase.$$$reportNull$$$0(21);
        }
        return virtualFile;
    }

    protected void closeAndReopenProject() throws Exception {
        this.closeAndReopenProject(null);
    }

    protected void closeAndReopenProject(@Nullable Runnable beforeRestart) throws Exception {
        ((CidrProjectFixtureBase)this.myProjectFixture).saveAndCloseProject();
        if (beforeRestart != null) {
            beforeRestart.run();
        }
        ((CidrProjectFixtureBase)this.myProjectFixture).openProject(true);
    }

    @Nullable
    public static String getProjectPathIfOpenAutomatically(@NotNull Class<?> clazz) {
        CidrTestProject annotation;
        if (clazz == null) {
            CidrTestCaseBase.$$$reportNull$$$0(22);
        }
        if ((annotation = CidrTestCaseBase.getProjectPath(clazz)) == null || annotation.project() == CidrTestProjects.NO_PROJECT) {
            return null;
        }
        return annotation.project().getPath();
    }

    @Nullable
    public static String getProjectPathForSorting(@NotNull Class<?> clazz) {
        CidrTestProject annotation;
        if (clazz == null) {
            CidrTestCaseBase.$$$reportNull$$$0(23);
        }
        if ((annotation = CidrTestCaseBase.getProjectPath(clazz)) == null) {
            return null;
        }
        return annotation.project().getPath();
    }

    @Nullable
    public static CidrTestProject getProjectPath(@NotNull Class<?> clazz) {
        if (clazz == null) {
            CidrTestCaseBase.$$$reportNull$$$0(24);
        }
        return CidrTestCaseBase.findAnnotationInClassHierarchy(clazz, CidrTestProject.class);
    }

    @Nullable
    public static <AnnotationClass extends Annotation> AnnotationClass findAnnotationInClassHierarchy(@NotNull Class<?> clazz, @NotNull Class<AnnotationClass> annotationClass) {
        if (clazz == null) {
            CidrTestCaseBase.$$$reportNull$$$0(25);
        }
        if (annotationClass == null) {
            CidrTestCaseBase.$$$reportNull$$$0(26);
        }
        do {
            AnnotationClass annotation;
            if ((annotation = clazz.getAnnotation(annotationClass)) == null) continue;
            return annotation;
        } while ((clazz = clazz.getSuperclass()) != null);
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 15, 16, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testRunnable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 9: 
            case 15: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/CidrTestCaseBase";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subString";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFileRelativePath";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderToCopy";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/CidrTestCaseBase";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "assumeLocalSystem";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "assumeLocalArchitecture";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestProjectRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "waitForTaskAndDispatchEvents";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "waitAndDispatchEvents";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "platformInitializationFailed";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runTestRunnable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerAllowedRoots";
                break;
            }
            case 9: 
            case 15: 
            case 16: 
            case 21: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "assertContains";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findTestProjectSubFile";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "initProject";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getProjectPathIfOpenAutomatically";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getProjectPathForSorting";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getProjectPath";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotationInClassHierarchy";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 15, 16, 21 -> new IllegalStateException(string);
        };
    }

    public static class SystemAssumption {
        @NotNull
        static final SystemAssumption LOCAL_INSTANCE = new SystemAssumption(() -> OS.CURRENT);
        @NotNull
        private final Supplier<OS> myOSTypeSupplier;

        public SystemAssumption(@NotNull Supplier<OS> osTypeSupplier) {
            if (osTypeSupplier == null) {
                SystemAssumption.$$$reportNull$$$0(0);
            }
            this.myOSTypeSupplier = osTypeSupplier;
        }

        public void isWindows() {
            Assume.assumeTrue((String)"Windows host only", (this.myOSTypeSupplier.get() == OS.Windows ? 1 : 0) != 0);
        }

        public void isUnix() {
            Assume.assumeTrue((String)"Unix host only", (this.myOSTypeSupplier.get() != OS.Windows ? 1 : 0) != 0);
        }

        public void isLinux() {
            Assume.assumeTrue((String)"Linux host only", (this.myOSTypeSupplier.get() == OS.Linux ? 1 : 0) != 0);
        }

        public void isMac() {
            Assume.assumeTrue((String)"Mac host only", (this.myOSTypeSupplier.get() == OS.macOS ? 1 : 0) != 0);
        }

        public void isNotWindows() {
            Assume.assumeFalse((String)"not for Windows host", (this.myOSTypeSupplier.get() == OS.Windows ? 1 : 0) != 0);
        }

        public void isNotUnix() {
            Assume.assumeFalse((String)"not for Unix host", (this.myOSTypeSupplier.get() != OS.Windows ? 1 : 0) != 0);
        }

        public void isNotLinux() {
            Assume.assumeFalse((String)"not for Linux host", (this.myOSTypeSupplier.get() == OS.Linux ? 1 : 0) != 0);
        }

        public void isNotMac() {
            Assume.assumeFalse((String)"not for Mac host", (this.myOSTypeSupplier.get() == OS.macOS ? 1 : 0) != 0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "osTypeSupplier", "com/jetbrains/cidr/CidrTestCaseBase$SystemAssumption", "<init>"));
        }
    }

    public static class ArchitectureAssumption {
        @NotNull
        static final ArchitectureAssumption LOCAL_INSTANCE = new ArchitectureAssumption(() -> ArchitectureType.forVmCpuArch((CpuArch)CpuArch.CURRENT));
        @NotNull
        private final Supplier<ArchitectureType> myArchSupplier;

        public ArchitectureAssumption(@NotNull Supplier<ArchitectureType> architectureTypeSupplier) {
            if (architectureTypeSupplier == null) {
                ArchitectureAssumption.$$$reportNull$$$0(0);
            }
            this.myArchSupplier = architectureTypeSupplier;
        }

        public void isX86orX64() {
            ArchitectureType arch = this.myArchSupplier.get();
            Assume.assumeTrue((String)"x86 or x86_64 host only", (arch == ArchitectureType.X86_64 || arch == ArchitectureType.I386 ? 1 : 0) != 0);
        }

        public void isX86() {
            Assume.assumeTrue((String)"x86 host only", (this.myArchSupplier.get() == ArchitectureType.I386 ? 1 : 0) != 0);
        }

        public void isX64() {
            Assume.assumeTrue((String)"x86_64 host only", (this.myArchSupplier.get() == ArchitectureType.X86_64 ? 1 : 0) != 0);
        }

        public void isAarch64() {
            Assume.assumeTrue((String)"Aarch64 host only", (this.myArchSupplier.get() == ArchitectureType.ARM64 ? 1 : 0) != 0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "architectureTypeSupplier", "com/jetbrains/cidr/CidrTestCaseBase$ArchitectureAssumption", "<init>"));
        }
    }
}

