/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.AllOf;
import com.jetbrains.cidr.AnyAnnotation;
import com.jetbrains.cidr.AnyOf;
import com.jetbrains.cidr.AnyOfOptional;
import com.jetbrains.cidr.ExpectedAnnotations;
import com.jetbrains.cidr.ExpectedSingleAnnotation;
import com.jetbrains.cidr.ExpectedSingleAnnotationWithRange;
import com.jetbrains.cidr.Optional;
import com.jetbrains.cidr.RegexAnnotation;
import com.jetbrains.cidr.SimpleAnnotation;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0002\u001a\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002\u001a\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"createByComment", "Lcom/jetbrains/cidr/ExpectedAnnotations;", "e", "Lcom/intellij/psi/PsiElement;", "ENABLE_LANGUAGE_FEATURE", "", "TEST_DISABLED", "RUN_INSPECTIONS", "ALLOW_RESOLVE_CYCLE", "DISABLE_CLANG_WARNING", "isNonAnnotationComment", "", "node", "splitAndUnescapeSemicolon", "", "text", "createSingleAnnotation", "Lcom/jetbrains/cidr/ExpectedSingleAnnotation;", "file", "Lcom/jetbrains/cidr/lang/psi/OCFile;", "createConditionalAnnotation", "contents", "intellij.cidr.common.testFramework.core"})
@SourceDebugExtension(value={"SMAP\nExpectedAnnotations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpectedAnnotations.kt\ncom/jetbrains/cidr/ExpectedAnnotationsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,182:1\n1563#2:183\n1634#2,3:184\n774#2:187\n865#2,2:188\n*S KotlinDebug\n*F\n+ 1 ExpectedAnnotations.kt\ncom/jetbrains/cidr/ExpectedAnnotationsKt\n*L\n138#1:183\n138#1:184,3\n138#1:187\n138#1:188,2\n*E\n"})
public final class ExpectedAnnotationsKt {
    @NotNull
    public static final String ENABLE_LANGUAGE_FEATURE = "Enable language feature ";
    @NotNull
    public static final String TEST_DISABLED = "Test disabled";
    @NotNull
    public static final String RUN_INSPECTIONS = "Run inspections";
    @NotNull
    public static final String ALLOW_RESOLVE_CYCLE = "Allow resolve cycle";
    @NotNull
    public static final String DISABLE_CLANG_WARNING = "Disable clang warning ";

    @Nullable
    public static final ExpectedAnnotations createByComment(@NotNull PsiElement e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (ExpectedAnnotationsKt.isNonAnnotationComment(e)) {
            return null;
        }
        PsiFile psiFile = e.getContainingFile();
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.jetbrains.cidr.lang.psi.OCFile");
        OCFile file = (OCFile)psiFile;
        String string = e.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text = ((Object)StringsKt.trim((CharSequence)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"//", (String)"", (boolean)false, (int)4, null), (String)"/*", (String)"", (boolean)false, (int)4, null), (String)"*/", (String)"", (boolean)false, (int)4, null), (String)"E:", (String)"", (boolean)false, (int)4, null), (String)"W:", (String)"", (boolean)false, (int)4, null))).toString();
        return Intrinsics.areEqual((Object)text, (Object)"any") ? (ExpectedAnnotations)new AnyAnnotation() : (StringsKt.startsWith$default((String)text, (String)"any_of:", (boolean)false, (int)2, null) ? (ExpectedAnnotations)new AnyOf(StringsKt.removePrefix((String)text, (CharSequence)"any_of:"), file) : (StringsKt.startsWith$default((String)text, (String)"any_of_optional:", (boolean)false, (int)2, null) ? (ExpectedAnnotations)new AnyOfOptional(StringsKt.removePrefix((String)text, (CharSequence)"any_of_optional:"), file) : (StringsKt.startsWith$default((String)text, (String)"optional:", (boolean)false, (int)2, null) ? (ExpectedAnnotations)new Optional(StringsKt.removePrefix((String)text, (CharSequence)"optional:"), file) : (ExpectedAnnotations)new AllOf(text, file))));
    }

    private static final boolean isNonAnnotationComment(PsiElement node) {
        if (!(node instanceof PsiComment)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)((PsiComment)node).getTokenType(), (Object)OCTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT)) {
            return true;
        }
        String text = ((PsiComment)node).getText();
        Intrinsics.checkNotNull((Object)text);
        return StringsKt.startsWith$default((String)text, (String)"//!", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)text, (String)"/*!", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)text, (String)"/**!", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)text, (CharSequence)ENABLE_LANGUAGE_FEATURE, (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)text, (CharSequence)TEST_DISABLED, (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)text, (CharSequence)RUN_INSPECTIONS, (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)text, (CharSequence)ALLOW_RESOLVE_CYCLE, (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)text, (CharSequence)DISABLE_CLANG_WARNING, (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection<String> splitAndUnescapeSemicolon(String text) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = Regex.split$default((Regex)new Regex("(?<!\\\\);"), (CharSequence)text, (int)0, (int)2, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)StringsKt.replace$default((String)it, (String)"\\;", (String)";", (boolean)false, (int)4, null))).toString());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String p0 = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)p0).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final ExpectedSingleAnnotation createSingleAnnotation(String text, OCFile file) {
        if (StringsKt.startsWith$default((String)text, (String)"lines", (boolean)false, (int)2, null)) {
            Regex pattern = new Regex("lines\\s+\\+(\\d+)\\s*:(.*)");
            MatchResult matchResult = Regex.find$default((Regex)pattern, (CharSequence)text, (int)0, (int)2, null);
            if (matchResult == null) {
                return null;
            }
            MatchResult matchResult2 = matchResult;
            MatchResult.Destructured destructured = matchResult2.getDestructured();
            String numberOfLines = (String)destructured.getMatch().getGroupValues().get(1);
            String remainingText = (String)destructured.getMatch().getGroupValues().get(2);
            ExpectedSingleAnnotation expectedSingleAnnotation = ExpectedAnnotationsKt.createSingleAnnotation(((Object)StringsKt.trim((CharSequence)remainingText)).toString(), file);
            if (expectedSingleAnnotation == null) {
                return null;
            }
            ExpectedSingleAnnotation innerAnnotation = expectedSingleAnnotation;
            Integer n = StringsKt.toIntOrNull((String)numberOfLines);
            if (n == null) {
                return null;
            }
            return new ExpectedSingleAnnotationWithRange(innerAnnotation, n);
        }
        return StringsKt.startsWith$default((String)text, (String)"re:", (boolean)false, (int)2, null) ? (ExpectedSingleAnnotation)new RegexAnnotation(((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)text, (CharSequence)"re:"))).toString()) : (StringsKt.startsWith$default((String)text, (String)"cond=", (boolean)false, (int)2, null) ? ExpectedAnnotationsKt.createConditionalAnnotation(((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)text, (CharSequence)"cond="))).toString(), file) : (ExpectedSingleAnnotation)new SimpleAnnotation(((Object)StringsKt.trim((CharSequence)text)).toString()));
    }

    private static final ExpectedSingleAnnotation createConditionalAnnotation(String contents, OCFile file) {
        boolean negative = StringsKt.startsWith$default((String)contents, (String)"!", (boolean)false, (int)2, null);
        int idx = StringsKt.indexOf$default((CharSequence)contents, (String)":", (int)0, (boolean)false, (int)6, null);
        String string = contents.substring(negative ? 1 : 0, idx);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String definition = string;
        String string2 = contents.substring(idx + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String text = string2;
        boolean hasMacroDefinition = !file.getMembersContainer(false).processMembers(definition, arg_0 -> ExpectedAnnotationsKt.createConditionalAnnotation$lambda$2(ExpectedAnnotationsKt::createConditionalAnnotation$lambda$1, arg_0));
        return hasMacroDefinition != negative ? ExpectedAnnotationsKt.createSingleAnnotation(text, file) : null;
    }

    private static final boolean createConditionalAnnotation$lambda$1(OCSymbol it) {
        return !(it instanceof OCMacroSymbol);
    }

    private static final boolean createConditionalAnnotation$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Collection access$splitAndUnescapeSemicolon(String text) {
        return ExpectedAnnotationsKt.splitAndUnescapeSemicolon(text);
    }

    public static final /* synthetic */ ExpectedSingleAnnotation access$createSingleAnnotation(String text, OCFile file) {
        return ExpectedAnnotationsKt.createSingleAnnotation(text, file);
    }
}

