/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.completion;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.lang.OCInlineAsserts;
import com.jetbrains.cidr.lang.fixtures.OCFoundationCodeInsightTestCase;
import com.jetbrains.cidr.lang.psi.OCFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Scanner;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class CidrFileBasedCompletionTestCase
extends OCFoundationCodeInsightTestCase
implements OCInlineAsserts.Assert {
    public CidrFileBasedCompletionTestCase(@NonNls @NotNull String dataPath, @NotNull String fileExt) {
        if (dataPath == null) {
            CidrFileBasedCompletionTestCase.$$$reportNull$$$0(0);
        }
        if (fileExt == null) {
            CidrFileBasedCompletionTestCase.$$$reportNull$$$0(1);
        }
        super(dataPath, fileExt);
    }

    protected void checkCompletions() throws Exception {
        CamelHumpMatcher.forceStartMatching((Disposable)this.getTestRootDisposable());
        OCFile file = ((CidrCodeInsightFixture)this.myCodeInsightFixture).configureByFile(this.getTestName(false));
        Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getCachedDocument((PsiFile)file);
        CidrFileBasedCompletionTestCase.assertNotNull((Object)document);
        OCInlineAsserts.doAll(document.getText(), this);
    }

    private static String trimExtraInsertions(@NotNull String completionItem) {
        if (completionItem == null) {
            CidrFileBasedCompletionTestCase.$$$reportNull$$$0(2);
        }
        completionItem = StringUtil.trimEnd((String)completionItem, (String)";").trim();
        completionItem = StringUtil.trimEnd((String)completionItem, (String)"{}").trim();
        completionItem = StringUtil.trimEnd((String)completionItem, (String)"()").trim();
        completionItem = StringUtil.trimEnd((String)completionItem, (String)"<>").trim();
        completionItem = StringUtil.trimEnd((String)completionItem, (String)"=").trim();
        return StringUtil.trimEnd((String)completionItem, (String)":").trim();
    }

    @Override
    public void doAssert(@NotNull String text, @NotNull TextRange assertionRange, @NotNull String assertionText) {
        AssertionData data;
        if (text == null) {
            CidrFileBasedCompletionTestCase.$$$reportNull$$$0(3);
        }
        if (assertionRange == null) {
            CidrFileBasedCompletionTestCase.$$$reportNull$$$0(4);
        }
        if (assertionText == null) {
            CidrFileBasedCompletionTestCase.$$$reportNull$$$0(5);
        }
        if ((data = CidrFileBasedCompletionTestCase.readAssertionData(assertionText)) == null) {
            return;
        }
        int caret = assertionRange.getStartOffset() + data.shift;
        Editor editor2 = this.getEditor();
        Document document = editor2.getDocument();
        WriteAction.run(() -> document.setText((CharSequence)StringUtil.replaceSubstring((String)text, (TextRange)assertionRange, (String)"")));
        editor2.getCaretModel().moveToOffset(caret);
        CodeCompletionHandlerBase base = new CodeCompletionHandlerBase(data.type, false, false, true);
        base.invokeCompletion(this.getProject(), editor2, data.times);
        LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup((Editor)editor2);
        if (lookup == null && !data.text.isEmpty()) {
            String message = "Empty lookup instead of \"" + data.text;
            if (data.mode == Mode.ONLYWARN) {
                LOG.warn(message);
                return;
            }
            CidrFileBasedCompletionTestCase.fail((String)message);
        }
        if (lookup != null) {
            List items = lookup.getItems();
            List actualItems = ContainerUtil.map((Collection)items, element -> element.getLookupString().trim());
            lookup.hide();
            String actualString = StringUtil.join((Collection)actualItems, (String)" ");
            if (data.mode == Mode.STRICT) {
                String message = "Expected: \"" + data.text + "\",\n  actual: \"" + actualString + "\"";
                CidrFileBasedCompletionTestCase.assertEquals((String)message, (String)data.text, (String)actualString);
            } else {
                ArrayList<String> actualFiltered = new ArrayList<String>(actualItems);
                List expectedItems = StringUtil.split((String)data.text, (String)" ");
                if (data.mode == Mode.ONLYWARN) {
                    actualFiltered.clear();
                    for (String item : actualItems) {
                        actualFiltered.add(CidrFileBasedCompletionTestCase.trimExtraInsertions(item));
                    }
                    for (String item : expectedItems) {
                        if (item.startsWith("__") || actualFiltered.contains(item = CidrFileBasedCompletionTestCase.trimExtraInsertions(item)) || actualFiltered.contains(item + "()")) continue;
                        String message = "Line: " + (editor2.offsetToLogicalPosition((int)assertionRange.getStartOffset()).line + 1) + "\nExpected item: \"" + item + "\",not found in\n         list: \"" + actualString + "\"";
                        LOG.warn(message);
                    }
                    return;
                }
                actualFiltered.retainAll(expectedItems);
                if (data.mode == Mode.WEAK) {
                    String message = "Expected weakly: \"" + data.text + "\",\n         actual: \"" + actualString + "\"";
                    CidrFileBasedCompletionTestCase.assertEquals((String)message, (Object)expectedItems, actualFiltered);
                } else {
                    String message = "Didn't expect any of: \"" + data.text + "\",\n              actual: \"" + actualString + "\"";
                    CidrFileBasedCompletionTestCase.assertEmpty(message, actualFiltered);
                }
            }
        }
    }

    public static AssertionData readAssertionData(@NotNull String text) {
        Mode mode;
        CompletionType type;
        if (text == null) {
            CidrFileBasedCompletionTestCase.$$$reportNull$$$0(6);
        }
        if (((String)text).contains("!COMMENT")) {
            return null;
        }
        if (((String)text).contains("!S")) {
            type = CompletionType.SMART;
            text = ((String)text).replace("!S", "");
        } else {
            type = CompletionType.BASIC;
        }
        int time = 1;
        if (((String)text).contains("!D")) {
            time = 2;
            text = ((String)text).replace("!D", "");
        }
        text = ((String)text).trim();
        int shift = 0;
        int shiftTagIdx = ((String)text).indexOf("!<");
        if (shiftTagIdx >= 0) {
            int afterTag = shiftTagIdx + 2;
            try (Scanner scanner = new Scanner(((String)text).substring(afterTag));){
                shift = scanner.nextInt();
                text = ((String)text).substring(0, shiftTagIdx) + ((String)text).substring(afterTag + scanner.match().end());
            }
        }
        if (((String)(text = ((String)text).trim())).contains("!O")) {
            mode = Mode.ONLYWARN;
            text = ((String)text).replace("!O", "");
        } else if (((String)text).contains("!W")) {
            mode = Mode.WEAK;
            text = ((String)text).replace("!W", "");
        } else if (((String)text).contains("!!")) {
            mode = Mode.FORBID;
            text = ((String)text).replace("!!", "");
        } else {
            mode = Mode.STRICT;
        }
        text = ((String)text).trim();
        text = StringUtil.unescapeStringCharacters((String)text);
        return new AssertionData(type, time, (String)text, shift, mode);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileExt";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionItem";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assertionRange";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assertionText";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/completion/CidrFileBasedCompletionTestCase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "trimExtraInsertions";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "doAssert";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "readAssertionData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class AssertionData {
        final CompletionType type;
        final int times;
        final String text;
        private final Mode mode;
        private final int shift;

        AssertionData(CompletionType type, int times, String text, int shift, Mode md) {
            this.type = type;
            this.times = times;
            this.text = text;
            this.mode = md;
            this.shift = shift;
        }
    }

    static enum Mode {
        STRICT,
        WEAK,
        FORBID,
        ONLYWARN;

    }
}

