/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.ExceptionUtil;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.CidrFormattingFixture;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.fixtures.OCCodeInsightTestCase;
import org.jetbrains.annotations.NotNull;

public abstract class OCFormattingTestCase
extends OCCodeInsightTestCase {
    private String myToFormat;
    private OCLanguageKind languageKind;
    private boolean myReformatWhitespacesOnly;
    protected CidrFormattingFixture myFormattingFixture;

    public OCFormattingTestCase() {
        this.myToFormat = null;
        this.languageKind = CLanguageKind.OBJ_CPP;
        this.myReformatWhitespacesOnly = false;
    }

    public OCFormattingTestCase(@NotNull String projectName) {
        if (projectName == null) {
            OCFormattingTestCase.$$$reportNull$$$0(0);
        }
        super(projectName);
        this.myToFormat = null;
        this.languageKind = CLanguageKind.OBJ_CPP;
        this.myReformatWhitespacesOnly = false;
    }

    public OCFormattingTestCase(@NotNull String testFilesPath, @NotNull String testFilesExtension) {
        if (testFilesPath == null) {
            OCFormattingTestCase.$$$reportNull$$$0(1);
        }
        if (testFilesExtension == null) {
            OCFormattingTestCase.$$$reportNull$$$0(2);
        }
        super(testFilesPath, testFilesExtension);
        this.myToFormat = null;
        this.languageKind = CLanguageKind.OBJ_CPP;
        this.myReformatWhitespacesOnly = false;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.myFormattingFixture.setUp();
    }

    @Override
    protected void setUpFixtures() throws Exception {
        super.setUpFixtures();
        this.myFormattingFixture = new CidrFormattingFixture((CidrCodeInsightFixture)this.myCodeInsightFixture);
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            this.myFormattingFixture.tearDown();
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    protected void prepareForFormat(String text) {
        this.prepareForFormat(text, CLanguageKind.OBJ_C);
    }

    protected void prepareForFormatCPP(String text) {
        this.prepareForFormat(text, CLanguageKind.OBJ_CPP);
    }

    protected void prepareForFormat(String text, CLanguageKind kind) {
        this.myToFormat = text;
        this.languageKind = kind;
    }

    protected void assertFormat(String before, String after2) {
        this.assertFormat(before, after2, CLanguageKind.OBJ_C);
    }

    protected void assertFormatCPP(String before, String after2) {
        this.assertFormat(before, after2, CLanguageKind.OBJ_CPP);
    }

    protected void assertFormat(String before, String after2, CLanguageKind kind) {
        this.assertFormat(before, after2, kind, false);
    }

    protected void assertFormat(String before, String after2, CLanguageKind kind, boolean reformatWhitespacesOnly) {
        this.myReformatWhitespacesOnly = reformatWhitespacesOnly;
        this.prepareForFormat(before, kind);
        this.assertFormat(after2);
        this.assertFormatPsi(after2);
    }

    protected void assertFormat(String expected) {
        assert (this.myToFormat != null);
        this.doConfigureText();
        this.formatCurrentFile();
        this.assertFormatResult(expected);
    }

    protected void formatCurrentFile() {
        PsiFile file = this.getFile();
        TextRange range = this.getSelection();
        WriteCommandAction.runWriteCommandAction((Project)this.getProject(), () -> {
            if (this.myReformatWhitespacesOnly) {
                CodeStyleManager.getInstance((Project)this.getProject()).reformatRange((PsiElement)file, range.getStartOffset(), range.getEndOffset(), true);
            } else {
                CodeStyleManager.getInstance((Project)this.getProject()).reformatText(file, range.getStartOffset(), range.getEndOffset());
            }
        });
    }

    private void assertFormatPsi(String after2) {
        this.doConfigureText();
        WriteCommandAction.runWriteCommandAction((Project)this.getProject(), () -> {
            PsiFile psiFile = this.getFile();
            TextRange range = this.getSelection();
            PsiElement elementAtStart = psiFile.findElementAt(range.getStartOffset());
            PsiElement elementAtEnd = psiFile.findElementAt(range.getEndOffset());
            CodeStyleManager.getInstance((Project)this.getProject()).reformat((PsiElement)(elementAtStart == elementAtEnd ? elementAtStart : psiFile), this.myReformatWhitespacesOnly);
        });
        this.assertFormatResult(after2);
    }

    protected void assertFormatResult(String expected) {
        try {
            ((CidrCodeInsightFixture)this.myCodeInsightFixture).checkResult(expected);
        }
        catch (Throwable e) {
            this.doConfigureText();
            OCFormattingTestCase.printPsiStructure((PsiElement)this.getFile());
            ExceptionUtil.rethrow((Throwable)e);
        }
    }

    protected void doConfigureText() {
        ((CidrCodeInsightFixture)this.myCodeInsightFixture).configureByText(this.myToFormat, "test." + this.languageKind.getDefaultSourceExtension());
    }

    protected void checkCopyPaste(String from, String to, String expected) {
        this.configureByTextOCpp(from);
        ((CidrCodeInsightFixture)this.myCodeInsightFixture).getFixture().performEditorAction("$Copy");
        this.configureByTextOCpp(to);
        ((CidrCodeInsightFixture)this.myCodeInsightFixture).getFixture().performEditorAction("$Paste");
        this.checkResult(expected);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "projectName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "testFilesPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "testFilesExtension";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/formatting/OCFormattingTestCase";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

