/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Comparator;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Index;
import org.assertj.core.internal.Arrays;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.VisibleForTesting;

public class DoubleArrays {
    private static final DoubleArrays INSTANCE = new DoubleArrays();
    private Arrays arrays = Arrays.instance();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static DoubleArrays instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    DoubleArrays() {
        this(StandardComparisonStrategy.instance());
    }

    public DoubleArrays(ComparisonStrategy comparisonStrategy) {
        this.setArrays(new Arrays(comparisonStrategy));
    }

    @VisibleForTesting
    public void setArrays(Arrays arrays) {
        this.arrays = arrays;
    }

    @VisibleForTesting
    public Comparator<?> getComparator() {
        return this.arrays.getComparator();
    }

    public void assertNullOrEmpty(AssertionInfo info, double[] actual) {
        this.arrays.assertNullOrEmpty(info, this.failures, actual);
    }

    public void assertEmpty(AssertionInfo info, double[] actual) {
        this.arrays.assertEmpty(info, this.failures, actual);
    }

    public void assertNotEmpty(AssertionInfo info, double[] actual) {
        this.arrays.assertNotEmpty(info, this.failures, actual);
    }

    public void assertHasSize(AssertionInfo info, double[] actual, int expectedSize) {
        this.arrays.assertHasSize(info, actual, expectedSize);
    }

    public void assertHasSizeGreaterThan(AssertionInfo info, double[] actual, int boundary) {
        this.arrays.assertHasSizeGreaterThan(info, actual, boundary);
    }

    public void assertHasSizeGreaterThanOrEqualTo(AssertionInfo info, double[] actual, int boundary) {
        this.arrays.assertHasSizeGreaterThanOrEqualTo(info, actual, boundary);
    }

    public void assertHasSizeLessThan(AssertionInfo info, double[] actual, int boundary) {
        this.arrays.assertHasSizeLessThan(info, actual, boundary);
    }

    public void assertHasSizeLessThanOrEqualTo(AssertionInfo info, double[] actual, int boundary) {
        this.arrays.assertHasSizeLessThanOrEqualTo(info, actual, boundary);
    }

    public void assertHasSizeBetween(AssertionInfo info, double[] actual, int lowerBoundary, int higherBoundary) {
        this.arrays.assertHasSizeBetween(info, actual, lowerBoundary, higherBoundary);
    }

    public void assertHasSameSizeAs(AssertionInfo info, double[] actual, Iterable<?> other) {
        this.arrays.assertHasSameSizeAs(info, (Object)actual, other);
    }

    public void assertHasSameSizeAs(AssertionInfo info, double[] actual, Object[] other) {
        this.arrays.assertHasSameSizeAs(info, (Object)actual, other);
    }

    public void assertContains(AssertionInfo info, double[] actual, double[] values) {
        this.arrays.assertContains(info, this.failures, actual, values);
    }

    public void assertContains(AssertionInfo info, double[] actual, double value2, Index index) {
        this.arrays.assertContains(info, this.failures, actual, value2, index);
    }

    public void assertDoesNotContain(AssertionInfo info, double[] actual, double value2, Index index) {
        this.arrays.assertDoesNotContain(info, this.failures, actual, value2, index);
    }

    public void assertContainsOnly(AssertionInfo info, double[] actual, double[] values) {
        this.arrays.assertContainsOnly(info, this.failures, actual, values);
    }

    public void assertContainsOnlyOnce(AssertionInfo info, double[] actual, double[] values) {
        this.arrays.assertContainsOnlyOnce(info, this.failures, actual, values);
    }

    public void assertContainsExactly(AssertionInfo info, double[] actual, double[] values) {
        this.arrays.assertContainsExactly(info, this.failures, actual, values);
    }

    public void assertContainsExactlyInAnyOrder(AssertionInfo info, double[] actual, double[] values) {
        this.arrays.assertContainsExactlyInAnyOrder(info, this.failures, actual, values);
    }

    public void assertContainsSequence(AssertionInfo info, double[] actual, double[] sequence) {
        this.arrays.assertContainsSequence(info, this.failures, actual, sequence);
    }

    public void assertContainsSubsequence(AssertionInfo info, double[] actual, double[] subsequence) {
        this.arrays.assertContainsSubsequence(info, this.failures, actual, subsequence);
    }

    public void assertDoesNotContain(AssertionInfo info, double[] actual, double[] values) {
        this.arrays.assertDoesNotContain(info, this.failures, actual, values);
    }

    public void assertDoesNotHaveDuplicates(AssertionInfo info, double[] actual) {
        this.arrays.assertDoesNotHaveDuplicates(info, this.failures, actual);
    }

    public void assertStartsWith(AssertionInfo info, double[] actual, double[] sequence) {
        this.arrays.assertStartsWith(info, this.failures, actual, sequence);
    }

    public void assertEndsWith(AssertionInfo info, double[] actual, double[] sequence) {
        this.arrays.assertEndsWith(info, this.failures, actual, sequence);
    }

    public void assertIsSorted(AssertionInfo info, double[] actual) {
        this.arrays.assertIsSorted(info, this.failures, actual);
    }

    public void assertIsSortedAccordingToComparator(AssertionInfo info, double[] actual, Comparator<? super Double> comparator) {
        Arrays.assertIsSortedAccordingToComparator(info, this.failures, actual, comparator);
    }

    public void assertContainsAnyOf(AssertionInfo info, double[] actual, double[] values) {
        this.arrays.assertContainsAnyOf(info, this.failures, actual, values);
    }
}

