/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.search;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeCommandName;
import com.jetbrains.cmake.psi.CMakeRoutine;
import com.jetbrains.cmake.resolve.command.CMakeStandardCommandElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CMakeDefinitionsSearch
extends QueryExecutorBase<PsiElement, DefinitionsScopedSearch.SearchParameters> {
    public void processQuery(@NotNull DefinitionsScopedSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiElement> consumer) {
        if (queryParameters == null) {
            CMakeDefinitionsSearch.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            CMakeDefinitionsSearch.$$$reportNull$$$0(1);
        }
        PsiElement queryParametersElement = queryParameters.getElement();
        ReadAction.run(() -> {
            if (CMakeDefinitionsSearch.isDeclaration(queryParametersElement).booleanValue()) {
                consumer.process((Object)CMakeDefinitionsSearch.getDefinition(queryParametersElement));
            } else {
                PsiReference reference = CMakeDefinitionsSearch.findReference(queryParametersElement);
                if (reference instanceof PsiPolyVariantReference) {
                    ResolveResult[] resolveResults;
                    for (ResolveResult resolveResult : resolveResults = ((PsiPolyVariantReference)reference).multiResolve(false)) {
                        PsiElement resolvedElement = resolveResult.getElement();
                        if (resolvedElement == null || resolvedElement instanceof CMakeStandardCommandElement) continue;
                        consumer.process((Object)resolvedElement.getParent().getParent());
                    }
                }
            }
        });
    }

    private static Boolean isDeclaration(@NotNull PsiElement element) {
        CMakeArgument arg;
        if (element == null) {
            CMakeDefinitionsSearch.$$$reportNull$$$0(2);
        }
        return element instanceof CMakeArgument && ((arg = (CMakeArgument)element).isCMakeTargetDefinitionName() || arg.isCommandDefinitionName());
    }

    private static PsiElement getDefinition(@NotNull PsiElement declaration) {
        CMakeArgument arg;
        CMakeArgument arg2;
        if (declaration == null) {
            CMakeDefinitionsSearch.$$$reportNull$$$0(3);
        }
        if (declaration instanceof CMakeArgument && (arg2 = (CMakeArgument)declaration).isCMakeTargetDefinitionName()) {
            return declaration.getParent().getParent();
        }
        if (declaration instanceof CMakeArgument && (arg = (CMakeArgument)declaration).isCommandDefinitionName()) {
            return PsiTreeUtil.getParentOfType((PsiElement)declaration, CMakeRoutine.class);
        }
        return null;
    }

    @Nullable
    private static PsiReference findReference(@NotNull PsiElement queryParametersElement) {
        if (queryParametersElement == null) {
            CMakeDefinitionsSearch.$$$reportNull$$$0(4);
        }
        PsiReference reference = null;
        if (queryParametersElement instanceof CMakeCommandName) {
            reference = queryParametersElement.getReference();
        } else if (queryParametersElement instanceof CMakeArgument) {
            reference = queryParametersElement.getReference();
        }
        return reference;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryParametersElement";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cmake/search/CMakeDefinitionsSearch";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processQuery";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isDeclaration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getDefinition";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

