/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution;

import com.android.annotations.concurrency.Slow;
import com.android.build.attribution.BuildAnalysisResults;
import com.android.build.attribution.BuildAnalysisResultsMessage;
import com.android.build.attribution.HistoricBuildAnalysisResults;
import com.android.build.attribution.proto.converters.BuildResultsProtoMessageConverter;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.FluentIterable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.observable.properties.AtomicProperty;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\b\u0010\u0013\u001a\u00020\fH\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017H\u0007J\b\u0010\u001b\u001a\u00020\u0019H\u0003J\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0017H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/android/build/attribution/BuildAnalyzerStorageFileManager;", "", "dataFolder", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "totalFilesSize", "Lcom/intellij/openapi/observable/properties/AtomicProperty;", "", "getTotalFilesSize", "()Lcom/intellij/openapi/observable/properties/AtomicProperty;", "storeBuildResultsInFile", "", "buildResults", "Lcom/android/build/attribution/BuildAnalysisResults;", "getCurrentBuildHistoryDataSize", "getHistoricBuildResultByID", "Lcom/android/build/attribution/HistoricBuildAnalysisResults;", "buildSessionID", "", "deleteHistoricBuildResultByID", "", "buildID", "updateObservables", "getFileFromBuildID", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nBuildAnalyzerStorageFileManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildAnalyzerStorageFileManager.kt\ncom/android/build/attribution/BuildAnalyzerStorageFileManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1#2:111\n*E\n"})
public final class BuildAnalyzerStorageFileManager {
    @NotNull
    private final File dataFolder;
    @NotNull
    private final AtomicProperty<Long> totalFilesSize;

    public BuildAnalyzerStorageFileManager(@NotNull File dataFolder) {
        Intrinsics.checkNotNullParameter((Object)dataFolder, (String)"dataFolder");
        this.dataFolder = dataFolder;
        this.totalFilesSize = new AtomicProperty((Object)this.getCurrentBuildHistoryDataSize());
    }

    private final Logger getLog() {
        Logger logger = Logger.getInstance((String)"Build Analyzer");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    @NotNull
    public final AtomicProperty<Long> getTotalFilesSize() {
        return this.totalFilesSize;
    }

    @Slow
    public final boolean storeBuildResultsInFile(@NotNull BuildAnalysisResults buildResults) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)buildResults, (String)"buildResults");
        try {
            FileUtils.mkdirs((File)this.dataFolder);
            File buildResultFile = this.getFileFromBuildID(buildResults.getBuildSessionID());
            buildResultFile.createNewFile();
            BuildResultsProtoMessageConverter.Companion.convertBuildAnalysisResultsFromObjectToBytes(buildResults, buildResults.getPluginMap(), buildResults.getTaskMap()).writeDelimitedTo((OutputStream)new FileOutputStream(buildResultFile));
            this.updateObservables();
            bl = true;
        }
        catch (IOException e) {
            this.getLog().error("Error when attempting to store build results with ID " + buildResults.getBuildSessionID() + " in file.");
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Slow
    public final long getCurrentBuildHistoryDataSize() {
        FileUtils.mkdirs((File)this.dataFolder);
        FluentIterable fluentIterable = FileUtils.getAllFiles((File)this.dataFolder);
        Intrinsics.checkNotNullExpressionValue((Object)fluentIterable, (String)"getAllFiles(...)");
        Iterable iterable = (Iterable)fluentIterable;
        long l = 0L;
        for (Object t : iterable) {
            void it;
            File file = (File)t;
            long l2 = l;
            boolean bl = false;
            long l3 = it.length();
            l = l2 + l3;
        }
        return l;
    }

    @Slow
    @NotNull
    public final HistoricBuildAnalysisResults getHistoricBuildResultByID(@NotNull String buildSessionID) {
        Intrinsics.checkNotNullParameter((Object)buildSessionID, (String)"buildSessionID");
        try {
            FileInputStream stream = new FileInputStream(this.getFileFromBuildID(buildSessionID));
            BuildAnalysisResultsMessage message = BuildAnalysisResultsMessage.parseDelimitedFrom((InputStream)stream);
            Intrinsics.checkNotNull((Object)message);
            return BuildResultsProtoMessageConverter.Companion.convertBuildAnalysisResultsFromBytesToObject(message);
        }
        catch (Exception e) {
            throw new IOException("Error reading in build results file with ID: " + buildSessionID, e);
        }
    }

    @Slow
    public final void deleteHistoricBuildResultByID(@NotNull String buildID) {
        Intrinsics.checkNotNullParameter((Object)buildID, (String)"buildID");
        this.getFileFromBuildID(buildID).delete();
        this.updateObservables();
    }

    @Slow
    private final void updateObservables() {
        this.totalFilesSize.set((Object)this.getCurrentBuildHistoryDataSize());
    }

    @VisibleForTesting
    @NotNull
    public final File getFileFromBuildID(@NotNull String buildID) {
        Intrinsics.checkNotNullParameter((Object)buildID, (String)"buildID");
        return FilesKt.resolve((File)this.dataFolder, (String)buildID);
    }
}

