/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.model;

import com.android.build.attribution.analyzers.DownloadsAnalyzer;
import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.model.RepositoriesTableModel;
import com.intellij.openapi.util.text.Formats;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\f\u0010\u0007\u001a\u00020\b*\u00020\u0002H\u0002J\f\u0010\t\u001a\u00020\n*\u00020\u0002H\u0002J\f\u0010\u000b\u001a\u00020\n*\u00020\u0002H\u0002J\f\u0010\f\u001a\u00020\b*\u00020\u0002H\u0002J\f\u0010\r\u001a\u00020\n*\u00020\u0002H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/android/build/attribution/ui/model/RepositoriesTableModel;", "Lcom/intellij/util/ui/ListTableModel;", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$RepositoryResult;", "result", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Result;", "<init>", "(Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Result;)V", "totalNumberOfRequests", "", "totalAmountOfData", "", "totalAmountOfTime", "numberOfFailed", "timeOfFailed", "intellij.android.build-attribution"})
final class RepositoriesTableModel
extends ListTableModel<DownloadsAnalyzer.RepositoryResult> {
    public RepositoriesTableModel(@NotNull DownloadsAnalyzer.Result result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        super(new ColumnInfo[0]);
        column.1[] nullArray = new column.1[]{RepositoriesTableModel._init_$column$default("Repository", null, RepositoriesTableModel::_init_$lambda$0, 2, null), RepositoriesTableModel._init_$column("Requests", "Total number of requests.", (Function1<? super DownloadsAnalyzer.RepositoryResult, String>)((Function1)arg_0 -> RepositoriesTableModel._init_$lambda$1(this, arg_0))), RepositoriesTableModel._init_$column("Data", "Total amount of data downloaded.", (Function1<? super DownloadsAnalyzer.RepositoryResult, String>)((Function1)arg_0 -> RepositoriesTableModel._init_$lambda$2(this, arg_0))), RepositoriesTableModel._init_$column("Time", "Total amount of time taken to execute requests.", (Function1<? super DownloadsAnalyzer.RepositoryResult, String>)((Function1)arg_0 -> RepositoriesTableModel._init_$lambda$3(this, arg_0))), RepositoriesTableModel._init_$column("Failed Requests", "Number of failed requests.", (Function1<? super DownloadsAnalyzer.RepositoryResult, String>)((Function1)arg_0 -> RepositoriesTableModel._init_$lambda$4(this, arg_0))), RepositoriesTableModel._init_$column("Failed Requests Time", "Total amount of time taken to execute failed requests.", (Function1<? super DownloadsAnalyzer.RepositoryResult, String>)((Function1)arg_0 -> RepositoriesTableModel._init_$lambda$5(this, arg_0)))};
        this.setColumnInfos(nullArray);
        Object object = result2 instanceof DownloadsAnalyzer.ActiveResult ? (DownloadsAnalyzer.ActiveResult)result2 : null;
        if (object == null || (object = ((DownloadsAnalyzer.ActiveResult)object).getRepositoryResults()) == null) {
            object = CollectionsKt.emptyList();
        }
        this.setItems((List)object);
    }

    private final int totalNumberOfRequests(DownloadsAnalyzer.RepositoryResult $this$totalNumberOfRequests) {
        return $this$totalNumberOfRequests.getSuccessRequestsCount() + $this$totalNumberOfRequests.getFailedRequestsCount() + $this$totalNumberOfRequests.getMissedRequestsCount();
    }

    private final long totalAmountOfData(DownloadsAnalyzer.RepositoryResult $this$totalAmountOfData) {
        return $this$totalAmountOfData.getSuccessRequestsBytesDownloaded() + $this$totalAmountOfData.getFailedRequestsBytesDownloaded();
    }

    private final long totalAmountOfTime(DownloadsAnalyzer.RepositoryResult $this$totalAmountOfTime) {
        return $this$totalAmountOfTime.getSuccessRequestsTimeMs() + $this$totalAmountOfTime.getFailedRequestsTimeMs() + $this$totalAmountOfTime.getMissedRequestsTimeMs();
    }

    private final int numberOfFailed(DownloadsAnalyzer.RepositoryResult $this$numberOfFailed) {
        return $this$numberOfFailed.getFailedRequestsCount() + $this$numberOfFailed.getMissedRequestsCount();
    }

    private final long timeOfFailed(DownloadsAnalyzer.RepositoryResult $this$timeOfFailed) {
        return $this$timeOfFailed.getFailedRequestsTimeMs() + $this$timeOfFailed.getMissedRequestsTimeMs();
    }

    private static final column.1 _init_$column(String title2, String tooltip, Function1<? super DownloadsAnalyzer.RepositoryResult, String> valueOf) {
        return new ColumnInfo<DownloadsAnalyzer.RepositoryResult, String>(title2, valueOf, tooltip){
            final /* synthetic */ String $title;
            final /* synthetic */ Function1<DownloadsAnalyzer.RepositoryResult, String> $valueOf;
            final /* synthetic */ String $tooltip;
            {
                this.$title = $title;
                this.$valueOf = $valueOf;
                this.$tooltip = $tooltip;
                super($title);
            }

            public String valueOf(DownloadsAnalyzer.RepositoryResult found) {
                Intrinsics.checkNotNullParameter((Object)found, (String)"found");
                return (String)this.$valueOf.invoke((Object)found);
            }

            public String getPreferredStringValue() {
                return this.$title;
            }

            public String getTooltipText() {
                return this.$tooltip;
            }
        };
    }

    static /* synthetic */ column.1 _init_$column$default(String string, String string2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return RepositoriesTableModel._init_$column(string, string2, (Function1<? super DownloadsAnalyzer.RepositoryResult, String>)function1);
    }

    private static final String _init_$lambda$0(DownloadsAnalyzer.RepositoryResult it) {
        String string;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DownloadsAnalyzer.Repository repo = it.getRepository();
        if (repo instanceof DownloadsAnalyzer.KnownRepository) {
            string = ((DownloadsAnalyzer.KnownRepository)repo).getPresentableName();
        } else if (repo instanceof DownloadsAnalyzer.OtherRepository) {
            string = ((DownloadsAnalyzer.OtherRepository)repo).getHost();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private static final String _init_$lambda$1(RepositoriesTableModel this$0, DownloadsAnalyzer.RepositoryResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return String.valueOf(this$0.totalNumberOfRequests(it));
    }

    private static final String _init_$lambda$2(RepositoriesTableModel this$0, DownloadsAnalyzer.RepositoryResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = Formats.formatFileSize((long)this$0.totalAmountOfData(it));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatFileSize(...)");
        return string;
    }

    private static final String _init_$lambda$3(RepositoriesTableModel this$0, DownloadsAnalyzer.RepositoryResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return BuildAttributionUIUtilKt.durationString(this$0.totalAmountOfTime(it));
    }

    private static final String _init_$lambda$4(RepositoriesTableModel this$0, DownloadsAnalyzer.RepositoryResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return String.valueOf(this$0.numberOfFailed(it));
    }

    private static final String _init_$lambda$5(RepositoriesTableModel this$0, DownloadsAnalyzer.RepositoryResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return BuildAttributionUIUtilKt.durationString(this$0.timeOfFailed(it));
    }
}

