/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.view.details;

import com.android.build.attribution.analyzers.AnalyzerNotRun;
import com.android.build.attribution.analyzers.JetifierCanBeRemoved;
import com.android.build.attribution.analyzers.JetifierNotUsed;
import com.android.build.attribution.analyzers.JetifierRequiredForLibraries;
import com.android.build.attribution.analyzers.JetifierUsageAnalyzerResult;
import com.android.build.attribution.analyzers.JetifierUsageProjectStatus;
import com.android.build.attribution.analyzers.JetifierUsedCheckRequired;
import com.android.build.attribution.ui.BuildAnalyzerBrowserLinks;
import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.HtmlLinksHandler;
import com.android.build.attribution.ui.view.ViewActionHandlers;
import com.android.build.attribution.ui.view.details.JetifierWarningDetailsKt;
import com.android.buildanalyzer.common.FullDependencyPath;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.PlatformIcons;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0004&'()B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u001fH\u0002J\b\u0010!\u001a\u00020\u001fH\u0002J\u0016\u0010\"\u001a\u00020\u001f2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\f\u0010$\u001a\u00020%*\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0010\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00150\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/android/build/attribution/ui/view/details/JetifierWarningDetailsView;", "", "data", "Lcom/android/build/attribution/analyzers/JetifierUsageAnalyzerResult;", "actionHandlers", "Lcom/android/build/attribution/ui/view/ViewActionHandlers;", "disposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/android/build/attribution/analyzers/JetifierUsageAnalyzerResult;Lcom/android/build/attribution/ui/view/ViewActionHandlers;Lcom/intellij/openapi/Disposable;)V", "pagePanel", "Ljavax/swing/JPanel;", "getPagePanel", "()Ljavax/swing/JPanel;", "headerTextArea", "Ljavax/swing/JEditorPane;", "runCheckButton", "Ljavax/swing/JButton;", "removeJetifierButton", "declaredDependenciesList", "Lcom/intellij/ui/components/JBList;", "Lcom/android/build/attribution/ui/view/details/JetifierWarningDetailsView$DirectDependencyDescriptor;", "kotlin.jvm.PlatformType", "tableHeader", "Lcom/intellij/ui/SimpleColoredComponent;", "outdatedResultsBanner", "treeHeader", "dependencyStructureTree", "Lcom/intellij/ui/treeStructure/Tree;", "resultPanel", "setupRefresh", "", "refreshUi", "onDeclaredDependencySelection", "installResultsTableActions", "resultsTable", "isPreviouslySavedResultReused", "", "DependencyTreeNode", "DependencyDescriptor", "DirectDependencyDescriptor", "DependenciesStructureTreeRenderer", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nJetifierWarningDetails.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JetifierWarningDetails.kt\ncom/android/build/attribution/ui/view/details/JetifierWarningDetailsView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,452:1\n1563#2:453\n1634#2,3:454\n1833#2,5:457\n1840#2:463\n1#3:462\n*S KotlinDebug\n*F\n+ 1 JetifierWarningDetails.kt\ncom/android/build/attribution/ui/view/details/JetifierWarningDetailsView\n*L\n335#1:453\n335#1:454,3\n338#1:457,5\n338#1:463\n*E\n"})
public final class JetifierWarningDetailsView {
    @NotNull
    private final JetifierUsageAnalyzerResult data;
    @NotNull
    private final ViewActionHandlers actionHandlers;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final JPanel pagePanel;
    @NotNull
    private final JEditorPane headerTextArea;
    @NotNull
    private final JButton runCheckButton;
    @NotNull
    private final JButton removeJetifierButton;
    @NotNull
    private final JBList<DirectDependencyDescriptor> declaredDependenciesList;
    @NotNull
    private final SimpleColoredComponent tableHeader;
    @NotNull
    private final JPanel outdatedResultsBanner;
    @NotNull
    private final SimpleColoredComponent treeHeader;
    @NotNull
    private final Tree dependencyStructureTree;
    @NotNull
    private final JPanel resultPanel;

    public JetifierWarningDetailsView(@NotNull JetifierUsageAnalyzerResult data2, @NotNull ViewActionHandlers actionHandlers, @NotNull Disposable disposable) {
        Serializable serializable;
        JPanel $this$resultPanel_u24lambda_u2419;
        JComponent $this$dependencyStructureTree_u24lambda_u2416;
        JComponent $this$treeHeader_u24lambda_u2415;
        JComponent $this$outdatedResultsBanner_u24lambda_u2414;
        JComponent $this$tableHeader_u24lambda_u2412;
        JButton $this$declaredDependenciesList_u24lambda_u2411;
        JButton $this$removeJetifierButton_u24lambda_u245;
        JButton $this$runCheckButton_u24lambda_u242;
        JComponent jComponent;
        String string;
        String string2;
        JButton $this$headerTextArea_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)actionHandlers, (String)"actionHandlers");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.data = data2;
        this.actionHandlers = actionHandlers;
        this.disposable = disposable;
        this.pagePanel = new JPanel();
        JetifierWarningDetailsView jetifierWarningDetailsView = this;
        Object object = this;
        boolean bl = false;
        Object linksHandler = new HtmlLinksHandler(((JetifierWarningDetailsView)((Object)$this$headerTextArea_u24lambda_u240)).actionHandlers);
        String learnMoreLink = ((HtmlLinksHandler)linksHandler).externalLink("Learn more", BuildAnalyzerBrowserLinks.JETIIFER_MIGRATE);
        JetifierUsageProjectStatus jetifierUsageProjectStatus = ((JetifierWarningDetailsView)((Object)$this$headerTextArea_u24lambda_u240)).data.getProjectStatus();
        if (Intrinsics.areEqual((Object)jetifierUsageProjectStatus, (Object)JetifierUsedCheckRequired.INSTANCE)) {
            string2 = "Check if you need Jetifier in your project";
        } else if (jetifierUsageProjectStatus instanceof JetifierRequiredForLibraries) {
            string2 = "Some project dependencies require Jetifier";
        } else if (Intrinsics.areEqual((Object)jetifierUsageProjectStatus, (Object)JetifierCanBeRemoved.INSTANCE)) {
            string2 = "Jetifier flag can be removed";
        } else {
            if (Intrinsics.areEqual((Object)jetifierUsageProjectStatus, (Object)JetifierNotUsed.INSTANCE)) {
                throw new IllegalStateException("Warning should not be shown in this state.".toString());
            }
            if (Intrinsics.areEqual((Object)jetifierUsageProjectStatus, (Object)AnalyzerNotRun.INSTANCE)) {
                throw new IllegalStateException("Warning should not be shown in this state.".toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        String headerStatus = string2;
        JetifierUsageProjectStatus jetifierUsageProjectStatus2 = ((JetifierWarningDetailsView)((Object)$this$headerTextArea_u24lambda_u240)).data.getProjectStatus();
        if (Intrinsics.areEqual((Object)jetifierUsageProjectStatus2, (Object)JetifierUsedCheckRequired.INSTANCE)) {
            string = "Removing Jetifier could reduce project build time.\nTo disable Jetifier your project should have no dependencies on legacy support libraries.\nRun check to see if you have any of such dependencies in your project.";
        } else if (jetifierUsageProjectStatus2 instanceof JetifierRequiredForLibraries) {
            int size = ((JetifierRequiredForLibraries)((JetifierWarningDetailsView)((Object)$this$headerTextArea_u24lambda_u240)).data.getProjectStatus()).getCheckJetifierResult().getDependenciesDependingOnSupportLibs().size();
            string = size == 1 ? "This check found <b>1 declared dependency</b> that requires legacy support libraries.\nRemoving Jetifier could reduce project build time.\nTo disable Jetifier you need to upgrade it to a version that does not require legacy support libraries or find an alternative.\nRun this check again to include recent changes to project files." : StringsKt.trimIndent((String)("\n            This check found <b>" + size + " declared dependencies</b> that require legacy support libraries.\n            Removing Jetifier could reduce project build time.\n            To disable Jetifier you need to upgrade them to versions that do not require legacy support libraries or find alternatives.\n            Run this check again to include recent changes to project files.\n            "));
        } else if (Intrinsics.areEqual((Object)jetifierUsageProjectStatus2, (Object)JetifierCanBeRemoved.INSTANCE)) {
            string = "This check found <b>0 declared dependencies</b> that require Jetifier in your project.\nYou can safely remove the 'android.enableJetifier' flag.";
        } else {
            if (Intrinsics.areEqual((Object)jetifierUsageProjectStatus2, (Object)JetifierNotUsed.INSTANCE)) {
                throw new IllegalStateException("Warning should not be shown in this state.".toString());
            }
            if (Intrinsics.areEqual((Object)jetifierUsageProjectStatus2, (Object)AnalyzerNotRun.INSTANCE)) {
                throw new IllegalStateException("Warning should not be shown in this state.".toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        String callToActionLine = string;
        String contentHtml = StringsKt.trimIndent((String)("\n          <b>" + headerStatus + "</b><br/>\n          <br/>\n          Your project\u2019s gradle.properties file includes 'android.enableJetifier=true'.\n          This flag is needed to enable AndroidX for libraries that don\u2019t support it natively.\n          " + learnMoreLink + ".<br/>\n          <br/>\n          " + callToActionLine + "<br/>\n        "));
        ((JetifierWarningDetailsView)object).headerTextArea = BuildAttributionUIUtilKt.htmlTextLabelWithLinesWrap(contentHtml, (HtmlLinksHandler)linksHandler);
        $this$headerTextArea_u24lambda_u240 = jComponent = new JButton("Run Jetifier check");
        object = this;
        boolean bl2 = false;
        $this$runCheckButton_u24lambda_u242.setName("run-check-button");
        $this$runCheckButton_u24lambda_u242.addActionListener(arg_0 -> JetifierWarningDetailsView.runCheckButton$lambda$2$lambda$1(this, arg_0));
        $this$runCheckButton_u24lambda_u242.putClientProperty(DarculaButtonUI.DEFAULT_STYLE_KEY, !(this.data.getProjectStatus() instanceof JetifierCanBeRemoved));
        ((JetifierWarningDetailsView)object).runCheckButton = jComponent;
        $this$runCheckButton_u24lambda_u242 = jComponent = new JButton("Disable Jetifier");
        object = this;
        boolean bl3 = false;
        $this$removeJetifierButton_u24lambda_u245.setName("disable-jetifier-button");
        $this$removeJetifierButton_u24lambda_u245.setToolTipText("Remove the 'android.enableJetifier' flag from gradle.properties");
        $this$removeJetifierButton_u24lambda_u245.addActionListener(arg_0 -> JetifierWarningDetailsView.removeJetifierButton$lambda$5$lambda$4(this, $this$removeJetifierButton_u24lambda_u245, arg_0));
        $this$removeJetifierButton_u24lambda_u245.putClientProperty(DarculaButtonUI.DEFAULT_STYLE_KEY, this.data.getProjectStatus() instanceof JetifierCanBeRemoved);
        $this$removeJetifierButton_u24lambda_u245.setVisible(this.data.getProjectStatus() instanceof JetifierCanBeRemoved);
        $this$removeJetifierButton_u24lambda_u245.setPreferredSize(this.runCheckButton.getPreferredSize());
        $this$removeJetifierButton_u24lambda_u245.setMaximumSize(this.runCheckButton.getMaximumSize());
        $this$removeJetifierButton_u24lambda_u245.setMinimumSize(this.runCheckButton.getMinimumSize());
        ((JetifierWarningDetailsView)object).removeJetifierButton = jComponent;
        $this$removeJetifierButton_u24lambda_u245 = jComponent = new JBList((Collection)JetifierWarningDetailsKt.access$createDeclaredDependenciesList(this.data));
        object = this;
        boolean bl4 = false;
        $this$declaredDependenciesList_u24lambda_u2411.setName("declared-dependencies-list");
        $this$declaredDependenciesList_u24lambda_u2411.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<DirectDependencyDescriptor>(this){
            final /* synthetic */ JetifierWarningDetailsView this$0;
            {
                this.this$0 = $receiver;
            }

            protected void customizeCellRenderer(JList<? extends DirectDependencyDescriptor> list, DirectDependencyDescriptor value2, int index, boolean selected, boolean hasFocus) {
                Intrinsics.checkNotNullParameter(list, (String)"list");
                if (value2 == null) {
                    return;
                }
                this.setIcon(PlatformIcons.LIBRARY_ICON);
                this.setIconOpaque(true);
                this.setFocusBorderAroundIcon(true);
                this.setBackground(UIUtil.getListBackground((boolean)selected, (boolean)hasFocus));
                this.mySelectionForeground = UIUtil.getListForeground((boolean)selected, (boolean)hasFocus);
                if (JetifierWarningDetailsView.access$getData$p(this.this$0).getProjectStatus() instanceof JetifierRequiredForLibraries) {
                    this.setToolTipText(JetifierWarningDetailsKt.access$treeToolTip(value2.isSupportLibrary(), true));
                }
                this.append(value2.getFullName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        });
        $this$declaredDependenciesList_u24lambda_u2411.setBorder((Border)JBUI.Borders.empty());
        $this$declaredDependenciesList_u24lambda_u2411.setSelectionMode(0);
        $this$declaredDependenciesList_u24lambda_u2411.getSelectionModel().addListSelectionListener(arg_0 -> JetifierWarningDetailsView.declaredDependenciesList$lambda$11$lambda$6(this, arg_0));
        $this$declaredDependenciesList_u24lambda_u2411.getEmptyText().clear();
        linksHandler = this.data.getProjectStatus();
        if (linksHandler instanceof JetifierUsedCheckRequired) {
            $this$declaredDependenciesList_u24lambda_u2411.getEmptyText().appendText("Run check", SimpleTextAttributes.LINK_ATTRIBUTES, arg_0 -> JetifierWarningDetailsView.declaredDependenciesList$lambda$11$lambda$7(this, arg_0));
            v2 = $this$declaredDependenciesList_u24lambda_u2411.getEmptyText().appendText(" to see if you need Jetifier in your project.");
        } else if (linksHandler instanceof JetifierCanBeRemoved) {
            $this$declaredDependenciesList_u24lambda_u2411.getEmptyText().appendText("No dependencies require jetifier, ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            v2 = $this$declaredDependenciesList_u24lambda_u2411.getEmptyText().appendText("remove 'android.enableJetifier' flag.", SimpleTextAttributes.LINK_ATTRIBUTES, arg_0 -> JetifierWarningDetailsView.declaredDependenciesList$lambda$11$lambda$10((JBList)$this$declaredDependenciesList_u24lambda_u2411, this, arg_0));
        } else if (Intrinsics.areEqual((Object)linksHandler, (Object)AnalyzerNotRun.INSTANCE) || Intrinsics.areEqual((Object)linksHandler, (Object)JetifierNotUsed.INSTANCE) || linksHandler instanceof JetifierRequiredForLibraries) {
            v2 = Unit.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.installResultsTableActions((JBList<DirectDependencyDescriptor>)$this$declaredDependenciesList_u24lambda_u2411);
        ListSpeedSearch.installOn((JList)((JList)((Object)$this$declaredDependenciesList_u24lambda_u2411)));
        ((JetifierWarningDetailsView)object).declaredDependenciesList = jComponent;
        $this$declaredDependenciesList_u24lambda_u2411 = jComponent = new SimpleColoredComponent();
        object = this;
        boolean bl5 = false;
        $this$tableHeader_u24lambda_u2412.setName("declared-dependencies-header");
        $this$tableHeader_u24lambda_u2412.setIpad((Insets)JBUI.insetsLeft((int)8));
        $this$tableHeader_u24lambda_u2412.setBorder(JBUI.Borders.customLineBottom((Color)JBUI.CurrentTheme.ToolWindow.headerBorderBackground()));
        $this$tableHeader_u24lambda_u2412.setBackground(UIUtil.getTreeBackground());
        ((JetifierWarningDetailsView)object).tableHeader = jComponent;
        $this$tableHeader_u24lambda_u2412 = jComponent = new JPanel();
        object = this;
        boolean bl6 = false;
        $this$outdatedResultsBanner_u24lambda_u2414.setName("outdated-results-banner");
        $this$outdatedResultsBanner_u24lambda_u2414.setVisible(this.isPreviouslySavedResultReused(this.data));
        ((Container)$this$outdatedResultsBanner_u24lambda_u2414).setLayout((LayoutManager)new HorizontalLayout(10, 0, 2, null));
        $this$outdatedResultsBanner_u24lambda_u2414.setBorder((Border)JBUI.Borders.empty((int)4, (int)8));
        $this$outdatedResultsBanner_u24lambda_u2414.add((Component)new JLabel("Showing previously saved results."), "LEFT");
        $this$outdatedResultsBanner_u24lambda_u2414.add((Component)new ActionLink("Re-run check.", arg_0 -> JetifierWarningDetailsView.outdatedResultsBanner$lambda$14$lambda$13(this, arg_0)), "RIGHT");
        $this$outdatedResultsBanner_u24lambda_u2414.setBackground(JBUI.CurrentTheme.NotificationWarning.backgroundColor());
        $this$outdatedResultsBanner_u24lambda_u2414.setForeground(JBUI.CurrentTheme.NotificationWarning.foregroundColor());
        ((JetifierWarningDetailsView)object).outdatedResultsBanner = jComponent;
        $this$outdatedResultsBanner_u24lambda_u2414 = jComponent = new SimpleColoredComponent();
        object = this;
        boolean bl7 = false;
        $this$treeHeader_u24lambda_u2415.setName("dependency-structure-header");
        $this$treeHeader_u24lambda_u2415.setIpad((Insets)JBUI.insetsLeft((int)8));
        $this$treeHeader_u24lambda_u2415.append("Dependency Structure");
        $this$treeHeader_u24lambda_u2415.setBorder(JBUI.Borders.customLineBottom((Color)JBUI.CurrentTheme.ToolWindow.headerBorderBackground()));
        $this$treeHeader_u24lambda_u2415.setBackground(UIUtil.getTreeBackground());
        ((JetifierWarningDetailsView)object).treeHeader = jComponent;
        $this$treeHeader_u24lambda_u2415 = jComponent = new Tree();
        object = this;
        boolean bl8 = false;
        $this$dependencyStructureTree_u24lambda_u2416.setRootVisible(false);
        $this$dependencyStructureTree_u24lambda_u2416.setCellRenderer((TreeCellRenderer)((Object)new DependenciesStructureTreeRenderer()));
        $this$dependencyStructureTree_u24lambda_u2416.setModel(new DefaultTreeModel(null));
        ((JetifierWarningDetailsView)object).dependencyStructureTree = jComponent;
        $this$dependencyStructureTree_u24lambda_u2416 = jComponent = new JPanel();
        object = this;
        boolean bl9 = false;
        $this$resultPanel_u24lambda_u2419.setName("jetifier-libraries-list");
        $this$resultPanel_u24lambda_u2419.setLayout(new BorderLayout());
        Object $this$resultPanel_u24lambda_u2419_u24lambda_u2417 = linksHandler = ScrollPaneFactory.createScrollPane();
        boolean bl10 = false;
        ((JScrollPane)$this$resultPanel_u24lambda_u2419_u24lambda_u2417).setColumnHeaderView((Component)this.tableHeader);
        BorderLayoutPanel listWithBanner = new BorderLayoutPanel();
        ((JScrollPane)$this$resultPanel_u24lambda_u2419_u24lambda_u2417).setViewportView((Component)listWithBanner.addToTop((Component)this.outdatedResultsBanner).addToCenter((Component)this.declaredDependenciesList));
        Object object2 = linksHandler;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"apply(...)");
        Object declaredDependenciesListPanel = object2;
        Object $this$resultPanel_u24lambda_u2419_u24lambda_u2418 = $this$resultPanel_u24lambda_u2419_u24lambda_u2417 = ScrollPaneFactory.createScrollPane();
        boolean bl11 = false;
        ((JScrollPane)$this$resultPanel_u24lambda_u2419_u24lambda_u2418).setColumnHeaderView((Component)this.treeHeader);
        ((JScrollPane)$this$resultPanel_u24lambda_u2419_u24lambda_u2418).setViewportView((Component)this.dependencyStructureTree);
        Object object3 = $this$resultPanel_u24lambda_u2419_u24lambda_u2417;
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"apply(...)");
        Object librariesStructurePanel = object3;
        OnePixelSplitter splitter = new OnePixelSplitter(false, 0.5f);
        splitter.setFirstComponent((JComponent)declaredDependenciesListPanel);
        splitter.setSecondComponent((JComponent)librariesStructurePanel);
        $this$resultPanel_u24lambda_u2419.add((Component)splitter, "Center");
        ((JetifierWarningDetailsView)object).resultPanel = jComponent;
        JPanel $this$_init__u24lambda_u2420 = $this$resultPanel_u24lambda_u2419 = new JPanel();
        boolean bl12 = false;
        $this$_init__u24lambda_u2420.setLayout(new BoxLayout($this$_init__u24lambda_u2420, 1));
        $this$_init__u24lambda_u2420.add(this.removeJetifierButton);
        $this$_init__u24lambda_u2420.add(this.runCheckButton);
        JPanel buttonsPanel = $this$resultPanel_u24lambda_u2419;
        JPanel $this$_init__u24lambda_u2421 = serializable = new JPanel();
        boolean bl13 = false;
        $this$_init__u24lambda_u2421.setLayout(new BoxLayout($this$_init__u24lambda_u2421, 0));
        this.headerTextArea.setMaximumSize((Dimension)JBUI.size((int)800, (int)Integer.MAX_VALUE));
        buttonsPanel.setAlignmentY(1.0f);
        this.headerTextArea.setAlignmentY(1.0f);
        $this$_init__u24lambda_u2421.add(this.headerTextArea);
        $this$_init__u24lambda_u2421.add(buttonsPanel);
        JPanel headerPanel2 = serializable;
        this.pagePanel.setLayout(new GridBagLayout());
        $this$_init__u24lambda_u2421 = serializable = new GridBagConstraints();
        Component component = headerPanel2;
        object = this.pagePanel;
        boolean bl14 = false;
        ((GridBagConstraints)$this$_init__u24lambda_u2422).gridx = 0;
        ((GridBagConstraints)$this$_init__u24lambda_u2422).gridy = 0;
        ((GridBagConstraints)$this$_init__u24lambda_u2422).weightx = 1.0;
        ((GridBagConstraints)$this$_init__u24lambda_u2422).fill = 2;
        Unit unit = Unit.INSTANCE;
        ((Container)object).add(component, serializable);
        Serializable $this$_init__u24lambda_u2422 = serializable = new GridBagConstraints();
        component = this.resultPanel;
        object = this.pagePanel;
        boolean bl15 = false;
        $this$_init__u24lambda_u2423.gridx = 0;
        $this$_init__u24lambda_u2423.gridy = 1;
        $this$_init__u24lambda_u2423.gridwidth = 0;
        $this$_init__u24lambda_u2423.weightx = 1.0;
        $this$_init__u24lambda_u2423.weighty = 1.0;
        $this$_init__u24lambda_u2423.insets = (Insets)JBUI.insetsTop((int)10);
        $this$_init__u24lambda_u2423.fill = 1;
        unit = Unit.INSTANCE;
        ((Container)object).add(component, serializable);
        this.setupRefresh();
    }

    @NotNull
    public final JPanel getPagePanel() {
        return this.pagePanel;
    }

    private final void setupRefresh() {
        Alarm refreshAlarm = new Alarm((JComponent)this.pagePanel, this.disposable);
        new Runnable(this, refreshAlarm){
            final /* synthetic */ JetifierWarningDetailsView this$0;
            final /* synthetic */ Alarm $refreshAlarm;
            {
                this.this$0 = $receiver;
                this.$refreshAlarm = $refreshAlarm;
            }

            public void run() {
                JetifierWarningDetailsView.access$refreshUi(this.this$0);
                this.$refreshAlarm.addRequest((Runnable)this, 30000);
            }
        }.run();
        UiNotifyConnector.Companion.installOn((Component)this.pagePanel, new Activatable(this){
            final /* synthetic */ JetifierWarningDetailsView this$0;
            {
                this.this$0 = $receiver;
            }

            public void showNotify() {
                JetifierWarningDetailsView.access$refreshUi(this.this$0);
            }
        });
    }

    private final void refreshUi() {
        Object object;
        SimpleColoredComponent it;
        block3: {
            block2: {
                it = this.tableHeader;
                boolean bl = false;
                it.clear();
                object = this.data.getLastCheckJetifierBuildTimestamp();
                if (object == null) break block2;
                long it2 = ((Number)object).longValue();
                boolean bl2 = false;
                String string = StringUtil.decapitalize((String)DateFormatUtil.formatPrettyDateTime((long)it2));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decapitalize(...)");
                String lastUpdatedTime = string;
                String string2 = " (updated " + lastUpdatedTime + ")";
                object = string2;
                if (string2 != null) break block3;
            }
            object = "";
        }
        Object lastUpdatedSuffix = object;
        it.append("Declared Dependencies Requiring Jetifier" + (String)lastUpdatedSuffix);
    }

    /*
     * WARNING - void declaration
     */
    private final void onDeclaredDependencySelection() {
        if (this.data.getProjectStatus() instanceof JetifierRequiredForLibraries) {
            TreeModel treeModel;
            DefaultMutableTreeNode newRoot = new DefaultMutableTreeNode();
            DirectDependencyDescriptor selectedDependency = (DirectDependencyDescriptor)this.declaredDependenciesList.getSelectedValue();
            if (selectedDependency != null) {
                void $this$foldRight$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = selectedDependency.getPathToSupportLibrary();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(new DependencyDescriptor((String)it));
                }
                List descriptors = (List)destination$iv$iv;
                ((DependencyDescriptor)CollectionsKt.last((List)descriptors)).setSupportLibrary(true);
                ((DependencyDescriptor)CollectionsKt.first((List)descriptors)).setDeclaredDependency(true);
                $this$map$iv = descriptors;
                DefaultMutableTreeNode initial$iv = newRoot;
                boolean $i$f$foldRight = false;
                DefaultMutableTreeNode accumulator$iv = initial$iv;
                if (!$this$foldRight$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$foldRight$iv.listIterator($this$foldRight$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        void parentNode;
                        DependencyTreeNode dependencyTreeNode;
                        DefaultMutableTreeNode defaultMutableTreeNode = accumulator$iv;
                        DependencyDescriptor descriptor2 = (DependencyDescriptor)iterator$iv.previous();
                        boolean bl = false;
                        DependencyTreeNode it = dependencyTreeNode = new DependencyTreeNode(descriptor2);
                        boolean bl2 = false;
                        parentNode.add(it);
                        accumulator$iv = dependencyTreeNode;
                    }
                }
            }
            DefaultTreeModel defaultTreeModel = (treeModel = this.dependencyStructureTree.getModel()) instanceof DefaultTreeModel ? (DefaultTreeModel)treeModel : null;
            if (defaultTreeModel != null) {
                defaultTreeModel.setRoot(newRoot);
            }
            TreeUtil.expandAll((JTree)((JTree)this.dependencyStructureTree));
        }
    }

    private final void installResultsTableActions(JBList<DirectDependencyDescriptor> resultsTable) {
        AnAction findSelectedLibVersionDeclarationAction = this.actionHandlers.createFindSelectedLibVersionDeclarationAction(() -> JetifierWarningDetailsView.installResultsTableActions$lambda$29(resultsTable));
        DefaultActionGroup group2 = new DefaultActionGroup();
        boolean bl = false;
        group2.add(findSelectedLibVersionDeclarationAction);
        PopupHandler.installPopupMenu((JComponent)((JComponent)resultsTable), (ActionGroup)((ActionGroup)group2), (String)"popup");
        new DoubleClickListener(findSelectedLibVersionDeclarationAction, resultsTable){
            final /* synthetic */ AnAction $findSelectedLibVersionDeclarationAction;
            final /* synthetic */ JBList<DirectDependencyDescriptor> $resultsTable;
            {
                this.$findSelectedLibVersionDeclarationAction = $findSelectedLibVersionDeclarationAction;
                this.$resultsTable = $resultsTable;
            }

            protected boolean onDoubleClick(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ActionManager.getInstance().tryToExecute(this.$findSelectedLibVersionDeclarationAction, (InputEvent)e, (Component)this.$resultsTable, null, true);
                return true;
            }
        }.installOn((Component)resultsTable);
        Serializable serializable = resultsTable.getInputMap(1);
        InputMap $this$installResultsTableActions_u24lambda_u2431 = serializable;
        boolean bl2 = false;
        $this$installResultsTableActions_u24lambda_u2431.put(KeyStroke.getKeyStroke(10, 0), "enter");
        $this$installResultsTableActions_u24lambda_u2431.put(KeyStroke.getKeyStroke(32, 0), "enter");
        Serializable $this$installResultsTableActions_u24lambda_u2432 = serializable = resultsTable.getActionMap();
        boolean bl3 = false;
        ((ActionMap)$this$installResultsTableActions_u24lambda_u2432).put("enter", new AbstractAction(findSelectedLibVersionDeclarationAction, resultsTable){
            final /* synthetic */ AnAction $findSelectedLibVersionDeclarationAction;
            final /* synthetic */ JBList<DirectDependencyDescriptor> $resultsTable;
            {
                this.$findSelectedLibVersionDeclarationAction = $findSelectedLibVersionDeclarationAction;
                this.$resultsTable = $resultsTable;
            }

            public void actionPerformed(ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ActionManager.getInstance().tryToExecute(this.$findSelectedLibVersionDeclarationAction, null, (Component)this.$resultsTable, null, true);
            }
        });
    }

    private final boolean isPreviouslySavedResultReused(JetifierUsageAnalyzerResult $this$isPreviouslySavedResultReused) {
        return !$this$isPreviouslySavedResultReused.getCheckJetifierBuild() && ($this$isPreviouslySavedResultReused.getProjectStatus() instanceof JetifierCanBeRemoved || $this$isPreviouslySavedResultReused.getProjectStatus() instanceof JetifierRequiredForLibraries);
    }

    private static final void runCheckButton$lambda$2$lambda$1(JetifierWarningDetailsView this$0, ActionEvent it) {
        this$0.actionHandlers.runCheckJetifierTask();
    }

    private static final RelativePoint removeJetifierButton$lambda$5$lambda$4$lambda$3(JButton $this_apply) {
        return RelativePoint.getSouthOf((JComponent)$this_apply);
    }

    private static final void removeJetifierButton$lambda$5$lambda$4(JetifierWarningDetailsView this$0, JButton $this_apply, ActionEvent it) {
        this$0.actionHandlers.turnJetifierOffInProperties(() -> JetifierWarningDetailsView.removeJetifierButton$lambda$5$lambda$4$lambda$3($this_apply));
    }

    private static final void declaredDependenciesList$lambda$11$lambda$6(JetifierWarningDetailsView this$0, ListSelectionEvent it) {
        this$0.onDeclaredDependencySelection();
    }

    private static final void declaredDependenciesList$lambda$11$lambda$7(JetifierWarningDetailsView this$0, ActionEvent it) {
        this$0.actionHandlers.runCheckJetifierTask();
    }

    private static final RelativePoint declaredDependenciesList$lambda$11$lambda$10$lambda$9(JBList $this_apply, Point $pointBelowCenter) {
        return new RelativePoint((Component)$this_apply, $pointBelowCenter);
    }

    private static final void declaredDependenciesList$lambda$11$lambda$10(JBList $this_apply, JetifierWarningDetailsView this$0, ActionEvent it) {
        Point point;
        Point $this$declaredDependenciesList_u24lambda_u2411_u24lambda_u2410_u24lambda_u248 = point = $this_apply.getEmptyText().getPointBelow();
        boolean bl = false;
        $this$declaredDependenciesList_u24lambda_u2411_u24lambda_u2410_u24lambda_u248.translate($this_apply.getEmptyText().getPreferredSize().width / 2, 0);
        Point pointBelowCenter = point;
        this$0.actionHandlers.turnJetifierOffInProperties(() -> JetifierWarningDetailsView.declaredDependenciesList$lambda$11$lambda$10$lambda$9($this_apply, pointBelowCenter));
    }

    private static final Unit outdatedResultsBanner$lambda$14$lambda$13(JetifierWarningDetailsView this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.actionHandlers.runCheckJetifierTask();
        return Unit.INSTANCE;
    }

    private static final DirectDependencyDescriptor installResultsTableActions$lambda$29(JBList $resultsTable) {
        return (DirectDependencyDescriptor)$resultsTable.getSelectedValue();
    }

    public static final /* synthetic */ void access$refreshUi(JetifierWarningDetailsView $this) {
        $this.refreshUi();
    }

    public static final /* synthetic */ JetifierUsageAnalyzerResult access$getData$p(JetifierWarningDetailsView $this) {
        return $this.data;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/android/build/attribution/ui/view/details/JetifierWarningDetailsView$DependenciesStructureTreeRenderer;", "Lcom/intellij/ide/util/treeView/NodeRenderer;", "<init>", "()V", "customizeCellRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "intellij.android.build-attribution"})
    private static final class DependenciesStructureTreeRenderer
    extends NodeRenderer {
        public void customizeCellRenderer(@NotNull JTree tree, @Nullable Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DependencyDescriptor userObj;
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value2;
            Object object = node.getUserObject();
            DependencyDescriptor dependencyDescriptor = userObj = object instanceof DependencyDescriptor ? (DependencyDescriptor)object : null;
            if (userObj == null) {
                super.customizeCellRenderer(tree, value2, selected, expanded, leaf, row, hasFocus);
            } else {
                this.setIcon(PlatformIcons.LIBRARY_ICON);
                this.append(userObj.getPrefix(), SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
                this.append(userObj.getFullName());
                this.setToolTipText(userObj.getTooltip());
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u0011\u0010\u0011\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0007R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/android/build/attribution/ui/view/details/JetifierWarningDetailsView$DependencyDescriptor;", "", "fullName", "", "<init>", "(Ljava/lang/String;)V", "getFullName", "()Ljava/lang/String;", "declaredDependency", "", "getDeclaredDependency", "()Z", "setDeclaredDependency", "(Z)V", "supportLibrary", "getSupportLibrary", "setSupportLibrary", "prefix", "getPrefix", "tooltip", "getTooltip", "intellij.android.build-attribution"})
    public static final class DependencyDescriptor {
        @NotNull
        private final String fullName;
        private boolean declaredDependency;
        private boolean supportLibrary;

        public DependencyDescriptor(@NotNull String fullName) {
            Intrinsics.checkNotNullParameter((Object)fullName, (String)"fullName");
            this.fullName = fullName;
        }

        @NotNull
        public final String getFullName() {
            return this.fullName;
        }

        public final boolean getDeclaredDependency() {
            return this.declaredDependency;
        }

        public final void setDeclaredDependency(boolean bl) {
            this.declaredDependency = bl;
        }

        public final boolean getSupportLibrary() {
            return this.supportLibrary;
        }

        public final void setSupportLibrary(boolean bl) {
            this.supportLibrary = bl;
        }

        @NotNull
        public final String getPrefix() {
            return this.declaredDependency ? "" : (this.supportLibrary ? "depends on " : "via ");
        }

        @Nullable
        public final String getTooltip() {
            return JetifierWarningDetailsKt.access$treeToolTip(this.supportLibrary, this.declaredDependency);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/android/build/attribution/ui/view/details/JetifierWarningDetailsView$DependencyTreeNode;", "Ljavax/swing/tree/DefaultMutableTreeNode;", "descriptor", "Lcom/android/build/attribution/ui/view/details/JetifierWarningDetailsView$DependencyDescriptor;", "<init>", "(Lcom/android/build/attribution/ui/view/details/JetifierWarningDetailsView$DependencyDescriptor;)V", "getDescriptor", "()Lcom/android/build/attribution/ui/view/details/JetifierWarningDetailsView$DependencyDescriptor;", "toString", "", "intellij.android.build-attribution"})
    private static final class DependencyTreeNode
    extends DefaultMutableTreeNode {
        @NotNull
        private final DependencyDescriptor descriptor;

        public DependencyTreeNode(@NotNull DependencyDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            super(descriptor2);
            this.descriptor = descriptor2;
        }

        @NotNull
        public final DependencyDescriptor getDescriptor() {
            return this.descriptor;
        }

        @Override
        @NotNull
        public String toString() {
            return this.descriptor.getFullName();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010&\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB#\b\u0016\u0012\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00050\n\u00a2\u0006\u0004\b\u0007\u0010\fJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J3\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lcom/android/build/attribution/ui/view/details/JetifierWarningDetailsView$DirectDependencyDescriptor;", "", "fullName", "", "projects", "", "pathToSupportLibrary", "<init>", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "resultEntry", "", "Lcom/android/buildanalyzer/common/FullDependencyPath;", "(Ljava/util/Map$Entry;)V", "getFullName", "()Ljava/lang/String;", "getProjects", "()Ljava/util/List;", "getPathToSupportLibrary", "isSupportLibrary", "", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "intellij.android.build-attribution"})
    @SourceDebugExtension(value={"SMAP\nJetifierWarningDetails.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JetifierWarningDetails.kt\ncom/android/build/attribution/ui/view/details/JetifierWarningDetailsView$DirectDependencyDescriptor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,452:1\n1563#2:453\n1634#2,3:454\n*S KotlinDebug\n*F\n+ 1 JetifierWarningDetails.kt\ncom/android/build/attribution/ui/view/details/JetifierWarningDetailsView$DirectDependencyDescriptor\n*L\n407#1:453\n407#1:454,3\n*E\n"})
    public static final class DirectDependencyDescriptor {
        @NotNull
        private final String fullName;
        @NotNull
        private final List<String> projects;
        @NotNull
        private final List<String> pathToSupportLibrary;

        public DirectDependencyDescriptor(@NotNull String fullName, @NotNull List<String> projects, @NotNull List<String> pathToSupportLibrary) {
            Intrinsics.checkNotNullParameter((Object)fullName, (String)"fullName");
            Intrinsics.checkNotNullParameter(projects, (String)"projects");
            Intrinsics.checkNotNullParameter(pathToSupportLibrary, (String)"pathToSupportLibrary");
            this.fullName = fullName;
            this.projects = projects;
            this.pathToSupportLibrary = pathToSupportLibrary;
        }

        @NotNull
        public final String getFullName() {
            return this.fullName;
        }

        @NotNull
        public final List<String> getProjects() {
            return this.projects;
        }

        @NotNull
        public final List<String> getPathToSupportLibrary() {
            return this.pathToSupportLibrary;
        }

        public final boolean isSupportLibrary() {
            return this.pathToSupportLibrary.size() == 1;
        }

        /*
         * WARNING - void declaration
         */
        public DirectDependencyDescriptor(@NotNull Map.Entry<String, ? extends List<FullDependencyPath>> resultEntry) {
            Collection<String> collection2;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(resultEntry, (String)"resultEntry");
            Iterable iterable = resultEntry.getValue();
            String string = resultEntry.getKey();
            DirectDependencyDescriptor directDependencyDescriptor = this;
            boolean $i$f$map = false;
            void var4_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FullDependencyPath fullDependencyPath = (FullDependencyPath)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getProjectPath());
            }
            collection2 = (List)destination$iv$iv;
            directDependencyDescriptor(string, (List<String>)collection2, ((FullDependencyPath)CollectionsKt.first(resultEntry.getValue())).getDependencyPath().getElements());
        }

        @NotNull
        public final String component1() {
            return this.fullName;
        }

        @NotNull
        public final List<String> component2() {
            return this.projects;
        }

        @NotNull
        public final List<String> component3() {
            return this.pathToSupportLibrary;
        }

        @NotNull
        public final DirectDependencyDescriptor copy(@NotNull String fullName, @NotNull List<String> projects, @NotNull List<String> pathToSupportLibrary) {
            Intrinsics.checkNotNullParameter((Object)fullName, (String)"fullName");
            Intrinsics.checkNotNullParameter(projects, (String)"projects");
            Intrinsics.checkNotNullParameter(pathToSupportLibrary, (String)"pathToSupportLibrary");
            return new DirectDependencyDescriptor(fullName, projects, pathToSupportLibrary);
        }

        public static /* synthetic */ DirectDependencyDescriptor copy$default(DirectDependencyDescriptor directDependencyDescriptor, String string, List list, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                string = directDependencyDescriptor.fullName;
            }
            if ((n & 2) != 0) {
                list = directDependencyDescriptor.projects;
            }
            if ((n & 4) != 0) {
                list2 = directDependencyDescriptor.pathToSupportLibrary;
            }
            return directDependencyDescriptor.copy(string, list, list2);
        }

        @NotNull
        public String toString() {
            return "DirectDependencyDescriptor(fullName=" + this.fullName + ", projects=" + this.projects + ", pathToSupportLibrary=" + this.pathToSupportLibrary + ")";
        }

        public int hashCode() {
            int result2 = this.fullName.hashCode();
            result2 = result2 * 31 + ((Object)this.projects).hashCode();
            result2 = result2 * 31 + ((Object)this.pathToSupportLibrary).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DirectDependencyDescriptor)) {
                return false;
            }
            DirectDependencyDescriptor directDependencyDescriptor = (DirectDependencyDescriptor)other;
            if (!Intrinsics.areEqual((Object)this.fullName, (Object)directDependencyDescriptor.fullName)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.projects, directDependencyDescriptor.projects)) {
                return false;
            }
            return Intrinsics.areEqual(this.pathToSupportLibrary, directDependencyDescriptor.pathToSupportLibrary);
        }
    }
}

