/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.output;

import com.android.build.output.DownloadRequestItem;
import com.android.build.output.DownloadRequestKey;
import com.android.build.output.LongDownloadsNotifier;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.analytics.UsageTrackerUtils;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.BuildOutputDownloadsInfoEvent;
import com.intellij.build.BuildContentManager;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.EdtExecutorService;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u001bH\u0002J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/build/output/LongDownloadsNotifier;", "", "taskId", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "project", "Lcom/intellij/openapi/project/Project;", "buildFinishedDisposable", "Lcom/intellij/openapi/util/CheckedDisposable;", "buildStartTimestampMs", "", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "ticker", "Lcom/google/common/base/Ticker;", "<init>", "(Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/util/CheckedDisposable;JLjava/util/concurrent/ScheduledExecutorService;Lcom/google/common/base/Ticker;)V", "runningRequestsSet", "", "Lcom/android/build/output/DownloadRequestKey;", "watch", "Lcom/google/common/base/Stopwatch;", "kotlin.jvm.PlatformType", "notified", "", "notificationThresholdInSeconds", "notificationRecheckDelayInSeconds", "updateDownloadRequest", "", "downloadRequest", "Lcom/android/build/output/DownloadRequestItem;", "notifyIfTimeElapsed", "logUserEvent", "reportedInteraction", "Lcom/google/wireless/android/sdk/stats/BuildOutputDownloadsInfoEvent$Interaction;", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nLongDownloadsNotifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongDownloadsNotifier.kt\ncom/android/build/output/LongDownloadsNotifier\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1#2:115\n*E\n"})
public final class LongDownloadsNotifier {
    @NotNull
    private final ExternalSystemTaskId taskId;
    @NotNull
    private final Project project;
    @NotNull
    private final CheckedDisposable buildFinishedDisposable;
    private final long buildStartTimestampMs;
    @NotNull
    private final Set<DownloadRequestKey> runningRequestsSet;
    private final Stopwatch watch;
    private volatile boolean notified;
    private final long notificationThresholdInSeconds;
    private final long notificationRecheckDelayInSeconds;

    public LongDownloadsNotifier(@NotNull ExternalSystemTaskId taskId, @NotNull Project project, @NotNull CheckedDisposable buildFinishedDisposable, long buildStartTimestampMs, @NotNull ScheduledExecutorService scheduler, @NotNull Ticker ticker) {
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)buildFinishedDisposable, (String)"buildFinishedDisposable");
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        Intrinsics.checkNotNullParameter((Object)ticker, (String)"ticker");
        this.taskId = taskId;
        this.project = project;
        this.buildFinishedDisposable = buildFinishedDisposable;
        this.buildStartTimestampMs = buildStartTimestampMs;
        this.runningRequestsSet = new LinkedHashSet();
        this.watch = Stopwatch.createUnstarted((Ticker)ticker);
        this.notificationThresholdInSeconds = 30L;
        this.notificationRecheckDelayInSeconds = 5L;
        Runnable runnable2 = new Runnable(this){
            final /* synthetic */ LongDownloadsNotifier this$0;
            {
                this.this$0 = $receiver;
            }

            public void run() {
                if (LongDownloadsNotifier.access$getNotified$p(this.this$0)) {
                    return;
                }
                LongDownloadsNotifier.access$notifyIfTimeElapsed(this.this$0);
            }
        };
        ScheduledFuture<?> taskFuture = scheduler.scheduleWithFixedDelay(runnable2, this.notificationThresholdInSeconds, this.notificationRecheckDelayInSeconds, TimeUnit.SECONDS);
        Disposer.register((Disposable)((Disposable)this.buildFinishedDisposable), () -> LongDownloadsNotifier._init_$lambda$0(taskFuture));
    }

    public /* synthetic */ LongDownloadsNotifier(ExternalSystemTaskId externalSystemTaskId, Project project, CheckedDisposable checkedDisposable, long l, ScheduledExecutorService scheduledExecutorService, Ticker ticker, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            ScheduledExecutorService scheduledExecutorService2 = EdtExecutorService.getScheduledExecutorInstance();
            Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService2, (String)"getScheduledExecutorInstance(...)");
            scheduledExecutorService = scheduledExecutorService2;
        }
        if ((n & 0x20) != 0) {
            Ticker ticker2 = Ticker.systemTicker();
            Intrinsics.checkNotNullExpressionValue((Object)ticker2, (String)"systemTicker(...)");
            ticker = ticker2;
        }
        this(externalSystemTaskId, project, checkedDisposable, l, scheduledExecutorService, ticker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateDownloadRequest(@NotNull DownloadRequestItem downloadRequest) {
        Intrinsics.checkNotNullParameter((Object)downloadRequest, (String)"downloadRequest");
        if (this.notified) {
            return;
        }
        boolean bl = !downloadRequest.getCompleted() ? this.runningRequestsSet.add(downloadRequest.getRequestKey()) : this.runningRequestsSet.remove(downloadRequest.getRequestKey());
        if (!((Collection)this.runningRequestsSet).isEmpty()) {
            Stopwatch stopwatch = this.watch;
            Intrinsics.checkNotNullExpressionValue((Object)stopwatch, (String)"watch");
            Stopwatch stopwatch2 = stopwatch;
            synchronized (stopwatch2) {
                boolean $i$a$-synchronized-LongDownloadsNotifier$updateDownloadRequest$32 = false;
                if (!this.watch.isRunning()) {
                    this.watch.start();
                }
                Unit $i$a$-synchronized-LongDownloadsNotifier$updateDownloadRequest$32 = Unit.INSTANCE;
            }
        }
        Stopwatch stopwatch = this.watch;
        Intrinsics.checkNotNullExpressionValue((Object)stopwatch, (String)"watch");
        Stopwatch stopwatch3 = stopwatch;
        synchronized (stopwatch3) {
            boolean bl2 = false;
            if (this.watch.isRunning()) {
                this.watch.stop();
            }
            Unit unit = Unit.INSTANCE;
        }
        this.notifyIfTimeElapsed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void notifyIfTimeElapsed() {
        Stopwatch stopwatch = this.watch;
        Intrinsics.checkNotNullExpressionValue((Object)stopwatch, (String)"watch");
        Stopwatch stopwatch2 = stopwatch;
        synchronized (stopwatch2) {
            boolean bl = false;
            if (!this.notified && this.watch.elapsed().getSeconds() >= this.notificationThresholdInSeconds) {
                NotificationGroupManager.getInstance().getNotificationGroup("Build Analyzer").createNotification("Sync is taking a significant amount of time to download dependencies.", NotificationType.WARNING).addAction(new AnAction(this){
                    final /* synthetic */ LongDownloadsNotifier this$0;
                    {
                        this.this$0 = $receiver;
                        super("Open Sync tool window for details");
                    }

                    public void actionPerformed(AnActionEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        BuildContentManager.getInstance((Project)LongDownloadsNotifier.access$getProject$p(this.this$0)).getOrCreateToolWindow().show(notifyIfTimeElapsed.1.1::actionPerformed$lambda$0);
                        LongDownloadsNotifier.access$logUserEvent(this.this$0, BuildOutputDownloadsInfoEvent.Interaction.NOTIFICATION_LINK_CLICK);
                    }

                    private static final void actionPerformed$lambda$0() {
                    }
                }).notify(this.project);
                this.notified = true;
                this.logUserEvent(BuildOutputDownloadsInfoEvent.Interaction.NOTIFICATION_TRIGGERED);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void logUserEvent(BuildOutputDownloadsInfoEvent.Interaction reportedInteraction) {
        void $this$logUserEvent_u24lambda_u244;
        BuildOutputDownloadsInfoEvent.Builder builder;
        BuildOutputDownloadsInfoEvent.Builder builder2 = builder = BuildOutputDownloadsInfoEvent.newBuilder();
        AndroidStudioEvent.Builder builder3 = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.BUILD_OUTPUT_DOWNLOADS_INFO_USER_INTERACTION);
        boolean bl = false;
        $this$logUserEvent_u24lambda_u244.setView(this.taskId.getType() == ExternalSystemTaskType.RESOLVE_PROJECT ? BuildOutputDownloadsInfoEvent.View.SYNC_VIEW : BuildOutputDownloadsInfoEvent.View.BUILD_VIEW);
        $this$logUserEvent_u24lambda_u244.setMsSinceBuildStart((int)(System.currentTimeMillis() - this.buildStartTimestampMs));
        $this$logUserEvent_u24lambda_u244.setBuildFinished(this.buildFinishedDisposable.isDisposed());
        $this$logUserEvent_u24lambda_u244.setInteraction(reportedInteraction);
        AndroidStudioEvent.Builder event = builder3.setBuildOutputDownloadsInfoEvent(builder);
        Intrinsics.checkNotNull((Object)event);
        UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(event, this.project));
    }

    private static final void _init_$lambda$0(ScheduledFuture $taskFuture) {
        $taskFuture.cancel(false);
    }

    public static final /* synthetic */ Project access$getProject$p(LongDownloadsNotifier $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$logUserEvent(LongDownloadsNotifier $this, BuildOutputDownloadsInfoEvent.Interaction reportedInteraction) {
        $this.logUserEvent(reportedInteraction);
    }

    public static final /* synthetic */ boolean access$getNotified$p(LongDownloadsNotifier $this) {
        return $this.notified;
    }

    public static final /* synthetic */ void access$notifyIfTimeElapsed(LongDownloadsNotifier $this) {
        $this.notifyIfTimeElapsed();
    }
}

