/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.componenttree.treetable;

import com.android.tools.componenttree.treetable.TreeTableHeaderTraversalPolicy;
import com.android.tools.componenttree.treetable.TreeTableHeaderUI;
import com.android.tools.componenttree.treetable.TreeTableImpl;
import com.intellij.ui.JBColor;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001(B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0007J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u0016H\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\rR\u0016\u0010%\u001a\u0004\u0018\u00010\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006)"}, d2={"Lcom/android/tools/componenttree/treetable/TreeTableHeader;", "Ljavax/swing/table/JTableHeader;", "treeTable", "Lcom/android/tools/componenttree/treetable/TreeTableImpl;", "<init>", "(Lcom/android/tools/componenttree/treetable/TreeTableImpl;)V", "hoverColumn", "", "hoverCachedComponent", "Ljava/awt/Component;", "value", "editingColumn", "getEditingColumn", "()I", "isEditing", "", "()Z", "columnCount", "getColumnCount", "editCellAt", "columnIndex", "removeEditor", "", "getPreferredSize", "Ljava/awt/Dimension;", "paintComponent", "g", "Ljava/awt/Graphics;", "updateUI", "getToolTipText", "", "event", "Ljava/awt/event/MouseEvent;", "paintBottomSeparator", "updateHoverColumn", "hoverComponentAt", "Ljavax/swing/JComponent;", "hoverComponent", "getHoverComponent", "()Ljava/awt/Component;", "HoverMouseListener", "intellij.android.layout-ui"})
@SourceDebugExtension(value={"SMAP\nTreeTableHeader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TreeTableHeader.kt\ncom/android/tools/componenttree/treetable/TreeTableHeader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,234:1\n1#2:235\n1321#3,2:236\n*S KotlinDebug\n*F\n+ 1 TreeTableHeader.kt\ncom/android/tools/componenttree/treetable/TreeTableHeader\n*L\n122#1:236,2\n*E\n"})
public final class TreeTableHeader
extends JTableHeader {
    @NotNull
    private final TreeTableImpl treeTable;
    private int hoverColumn;
    @Nullable
    private Component hoverCachedComponent;
    private int editingColumn;

    public TreeTableHeader(@NotNull TreeTableImpl treeTable2) {
        Intrinsics.checkNotNullParameter((Object)treeTable2, (String)"treeTable");
        super(treeTable2.getColumnModel());
        this.treeTable = treeTable2;
        this.hoverColumn = -1;
        this.editingColumn = -1;
        this.reorderingAllowed = false;
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new TreeTableHeaderTraversalPolicy(this));
        this.setBackground(UIUtil.TRANSPARENT_COLOR);
        this.setOpaque(false);
        HoverMouseListener mouseListener2 = new HoverMouseListener();
        this.addMouseListener(mouseListener2);
        this.addMouseMotionListener(mouseListener2);
    }

    public final int getEditingColumn() {
        return this.editingColumn;
    }

    public final boolean isEditing() {
        return this.editingColumn >= 0;
    }

    public final int getColumnCount() {
        return this.treeTable.getColumnCount();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean editCellAt(int columnIndex) {
        TableColumn column2 = this.columnModel.getColumn(columnIndex);
        Component component = column2.getHeaderRenderer().getTableCellRendererComponent((JTable)((Object)this.treeTable), null, false, false, 0, columnIndex);
        Enumeration<TableColumn> enumeration = this.columnModel.getColumns();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getColumns(...)");
        Sequence sequence = SequencesKt.take((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), (int)columnIndex);
        int n = 0;
        for (Object e : sequence) {
            void it;
            TableColumn tableColumn = (TableColumn)e;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getWidth();
            n = n2 + n3;
        }
        int x = n;
        component.setBounds(x, 0, column2.getWidth(), this.getHeight() - 1);
        this.removeEditor();
        this.add(component);
        component.validate();
        component.repaint();
        this.editingColumn = columnIndex;
        return true;
    }

    public final void removeEditor() {
        Component[] componentArray = this.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        Component editor = (Component)ArraysKt.firstOrNull((Object[])componentArray);
        if (editor != null && IJSwingUtilities.hasFocus((Component)editor)) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().clearFocusOwner();
        }
        this.removeAll();
        this.editingColumn = -1;
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        int n = size.height;
        size.height = n + 1;
        Intrinsics.checkNotNull((Object)size);
        return size;
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintComponent(g);
        this.treeTable.paintColumnDividers(g);
        this.paintBottomSeparator(g);
    }

    @Override
    public void updateUI() {
        this.setUI(new TreeTableHeaderUI());
        Enumeration<TableColumn> enumeration = this.columnModel.getColumns();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getColumns(...)");
        Sequence $this$forEach$iv = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TableColumn it = (TableColumn)element$iv;
            boolean bl = false;
            TableCellRenderer tableCellRenderer = it.getHeaderRenderer();
            Component component = tableCellRenderer != null ? tableCellRenderer.getTableCellRendererComponent(this.table, null, false, false, 0, it.getModelIndex()) : null;
            IJSwingUtilities.updateComponentTreeUI(component);
        }
    }

    @Override
    @Nullable
    public String getToolTipText(@NotNull MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.updateHoverColumn(event);
        JComponent jComponent = this.hoverComponentAt(event);
        return jComponent != null ? jComponent.getToolTipText() : null;
    }

    private final void paintBottomSeparator(Graphics g) {
        Graphics g2 = g.create();
        g2.setColor(JBColor.border());
        g2.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
        g2.dispose();
    }

    private final void updateHoverColumn(MouseEvent event) {
        Serializable serializable;
        int column2 = this.table.columnAtPoint(event.getPoint());
        if (column2 != this.hoverColumn) {
            this.hoverColumn = column2;
            this.hoverCachedComponent = null;
        }
        if ((serializable = this.hoverComponentAt(event)) == null || (serializable = serializable.getCursor()) == null) {
            serializable = Cursor.getDefaultCursor();
        }
        this.setCursor((Cursor)serializable);
    }

    private final JComponent hoverComponentAt(MouseEvent event) {
        Serializable serializable;
        Component component = this.getHoverComponent();
        if (component == null) {
            return null;
        }
        Component columnComponent = component;
        Rectangle cellRect = this.getHeaderRect(this.hoverColumn);
        columnComponent.setBounds(0, 0, cellRect.width, cellRect.height);
        columnComponent.doLayout();
        Point it = serializable = event.getPoint();
        boolean bl = false;
        it.translate(-cellRect.x, -cellRect.y);
        Point point = serializable;
        serializable = SwingUtilities.getDeepestComponentAt(columnComponent, point.x, point.y);
        return serializable instanceof JComponent ? (JComponent)serializable : null;
    }

    private final Component getHoverComponent() {
        if (this.hoverCachedComponent == null && this.hoverColumn != -1) {
            TableColumn aColumn = this.columnModel.getColumn(this.hoverColumn);
            TableCellRenderer tableCellRenderer = aColumn.getHeaderRenderer();
            if (tableCellRenderer == null) {
                tableCellRenderer = this.getDefaultRenderer();
            }
            TableCellRenderer renderer2 = tableCellRenderer;
            this.hoverCachedComponent = renderer2.getTableCellRendererComponent(this.table, aColumn.getHeaderValue(), false, false, -1, this.hoverColumn);
        }
        return this.hoverCachedComponent;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/componenttree/treetable/TreeTableHeader$HoverMouseListener;", "Ljava/awt/event/MouseAdapter;", "<init>", "(Lcom/android/tools/componenttree/treetable/TreeTableHeader;)V", "mouseEntered", "", "event", "Ljava/awt/event/MouseEvent;", "mouseMoved", "mouseWheelMoved", "Ljava/awt/event/MouseWheelEvent;", "mouseExited", "mousePressed", "mouseReleased", "mouseClicked", "redispatchMouseEvent", "intellij.android.layout-ui"})
    @SourceDebugExtension(value={"SMAP\nTreeTableHeader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TreeTableHeader.kt\ncom/android/tools/componenttree/treetable/TreeTableHeader$HoverMouseListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,234:1\n1#2:235\n1321#3,2:236\n*S KotlinDebug\n*F\n+ 1 TreeTableHeader.kt\ncom/android/tools/componenttree/treetable/TreeTableHeader$HoverMouseListener\n*L\n214#1:236,2\n*E\n"})
    private final class HoverMouseListener
    extends MouseAdapter {
        @Override
        public void mouseEntered(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            TreeTableHeader.this.updateHoverColumn(event);
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            TreeTableHeader.this.updateHoverColumn(event);
        }

        @Override
        public void mouseWheelMoved(@NotNull MouseWheelEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            TreeTableHeader.this.updateHoverColumn(event);
        }

        @Override
        public void mouseExited(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            TreeTableHeader.this.hoverColumn = -1;
            TreeTableHeader.this.hoverCachedComponent = null;
        }

        @Override
        public void mousePressed(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.redispatchMouseEvent(event);
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.redispatchMouseEvent(event);
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.redispatchMouseEvent(event);
        }

        /*
         * WARNING - void declaration
         */
        private final void redispatchMouseEvent(MouseEvent event) {
            void $this$forEach$iv;
            Point point;
            TreeTableHeader.this.updateHoverColumn(event);
            JComponent jComponent = TreeTableHeader.this.hoverComponentAt(event);
            if (jComponent == null) {
                return;
            }
            JComponent component = jComponent;
            Rectangle cellRect = TreeTableHeader.this.getHeaderRect(TreeTableHeader.this.hoverColumn);
            Point it = point = event.getPoint();
            boolean bl = false;
            it.translate(-cellRect.x, -cellRect.y);
            Point point2 = point;
            point = SequencesKt.generateSequence((Object)component, HoverMouseListener::redispatchMouseEvent$lambda$1);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JComponent it2 = (JComponent)element$iv;
                boolean bl2 = false;
                point2.translate(-it2.getX(), -it2.getY());
            }
            MouseEvent newEvent = new MouseEvent(component, event.getID(), event.getWhen(), event.getModifiers() | event.getModifiersEx(), point2.x, point2.y, event.getXOnScreen(), event.getYOnScreen(), event.getClickCount(), event.isPopupTrigger(), event.getButton());
            component.dispatchEvent(newEvent);
        }

        private static final JComponent redispatchMouseEvent$lambda$1(JComponent it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return (JComponent)it.getParent();
        }
    }
}

