/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginModuleDescriptor;
import com.intellij.ide.plugins.PluginSet;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0002J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/actions/ValidateEssentialPluginsAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "validateEssentialPlugins", "getRequiredPluginDependencies", "", "Lcom/intellij/openapi/extensions/PluginId;", "plugin", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nValidateEssentialPluginsAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValidateEssentialPluginsAction.kt\ncom/android/tools/idea/actions/ValidateEssentialPluginsAction\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n24#2:104\n1563#3:105\n1634#3,3:106\n*S KotlinDebug\n*F\n+ 1 ValidateEssentialPluginsAction.kt\ncom/android/tools/idea/actions/ValidateEssentialPluginsAction\n*L\n33#1:104\n93#1:105\n93#1:106,3\n*E\n"})
public final class ValidateEssentialPluginsAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.validateEssentialPlugins();
        ValidateEssentialPluginsAction $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(ValidateEssentialPluginsAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("Done validating plugins");
    }

    private final void validateEssentialPlugins() {
        ApplicationInfoEx appInfoEx = ApplicationInfoEx.getInstanceEx();
        List list = appInfoEx.getEssentialPluginIds();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEssentialPluginIds(...)");
        Set essentialPlugins = CollectionsKt.toSet((Iterable)list);
        List errors = new ArrayList();
        for (PluginId plugin : essentialPlugins) {
            Intrinsics.checkNotNull((Object)plugin);
            for (PluginId dependency : this.getRequiredPluginDependencies(plugin)) {
                if (essentialPlugins.contains(dependency) || Intrinsics.areEqual((Object)dependency, (Object)PluginManagerCore.CORE_ID)) continue;
                errors.add("Essential plugin '" + plugin + "' requires non-essential plugin '" + dependency + "'");
            }
        }
        if (!((Collection)errors).isEmpty()) {
            String msg = "The essential plugins in AndroidStudioApplicationInfo.xml do not form a transitive closure:\n" + CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            throw new AssertionError((Object)msg);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<PluginId> getRequiredPluginDependencies(PluginId plugin) {
        void $this$mapTo$iv$iv;
        PluginSet pluginSet = PluginManagerCore.getPluginSet();
        Set plugins = new LinkedHashSet();
        Set modules = new LinkedHashSet();
        PluginModuleDescriptor pluginModuleDescriptor = pluginSet.findEnabledPlugin(plugin);
        if (pluginModuleDescriptor == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        PluginModuleDescriptor descriptor2 = pluginModuleDescriptor;
        ValidateEssentialPluginsAction.getRequiredPluginDependencies$collectDependencies(plugins, pluginSet, modules, (IdeaPluginDescriptorImpl)descriptor2);
        Iterable $this$map$iv = PluginManagerCore.INSTANCE.getNonOptionalDependenciesIds((IdeaPluginDescriptorImpl)descriptor2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            PluginId pluginId = (PluginId)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(ValidateEssentialPluginsAction.getRequiredPluginDependencies$getCanonicalPluginId(pluginSet, (PluginId)p0));
        }
        List baseline = (List)destination$iv$iv;
        if (!plugins.containsAll(baseline)) {
            boolean bl = false;
            String string = "The result of getRequiredPluginDependencies() appears to be inconsistent with getNonOptionalDependenciesIds() from IntelliJ";
            throw new IllegalStateException(string.toString());
        }
        return plugins;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private static final PluginId getRequiredPluginDependencies$getCanonicalPluginId(PluginSet pluginSet, PluginId id2) {
        PluginModuleDescriptor pluginModuleDescriptor = pluginSet.findEnabledPlugin(id2);
        if (pluginModuleDescriptor == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        PluginId pluginId = pluginModuleDescriptor.getPluginId();
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getPluginId(...)");
        return pluginId;
    }

    private static final void getRequiredPluginDependencies$collectDependencies(Set<PluginId> plugins, PluginSet pluginSet, Set<String> modules, IdeaPluginDescriptorImpl descriptor2) {
        for (PluginDependency dep : descriptor2.getDependencies()) {
            if (dep.isOptional()) continue;
            plugins.add(ValidateEssentialPluginsAction.getRequiredPluginDependencies$getCanonicalPluginId(pluginSet, dep.getPluginId()));
        }
        for (PluginDependency dep : descriptor2.getModuleDependencies().getPlugins()) {
            plugins.add(ValidateEssentialPluginsAction.getRequiredPluginDependencies$getCanonicalPluginId(pluginSet, dep.getId()));
        }
        for (PluginDependency dep : descriptor2.getModuleDependencies().getModules()) {
            PluginModuleDescriptor moduleDescriptor;
            if (pluginSet.findEnabledModule(dep.getName()) == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            if (modules.add(dep.getName())) {
                ValidateEssentialPluginsAction.getRequiredPluginDependencies$collectDependencies(plugins, pluginSet, modules, (IdeaPluginDescriptorImpl)moduleDescriptor);
            }
            PluginId pluginId = moduleDescriptor.getPluginId();
            Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getPluginId(...)");
            plugins.add(ValidateEssentialPluginsAction.getRequiredPluginDependencies$getCanonicalPluginId(pluginSet, pluginId));
        }
    }
}

