/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb;

import com.android.tools.idea.adb.AdbOptionsService;
import com.android.tools.idea.adb.AdbServerBurstMode;
import com.android.tools.idea.adb.AdbServerLogLevel;
import com.android.tools.idea.adb.AdbServerMdnsBackend;
import com.android.tools.idea.adb.AdbServerUsbBackend;
import com.android.tools.idea.flags.StudioFlags;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBIntSpinner;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class AdbConfigurableUi
implements ConfigurableUi<AdbOptionsService> {
    private JPanel myPanel;
    private JBLabel myExistingAdbServerPortLabel;
    private JBIntSpinner myExistingAdbServerPortSpinner;
    private JRadioButton myAutomaticallyStartAndManageServerRadioButton;
    private JRadioButton myUseExistingManuallyManagedServerRadioButton;
    private JComboBox<String> myAdbServerUsbBackend;
    private JComboBox myAdbServerMdnsBackend;
    private JComboBox myAdbServerBurstMode;
    private JComboBox myAdbServerLogLevel;
    private JCheckBox myEnableADBServerLogs;

    public AdbConfigurableUi() {
        this.setupUI();
    }

    public boolean isModified(@NotNull AdbOptionsService settings) {
        return this.getAdbServerUsbBackend() != settings.getAdbServerUsbBackend() || this.getAdbServerMdnsBackend() != settings.getAdbServerMdnsBackend() || this.myUseExistingManuallyManagedServerRadioButton.isSelected() != settings.shouldUseUserManagedAdb() || this.getUserManagedAdbPortNumber() != settings.getUserManagedAdbPort() || this.getAdbServerBurstMode() != settings.getAdbServerBurstMode() || this.getAdbServerLogsEnabled() != settings.getAdbServerLogsEnabled() || this.getAdbServerLogLevel() != settings.getAdbServerLogLevel();
    }

    public void reset(@NotNull AdbOptionsService settings) {
        this.setAdbServerUsbBackend(settings.getAdbServerUsbBackend());
        if (settings.shouldUseUserManagedAdb()) {
            this.myUseExistingManuallyManagedServerRadioButton.setSelected(true);
        } else {
            this.myAutomaticallyStartAndManageServerRadioButton.setSelected(true);
        }
        this.setAdbServerMdnsBackend(settings.getAdbServerMdnsBackend());
        this.myExistingAdbServerPortSpinner.setValue((Object)settings.getUserManagedAdbPort());
        this.setPortNumberUiEnabled(settings.shouldUseUserManagedAdb());
        this.setAdbServerBurstMode(settings.getAdbServerBurstMode());
        this.setAdbServerLogsEnabled(settings.getAdbServerLogsEnabled());
        this.setAdbServerLogLevel(settings.getAdbServerLogLevel());
    }

    public void apply(@NotNull AdbOptionsService settings) throws ConfigurationException {
        settings.getOptionsUpdater().setAdbServerUsbBackend(this.getAdbServerUsbBackend()).setUseUserManagedAdb(this.myUseExistingManuallyManagedServerRadioButton.isSelected()).setAdbServerMdnsBackend(this.getAdbServerMdnsBackend()).setUserManagedAdbPort(this.getUserManagedAdbPortNumber()).setBurstMode(this.getAdbServerBurstMode()).setAdbServerLogsEnabled(this.getAdbServerLogsEnabled()).setAdbServerLogLevel(this.getAdbServerLogLevel()).commit();
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    private void createUIComponents() {
        this.myExistingAdbServerPortSpinner = new JBIntSpinner(5038, 5037, 65535);
        this.myExistingAdbServerPortLabel = new JBLabel();
        this.myAutomaticallyStartAndManageServerRadioButton = new JRadioButton();
        this.myAutomaticallyStartAndManageServerRadioButton.addActionListener(event -> this.setPortNumberUiEnabled(false));
        this.myUseExistingManuallyManagedServerRadioButton = new JRadioButton();
        this.myUseExistingManuallyManagedServerRadioButton.addActionListener(event -> this.setPortNumberUiEnabled(true));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myAutomaticallyStartAndManageServerRadioButton);
        buttonGroup.add(this.myUseExistingManuallyManagedServerRadioButton);
        this.myAdbServerUsbBackend = new ComboBox();
        this.myAdbServerMdnsBackend = new ComboBox();
        this.myAdbServerBurstMode = new ComboBox();
        this.myEnableADBServerLogs = new JCheckBox();
        this.myAdbServerLogLevel = new ComboBox();
        this.myAdbServerLogLevel.setModel(new DefaultComboBoxModel<AdbServerLogLevel>(AdbServerLogLevel.values()));
    }

    private void setPortNumberUiEnabled(boolean enabled) {
        this.myExistingAdbServerPortSpinner.setEnabled(enabled);
        this.myExistingAdbServerPortLabel.setEnabled(enabled);
    }

    private int getUserManagedAdbPortNumber() {
        return this.myExistingAdbServerPortSpinner.getNumber();
    }

    void setAdbServerMdnsBackend(AdbServerMdnsBackend backend) {
        this.myAdbServerMdnsBackend.setSelectedItem((Object)backend);
    }

    AdbServerMdnsBackend getAdbServerMdnsBackend() {
        return AdbServerMdnsBackend.fromDisplayText(this.myAdbServerMdnsBackend.getSelectedItem().toString());
    }

    void setAdbServerUsbBackend(AdbServerUsbBackend backend) {
        this.myAdbServerUsbBackend.setSelectedItem((Object)backend);
    }

    AdbServerUsbBackend getAdbServerUsbBackend() {
        return AdbServerUsbBackend.fromDisplayText(this.myAdbServerUsbBackend.getSelectedItem().toString());
    }

    void setAdbServerBurstMode(AdbServerBurstMode burstMode) {
        this.myAdbServerBurstMode.setSelectedItem((Object)burstMode);
    }

    AdbServerBurstMode getAdbServerBurstMode() {
        return AdbServerBurstMode.fromDisplayText(this.myAdbServerBurstMode.getSelectedItem().toString());
    }

    AdbServerLogLevel getAdbServerLogLevel() {
        return AdbServerLogLevel.fromDisplayText(this.myAdbServerLogLevel.getSelectedItem().toString());
    }

    void setAdbServerLogLevel(AdbServerLogLevel logLevel) {
        this.myAdbServerLogLevel.setSelectedItem((Object)logLevel);
    }

    private void setupUI() {
        this.createUIComponents();
        this.myPanel = new JPanel();
        this.myPanel.setLayout((LayoutManager)new GridLayoutManager(6, 6, new Insets(0, 0, 0, 0), -1, -1));
        this.myPanel.add((Component)new Spacer(), new GridConstraints(0, 5, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        HyperlinkLabel adbServerUsbBackendLabel = new HyperlinkLabel();
        adbServerUsbBackendLabel.setToolTipText("");
        adbServerUsbBackendLabel.setHyperlinkText("ADB server USB backend (", "Support list", ")");
        adbServerUsbBackendLabel.setHyperlinkTarget("https://developer.android.com/tools/adb#backends");
        adbServerUsbBackendLabel.setIcon(null);
        this.myPanel.add((Component)adbServerUsbBackendLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myAdbServerUsbBackend.setModel(new DefaultComboBoxModel<AdbServerUsbBackend>(AdbServerUsbBackend.values()));
        this.myPanel.add(this.myAdbServerUsbBackend, new GridConstraints(0, 1, 1, 1, 8, 1, 0, 0, null, null, null, 0, false));
        HyperlinkLabel adbServerMdnsBackendLabel = new HyperlinkLabel();
        adbServerMdnsBackendLabel.setHyperlinkText("ADB server mDNS backend (", "Support list", ")");
        adbServerMdnsBackendLabel.setHyperlinkTarget("https://developer.android.com/tools/adb#mdnsBackends");
        adbServerMdnsBackendLabel.setIcon(null);
        this.myPanel.add((Component)adbServerMdnsBackendLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(4, 38), null, 0, false));
        this.myAdbServerMdnsBackend.setModel(new DefaultComboBoxModel<AdbServerMdnsBackend>(AdbServerMdnsBackend.values()));
        this.myPanel.add((Component)this.myAdbServerMdnsBackend, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(83, 38), null, 0, false));
        HyperlinkLabel adbServerBurstModeLabel = new HyperlinkLabel();
        adbServerBurstModeLabel.setHyperlinkText("ADB server Burst Mode (", "Support list", ")");
        adbServerBurstModeLabel.setHyperlinkTarget("https://developer.android.com/tools/adb#burstMode");
        adbServerBurstModeLabel.setIcon(null);
        this.myPanel.add((Component)adbServerBurstModeLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(4, 38), null, 0, false));
        this.myAdbServerBurstMode.setModel(new DefaultComboBoxModel<AdbServerBurstMode>(AdbServerBurstMode.values()));
        this.myPanel.add((Component)this.myAdbServerBurstMode, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(83, 38), null, 0, false));
        if (((Boolean)StudioFlags.ADB_HOST_LOGS_ENABLED.get()).booleanValue()) {
            JBLabel adbServerLogLevelLabel = new JBLabel("ADB server Log Level:");
            this.myPanel.add((Component)adbServerLogLevelLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(4, 38), null, 0, false));
            this.myPanel.add((Component)this.myAdbServerLogLevel, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(83, 38), null, 0, false));
        } else {
            this.myEnableADBServerLogs.setText("Enable ADB server logs");
            this.myPanel.add((Component)this.myEnableADBServerLogs, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(4, 38), null, 0, false));
        }
        JPanel lifeCyclePanel = new JPanel();
        lifeCyclePanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Adb Server Lifecycle Management", (int)0, (int)0, null, null));
        this.myPanel.add((Component)lifeCyclePanel, new GridConstraints(4, 0, 1, 4, 0, 3, 3, 3, null, null, null, 0, false));
        lifeCyclePanel.setLayout((LayoutManager)new GridLayoutManager(4, 5, (Insets)JBUI.emptyInsets(), -1, -1));
        this.myAutomaticallyStartAndManageServerRadioButton.setText("Automatically start and manage server");
        lifeCyclePanel.add((Component)this.myAutomaticallyStartAndManageServerRadioButton, new GridConstraints(0, 0, 1, 5, 8, 0, 3, 0, null, null, null, 0, false));
        this.myUseExistingManuallyManagedServerRadioButton.setEnabled(true);
        this.myUseExistingManuallyManagedServerRadioButton.setText("Use existing manually managed server");
        lifeCyclePanel.add((Component)this.myUseExistingManuallyManagedServerRadioButton, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 0, null, null, null, 0, false));
        this.myExistingAdbServerPortLabel.setText("Existing ADB server port:");
        lifeCyclePanel.add((Component)this.myExistingAdbServerPortLabel, new GridConstraints(2, 0, 1, 1, 0, 0, 0, 0, null, null, null, 2, false));
        this.myExistingAdbServerPortSpinner.setMax(65535);
        this.myExistingAdbServerPortSpinner.setMin(5037);
        this.myExistingAdbServerPortSpinner.setNumber(5038);
        this.myExistingAdbServerPortSpinner.setOpaque(false);
        lifeCyclePanel.add((Component)this.myExistingAdbServerPortSpinner, new GridConstraints(3, 1, 1, 1, 8, 1, 4, 0, null, null, null, 0, false));
    }

    void setAdbServerLogsEnabled(boolean enabled) {
        this.myEnableADBServerLogs.setSelected(enabled);
    }

    boolean getAdbServerLogsEnabled() {
        return this.myEnableADBServerLogs.isSelected();
    }
}

