/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb.wireless;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.adtui.ui.SVGScaledImageProvider;
import com.android.tools.adtui.ui.ScaledImageProvider;
import com.android.tools.adtui.ui.ScalingImagePanel;
import com.android.tools.idea.adb.wireless.AdbOnlineDevice;
import com.android.tools.idea.adb.wireless.QrCodeImage;
import com.android.tools.idea.adb.wireless.TrackingMdnsService;
import com.android.tools.idea.adb.wireless.UIColors;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.AsyncProcessIcon;
import icons.StudioIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
public class QrCodeTabPanel {
    @NotNull
    private final Logger LOG = Logger.getInstance(QrCodeTabPanel.class);
    @NotNull
    private JBLabel myTopLabel1;
    @NotNull
    private JBLabel myTopLabel2;
    @NotNull
    private JBLabel myFirstLineLabel;
    @NotNull
    private JBLabel mySecondLineLabel;
    @NotNull
    private ScalingImagePanel myQrCodePanel;
    @NotNull
    private JPanel myRootComponent;
    @NotNull
    private JPanel myPairingStatusPanel;
    @NotNull
    private JPanel myPairingStatusIconPanel;
    @NotNull
    private JBLabel myPairingStatusIconLabel;
    @NotNull
    private AsyncProcessIcon myPairingStatusProcessIcon;
    @NotNull
    private JBLabel myPairingStatusLabel;
    @NotNull
    private JPanel myScanNewDevicePanel;
    @NotNull
    private LinkLabel<Void> myScanNewDeviceLink;
    @Nullable
    private final TrackingMdnsService mdnsServiceUnderPairing;

    public QrCodeTabPanel(@NotNull Runnable scanAnotherDeviceRunnable, @NotNull Disposable parentDisposable, @Nullable TrackingMdnsService mdnsServiceUnderPairing) {
        this.mdnsServiceUnderPairing = mdnsServiceUnderPairing;
        this.setupUI();
        this.myRootComponent.setBackground(UIColors.PAIRING_CONTENT_BACKGROUND);
        this.myQrCodePanel.setBackground(UIColors.PAIRING_CONTENT_BACKGROUND);
        this.myPairingStatusPanel.setBackground(UIColors.PAIRING_CONTENT_BACKGROUND);
        this.myPairingStatusIconPanel.setBackground(UIColors.PAIRING_CONTENT_BACKGROUND);
        this.myPairingStatusIconLabel.setBackground(UIColors.PAIRING_CONTENT_BACKGROUND);
        this.myPairingStatusProcessIcon.setBackground(UIColors.PAIRING_CONTENT_BACKGROUND);
        this.myScanNewDevicePanel.setBackground(UIColors.PAIRING_CONTENT_BACKGROUND);
        this.myScanNewDeviceLink.setBackground(UIColors.PAIRING_CONTENT_BACKGROUND);
        this.myPairingStatusLabel.setForeground(UIColors.PAIRING_STATUS_LABEL);
        this.myScanNewDeviceLink.setForeground(UIColors.PAIRING_STATUS_LABEL);
        this.myFirstLineLabel.setForeground(UIColors.PAIRING_HINT_LABEL);
        this.mySecondLineLabel.setForeground(UIColors.PAIRING_HINT_LABEL);
        this.myScanNewDeviceLink.setListener((aSource, aLinkData) -> scanAnotherDeviceRunnable.run(), null);
        this.myScanNewDeviceLink.setIcon(null);
        Disposer.register((Disposable)parentDisposable, (Disposable)this.myPairingStatusProcessIcon);
        Disposer.register((Disposable)parentDisposable, (Disposable)this.myQrCodePanel);
    }

    private void createUIComponents() {
        this.myPairingStatusProcessIcon = new AsyncProcessIcon("pairing code pairing progress");
    }

    @NotNull
    public JPanel getComponent() {
        return this.myRootComponent;
    }

    public void setQrCode(@NotNull QrCodeImage image) {
        this.LOG.info("New QR Code generated: " + image.getPairingString());
        this.myQrCodePanel.setScaledImageProvider(null);
        this.myQrCodePanel.setImage((Image)image.getImage());
    }

    public void showQrCodePairingStarted() {
        this.myQrCodePanel.setActive(true);
        this.myTopLabel1.setVisible(true);
        this.myTopLabel2.setVisible(true);
        this.setBold(this.myPairingStatusLabel, false);
        this.myPairingStatusLabel.setText(" ");
        this.myPairingStatusIconLabel.setVisible(false);
        this.myPairingStatusProcessIcon.setVisible(false);
        this.myScanNewDeviceLink.setVisible(false);
    }

    public void showQrCodePairingInProgress() {
        this.myQrCodePanel.setActive(false);
        this.setBold(this.myPairingStatusLabel, true);
        this.myPairingStatusLabel.setText("Connecting to device. This takes up to 2 minutes.");
        this.myPairingStatusIconLabel.setVisible(false);
        this.myPairingStatusProcessIcon.setVisible(true);
        this.myScanNewDeviceLink.setVisible(false);
    }

    public void showQrCodePairingWaitForDevice() {
        this.showQrCodePairingInProgress();
    }

    public void showQrCodePairingSuccess(@NotNull AdbOnlineDevice device2) {
        this.myQrCodePanel.setScaledImageProvider((ScaledImageProvider)SVGScaledImageProvider.create((Icon)StudioIcons.Common.SUCCESS));
        this.myQrCodePanel.setActive(true);
        this.myTopLabel1.setVisible(false);
        this.myTopLabel2.setVisible(false);
        this.myPairingStatusIconLabel.setVisible(false);
        this.myPairingStatusProcessIcon.setVisible(false);
        this.setBold(this.myPairingStatusLabel, true);
        this.myPairingStatusLabel.setText(device2.getDisplayString() + " connected");
        if (this.mdnsServiceUnderPairing == null) {
            this.myScanNewDeviceLink.setVisible(true);
        }
    }

    public void showQrCodePairingError() {
        this.myQrCodePanel.setActive(false);
        this.myTopLabel1.setVisible(false);
        this.myTopLabel2.setVisible(false);
        this.myPairingStatusIconLabel.setVisible(true);
        this.myPairingStatusIconLabel.setIcon(StudioIcons.Common.ERROR);
        this.myPairingStatusProcessIcon.setVisible(false);
        this.setBold(this.myPairingStatusLabel, false);
        this.myPairingStatusLabel.setText("An error occurred connecting device. Scan to try again.");
        this.myScanNewDeviceLink.setVisible(true);
    }

    public void setBold(JBLabel label2, boolean isBold) {
        if (isBold) {
            label2.setFont(label2.getFont().deriveFont(1));
        } else {
            label2.setFont(label2.getFont().deriveFont(0));
        }
    }

    private void setupUI() {
        this.createUIComponents();
        this.myRootComponent = new JPanel();
        this.myRootComponent.setLayout((LayoutManager)new GridLayoutManager(14, 3, new Insets(0, 0, 0, 0), -1, -1));
        Spacer spacer1 = new Spacer();
        this.myRootComponent.add((Component)spacer1, new GridConstraints(0, 1, 1, 1, 0, 2, 1, 0, new Dimension(5, 15), null, null, 0, false));
        this.myTopLabel1 = new JBLabel();
        if (this.mdnsServiceUnderPairing == null) {
            this.myTopLabel1.setText("<html>To pair an <b>Android 11+</b> device<html>");
        }
        this.myRootComponent.add((Component)this.myTopLabel1, new GridConstraints(1, 1, 1, 1, 0, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer2 = new Spacer();
        this.myRootComponent.add((Component)spacer2, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 0, new Dimension(5, 4), null, null, 0, false));
        this.myTopLabel2 = new JBLabel();
        Object topLabel2Text = "scan the QR code from your device";
        if (this.mdnsServiceUnderPairing != null) {
            topLabel2Text = "Scan the QR code from your " + this.mdnsServiceUnderPairing.getDisplayString();
        }
        this.myTopLabel2.setText((String)topLabel2Text);
        this.myRootComponent.add((Component)this.myTopLabel2, new GridConstraints(3, 1, 1, 1, 0, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer3 = new Spacer();
        this.myRootComponent.add((Component)spacer3, new GridConstraints(4, 1, 1, 1, 0, 2, 1, 2, new Dimension(5, 20), null, null, 0, false));
        Spacer spacer4 = new Spacer();
        this.myRootComponent.add((Component)spacer4, new GridConstraints(5, 0, 1, 1, 0, 1, 2, 1, new Dimension(5, 5), null, null, 0, false));
        this.myQrCodePanel = new ScalingImagePanel();
        this.myRootComponent.add((Component)this.myQrCodePanel, new GridConstraints(5, 1, 1, 1, 0, 3, 5, 5, new Dimension(100, 100), null, null, 0, false));
        Spacer spacer5 = new Spacer();
        this.myRootComponent.add((Component)spacer5, new GridConstraints(5, 2, 1, 1, 0, 1, 2, 1, new Dimension(5, 5), null, null, 0, false));
        Spacer spacer6 = new Spacer();
        this.myRootComponent.add((Component)spacer6, new GridConstraints(6, 1, 1, 1, 0, 2, 1, 2, new Dimension(5, 20), null, null, 0, false));
        this.myPairingStatusPanel = new JPanel();
        this.myPairingStatusPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.myRootComponent.add((Component)this.myPairingStatusPanel, new GridConstraints(7, 0, 1, 3, 0, 1, 3, 0, null, null, null, 0, false));
        this.myPairingStatusIconPanel = new JPanel();
        this.myPairingStatusIconPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.myPairingStatusPanel.add((Component)this.myPairingStatusIconPanel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        this.myPairingStatusIconLabel = new JBLabel();
        this.myPairingStatusIconPanel.add((Component)this.myPairingStatusIconLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null, 0, false));
        this.myPairingStatusIconPanel.add((Component)this.myPairingStatusProcessIcon, new GridConstraints(0, 1, 1, 1, 4, 0, 0, 3, null, null, null, 0, false));
        Spacer spacer7 = new Spacer();
        this.myPairingStatusIconPanel.add((Component)spacer7, new GridConstraints(0, 2, 1, 1, 0, 1, 0, 1, null, new Dimension(2, 0), null, 0, false));
        this.myPairingStatusLabel = new JBLabel();
        this.myPairingStatusLabel.setText("(some text)");
        this.myPairingStatusPanel.add((Component)this.myPairingStatusLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myScanNewDevicePanel = new JPanel();
        this.myScanNewDevicePanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.myRootComponent.add((Component)this.myScanNewDevicePanel, new GridConstraints(8, 0, 1, 3, 1, 1, 3, 2, null, null, null, 0, false));
        this.myScanNewDevicePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0), null, 0, 0, null, null));
        this.myScanNewDeviceLink = new LinkLabel();
        if (this.mdnsServiceUnderPairing == null) {
            this.myScanNewDeviceLink.setText("Scan new device");
        } else {
            this.myScanNewDeviceLink.setText("Try again");
        }
        this.myScanNewDevicePanel.add((Component)this.myScanNewDeviceLink, new GridConstraints(0, 0, 1, 1, 0, 0, 1, 0, null, null, null, 0, false));
        Spacer spacer8 = new Spacer();
        this.myRootComponent.add((Component)spacer8, new GridConstraints(9, 1, 1, 1, 0, 2, 1, 0, new Dimension(0, 30), null, null, 0, false));
        this.myFirstLineLabel = new JBLabel();
        Font myFirstLineLabelFont = this.getFont(null, 1, -1, this.myFirstLineLabel.getFont());
        if (myFirstLineLabelFont != null) {
            this.myFirstLineLabel.setFont(myFirstLineLabelFont);
        }
        this.myFirstLineLabel.setText("QR scanner available at:");
        this.myRootComponent.add((Component)this.myFirstLineLabel, new GridConstraints(10, 0, 1, 3, 0, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer9 = new Spacer();
        this.myRootComponent.add((Component)spacer9, new GridConstraints(11, 1, 1, 1, 0, 2, 1, 0, new Dimension(0, 4), null, null, 0, false));
        this.mySecondLineLabel = new JBLabel();
        this.mySecondLineLabel.setText("Developer options > Wireless debugging > Pair using QR code");
        this.myRootComponent.add((Component)this.mySecondLineLabel, new GridConstraints(12, 0, 1, 3, 0, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer10 = new Spacer();
        this.myRootComponent.add((Component)spacer10, new GridConstraints(13, 1, 1, 1, 0, 2, 1, 0, new Dimension(5, 20), null, null, 0, false));
    }

    private Font getFont(String fontName, int style, int size, Font currentFont) {
        Font testFont;
        if (currentFont == null) {
            return null;
        }
        String resultName = fontName == null ? currentFont.getName() : ((testFont = new Font(fontName, 0, 10)).canDisplay('a') && testFont.canDisplay('1') ? fontName : currentFont.getName());
        Font font = new Font(resultName, style >= 0 ? style : currentFont.getStyle(), size >= 0 ? size : currentFont.getSize());
        boolean isMac = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font fontWithFallback = isMac ? new Font(font.getFamily(), font.getStyle(), font.getSize()) : new StyleContext().getFont(font.getFamily(), font.getStyle(), font.getSize());
        return fontWithFallback instanceof FontUIResource ? fontWithFallback : new FontUIResource(fontWithFallback);
    }
}

