/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb.wireless;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.adb.wireless.WifiPairingUsageTrackerKt;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.ApiVersion;
import com.google.wireless.android.sdk.stats.WifiPairingEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\rJ&\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/adb/wireless/WifiPairingUsageTracker;", "", "<init>", "()V", "trackSuccess", "", "adbVersion", "", "pairingMethod", "Lcom/google/wireless/android/sdk/stats/WifiPairingEvent$PairingMethod;", "deviceApi", "deviceCodeName", "elapsedTimeMs", "", "trackFailure", "exception", "", "logEvent", "event", "Lcom/google/wireless/android/sdk/stats/WifiPairingEvent$Builder;", "intellij.android.adb"})
@StabilityInferred(parameters=1)
public final class WifiPairingUsageTracker {
    @NotNull
    public static final WifiPairingUsageTracker INSTANCE = new WifiPairingUsageTracker();
    public static final int $stable;

    private WifiPairingUsageTracker() {
    }

    public final void trackSuccess(@NotNull String adbVersion, @NotNull WifiPairingEvent.PairingMethod pairingMethod, @Nullable String deviceApi, @Nullable String deviceCodeName, long elapsedTimeMs) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)adbVersion, (String)"adbVersion");
        Intrinsics.checkNotNullParameter((Object)pairingMethod, (String)"pairingMethod");
        WifiPairingEvent.Builder builder = WifiPairingEvent.newBuilder().setAdbVersion(adbVersion).setPairingMethod(pairingMethod);
        ApiVersion.Builder builder2 = ApiVersion.newBuilder().setApiLevel((object = deviceApi) != null && (object = StringsKt.toLongOrNull((String)object)) != null ? (Long)object : -1L);
        String string = deviceCodeName;
        if (string == null) {
            string = "Unknown";
        }
        WifiPairingEvent.Builder builder3 = builder.setDeviceApiVersion(builder2.setCodename(string)).setPairingResult(WifiPairingEvent.PairingResult.SUCCESS).setElapsedTimeMs(elapsedTimeMs);
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"setElapsedTimeMs(...)");
        this.logEvent(builder3);
    }

    public final void trackFailure(@NotNull String adbVersion, @NotNull WifiPairingEvent.PairingMethod pairingMethod, @NotNull Throwable exception, long elapsedTimeMs) {
        Intrinsics.checkNotNullParameter((Object)adbVersion, (String)"adbVersion");
        Intrinsics.checkNotNullParameter((Object)pairingMethod, (String)"pairingMethod");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        WifiPairingEvent.Builder builder = WifiPairingEvent.newBuilder().setAdbVersion(adbVersion).setPairingMethod(pairingMethod).setPairingResult(WifiPairingEvent.PairingResult.FAILURE).addAllExceptionClassNames((Iterable)WifiPairingUsageTrackerKt.access$getClassNames(exception)).setElapsedTimeMs(elapsedTimeMs);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setElapsedTimeMs(...)");
        this.logEvent(builder);
    }

    private final void logEvent(WifiPairingEvent.Builder event) {
        AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.WIFI_PAIRING_EVENT).setWifiPairingEvent(event);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setWifiPairingEvent(...)");
        UsageTracker.log((AndroidStudioEvent.Builder)builder);
    }
}

