/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer.dex;

import com.android.tools.apk.analyzer.dex.KeepRuleBuilder;
import com.android.tools.apk.analyzer.dex.tree.DexClassNode;
import com.android.tools.apk.analyzer.dex.tree.DexElementNode;
import com.android.tools.apk.analyzer.dex.tree.DexFieldNode;
import com.android.tools.apk.analyzer.dex.tree.DexMethodNode;
import com.android.tools.apk.analyzer.dex.tree.DexPackageNode;
import com.android.tools.idea.lang.proguardR8.ProguardR8FileType;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.treeStructure.Tree;
import javax.swing.JComponent;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateProguardKeepRuleAction
extends AnAction {
    @NotNull
    private final Tree myTree;

    public GenerateProguardKeepRuleAction(@NotNull Tree tree) {
        super("Generate Proguard keep rule", "Generates Proguard keep rule", AllIcons.Actions.Download);
        this.myTree = tree;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @NotNull
    @VisibleForTesting
    static String getKeepRule(@NotNull DexElementNode node) {
        StringBuilder keepRule = new StringBuilder();
        keepRule.append("# Add *one* of the following rules to your Proguard configuration file.\n# Alternatively, you can annotate classes and class members with @androidx.annotation.Keep\n\n");
        if (node instanceof DexPackageNode) {
            KeepRuleBuilder ruleBuilder = new KeepRuleBuilder();
            ruleBuilder.setPackage(((DexPackageNode)node).getPackageName());
            keepRule.append("# keep everything in this package from being removed or renamed\n");
            keepRule.append(ruleBuilder.build(KeepRuleBuilder.KeepType.KEEP));
            keepRule.append("\n\n");
            keepRule.append("# keep everything in this package from being renamed only\n");
            keepRule.append(ruleBuilder.build(KeepRuleBuilder.KeepType.KEEPNAMES));
        } else if (node instanceof DexMethodNode || node instanceof DexFieldNode) {
            DexClassNode classNode = (DexClassNode)node.getParent();
            DexPackageNode packageNode = (DexPackageNode)classNode.getParent();
            KeepRuleBuilder ruleBuilder = new KeepRuleBuilder();
            ruleBuilder.setPackage(packageNode.getPackageName() == null ? "" : packageNode.getPackageName()).setClass(classNode.getName()).setMember(node.getName());
            keepRule.append("# keep the class and specified members from being removed or renamed\n");
            keepRule.append(ruleBuilder.build(KeepRuleBuilder.KeepType.KEEP));
            keepRule.append("\n\n");
            keepRule.append("# keep the specified class members from being removed or renamed \n# only if the class is preserved\n");
            keepRule.append(ruleBuilder.build(KeepRuleBuilder.KeepType.KEEPCLASSMEMBERS));
            keepRule.append("\n\n");
            keepRule.append("# keep the class and specified members from being renamed only\n");
            keepRule.append(ruleBuilder.build(KeepRuleBuilder.KeepType.KEEPNAMES));
            keepRule.append("\n\n");
            keepRule.append("# keep the specified class members from being renamed only\n");
            keepRule.append(ruleBuilder.build(KeepRuleBuilder.KeepType.KEEPCLASSMEMBERNAMES));
            keepRule.append("\n\n");
        } else if (node instanceof DexClassNode) {
            DexPackageNode packageNode = (DexPackageNode)node.getParent();
            KeepRuleBuilder ruleBuilder = new KeepRuleBuilder();
            ruleBuilder.setPackage(packageNode.getPackageName() == null ? "" : packageNode.getPackageName()).setClass(node.getName());
            keepRule.append("# keep the class and specified members from being removed or renamed\n");
            keepRule.append(ruleBuilder.build(KeepRuleBuilder.KeepType.KEEP));
            keepRule.append("\n\n");
            keepRule.append("# keep the specified class members from being removed or renamed \n# only if the class is preserved\n");
            keepRule.append(ruleBuilder.build(KeepRuleBuilder.KeepType.KEEPCLASSMEMBERS));
            keepRule.append("\n\n");
            keepRule.append("# keep the class and specified members from being renamed only\n");
            keepRule.append(ruleBuilder.build(KeepRuleBuilder.KeepType.KEEPNAMES));
            keepRule.append("\n\n");
            keepRule.append("# keep the specified class members from being renamed only\n");
            keepRule.append(ruleBuilder.build(KeepRuleBuilder.KeepType.KEEPCLASSMEMBERNAMES));
            keepRule.append("\n\n");
        }
        return keepRule.toString();
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        DexElementNode node = this.getSelectedNode();
        if (!GenerateProguardKeepRuleAction.canGenerateRule(node)) {
            presentation.setEnabled(false);
            return;
        }
        presentation.setEnabled(true);
    }

    @VisibleForTesting
    static boolean canGenerateRule(DexElementNode node) {
        if (!(node instanceof DexPackageNode || node instanceof DexClassNode || node instanceof DexMethodNode || node instanceof DexFieldNode)) {
            return false;
        }
        return !(node instanceof DexPackageNode) || ((DexPackageNode)node).getPackageName() != null;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DexElementNode node = this.getSelectedNode();
        assert (node != null);
        Project project = GenerateProguardKeepRuleAction.getEventProject((AnActionEvent)e);
        String keepRule = GenerateProguardKeepRuleAction.getKeepRule(node);
        EditorFactory factory2 = EditorFactory.getInstance();
        Document doc = ((EditorFactoryImpl)factory2).createDocument((CharSequence)keepRule, true, false);
        doc.setReadOnly(true);
        Editor editor = factory2.createEditor(doc, project);
        EditorHighlighterFactory editorHighlighterFactory = EditorHighlighterFactory.getInstance();
        SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)ProguardR8FileType.INSTANCE, (Project)project, null);
        ((EditorEx)editor).setHighlighter(editorHighlighterFactory.createEditorHighlighter(syntaxHighlighter, EditorColorsManager.getInstance().getGlobalScheme()));
        ((EditorEx)editor).setCaretVisible(true);
        EditorSettings settings = editor.getSettings();
        settings.setLineMarkerAreaShown(false);
        settings.setIndentGuidesShown(false);
        settings.setLineNumbersShown(false);
        settings.setFoldingOutlineShown(false);
        editor.setBorder(null);
        JComponent editorComponent = editor.getComponent();
        JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder(editorComponent, null).setProject(project).setDimensionServiceKey(project, GenerateProguardKeepRuleAction.class.getName(), false).setResizable(true).setMovable(true).setTitle("Proguard keep rules for " + node.getName()).setFocusable(true).setRequestFocus(true).createPopup();
        Disposer.register((Disposable)popup, () -> EditorFactory.getInstance().releaseEditor(editor));
        popup.showInBestPositionFor(e.getDataContext());
    }

    @Nullable
    private DexElementNode getSelectedNode() {
        TreePath path = this.myTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        Object component = path.getLastPathComponent();
        return component instanceof DexElementNode ? (DexElementNode)component : null;
    }
}

