/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer.diff;

import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.adtui.util.HumanReadableUtil;
import com.android.tools.apk.analyzer.ArchiveContext;
import com.android.tools.apk.analyzer.Archives;
import com.android.tools.apk.analyzer.internal.ApkDiffEntry;
import com.android.tools.apk.analyzer.internal.ApkDiffParser;
import com.android.tools.apk.analyzer.internal.ApkEntry;
import com.android.tools.idea.apk.viewer.ApkViewPanel;
import com.android.tools.idea.apk.viewer.diff.FileByFileProgressDialog;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.nio.file.Path;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;

public class ApkDiffPanel {
    private static final ListeningExecutorService ourExecutorService = MoreExecutors.listeningDecorator((ExecutorService)PooledThreadExecutor.INSTANCE);
    private JPanel myContainer;
    private JComponent myColumnTreePane;
    private JCheckBox myCalculateFileByFileCheckBox;
    @NotNull
    private final VirtualFile myOldApk;
    @NotNull
    private final VirtualFile myNewApk;
    private Tree myTree;
    private DefaultTreeModel myTreeModel;
    private final AtomicReference<DefaultMutableTreeNode> myFbfDiffTreeNode = new AtomicReference<Object>(null);
    private static final int TEXT_RENDERER_HORIZ_PADDING = 6;
    private static final int TEXT_RENDERER_VERT_PADDING = 4;

    public ApkDiffPanel(@NotNull VirtualFile oldApk, @NotNull VirtualFile newApk) {
        this.myOldApk = oldApk;
        this.myNewApk = newApk;
        this.setupUI();
        this.myCalculateFileByFileCheckBox.addItemListener(e -> {
            this.addOrReplaceColumnTree();
            if (this.myCalculateFileByFileCheckBox.isSelected()) {
                this.myCalculateFileByFileCheckBox.setEnabled(false);
                this.constructFbfTree();
            } else {
                this.constructDiffTree();
            }
        });
        this.constructDiffTree();
    }

    private void constructFbfTree() {
        DefaultMutableTreeNode node = this.myFbfDiffTreeNode.get();
        if (node != null) {
            this.setRootNode(node);
            this.myCalculateFileByFileCheckBox.setEnabled(true);
            return;
        }
        FileByFileProgressDialog dialog2 = new FileByFileProgressDialog();
        ListenableFuture future2 = ourExecutorService.submit(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
        Futures.addCallback((ListenableFuture)future2, (FutureCallback)new FutureCallback<DefaultMutableTreeNode>(){

            public void onSuccess(DefaultMutableTreeNode result2) {
                ApkDiffPanel.this.myFbfDiffTreeNode.set(result2);
                ApkDiffPanel.this.setRootNode(result2);
                ApkDiffPanel.this.myCalculateFileByFileCheckBox.setEnabled(true);
            }

            public void onFailure(@NotNull Throwable t) {
                ApkDiffPanel.this.myCalculateFileByFileCheckBox.setEnabled(true);
                ApkDiffPanel.this.myCalculateFileByFileCheckBox.setSelected(false);
            }
        }, (Executor)EdtExecutorService.getInstance());
        dialog2.showDialog(() -> future2.cancel(true));
    }

    private void constructDiffTree() {
        ListenableFuture treeStructureFuture = ourExecutorService.submit(() -> {
            try (ArchiveContext archiveContext1 = Archives.open((Path)VfsUtilCore.virtualToIoFile((VirtualFile)this.myOldApk).toPath());){
                DefaultMutableTreeNode defaultMutableTreeNode;
                block12: {
                    ArchiveContext archiveContext2 = Archives.open((Path)VfsUtilCore.virtualToIoFile((VirtualFile)this.myNewApk).toPath());
                    try {
                        defaultMutableTreeNode = ApkDiffParser.createTreeNode((ArchiveContext)archiveContext1, (ArchiveContext)archiveContext2);
                        if (archiveContext2 == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (archiveContext2 != null) {
                            try {
                                archiveContext2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    archiveContext2.close();
                }
                return defaultMutableTreeNode;
            }
        });
        ApkViewPanel.FutureCallBackAdapter<DefaultMutableTreeNode> setRootNode = new ApkViewPanel.FutureCallBackAdapter<DefaultMutableTreeNode>(){

            @Override
            public void onSuccess(DefaultMutableTreeNode result2) {
                ApkDiffPanel.this.setRootNode(result2);
                ApkDiffPanel.this.myCalculateFileByFileCheckBox.setEnabled(true);
            }
        };
        Futures.addCallback((ListenableFuture)treeStructureFuture, (FutureCallback)setRootNode, (Executor)EdtExecutorService.getInstance());
    }

    @NotNull
    public JComponent getContainer() {
        return this.myContainer;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    private JComponent createColumnTree() {
        ColumnTreeBuilder builder = new ColumnTreeBuilder((JTree)this.myTree).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("File").setPreferredWidth(600).setHeaderAlignment(10).setHeaderBorder((Border)JBUI.Borders.empty((int)4, (int)6)).setRenderer((ColoredTreeCellRenderer)new NameRenderer())).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Old Size").setPreferredWidth(150).setHeaderAlignment(11).setHeaderBorder((Border)JBUI.Borders.empty((int)4, (int)6)).setRenderer((ColoredTreeCellRenderer)new SizeRenderer((com.intellij.util.Function<ApkEntry, Long>)((com.intellij.util.Function)ApkDiffEntry::getOldSize)))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("New Size").setPreferredWidth(150).setHeaderAlignment(11).setHeaderBorder((Border)JBUI.Borders.empty((int)4, (int)6)).setRenderer((ColoredTreeCellRenderer)new SizeRenderer((com.intellij.util.Function<ApkEntry, Long>)((com.intellij.util.Function)ApkDiffEntry::getNewSize)))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName(this.myCalculateFileByFileCheckBox.isSelected() ? "Patch Size" : "Diff Size").setPreferredWidth(150).setHeaderAlignment(11).setHeaderBorder((Border)JBUI.Borders.empty((int)4, (int)6)).setRenderer((ColoredTreeCellRenderer)new SizeRenderer((com.intellij.util.Function<ApkEntry, Long>)((com.intellij.util.Function)ApkEntry::getSize))));
        return builder.build();
    }

    private void setRootNode(@NotNull DefaultMutableTreeNode root) {
        this.myTreeModel = new DefaultTreeModel(root);
        ApkEntry entry = ApkEntry.fromNode((Object)root);
        assert (entry != null);
        this.myTree.setPaintBusy(false);
        this.myTree.setRootVisible(true);
        this.myTree.expandPath(new TreePath(root));
        this.myTree.setModel((TreeModel)this.myTreeModel);
    }

    private void setupUI() {
        this.myCalculateFileByFileCheckBox = new JCheckBox();
        this.myCalculateFileByFileCheckBox.setEnabled(false);
        this.myCalculateFileByFileCheckBox.setText("Show File-By-File patch size (may take a long time)");
        this.myCalculateFileByFileCheckBox.setToolTipText("This is a size estimation for the update that Play store sends to the device");
        this.myTreeModel = new DefaultTreeModel((TreeNode)new LoadingNode());
        this.myTree = new Tree((TreeModel)this.myTreeModel);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setRootVisible(true);
        this.myTree.setPaintBusy(true);
        Convertor convertor = path -> {
            ApkEntry e = ApkEntry.fromNode((Object)path.getLastPathComponent());
            if (e == null) {
                return null;
            }
            return e.getPath().toString();
        };
        TreeSpeedSearch.installOn((JTree)this.myTree, (boolean)true, (Function)convertor);
        this.myContainer = new JPanel();
        this.myContainer.setLayout((LayoutManager)new GridLayoutManager(2, 1, (Insets)JBUI.emptyInsets(), -1, -1));
        this.addOrReplaceColumnTree();
        this.myContainer.add((Component)this.myCalculateFileByFileCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
    }

    public JComponent getRootComponent() {
        return this.myContainer;
    }

    private void addOrReplaceColumnTree() {
        if (this.myColumnTreePane != null) {
            this.myContainer.remove(this.myColumnTreePane);
        }
        this.myColumnTreePane = this.createColumnTree();
        this.myContainer.add((Component)this.myColumnTreePane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 5, new Dimension(400, -1), new Dimension(400, 300), null, 0, false));
    }

    static class NameRenderer
    extends ColoredTreeCellRenderer {
        NameRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            ApkEntry entry = ApkEntry.fromNode((Object)value2);
            ApkEntry root = ApkEntry.fromNode((Object)tree.getModel().getRoot());
            if (entry == null || root == null) {
                return;
            }
            this.append(entry.getName());
        }
    }

    public static class SizeRenderer
    extends ColoredTreeCellRenderer {
        private final com.intellij.util.Function<ApkEntry, Long> mySizeMapper;

        public SizeRenderer(com.intellij.util.Function<ApkEntry, Long> sizeMapper) {
            this.mySizeMapper = sizeMapper;
            this.setTextAlign(4);
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            ApkEntry entry = ApkEntry.fromNode((Object)value2);
            ApkEntry root = ApkEntry.fromNode((Object)tree.getModel().getRoot());
            if (entry == null || root == null) {
                return;
            }
            this.append(HumanReadableUtil.getHumanizedSize((long)((Long)this.mySizeMapper.fun((Object)entry))));
        }
    }
}

