/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.inspectors.network.model;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.idea.appinspection.inspectors.network.model.NetworkInspectorDataSeries;
import com.android.tools.idea.appinspection.inspectors.network.model.NetworkInspectorDataSource;
import com.android.tools.idea.appinspection.inspectors.network.model.NetworkTrafficLabel;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import studio.network.inspection.NetworkInspectorProtocol;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0006\u0010\u0019\u001a\u00020\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkSpeedLineChartModel;", "Lcom/android/tools/adtui/model/LineChartModel;", "timeline", "Lcom/android/tools/adtui/model/Timeline;", "dataSource", "Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorDataSource;", "backgroundExecutor", "Ljava/util/concurrent/Executor;", "<init>", "(Lcom/android/tools/adtui/model/Timeline;Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorDataSource;Ljava/util/concurrent/Executor;)V", "trafficRange", "Lcom/android/tools/adtui/model/Range;", "getTrafficRange", "()Lcom/android/tools/adtui/model/Range;", "rxSeries", "Lcom/android/tools/adtui/model/RangedContinuousSeries;", "getRxSeries", "()Lcom/android/tools/adtui/model/RangedContinuousSeries;", "txSeries", "getTxSeries", "createSeries", "Lcom/android/tools/adtui/model/DataSeries;", "", "trafficType", "Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkTrafficLabel;", "invalidate", "", "app-inspection.inspectors.network.model"})
public final class NetworkSpeedLineChartModel
extends LineChartModel {
    @NotNull
    private final NetworkInspectorDataSource dataSource;
    @NotNull
    private final Range trafficRange;
    @NotNull
    private final RangedContinuousSeries rxSeries;
    @NotNull
    private final RangedContinuousSeries txSeries;

    public NetworkSpeedLineChartModel(@NotNull Timeline timeline, @NotNull NetworkInspectorDataSource dataSource, @NotNull Executor backgroundExecutor) {
        Intrinsics.checkNotNullParameter((Object)timeline, (String)"timeline");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)backgroundExecutor, (String)"backgroundExecutor");
        super(backgroundExecutor);
        this.dataSource = dataSource;
        this.trafficRange = new Range(0.0, 4.0);
        String string = NetworkTrafficLabel.BYTES_RECEIVED.getLabel(false);
        Range range = timeline.getViewRange();
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getViewRange(...)");
        DataSeries<Long> dataSeries = this.createSeries(NetworkTrafficLabel.BYTES_RECEIVED);
        Range range2 = timeline.getDataRange();
        Intrinsics.checkNotNullExpressionValue((Object)range2, (String)"getDataRange(...)");
        this.rxSeries = new RangedContinuousSeries(string, range, this.trafficRange, dataSeries, range2);
        String string2 = NetworkTrafficLabel.BYTES_SENT.getLabel(false);
        Range range3 = timeline.getViewRange();
        Intrinsics.checkNotNullExpressionValue((Object)range3, (String)"getViewRange(...)");
        DataSeries<Long> dataSeries2 = this.createSeries(NetworkTrafficLabel.BYTES_SENT);
        Range range4 = timeline.getDataRange();
        Intrinsics.checkNotNullExpressionValue((Object)range4, (String)"getDataRange(...)");
        this.txSeries = new RangedContinuousSeries(string2, range3, this.trafficRange, dataSeries2, range4);
        this.add(this.rxSeries);
        this.add(this.txSeries);
    }

    @NotNull
    public final Range getTrafficRange() {
        return this.trafficRange;
    }

    @NotNull
    public final RangedContinuousSeries getRxSeries() {
        return this.rxSeries;
    }

    @NotNull
    public final RangedContinuousSeries getTxSeries() {
        return this.txSeries;
    }

    private final DataSeries<Long> createSeries(NetworkTrafficLabel trafficType) {
        return new NetworkInspectorDataSeries(this.dataSource, arg_0 -> NetworkSpeedLineChartModel.createSeries$lambda$0(trafficType, arg_0));
    }

    public final void invalidate() {
        this.changed((Enum)LineChartModel.Aspect.LINE_CHART);
        this.rxSeries.invalidate();
        this.txSeries.invalidate();
    }

    private static final long createSeries$lambda$0(NetworkTrafficLabel $trafficType, NetworkInspectorProtocol.Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return $trafficType == NetworkTrafficLabel.BYTES_RECEIVED ? event.getSpeedEvent().getRxSpeed() : event.getSpeedEvent().getTxSpeed();
    }
}

