/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.inspectors.network.view.details;

import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.NumberFormatter;
import com.android.tools.adtui.model.legend.FixedLegend;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.idea.appinspection.inspectors.network.model.connections.ConnectionData;
import com.android.tools.idea.appinspection.inspectors.network.view.ConnectionsStateChart;
import com.android.tools.idea.appinspection.inspectors.network.view.NetworkState;
import com.android.tools.idea.appinspection.inspectors.network.view.details.DataComponentFactory;
import com.android.tools.idea.appinspection.inspectors.network.view.details.NoWrapBoldLabel;
import com.android.tools.idea.appinspection.inspectors.network.view.details.TabContent;
import com.android.tools.idea.appinspection.inspectors.network.view.details.TabUiUtilsKt;
import com.android.tools.inspectors.common.ui.dataviewer.DataViewer;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.TimeUnit;
import java.util.function.LongFunction;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0002\u0017\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u001a\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/details/OverviewTabContent;", "Lcom/android/tools/idea/appinspection/inspectors/network/view/details/TabContent;", "<init>", "()V", "layout", "Lcom/android/tools/adtui/TabularLayout;", "contentPanel", "Ljavax/swing/JPanel;", "overviewScroll", "Lcom/intellij/ui/components/JBScrollPane;", "title", "", "getTitle", "()Ljava/lang/String;", "createComponent", "Ljavax/swing/JComponent;", "populateFor", "", "data", "Lcom/android/tools/idea/appinspection/inspectors/network/model/connections/ConnectionData;", "dataComponentFactory", "Lcom/android/tools/idea/appinspection/inspectors/network/view/details/DataComponentFactory;", "updateRowSizing", "WrappedHyperlink", "Companion", "app-inspection.inspectors.network.view"})
public final class OverviewTabContent
extends TabContent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TabularLayout layout = new TabularLayout("*").setVGap(TabUiUtilsKt.getPAGE_VGAP());
    @NotNull
    private final JPanel contentPanel = new JPanel((LayoutManager)this.layout);
    @NotNull
    private final JBScrollPane overviewScroll = TabUiUtilsKt.createVerticalScrollPane(this.contentPanel);
    @NotNull
    private final String title;
    @NotNull
    private static final LongFunction<String> TIME_FORMATTER = OverviewTabContent::TIME_FORMATTER$lambda$0;
    @NotNull
    public static final String ID_REQUEST_TYPE = "REQUEST_TYPE";
    @NotNull
    public static final String ID_REQUEST_SIZE = "REQUEST_SIZE";
    @NotNull
    public static final String ID_RESPONSE_TYPE = "RESPONSE_TYPE";
    @NotNull
    public static final String ID_RESPONSE_SIZE = "RESPONSE_SIZE";
    @NotNull
    public static final String ID_URL = "URL";
    @NotNull
    public static final String ID_TIMING = "TIMING";
    @NotNull
    public static final String ID_INITIATING_THREAD = "INITIATING_THREAD";
    @NotNull
    public static final String ID_OTHER_THREADS = "OTHER_THREADS";
    @NotNull
    public static final String ID_RESPONSE_PAYLOAD_VIEWER = "RESPONSE_PAYLOAD_VIEWER";

    public OverviewTabContent() {
        this.title = "Overview";
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.title;
    }

    @Override
    @NotNull
    protected JComponent createComponent() {
        this.contentPanel.setBorder((Border)JBUI.Borders.empty((int)TabUiUtilsKt.getPAGE_VGAP(), (int)15, (int)0, (int)15));
        this.overviewScroll.getVerticalScrollBar().setUnitIncrement(TabUiUtilsKt.getSCROLL_UNIT());
        this.overviewScroll.addComponentListener((ComponentListener)new ComponentAdapter(this){
            final /* synthetic */ OverviewTabContent this$0;
            {
                this.this$0 = $receiver;
            }

            public void componentResized(ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                OverviewTabContent.access$updateRowSizing(this.this$0);
            }
        });
        return (JComponent)this.overviewScroll;
    }

    @Override
    public void populateFor(@Nullable ConnectionData data2, @NotNull DataComponentFactory dataComponentFactory) {
        DataViewer payloadViewer;
        Intrinsics.checkNotNullParameter((Object)dataComponentFactory, (String)"dataComponentFactory");
        this.contentPanel.removeAll();
        if (data2 == null) {
            return;
        }
        DataViewer dataViewer = payloadViewer = dataComponentFactory.createDataViewer(DataComponentFactory.ConnectionType.RESPONSE, false);
        JComponent responsePayloadComponent = dataViewer != null ? dataViewer.getComponent() : null;
        int row = 0;
        if (responsePayloadComponent != null) {
            responsePayloadComponent.setName(ID_RESPONSE_PAYLOAD_VIEWER);
            this.contentPanel.add((Component)responsePayloadComponent, new TabularLayout.Constraint(row++, 0, 0, 4, null));
        }
        this.contentPanel.add((Component)OverviewTabContent.Companion.createFields(data2), new TabularLayout.Constraint(row, 0, 0, 4, null));
        this.updateRowSizing();
    }

    private final void updateRowSizing() {
        TabularLayout.SizingRule sizingRule = this.contentPanel.getComponents().length > 1 ? new TabularLayout.SizingRule(TabularLayout.SizingRule.Type.FIXED, (int)((float)this.overviewScroll.getViewport().getHeight() * 0.4f)) : new TabularLayout.SizingRule(TabularLayout.SizingRule.Type.PROPORTIONAL, 1);
        this.layout.setRowSizing(0, sizingRule);
        this.layout.layoutContainer((Container)this.contentPanel);
    }

    private static final String TIME_FORMATTER$lambda$0(long time2) {
        return time2 >= 0L ? StringUtil.formatDuration((long)TimeUnit.MICROSECONDS.toMillis(time2)) : "*";
    }

    public static final /* synthetic */ void access$updateRowSizing(OverviewTabContent $this) {
        $this.updateRowSizing();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u00020\u00068\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0003R\u0016\u0010\t\u001a\u00020\u00068\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0003R\u0016\u0010\u000b\u001a\u00020\u00068\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\u0003R\u0016\u0010\r\u001a\u00020\u00068\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000e\u0010\u0003R\u0016\u0010\u000f\u001a\u00020\u00068\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0010\u0010\u0003R\u0016\u0010\u0011\u001a\u00020\u00068\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0012\u0010\u0003R\u0016\u0010\u0013\u001a\u00020\u00068\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0014\u0010\u0003R\u0016\u0010\u0015\u001a\u00020\u00068\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0016\u0010\u0003R\u0016\u0010\u0017\u001a\u00020\u00068\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0018\u0010\u0003\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/details/OverviewTabContent$Companion;", "", "<init>", "()V", "TIME_FORMATTER", "Ljava/util/function/LongFunction;", "", "ID_REQUEST_TYPE", "getID_REQUEST_TYPE$annotations", "ID_REQUEST_SIZE", "getID_REQUEST_SIZE$annotations", "ID_RESPONSE_TYPE", "getID_RESPONSE_TYPE$annotations", "ID_RESPONSE_SIZE", "getID_RESPONSE_SIZE$annotations", "ID_URL", "getID_URL$annotations", "ID_TIMING", "getID_TIMING$annotations", "ID_INITIATING_THREAD", "getID_INITIATING_THREAD$annotations", "ID_OTHER_THREADS", "getID_OTHER_THREADS$annotations", "ID_RESPONSE_PAYLOAD_VIEWER", "getID_RESPONSE_PAYLOAD_VIEWER$annotations", "createFields", "Ljavax/swing/JComponent;", "data", "Lcom/android/tools/idea/appinspection/inspectors/network/model/connections/ConnectionData;", "createTimingBar", "app-inspection.inspectors.network.view"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getID_REQUEST_TYPE$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getID_REQUEST_SIZE$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getID_RESPONSE_TYPE$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getID_RESPONSE_SIZE$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getID_URL$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getID_TIMING$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getID_INITIATING_THREAD$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getID_OTHER_THREADS$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getID_RESPONSE_PAYLOAD_VIEWER$annotations() {
        }

        private final JComponent createFields(ConnectionData data2) {
            int responseSize;
            String responseType;
            int requestSize;
            JPanel myFieldsPanel = new JPanel((LayoutManager)new TabularLayout("Fit-,40px,*").setVGap(TabUiUtilsKt.getSECTION_VGAP()));
            int row = 0;
            myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Request")), new TabularLayout.Constraint(row, 0, 0, 4, null));
            myFieldsPanel.add((Component)new JLabel(data2.getName()), new TabularLayout.Constraint(row, 2, 0, 4, null));
            myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Method")), new TabularLayout.Constraint(++row, 0, 0, 4, null));
            myFieldsPanel.add((Component)new JLabel(data2.getMethod()), new TabularLayout.Constraint(row, 2, 0, 4, null));
            myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Status")), new TabularLayout.Constraint(++row, 0, 0, 4, null));
            JLabel statusCode = new JLabel(data2.getStatus());
            myFieldsPanel.add((Component)statusCode, new TabularLayout.Constraint(row, 2, 0, 4, null));
            String requestType = data2.getRequestType();
            if (((CharSequence)requestType).length() > 0) {
                myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Request type")), new TabularLayout.Constraint(++row, 0, 0, 4, null));
                JLabel contentTypeLabel = new JLabel(requestType);
                contentTypeLabel.setName(OverviewTabContent.ID_REQUEST_TYPE);
                myFieldsPanel.add((Component)contentTypeLabel, new TabularLayout.Constraint(row, 2, 0, 4, null));
            }
            if ((requestSize = data2.getRequestPayload().size()) > 0) {
                myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Request size")), new TabularLayout.Constraint(++row, 0, 0, 4, null));
                JLabel contentLengthLabel = new JLabel(NumberFormatter.formatFileSize((long)requestSize));
                contentLengthLabel.setName(OverviewTabContent.ID_REQUEST_SIZE);
                myFieldsPanel.add((Component)contentLengthLabel, new TabularLayout.Constraint(row, 2, 0, 4, null));
            }
            if (((CharSequence)(responseType = data2.getResponseType())).length() > 0) {
                myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Response type")), new TabularLayout.Constraint(++row, 0, 0, 4, null));
                JLabel contentTypeLabel = new JLabel(responseType);
                contentTypeLabel.setName(OverviewTabContent.ID_RESPONSE_TYPE);
                myFieldsPanel.add((Component)contentTypeLabel, new TabularLayout.Constraint(row, 2, 0, 4, null));
            }
            if ((responseSize = data2.getResponsePayload().size()) > 0) {
                myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Response size")), new TabularLayout.Constraint(++row, 0, 0, 4, null));
                JLabel contentLengthLabel = new JLabel(NumberFormatter.formatFileSize((long)responseSize));
                contentLengthLabel.setName(OverviewTabContent.ID_RESPONSE_SIZE);
                myFieldsPanel.add((Component)contentLengthLabel, new TabularLayout.Constraint(row, 2, 0, 4, null));
            }
            myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Initiating thread")), new TabularLayout.Constraint(++row, 0, 0, 4, null));
            JLabel initiatingThreadLabel = new JLabel(data2.getThreads().get(0).getName());
            initiatingThreadLabel.setName(OverviewTabContent.ID_INITIATING_THREAD);
            myFieldsPanel.add((Component)initiatingThreadLabel, new TabularLayout.Constraint(row, 2, 0, 4, null));
            if (data2.getThreads().size() > 1) {
                StringBuilder otherThreadsBuilder = new StringBuilder();
                int n = data2.getThreads().size();
                for (int i = 1; i < n; ++i) {
                    if (((CharSequence)otherThreadsBuilder).length() > 0) {
                        otherThreadsBuilder.append(", ");
                    }
                    otherThreadsBuilder.append(data2.getThreads().get(i).getName());
                }
                myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Other threads")), new TabularLayout.Constraint(++row, 0, 0, 4, null));
                JLabel otherThreadsLabel = new JLabel(otherThreadsBuilder.toString());
                otherThreadsLabel.setName(OverviewTabContent.ID_OTHER_THREADS);
                myFieldsPanel.add((Component)otherThreadsLabel, new TabularLayout.Constraint(row, 2, 0, 4, null));
            }
            NoWrapBoldLabel urlLabel = new NoWrapBoldLabel(OverviewTabContent.ID_URL);
            urlLabel.setVerticalAlignment(1);
            myFieldsPanel.add((Component)((Object)urlLabel), new TabularLayout.Constraint(++row, 0, 0, 4, null));
            WrappedHyperlink hyperlink = new WrappedHyperlink(data2.getUrl());
            hyperlink.setName(OverviewTabContent.ID_URL);
            myFieldsPanel.add((Component)hyperlink, new TabularLayout.Constraint(row, 2, 0, 4, null));
            ++row;
            JSeparator separator = new JSeparator();
            separator.setMinimumSize(separator.getPreferredSize());
            int gap = TabUiUtilsKt.getPAGE_VGAP() - TabUiUtilsKt.getSECTION_VGAP() - (int)separator.getPreferredSize().getHeight() / 2;
            JPanel separatorContainer = new JPanel((LayoutManager)new VerticalFlowLayout(0, gap));
            separatorContainer.add(separator);
            myFieldsPanel.add((Component)separatorContainer, new TabularLayout.Constraint(row, 0, 1, 3));
            NoWrapBoldLabel timingLabel = new NoWrapBoldLabel("Timing");
            timingLabel.setVerticalAlignment(1);
            myFieldsPanel.add((Component)((Object)timingLabel), new TabularLayout.Constraint(++row, 0, 0, 4, null));
            JComponent timingBar = this.createTimingBar(data2);
            timingBar.setName(OverviewTabContent.ID_TIMING);
            myFieldsPanel.add((Component)timingBar, new TabularLayout.Constraint(row, 2, 0, 4, null));
            return myFieldsPanel;
        }

        private final JComponent createTimingBar(ConnectionData data2) {
            JPanel panel2 = new JPanel();
            panel2.setLayout(new BoxLayout(panel2, 1));
            Range range = new Range((double)data2.getRequestStartTimeUs(), (double)(data2.getConnectionEndTimeUs() > 0L ? data2.getConnectionEndTimeUs() : data2.getRequestStartTimeUs() + 1L));
            ConnectionsStateChart connectionsChart = new ConnectionsStateChart(data2, range);
            connectionsChart.getComponent().setMinimumSize(new Dimension(0, JBUI.scale((int)28)));
            connectionsChart.setHeightGap(0.0f);
            panel2.add((Component)connectionsChart.getComponent());
            long sentTime = -1L;
            long receivedTime = -1L;
            if (data2.getResponseStartTimeUs() > 0L) {
                sentTime = data2.getResponseStartTimeUs() - data2.getRequestStartTimeUs();
                receivedTime = data2.getResponseCompleteTimeUs() - data2.getResponseStartTimeUs();
            } else if (data2.getConnectionEndTimeUs() > 0L) {
                sentTime = data2.getConnectionEndTimeUs() - data2.getRequestStartTimeUs();
                receivedTime = 0L;
            }
            FixedLegend sentLegend = new FixedLegend("Sent", (String)TIME_FORMATTER.apply(sentTime));
            FixedLegend receivedLegend = new FixedLegend("Received", (String)TIME_FORMATTER.apply(receivedTime));
            LegendComponentModel legendModel = new LegendComponentModel();
            legendModel.add((Legend)sentLegend);
            legendModel.add((Legend)receivedLegend);
            LegendComponent legendComponent = new LegendComponent.Builder(legendModel).setLeftPadding(0).setVerticalPadding(JBUI.scale((int)8)).build();
            Intrinsics.checkNotNullExpressionValue((Object)legendComponent, (String)"build(...)");
            LegendComponent legend = legendComponent;
            legend.configure((Legend)sentLegend, new LegendConfig(LegendConfig.IconType.BOX, connectionsChart.getColors().getColor((Enum)NetworkState.SENDING)));
            legend.configure((Legend)receivedLegend, new LegendConfig(LegendConfig.IconType.BOX, connectionsChart.getColors().getColor((Enum)NetworkState.RECEIVING)));
            panel2.add((Component)legend);
            return panel2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0012\u0010\n\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/details/OverviewTabContent$WrappedHyperlink;", "Ljavax/swing/JTextArea;", "url", "", "<init>", "(Ljava/lang/String;)V", "setBackground", "", "ignored", "Ljava/awt/Color;", "setFont", "Ljava/awt/Font;", "getMouseAdapter", "Ljava/awt/event/MouseAdapter;", "app-inspection.inspectors.network.view"})
    private static final class WrappedHyperlink
    extends JTextArea {
        public WrappedHyperlink(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            super(url);
            this.setLineWrap(true);
            this.setEditable(false);
            this.setBackground(UIUtil.getLabelBackground());
            this.setForeground(PlatformColors.BLUE);
            this.setFont((Font)JBFont.label().asPlain());
            MouseAdapter mouseAdapter2 = this.getMouseAdapter(url);
            this.addMouseListener(mouseAdapter2);
            this.addMouseMotionListener(mouseAdapter2);
        }

        @Override
        public void setBackground(@Nullable Color ignored) {
            super.setBackground(UIUtil.getLabelBackground());
        }

        @Override
        public void setFont(@Nullable Font ignored) {
            super.setFont((Font)JBFont.label().asPlain());
        }

        private final MouseAdapter getMouseAdapter(String url) {
            return new MouseAdapter(this, url){
                final /* synthetic */ WrappedHyperlink this$0;
                final /* synthetic */ String $url;
                {
                    this.this$0 = $receiver;
                    this.$url = $url;
                }

                public void mouseEntered(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.mouseMoved(e);
                }

                public void mouseExited(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.this$0.setCursor(Cursor.getDefaultCursor());
                }

                public void mouseClicked(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (this.isMouseOverText(e)) {
                        BrowserUtil.browse((String)this.$url);
                    }
                }

                public void mouseMoved(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.this$0.setCursor(this.isMouseOverText(e) ? Cursor.getPredefinedCursor(12) : Cursor.getDefaultCursor());
                }

                private final boolean isMouseOverText(MouseEvent e) {
                    return this.this$0.viewToModel2D(e.getPoint()) < this.this$0.getDocument().getLength();
                }
            };
        }
    }
}

