/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.assistant.view;

import com.android.tools.idea.assistant.ScrollHandler;
import com.android.tools.idea.assistant.TutorialCardRefreshNotifier;
import com.android.tools.idea.assistant.datamodel.FeatureData;
import com.android.tools.idea.assistant.datamodel.StepData;
import com.android.tools.idea.assistant.datamodel.TutorialBundleData;
import com.android.tools.idea.assistant.datamodel.TutorialData;
import com.android.tools.idea.assistant.view.CardViewPanel;
import com.android.tools.idea.assistant.view.FeaturesPanel;
import com.android.tools.idea.assistant.view.NavigationButton;
import com.android.tools.idea.assistant.view.TutorialStep;
import com.android.tools.idea.assistant.view.UIUtils;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.Box;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TutorialCard
extends CardViewPanel {
    @NotNull
    private final JBScrollPane myContentsScroller = new JBScrollPane();
    @NotNull
    private final TutorialData myTutorial;
    @NotNull
    private final Project myProject;
    @NotNull
    private final TutorialBundleData myBundle;
    @Nullable
    private final ScrollHandler myScrollHandler;
    private MessageBusConnection myConnection;
    private final boolean myHideChooserAndNavigationBar;
    private boolean myAdjustmentListenerInitialized;
    private int myStepIndex;
    private boolean myFirstTimeDrawn = false;

    TutorialCard(@NotNull FeaturesPanel featuresPanel, @NotNull TutorialData tutorial, @NotNull FeatureData feature, boolean hideChooserAndNavigationalBar, @NotNull TutorialBundleData bundle) {
        super(featuresPanel);
        this.myTutorial = tutorial;
        this.myProject = featuresPanel.getProject();
        this.myBundle = bundle;
        this.myHideChooserAndNavigationBar = hideChooserAndNavigationalBar;
        this.myStepIndex = 0;
        this.myScrollHandler = ScrollHandler.EP_NAME.getExtensionList().stream().filter(handler2 -> handler2.getId().equals(bundle.getBundleCreatorId())).findAny().orElse(null);
        if (!this.myHideChooserAndNavigationBar) {
            this.add((Component)new HeaderNav(feature.getName()), "North");
        }
        this.add((Component)this.myContentsScroller, "Center");
        if (this.myBundle.isStepByStep()) {
            this.add((Component)new StepByStepFooter(), "South");
        }
        if (!tutorial.shouldLoadLazily()) {
            this.myFirstTimeDrawn = true;
            this.redraw();
        }
    }

    @Override
    public void setVisible(boolean aFlag) {
        if (aFlag && !this.myFirstTimeDrawn) {
            this.myFirstTimeDrawn = true;
            this.redraw();
        }
        super.setVisible(aFlag);
        JScrollBar verticalScrollBar = this.myContentsScroller.getVerticalScrollBar();
        JScrollBar horizontalScrollBar = this.myContentsScroller.getHorizontalScrollBar();
        verticalScrollBar.setValue(verticalScrollBar.getMinimum());
        horizontalScrollBar.setValue(horizontalScrollBar.getMinimum());
        if (!this.myAdjustmentListenerInitialized) {
            this.myAdjustmentListenerInitialized = true;
            if (this.myScrollHandler != null) {
                this.myContentsScroller.getVerticalScrollBar().addAdjustmentListener(this::trackScrolledToBottom);
                if (!this.myContentsScroller.getVerticalScrollBar().isShowing()) {
                    this.myScrollHandler.scrolledToBottom(this.myProject);
                }
            }
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.myConnection != null) {
            this.myConnection.disconnect();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.myConnection = this.myProject.getMessageBus().connect();
        this.myConnection.subscribe(TutorialCardRefreshNotifier.TUTORIAL_CARD_TOPIC, stepNumberToShow -> this.refreshView(stepNumberToShow));
    }

    private void refreshView(int stepNumberToShow) {
        if (this.isVisible()) {
            this.redraw();
            if (stepNumberToShow > 0 && this.isViewportExpectedLayout((JScrollPane)this.myContentsScroller)) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.myContentsScroller.getHorizontalScrollBar().setValue(0);
                    int positionToSetTo = this.getVerticalScrollbarPosition(stepNumberToShow, (JScrollPane)this.myContentsScroller);
                    this.myContentsScroller.getVerticalScrollBar().setValue(positionToSetTo);
                });
            }
        }
    }

    @VisibleForTesting
    int getVerticalScrollbarPosition(int tutorialStepNumber, JScrollPane jScrollPane) {
        JPanel tutorialCardView = (JPanel)jScrollPane.getViewport().getComponent(0);
        return Arrays.stream(tutorialCardView.getComponents()).filter(c -> c instanceof TutorialStep).skip(tutorialStepNumber).map(Component::getY).findFirst().orElse(0);
    }

    @VisibleForTesting
    boolean isViewportExpectedLayout(JScrollPane scrollPane2) {
        return scrollPane2 != null && scrollPane2.getViewport() != null && scrollPane2.getViewport().getComponents().length > 0 && scrollPane2.getViewport().getComponent(0) instanceof JPanel;
    }

    private void trackScrolledToBottom(@NotNull AdjustmentEvent event) {
        if (this.myScrollHandler == null || event.getValueIsAdjusting()) {
            return;
        }
        BoundedRangeModel model = ((JScrollBar)event.getAdjustable()).getModel();
        if (model.getExtent() + event.getValue() >= model.getMaximum()) {
            this.myScrollHandler.scrolledToBottom(this.myProject);
        }
    }

    private void redraw() {
        JPanel contents = new JPanel();
        contents.setLayout(new GridBagLayout());
        contents.setOpaque(false);
        contents.setAlignmentX(0.0f);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 18;
        c.insets = JBUI.insetsBottom((int)5);
        JBLabel title2 = new JBLabel(this.myTutorial.getLabel());
        title2.setFont(title2.getFont().deriveFont(0, JBUIScale.scaleFontSize((float)24.0f)));
        title2.setBorder((Border)JBUI.Borders.empty((int)10, (int)10, (int)0, (int)10));
        if (this.myTutorial.getIcon() != null) {
            title2.setIcon(this.myTutorial.getIcon());
        }
        contents.add((Component)title2, c);
        ++c.gridy;
        if (this.myTutorial.getDescription() != null && !this.myTutorial.getDescription().isEmpty()) {
            TutorialDescription description2 = new TutorialDescription();
            StringBuilder sb = new StringBuilder();
            String descriptionContent = this.myTutorial.getDescription();
            if (this.myTutorial.hasLocalHTMLPaths()) {
                descriptionContent = UIUtils.addLocalHTMLPaths(this.myTutorial.getResourceClass(), descriptionContent);
            }
            sb.append("<p class=\"description\">").append(descriptionContent);
            if (this.myTutorial.getRemoteLink() != null && this.myTutorial.getRemoteLinkLabel() != null) {
                sb.append("<br><br><a href=\"").append(this.myTutorial.getRemoteLink()).append("\" target=\"_blank\">").append(this.myTutorial.getRemoteLinkLabel()).append("</a>");
            }
            sb.append("</p>");
            UIUtils.setHtml(description2, sb.toString(), ".description { margin: 10px;}");
            contents.add((Component)description2, c);
            ++c.gridy;
        }
        c.insets = JBUI.insets((int)0, (int)5, (int)0, (int)5);
        boolean hideStepIndex = this.myBundle.hideStepIndex();
        if (this.myBundle.isStepByStep()) {
            List<? extends StepData> steps = this.myTutorial.getSteps();
            if (!steps.isEmpty()) {
                contents.add((Component)new TutorialStep(steps.get(this.myStepIndex), this.myStepIndex, this.myListener, this.myProject, hideStepIndex, this.myTutorial.hasLocalHTMLPaths(), this.myTutorial.getResourceClass()), c);
                ++c.gridy;
            }
        } else {
            int numericLabel = 0;
            for (StepData stepData : this.myTutorial.getSteps()) {
                TutorialStep stepDisplay = new TutorialStep(stepData, numericLabel, this.myListener, this.myProject, hideStepIndex, this.myTutorial.hasLocalHTMLPaths(), this.myTutorial.getResourceClass());
                contents.add((Component)stepDisplay, c);
                ++c.gridy;
                ++numericLabel;
            }
        }
        GridBagConstraints glueConstraints = UIUtils.getVerticalGlueConstraints(c.gridy);
        contents.add(Box.createVerticalGlue(), glueConstraints);
        ++c.gridy;
        if (!this.myHideChooserAndNavigationBar) {
            c.insets = JBInsets.emptyInsets();
            contents.add((Component)new FooterNav(), c);
        }
        this.myContentsScroller.getVerticalScrollBar().setUnitIncrement(16);
        this.myContentsScroller.setViewportView((Component)contents);
        this.myContentsScroller.setBorder((Border)BorderFactory.createMatteBorder(1, 0, 0, 0, UIUtils.getSeparatorColor()));
        this.myContentsScroller.setViewportBorder(BorderFactory.createEmptyBorder());
        this.myContentsScroller.setOpaque(false);
        this.myContentsScroller.getViewport().setOpaque(false);
        this.myContentsScroller.setHorizontalScrollBarPolicy(30);
    }

    private class HeaderNav
    extends JPanel {
        public final String ROOT_TITLE;

        HeaderNav(String location) {
            super((LayoutManager)new HorizontalLayout(5, 0));
            this.ROOT_TITLE = "<html><b>" + TutorialCard.this.myBundle.getName() + "</b> &nbsp;&rsaquo;</html>";
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.add(new BackButton(this.ROOT_TITLE));
            JBLabel label2 = new JBLabel(location);
            label2.setForeground(UIUtils.getSecondaryColor());
            this.add((Component)label2);
        }
    }

    private class StepByStepFooter
    extends JPanel {
        @NotNull
        private final StepButton myPrevButton;
        @NotNull
        private final StepButton myNextButton;

        StepByStepFooter() {
            super(new BorderLayout());
            this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIUtils.getSeparatorColor()));
            this.setOpaque(false);
            JPanel containerPanel = new JPanel(new BorderLayout());
            containerPanel.setBorder(JBUI.Borders.empty((int)5));
            this.myPrevButton = new StepButton("Previous", StepButton.Direction.PREV, this::handleStepButtonClick);
            containerPanel.add((Component)this.myPrevButton, "Before");
            this.myNextButton = new StepButton("Next", StepButton.Direction.NEXT, this::handleStepButtonClick);
            containerPanel.add((Component)this.myNextButton, "After");
            this.add(containerPanel);
            this.updateVisibility();
        }

        private void handleStepButtonClick(@NotNull ActionEvent event) {
            Object source2 = event.getSource();
            StepButton stepButton = (StepButton)source2;
            if (stepButton.myDirection == StepButton.Direction.NEXT) {
                if (TutorialCard.this.myStepIndex < TutorialCard.this.myTutorial.getSteps().size() - 1) {
                    ++TutorialCard.this.myStepIndex;
                } else {
                    this.closeAssistant();
                }
            } else if (TutorialCard.this.myStepIndex > 0) {
                --TutorialCard.this.myStepIndex;
            }
            this.updateVisibility();
            TutorialCard.this.redraw();
            this.repaint();
        }

        private void closeAssistant() {
            ToolWindow assistantToolWindow = ToolWindowManager.getInstance((Project)TutorialCard.this.myProject).getToolWindow("Assistant");
            if (assistantToolWindow != null) {
                assistantToolWindow.hide();
            }
            TutorialCard.this.myStepIndex = 0;
        }

        private void updateVisibility() {
            this.myPrevButton.setVisible(TutorialCard.this.myStepIndex > 0);
            this.myNextButton.setText(TutorialCard.this.myStepIndex < TutorialCard.this.myTutorial.getSteps().size() - 1 ? "Next" : "Finish");
        }
    }

    private static class TutorialDescription
    extends JEditorPane {
        TutorialDescription() {
            this.setOpaque(false);
            this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIUtils.getSeparatorColor()));
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }
    }

    private class FooterNav
    extends JPanel {
        FooterNav() {
            super(new FlowLayout(3));
            this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIUtils.getSeparatorColor()));
            this.setOpaque(false);
            this.add(new BackButton("Back to " + TutorialCard.this.myBundle.getName()));
        }
    }

    private class BackButton
    extends NavigationButton {
        private BackButton(String label2) {
            super(label2, "studio_tutorial_chooser", TutorialCard.this.myListener);
            this.setIcon(AllIcons.Actions.Back);
            this.setHorizontalTextPosition(4);
            this.setContentAreaFilled(false);
            this.setBorderPainted(false);
            this.setBorder(null);
            this.setOpaque(false);
            this.setCursor(Cursor.getPredefinedCursor(12));
            Font font = new JBLabel().getFont();
            this.setFont(new Font(font.getFontName(), 0, font.getSize()));
        }
    }

    private static class StepButton
    extends NavigationButton {
        public Direction myDirection;

        private StepButton(@Nullable String label2, @NotNull Direction direction, @NotNull ActionListener listener2) {
            super(label2, "studio_tutorial_chooser", listener2);
            this.myDirection = direction;
            if (Direction.NEXT == direction) {
                this.setIcon(AllIcons.Actions.Forward);
                this.setHorizontalTextPosition(2);
            } else {
                this.setIcon(AllIcons.Actions.Back);
                this.setHorizontalTextPosition(4);
            }
            this.setCursor(Cursor.getPredefinedCursor(12));
            Font font = new JBLabel().getFont();
            this.setFont(font.deriveFont(0, font.getSize()));
        }

        public static enum Direction {
            NEXT,
            PREV;

        }
    }
}

