/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avd;

import com.android.sdklib.ISystemImage;
import com.android.sdklib.devices.Camera;
import com.android.sdklib.devices.CameraLocation;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.AvdBuilder;
import com.android.sdklib.internal.avd.BootMode;
import com.android.sdklib.internal.avd.BootSnapshot;
import com.android.sdklib.internal.avd.ColdBoot;
import com.android.sdklib.internal.avd.ExternalSdCard;
import com.android.sdklib.internal.avd.GenericSkin;
import com.android.sdklib.internal.avd.GpuMode;
import com.android.sdklib.internal.avd.InternalSdCard;
import com.android.sdklib.internal.avd.OnDiskSkin;
import com.android.sdklib.internal.avd.QuickBoot;
import com.android.sdklib.internal.avd.SdCard;
import com.android.tools.idea.avd.Boot;
import com.android.tools.idea.avd.Custom;
import com.android.tools.idea.avd.ExistingImage;
import com.android.tools.idea.avd.ExpandedStorage;
import com.android.tools.idea.avd.GraphicsMode;
import com.android.tools.idea.avd.GraphicsModeKt;
import com.android.tools.idea.avd.None;
import com.android.tools.idea.avd.StorageCapacity;
import com.android.tools.idea.avd.VirtualDevice;
import com.android.tools.idea.avdmanager.skincombobox.DefaultSkin;
import com.android.tools.idea.avdmanager.skincombobox.NoSkin;
import com.android.tools.idea.avdmanager.skincombobox.Skin;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\f\u0010\u0003\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0002\u001a\f\u0010\f\u001a\u00020\u000b*\u00020\nH\u0000\u001a\u000e\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u000fH\u0000\u001a\u000e\u0010\u0010\u001a\u00020\u000f*\u0004\u0018\u00010\u000eH\u0000\u001a\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u0013H\u0000\u001a\u000e\u0010\u0014\u001a\u00020\u0013*\u0004\u0018\u00010\u0012H\u0000\u001a\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0017H\u0000\u001a\f\u0010\u0018\u001a\u00020\u0017*\u00020\u0016H\u0000\u00a8\u0006\u0019"}, d2={"hasFrontCamera", "", "Lcom/android/sdklib/devices/Device;", "hasRearCamera", "copyFrom", "", "Lcom/android/sdklib/internal/avd/AvdBuilder;", "device", "Lcom/android/tools/idea/avd/VirtualDevice;", "toStorage", "Lcom/android/sdklib/devices/Storage;", "Lcom/android/tools/idea/avd/StorageCapacity;", "toStorageCapacity", "toSdCard", "Lcom/android/sdklib/internal/avd/SdCard;", "Lcom/android/tools/idea/avd/ExpandedStorage;", "toExpandedStorage", "toAvdSkin", "Lcom/android/sdklib/internal/avd/Skin;", "Lcom/android/tools/idea/avdmanager/skincombobox/Skin;", "toSkin", "toBootMode", "Lcom/android/sdklib/internal/avd/BootMode;", "Lcom/android/tools/idea/avd/Boot;", "toBoot", "intellij.android.avd"})
@SourceDebugExtension(value={"SMAP\nVirtualDevice.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualDevice.kt\ncom/android/tools/idea/avd/VirtualDeviceKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,252:1\n1761#2,3:253\n1761#2,3:256\n1#3:259\n*S KotlinDebug\n*F\n+ 1 VirtualDevice.kt\ncom/android/tools/idea/avd/VirtualDeviceKt\n*L\n153#1:253,3\n156#1:256,3\n*E\n"})
public final class VirtualDeviceKt {
    private static final boolean hasFrontCamera(Device $this$hasFrontCamera) {
        boolean bl;
        block3: {
            List list = $this$hasFrontCamera.getDefaultHardware().getCameras();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCameras(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Camera it = (Camera)element$iv;
                    boolean bl2 = false;
                    if (!(it.getLocation() == CameraLocation.FRONT)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean hasRearCamera(Device $this$hasRearCamera) {
        boolean bl;
        block3: {
            List list = $this$hasRearCamera.getDefaultHardware().getCameras();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCameras(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Camera it = (Camera)element$iv;
                    boolean bl2 = false;
                    if (!(it.getLocation() == CameraLocation.BACK)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final void copyFrom(@NotNull AvdBuilder $this$copyFrom, @NotNull VirtualDevice device2) {
        Intrinsics.checkNotNullParameter((Object)$this$copyFrom, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        $this$copyFrom.setDevice(device2.getDeviceProfile());
        $this$copyFrom.setDisplayName(device2.getName());
        $this$copyFrom.setSystemImage(device2.getImage());
        ExpandedStorage expandedStorage = device2.getExpandedStorage();
        if (expandedStorage == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        $this$copyFrom.setSdCard(VirtualDeviceKt.toSdCard(expandedStorage));
        $this$copyFrom.setSkin(VirtualDeviceKt.toAvdSkin(device2.getSkin()));
        $this$copyFrom.setEnvironment(device2.getEnvironment());
        $this$copyFrom.setScreenOrientation(device2.getOrientation());
        $this$copyFrom.setCpuCoreCount(device2.getCpuCoreCount());
        StorageCapacity storageCapacity = device2.getRam();
        if (storageCapacity == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        $this$copyFrom.setRam(VirtualDeviceKt.toStorage(storageCapacity));
        StorageCapacity storageCapacity2 = device2.getVmHeapSize();
        if (storageCapacity2 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        $this$copyFrom.setVmHeap(VirtualDeviceKt.toStorage(storageCapacity2));
        StorageCapacity storageCapacity3 = device2.getInternalStorage();
        if (storageCapacity3 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        $this$copyFrom.setInternalStorage(VirtualDeviceKt.toStorage(storageCapacity3));
        $this$copyFrom.setFrontCamera(device2.getFrontCamera());
        $this$copyFrom.setBackCamera(device2.getRearCamera());
        GraphicsMode graphicsMode = device2.getGraphicsMode();
        ISystemImage iSystemImage = device2.getImage();
        Intrinsics.checkNotNull((Object)iSystemImage);
        GpuMode gpuMode = GraphicsModeKt.toGpuMode(graphicsMode, iSystemImage);
        Intrinsics.checkNotNullExpressionValue((Object)gpuMode, (String)"toGpuMode(...)");
        $this$copyFrom.setGpuMode(gpuMode);
        $this$copyFrom.setNetworkSpeed(device2.getSpeed());
        $this$copyFrom.setNetworkLatency(device2.getLatency());
        $this$copyFrom.setBootMode(VirtualDeviceKt.toBootMode(device2.getDefaultBoot()));
        String preferredAbi = device2.getPreferredAbi();
        if (preferredAbi == null) {
            $this$copyFrom.getUserSettings().remove("abi.type.preferred");
        } else {
            $this$copyFrom.getUserSettings().put("abi.type.preferred", preferredAbi);
        }
    }

    private static final Storage toStorage(StorageCapacity $this$toStorage) {
        return new Storage($this$toStorage.getValue() * $this$toStorage.getUnit().getByteCount());
    }

    @NotNull
    public static final StorageCapacity toStorageCapacity(@NotNull Storage $this$toStorageCapacity) {
        Intrinsics.checkNotNullParameter((Object)$this$toStorageCapacity, (String)"<this>");
        Storage.Unit unit = $this$toStorageCapacity.getAppropriateUnits();
        long l = $this$toStorageCapacity.getSizeAsUnit(unit);
        String string = unit.getDisplayValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayValue(...)");
        return new StorageCapacity(l, StorageCapacity.Unit.valueOf(string));
    }

    @Nullable
    public static final SdCard toSdCard(@NotNull ExpandedStorage $this$toSdCard) {
        SdCard sdCard;
        Intrinsics.checkNotNullParameter((Object)$this$toSdCard, (String)"<this>");
        ExpandedStorage expandedStorage = $this$toSdCard;
        if (expandedStorage instanceof Custom) {
            sdCard = (SdCard)new InternalSdCard(((Custom)$this$toSdCard).getValue().valueIn(StorageCapacity.Unit.B));
        } else if (expandedStorage instanceof ExistingImage) {
            sdCard = (SdCard)new ExternalSdCard(((ExistingImage)$this$toSdCard).toString());
        } else if (Intrinsics.areEqual((Object)expandedStorage, (Object)None.INSTANCE)) {
            sdCard = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return sdCard;
    }

    @NotNull
    public static final ExpandedStorage toExpandedStorage(@Nullable SdCard $this$toExpandedStorage) {
        ExpandedStorage expandedStorage;
        SdCard sdCard = $this$toExpandedStorage;
        if (sdCard == null) {
            expandedStorage = None.INSTANCE;
        } else if (sdCard instanceof ExternalSdCard) {
            Path path = Path.of(((ExternalSdCard)$this$toExpandedStorage).getPath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            expandedStorage = new ExistingImage(path);
        } else if (sdCard instanceof InternalSdCard) {
            expandedStorage = new Custom(new StorageCapacity(((InternalSdCard)$this$toExpandedStorage).getSize(), StorageCapacity.Unit.B).withMaxUnit$intellij_android_avd());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return expandedStorage;
    }

    @Nullable
    public static final com.android.sdklib.internal.avd.Skin toAvdSkin(@NotNull Skin $this$toAvdSkin) {
        OnDiskSkin onDiskSkin;
        Intrinsics.checkNotNullParameter((Object)$this$toAvdSkin, (String)"<this>");
        Path path = $this$toAvdSkin.path();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path(...)");
        OnDiskSkin it = onDiskSkin = new OnDiskSkin(path);
        boolean bl = false;
        return (com.android.sdklib.internal.avd.Skin)(!Intrinsics.areEqual((Object)$this$toAvdSkin, (Object)NoSkin.INSTANCE) ? onDiskSkin : null);
    }

    @NotNull
    public static final Skin toSkin(@Nullable com.android.sdklib.internal.avd.Skin $this$toSkin) {
        Skin skin;
        com.android.sdklib.internal.avd.Skin skin2 = $this$toSkin;
        if (skin2 == null) {
            Skin skin3 = NoSkin.INSTANCE;
            skin = skin3;
            Intrinsics.checkNotNullExpressionValue((Object)skin3, (String)"INSTANCE");
        } else if (skin2 instanceof OnDiskSkin) {
            skin = new DefaultSkin(((OnDiskSkin)$this$toSkin).getPath());
        } else if (skin2 instanceof GenericSkin) {
            Skin skin4 = NoSkin.INSTANCE;
            skin = skin4;
            Intrinsics.checkNotNullExpressionValue((Object)skin4, (String)"INSTANCE");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return skin;
    }

    @NotNull
    public static final BootMode toBootMode(@NotNull Boot $this$toBootMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toBootMode), (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toBootMode.ordinal()]) {
            case 1 -> (BootMode)ColdBoot.INSTANCE;
            case 2 -> (BootMode)QuickBoot.INSTANCE;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final Boot toBoot(@NotNull BootMode $this$toBoot) {
        Boot boot2;
        Intrinsics.checkNotNullParameter((Object)$this$toBoot, (String)"<this>");
        BootMode bootMode = $this$toBoot;
        if (Intrinsics.areEqual((Object)bootMode, (Object)ColdBoot.INSTANCE)) {
            boot2 = Boot.COLD;
        } else if (Intrinsics.areEqual((Object)bootMode, (Object)QuickBoot.INSTANCE)) {
            boot2 = Boot.QUICK;
        } else if (bootMode instanceof BootSnapshot) {
            boot2 = Boot.QUICK;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return boot2;
    }

    public static final /* synthetic */ boolean access$hasFrontCamera(Device $receiver) {
        return VirtualDeviceKt.hasFrontCamera($receiver);
    }

    public static final /* synthetic */ boolean access$hasRearCamera(Device $receiver) {
        return VirtualDeviceKt.hasRearCamera($receiver);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Boot.values().length];
            try {
                nArray[Boot.COLD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Boot.QUICK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

