/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.SdkConstants;
import com.android.tools.idea.avdmanager.AccelerationErrorSolution;
import com.android.tools.idea.avdmanager.EmulatorAccelerationCheck;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import org.jetbrains.annotations.NotNull;

public enum AccelerationErrorCode {
    ALREADY_INSTALLED(0, "", AccelerationErrorSolution.SolutionCode.NONE, ""),
    NESTED_NOT_SUPPORTED(1, "HAXM is deprecated and should be uninstalled.", AccelerationErrorSolution.SolutionCode.NONE, "Please use the latest emulator and follow https://developer.android.com/studio/run/emulator-acceleration#vm-windows to configure WHPX or AEHD instead"),
    INTEL_REQUIRED(2, "HAXM is deprecated and should be uninstalled.", AccelerationErrorSolution.SolutionCode.NONE, "Please use the latest emulator and follow https://developer.android.com/studio/run/emulator-acceleration#vm-windows to configure WHPX or AEHD instead"),
    NO_CPU_SUPPORT(3, "Your CPU does not support required features (VT-x or SVM).", AccelerationErrorSolution.SolutionCode.NONE, "Unfortunately, your computer does not support hardware accelerated virtualization.\nHere are some of your options:\n 1) Use a physical device for testing\n 2) Develop on a Windows/OSX computer with an Intel processor that supports VT-x and NX\n 3) Develop on a Linux computer that supports VT-x or SVM\n 4) Use an Android Virtual Device based on an ARM system image\n   (This is 10x slower than hardware accelerated virtualization)\n"),
    NO_CPU_VTX_SUPPORT(4, "Your CPU does not support VT-x.", AccelerationErrorSolution.SolutionCode.NONE, "Unfortunately, your computer does not support hardware accelerated virtualization.\nHere are some of your options:\n 1) Use a physical device for testing\n 2) Develop on a Windows/OSX computer with an Intel processor that supports VT-x and NX\n 3) Develop on a Linux computer that supports VT-x or SVM\n 4) Use an Android Virtual Device based on an ARM system image\n   (This is 10x slower than hardware accelerated virtualization)\n"),
    NO_CPU_NX_SUPPORT(5, "Your CPU does not support NX.", AccelerationErrorSolution.SolutionCode.NONE, "Unfortunately, your computer does not support hardware accelerated virtualization.\nHere are some of your options:\n 1) Use a physical device for testing\n 2) Develop on a Windows/OSX computer with an Intel processor that supports VT-x and NX\n 3) Develop on a Linux computer that supports VT-x or SVM\n 4) Use an Android Virtual Device based on an ARM system image\n   (This is 10x slower than hardware accelerated virtualization)\n"),
    ACCELERATION_NOT_INSTALLED_LINUX(6, "KVM is not installed.", AccelerationErrorSolution.SolutionCode.INSTALL_KVM, "Enable Linux KVM for better emulation performance."),
    ACCELERATION_NOT_INSTALLED_WIN(6, "Android Emulator hypervisor driver is not installed.", AccelerationErrorSolution.SolutionCode.INSTALL_AEHD, "Install Android Emulator hypervisor driver for better emulation performance."),
    ACCELERATION_OBSOLETE(7, "Virtual machine acceleration driver is out-of-date.", AccelerationErrorSolution.SolutionCode.REINSTALL_AEHD, "Reinstall Android Emulator hypervisor driver."),
    DEV_NOT_FOUND_LINUX(8, "/dev/kvm is not found.", AccelerationErrorSolution.SolutionCode.NONE, "Enable VT-x in your BIOS security settings, ensure that your Linux distro has working KVM module."),
    DEV_NOT_FOUND_WIN(8, "Android Emulator hypervisor driver device is not found.", AccelerationErrorSolution.SolutionCode.NONE, "Enable VT-x in your BIOS security settings, ensure that Android Emulator hypervisor driver is installed properly. Try disabling 3rd party security software if the problem still occurs."),
    VT_DISABLED(9, "VT-x is disabled in BIOS.", AccelerationErrorSolution.SolutionCode.NONE, "Enable VT-x in your BIOS security settings (refer to documentation for your computer)."),
    NX_DISABLED(10, "NX is disabled in BIOS.", AccelerationErrorSolution.SolutionCode.NONE, "Enable NX in your BIOS settings (refer to documentation for your computer)."),
    DEV_PERMISSION_LINUX(11, "/dev/kvm device: permission denied.", AccelerationErrorSolution.SolutionCode.NONE, "Grant current user access to /dev/kvm"),
    DEV_PERMISSION_WIN(11, "Android Emulator hypervisor driver device: permission denied.", AccelerationErrorSolution.SolutionCode.REINSTALL_AEHD, "Reinstall Android Emulator hypervisor driver."),
    DEV_OPEN_FAILED_LINUX(12, "/dev/kvm device: open failed.", AccelerationErrorSolution.SolutionCode.NONE, "Grant current user access to /dev/kvm"),
    DEV_OPEN_FAILED_WIN(12, "Android Emulator hypervisor driver device: open failed.", AccelerationErrorSolution.SolutionCode.REINSTALL_AEHD, "Reinstall Android Emulator hypervisor driver."),
    DEV_IOCTL_FAILED_LINUX(13, "/dev/kvm device: ioctl denied.", AccelerationErrorSolution.SolutionCode.NONE, "Upgrade your kernel."),
    DEV_IOCTL_FAILED_WIN(13, "Android Emulator hypervisor driver device: ioctl denied.", AccelerationErrorSolution.SolutionCode.REINSTALL_AEHD, "Reinstall Android Emulator hypervisor driver."),
    DEV_OBSOLETE_LINUX(14, "KVM module is too old.", AccelerationErrorSolution.SolutionCode.NONE, "Upgrade your kernel."),
    DEV_OBSOLETE_WIN(14, "Virtual machine acceleration driver out-of-date.", AccelerationErrorSolution.SolutionCode.REINSTALL_AEHD, "Reinstall Android Emulator hypervisor driver."),
    HYPER_V_ENABLED(15, "Android Emulator is incompatible with Hyper-V.", AccelerationErrorSolution.SolutionCode.TURNOFF_HYPER_V, "Unfortunately, you cannot have Hyper-V running and use the emulator.\nHere is what you can do:\n  1) Start a command prompt as Administrator\n  2) Run the following command: C:\\Windows\\system32> bcdedit /set hypervisorlaunchtype off\n  3) Reboot your machine.\n"),
    EMULATOR_ERROR(138, "Accelerator Detection Problem.", AccelerationErrorSolution.SolutionCode.NONE, "Please file a bug against Android Studio."),
    UNKNOWN_ERROR(-1, "Unknown Error", AccelerationErrorSolution.SolutionCode.NONE, "Please file a bug against Android Studio."),
    NO_EMULATOR_INSTALLED(-2, "No emulator installed", AccelerationErrorSolution.SolutionCode.DOWNLOAD_EMULATOR, "Please download the emulator."),
    EMULATOR_UPDATE_REQUIRED(-3, "The currently installed emulator is no longer supported by this version of Android Studio.", AccelerationErrorSolution.SolutionCode.UPDATE_EMULATOR, "Please update the emulator to version " + String.valueOf(EmulatorAccelerationCheck.MINIMUM_EMULATOR_VERSION) + " or later."),
    NOT_ENOUGH_MEMORY(-4, "Not enough memory to run the AVD", AccelerationErrorSolution.SolutionCode.NONE, "Get more available memory for the AVD"),
    HAXM_REQUIRES_WINDOWS(-5, "HAXM is deprecated.", AccelerationErrorSolution.SolutionCode.NONE, "Please file a bug against Android Studio."),
    PLATFORM_TOOLS_UPDATE_ADVISED(-6, "Platform tools update is available", AccelerationErrorSolution.SolutionCode.UPDATE_PLATFORM_TOOLS, "Please download platform tools"),
    SYSTEM_IMAGE_UPDATE_ADVISED(-7, "System image update is available", AccelerationErrorSolution.SolutionCode.UPDATE_SYSTEM_IMAGES, "Please update system images"),
    HAXM_REQUIRES_INTEL_CPU(-8, "HAXM is deprecated and should be uninstalled.", AccelerationErrorSolution.SolutionCode.NONE, "Please use the latest emulator and follow https://developer.android.com/studio/run/emulator-acceleration#vm-windows to configure WHPX or AEHD instead"),
    AEHD_REQUIRES_WINDOWS(-9, "Android Emulator hypervisor driver can only be installed on Windows.", AccelerationErrorSolution.SolutionCode.NONE, "Please file a bug against Android Studio."),
    MACOS_VERSION_TOO_OLD(-10, "The Android Emulator requires macOS 12.7 or newer.", AccelerationErrorSolution.SolutionCode.NONE, "Please upgrade to a newer version of macOS.");

    private int myErrorCode;
    private String myProblem;
    private AccelerationErrorSolution.SolutionCode mySolution;
    private String mySolutionMessage;

    private AccelerationErrorCode(@NotNull int code, @NotNull String problem, AccelerationErrorSolution.SolutionCode solution, String solutionMessage) {
        this.myErrorCode = code;
        this.myProblem = problem;
        this.mySolution = solution;
        this.mySolutionMessage = solutionMessage;
    }

    public int getErrorCode() {
        return this.myErrorCode;
    }

    public String getProblem() {
        return this.myProblem;
    }

    void setProblem(String problem) {
        this.myProblem = problem;
    }

    public AccelerationErrorSolution.SolutionCode getSolution() {
        return this.mySolution;
    }

    public String getSolutionMessage() {
        return this.mySolutionMessage;
    }

    public static AccelerationErrorCode fromExitCode(int code) {
        switch (code) {
            case 0: {
                return ALREADY_INSTALLED;
            }
            case 3: {
                return NO_CPU_SUPPORT;
            }
            case 4: {
                return NO_CPU_VTX_SUPPORT;
            }
            case 5: {
                return NO_CPU_NX_SUPPORT;
            }
            case 6: {
                return SystemInfo.isLinux ? ACCELERATION_NOT_INSTALLED_LINUX : (SystemInfo.isWindows ? ACCELERATION_NOT_INSTALLED_WIN : UNKNOWN_ERROR);
            }
            case 8: {
                return SystemInfo.isLinux ? DEV_NOT_FOUND_LINUX : (SystemInfo.isWindows ? DEV_NOT_FOUND_WIN : UNKNOWN_ERROR);
            }
            case 9: {
                return VT_DISABLED;
            }
            case 10: {
                return NX_DISABLED;
            }
            case 11: {
                return SystemInfo.isLinux ? DEV_PERMISSION_LINUX : (SystemInfo.isWindows ? DEV_PERMISSION_WIN : UNKNOWN_ERROR);
            }
            case 12: {
                return SystemInfo.isLinux ? DEV_OPEN_FAILED_LINUX : (SystemInfo.isWindows ? DEV_OPEN_FAILED_WIN : UNKNOWN_ERROR);
            }
            case 13: {
                return SystemInfo.isLinux ? DEV_IOCTL_FAILED_LINUX : (SystemInfo.isWindows ? DEV_IOCTL_FAILED_WIN : UNKNOWN_ERROR);
            }
            case 14: {
                return SystemInfo.isLinux ? DEV_OBSOLETE_LINUX : (SystemInfo.isWindows ? DEV_OBSOLETE_WIN : UNKNOWN_ERROR);
            }
            case 15: {
                return HYPER_V_ENABLED;
            }
            case 134: {
                if (!SystemInfo.isMac || SystemInfo.isOsVersionAtLeast((String)"12.7")) break;
                return MACOS_VERSION_TOO_OLD;
            }
        }
        Logger.getInstance(AccelerationErrorCode.class).warn(SdkConstants.FN_EMULATOR_CHECK + " terminated with code " + code);
        return UNKNOWN_ERROR;
    }
}

