/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.repository.Revision;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoPackage;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.RemoteSystemImage;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.SystemImageTags;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SystemImageDescription {
    @NotNull
    private final ISystemImage systemImage;
    @Nullable
    private final RemotePackage remotePackage;

    private SystemImageDescription(@NotNull ISystemImage systemImage, @Nullable RemotePackage remotePackage) {
        Preconditions.checkArgument((remotePackage == null || SystemImageDescription.hasSystemImage((RepoPackage)remotePackage) ? 1 : 0) != 0);
        this.systemImage = systemImage;
        this.remotePackage = remotePackage;
    }

    public SystemImageDescription(@NotNull ISystemImage systemImage) {
        this(systemImage, null);
    }

    public SystemImageDescription(@NotNull RemotePackage remotePackage) {
        this((ISystemImage)new RemoteSystemImage(remotePackage), remotePackage);
    }

    public static boolean hasSystemImage(RepoPackage p) {
        TypeDetails details = p.getTypeDetails();
        if (!(details instanceof DetailsTypes.ApiDetailsType)) {
            return false;
        }
        int apiLevel = ((DetailsTypes.ApiDetailsType)details).getApiLevel();
        if (details instanceof DetailsTypes.SysImgDetailsType) {
            return true;
        }
        if (details instanceof DetailsTypes.PlatformDetailsType && apiLevel <= 13) {
            return true;
        }
        return details instanceof DetailsTypes.AddonDetailsType && ((DetailsTypes.AddonDetailsType)details).getVendor().getId().equals("google") && SystemImageTags.TAGS_WITH_GOOGLE_API.contains(((DetailsTypes.AddonDetailsType)details).getTag()) && apiLevel <= 19;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.systemImage, this.remotePackage});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SystemImageDescription)) {
            return false;
        }
        SystemImageDescription other = (SystemImageDescription)obj;
        return Objects.equal((Object)this.systemImage, (Object)other.systemImage) && Objects.equal((Object)this.remotePackage, (Object)other.remotePackage);
    }

    public boolean downloadedFrom(@NotNull SystemImageDescription other) {
        if (other.getRemotePackage() == null || this.remotePackage != null) {
            return false;
        }
        return Objects.equal((Object)this.getName(), (Object)other.getName()) && Objects.equal((Object)this.getVendor(), (Object)other.getVendor()) && Objects.equal(this.getAbiTypes(), other.getAbiTypes()) && Objects.equal(this.getTranslatedAbiTypes(), other.getTranslatedAbiTypes()) && Objects.equal(this.getTags(), other.getTags());
    }

    @NotNull
    public AndroidVersion getVersion() {
        return this.systemImage.getAndroidVersion();
    }

    @Nullable
    public RepoPackage getRemotePackage() {
        return this.remotePackage;
    }

    public boolean isRemote() {
        return this.remotePackage != null;
    }

    public boolean obsolete() {
        return this.systemImage.obsolete();
    }

    @NotNull
    public String getPrimaryAbiType() {
        return this.systemImage.getPrimaryAbiType();
    }

    @NotNull
    public @NotNull List<@NotNull String> getAbiTypes() {
        return this.systemImage.getAbiTypes();
    }

    @NotNull
    public @NotNull List<@NotNull String> getTranslatedAbiTypes() {
        return this.systemImage.getTranslatedAbiTypes();
    }

    @NotNull
    public @NotNull List<@NotNull IdDisplay> getTags() {
        return this.systemImage.getTags();
    }

    public boolean hasGoogleApis() {
        return this.systemImage.hasGoogleApis();
    }

    public boolean isWearImage() {
        return SystemImageTags.isWearImage(this.getTags());
    }

    public boolean isTvImage() {
        return SystemImageTags.isTvImage(this.getTags());
    }

    @NotNull
    public String getName() {
        String versionString = SdkVersionInfo.getVersionString((int)this.getVersion().getFeatureLevel());
        return String.format("Android %s", versionString == null ? "API " + this.getVersion().getApiStringWithExtension() : versionString);
    }

    @NotNull
    public String getVendor() {
        if (this.systemImage.getAddonVendor() != null) {
            return this.systemImage.getAddonVendor().getDisplay();
        }
        return "Android Open Source Project";
    }

    @NotNull
    public String getVersionName() {
        return SdkVersionInfo.getVersionString((int)this.systemImage.getAndroidVersion().getApiLevel());
    }

    @NotNull
    public Revision getRevision() {
        return this.systemImage.getRevision();
    }

    @NotNull
    public @NotNull List<@NotNull Path> getSkins() {
        return this.systemImage.getSkins();
    }

    @NotNull
    public ISystemImage getSystemImage() {
        return this.systemImage;
    }
}

