/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager.skincombobox;

import com.android.tools.idea.avdmanager.skincombobox.DefaultSkin;
import com.android.tools.idea.avdmanager.skincombobox.NoSkin;
import com.android.tools.idea.avdmanager.skincombobox.Skin;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractListModel;
import javax.swing.MutableComboBoxModel;
import org.jetbrains.annotations.NotNull;

public final class SkinComboBoxModel
extends AbstractListModel<Skin>
implements MutableComboBoxModel<Skin> {
    @NotNull
    private List<Skin> mySkins;
    @NotNull
    private Object mySelectedSkin;
    @NotNull
    private final Callable<Collection<Skin>> myCollect;
    @NotNull
    private final Function<SkinComboBoxModel, FutureCallback<Collection<Skin>>> myNewMerge;

    SkinComboBoxModel(@NotNull Callable<Collection<Skin>> collect) {
        this(collect, Merge::new);
    }

    @VisibleForTesting
    SkinComboBoxModel(@NotNull Collection<Skin> skins2) {
        this(skins2, List::of, model -> null);
    }

    @VisibleForTesting
    public SkinComboBoxModel(@NotNull Callable<Collection<Skin>> collect, @NotNull Function<SkinComboBoxModel, FutureCallback<Collection<Skin>>> newMerge) {
        this(List.of(NoSkin.INSTANCE), collect, newMerge);
    }

    private SkinComboBoxModel(@NotNull Collection<Skin> skins2, @NotNull Callable<Collection<Skin>> collect, @NotNull Function<SkinComboBoxModel, FutureCallback<Collection<Skin>>> newMerge) {
        this.mySkins = new ArrayList<Skin>(skins2);
        this.mySelectedSkin = NoSkin.INSTANCE;
        this.myCollect = collect;
        this.myNewMerge = newMerge;
    }

    void load() {
        ListenableFuture future2 = Futures.submit(this.myCollect, (Executor)AppExecutorUtil.getAppExecutorService());
        Futures.addCallback((ListenableFuture)future2, this.myNewMerge.apply(this), (Executor)EdtExecutorService.getInstance());
    }

    @NotNull
    public static @NotNull List<@NotNull Skin> merge(@NotNull @NotNull Collection<@NotNull Skin> skins1, @NotNull @NotNull Collection<@NotNull Skin> skins2) {
        Map<Path, Skin> map2 = Stream.concat(skins1.stream(), skins2.stream()).collect(Collectors.toMap(Skin::path, skin -> skin, Skin::merge));
        return map2.values().stream().sorted().collect(Collectors.toList());
    }

    @NotNull
    Skin getSkin(@NotNull Path path) {
        return this.mySkins.stream().filter(skin -> skin.path().equals(path)).findFirst().orElse(new DefaultSkin(path));
    }

    @VisibleForTesting
    @NotNull
    Object getSkins() {
        return this.mySkins;
    }

    @Override
    public int getSize() {
        return this.mySkins.size();
    }

    @Override
    @NotNull
    public Skin getElementAt(int index) {
        return this.mySkins.get(index);
    }

    @Override
    public void addElement(@NotNull Skin skin) {
        if (this.mySkins.contains(skin)) {
            return;
        }
        this.mySkins.add(skin);
        this.mySkins.sort(null);
        int index = this.mySkins.indexOf(skin);
        this.fireIntervalAdded(this, index, index);
    }

    @Override
    public void removeElement(@NotNull Object skin) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insertElementAt(@NotNull Skin skin, int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeElementAt(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSelectedItem(@NotNull Object selectedSkin) {
        Skin skin;
        assert (selectedSkin instanceof Skin && this.mySkins.contains(skin = (Skin)selectedSkin));
        this.mySelectedSkin = selectedSkin;
        this.fireContentsChanged(this, -1, -1);
    }

    @Override
    @NotNull
    public Object getSelectedItem() {
        return this.mySelectedSkin;
    }

    @VisibleForTesting
    static final class Merge
    implements FutureCallback<Collection<Skin>> {
        @NotNull
        private final SkinComboBoxModel myModel;

        @VisibleForTesting
        Merge(@NotNull SkinComboBoxModel model) {
            this.myModel = model;
        }

        public void onSuccess(@NotNull Collection<Skin> skins2) {
            this.myModel.mySkins = SkinComboBoxModel.merge(this.myModel.mySkins, skins2);
            this.myModel.fireContentsChanged(this.myModel, 0, this.myModel.mySkins.size() - 1);
        }

        public void onFailure(@NotNull Throwable throwable) {
            if (!(throwable instanceof CancellationException)) {
                Logger.getInstance(SkinComboBoxModel.class).warn(throwable);
            }
        }
    }
}

