/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager.ui;

import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceManager;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

final class DeviceSupplier {
    @NotNull
    private final Supplier<DeviceManagerConnection> myGetDefaultDeviceManagerConnection;

    DeviceSupplier() {
        this(DeviceManagerConnection::getDefaultDeviceManagerConnection);
    }

    @VisibleForTesting
    DeviceSupplier(@NotNull Supplier<DeviceManagerConnection> getDefaultDeviceManagerConnection) {
        this.myGetDefaultDeviceManagerConnection = getDefaultDeviceManagerConnection;
    }

    @NotNull
    Collection<Device> get() {
        DeviceManagerConnection connection2 = this.myGetDefaultDeviceManagerConnection.get();
        EnumSet<DeviceManager.DeviceCategory> systemImageFilter = EnumSet.of(DeviceManager.DeviceCategory.SYSTEM_IMAGES);
        Stream<Device> systemImageDevices = connection2.getDevices(systemImageFilter).stream().filter(Predicate.not(DeviceSupplier::isDeprecatedWearOsDevice));
        return Stream.concat(connection2.getDevices(EnumSet.complementOf(systemImageFilter)).stream(), systemImageDevices).collect(Collectors.toMap(Key::new, device2 -> device2, (oldDevice, newDevice) -> newDevice)).values();
    }

    private static boolean isDeprecatedWearOsDevice(@NotNull Device device2) {
        return !device2.getId().startsWith("wearos") && Objects.equals(device2.getTagId(), "android-wear");
    }

    private record Key(@NotNull String id, @NotNull String manufacturer) {
        private Key(@NotNull Device device2) {
            this(device2.getId(), device2.getManufacturer());
        }
    }
}

