/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager.ui;

import com.android.sdklib.devices.Device;
import com.ibm.icu.text.Collator;
import com.ibm.icu.util.ULocale;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public final class NameComparator
implements Comparator<Device> {
    @NotNull
    private final @NotNull Comparator<@NotNull Device> myComparator = Comparator.comparing(device2 -> SortKey.valueOfDevice(device2)).thenComparing(Device::getDisplayName, Collator.getInstance((ULocale)ULocale.ROOT).reversed()).thenComparing(Device::getId);

    @Override
    public int compare(@NotNull Device device1, @NotNull Device device2) {
        return this.myComparator.compare(device1, device2);
    }

    private static enum SortKey {
        SMALL_PHONE,
        MEDIUM_PHONE,
        MEDIUM_TABLET,
        DEVICE,
        PIXEL_10_PLUS_FAMILY,
        PIXEL_9_FAMILY,
        PIXEL_8_FAMILY,
        PIXEL_FOLD,
        PIXEL_2_to_7_FAMILY,
        PIXEL_1,
        OBSOLETE;


        @NotNull
        private static SortKey valueOfDevice(@NotNull Device device2) {
            String displayName;
            if (device2.getIsDeprecated()) {
                return OBSOLETE;
            }
            return switch (displayName = device2.getDisplayName()) {
                case "Small Phone" -> SMALL_PHONE;
                case "Medium Phone" -> MEDIUM_PHONE;
                case "Medium Tablet" -> MEDIUM_TABLET;
                case "Pixel XL", "Pixel" -> PIXEL_1;
                case "Pixel Fold" -> PIXEL_FOLD;
                default -> {
                    String prefix;
                    switch (prefix = displayName.length() >= 7 ? displayName.substring(0, 7) : "") {
                        case "Pixel 1": {
                            yield PIXEL_10_PLUS_FAMILY;
                        }
                        case "Pixel 9": {
                            yield PIXEL_9_FAMILY;
                        }
                        case "Pixel 8": {
                            yield PIXEL_8_FAMILY;
                        }
                        case "Pixel 7": 
                        case "Pixel 6": 
                        case "Pixel 5": 
                        case "Pixel 4": 
                        case "Pixel 3": 
                        case "Pixel 2": {
                            yield PIXEL_2_to_7_FAMILY;
                        }
                    }
                    yield DEVICE;
                }
            };
        }
    }
}

