/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding;

import com.android.ide.common.resources.ResourceItem;
import com.android.tools.idea.databinding.BindingLayoutToken;
import com.android.tools.idea.databinding.index.BindingLayoutType;
import com.android.tools.idea.databinding.index.BindingXmlData;
import com.android.tools.idea.databinding.index.BindingXmlIndex;
import com.android.tools.idea.databinding.util.DataBindingUtil;
import com.android.tools.idea.databinding.util.ViewBindingUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlFile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 &2\u00020\u0001:\u0002&'B1\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\b\u0010\u0018\u001a\u00020\u0017H\u0002J\u0006\u0010 \u001a\u00020\u0005J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010$\u001a\u00020%H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR\u0011\u0010\u001e\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001b\u00a8\u0006("}, d2={"Lcom/android/tools/idea/databinding/BindingLayout;", "", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "modulePackage", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "data", "Lcom/android/tools/idea/databinding/index/BindingXmlData;", "resource", "Lcom/android/ide/common/resources/ResourceItem;", "<init>", "(Lorg/jetbrains/android/facet/AndroidFacet;Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/android/tools/idea/databinding/index/BindingXmlData;Lcom/android/ide/common/resources/ResourceItem;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getData", "()Lcom/android/tools/idea/databinding/index/BindingXmlData;", "getResource$intellij_android_databinding", "()Lcom/android/ide/common/resources/ResourceItem;", "toXmlFile", "Lcom/intellij/psi/xml/XmlFile;", "bindingClassName", "Lcom/android/tools/idea/databinding/BindingLayout$BindingClassName;", "computeBindingClassName", "packageName", "getPackageName", "()Ljava/lang/String;", "className", "getClassName", "qualifiedClassName", "getQualifiedClassName", "getImplSuffix", "equals", "", "other", "hashCode", "", "Companion", "BindingClassName", "intellij.android.databinding"})
public final class BindingLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AndroidFacet facet;
    @NotNull
    private final String modulePackage;
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final BindingXmlData data;
    @NotNull
    private final ResourceItem resource;
    @NotNull
    private final BindingClassName bindingClassName;

    private BindingLayout(AndroidFacet facet, String modulePackage, VirtualFile file, BindingXmlData data2, ResourceItem resource) {
        this.facet = facet;
        this.modulePackage = modulePackage;
        this.file = file;
        this.data = data2;
        this.resource = resource;
        this.bindingClassName = this.computeBindingClassName();
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    @NotNull
    public final BindingXmlData getData() {
        return this.data;
    }

    @NotNull
    public final ResourceItem getResource$intellij_android_databinding() {
        return this.resource;
    }

    @Nullable
    public final XmlFile toXmlFile() {
        return DataBindingUtil.findXmlFile(this.facet.getModule().getProject(), this.file);
    }

    private final BindingClassName computeBindingClassName() {
        Object object;
        CharSequence charSequence = this.data.getCustomBindingName();
        if (charSequence == null || charSequence.length() == 0) {
            return new BindingClassName(this.modulePackage + ".databinding", DataBindingUtil.convertFileNameToJavaClassName(this.file.getName()) + "Binding");
        }
        String string = this.data.getCustomBindingName();
        Intrinsics.checkNotNull((Object)string);
        String customBindingName = string;
        int firstDotIndex = StringsKt.indexOf$default((CharSequence)customBindingName, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (firstDotIndex < 0) {
            return new BindingClassName(this.modulePackage + ".databinding", customBindingName);
        }
        int lastDotIndex = StringsKt.lastIndexOf$default((CharSequence)customBindingName, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (firstDotIndex == 0) {
            String string2 = customBindingName.substring(0, lastDotIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            object = this.modulePackage + string2;
        } else {
            String string3 = customBindingName.substring(0, lastDotIndex);
            object = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        }
        String packageName = object;
        String string4 = customBindingName.substring(lastDotIndex + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        String simpleClassName = string4;
        return new BindingClassName(packageName, simpleClassName);
    }

    @NotNull
    public final String getPackageName() {
        return this.bindingClassName.getPackageName();
    }

    @NotNull
    public final String getClassName() {
        return this.bindingClassName.getClassName();
    }

    @NotNull
    public final String getQualifiedClassName() {
        return this.bindingClassName.getQualifiedClassName();
    }

    @NotNull
    public final String getImplSuffix() {
        String string = this.file.getParent().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String folderName = string;
        return ((CharSequence)folderName).length() == 0 ? "Impl" : (StringsKt.startsWith$default((String)folderName, (String)"layout-", (boolean)false, (int)2, null) ? DataBindingUtil.convertFileNameToJavaClassName(StringsKt.substringAfter$default((String)folderName, (String)"layout-", null, (int)2, null)) + "Impl" : (StringsKt.startsWith$default((String)folderName, (String)"layout", (boolean)false, (int)2, null) ? "Impl" : DataBindingUtil.convertFileNameToJavaClassName(folderName) + "Impl"));
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof BindingLayout && Intrinsics.areEqual((Object)this.file.getPath(), (Object)((BindingLayout)other).file.getPath());
    }

    public int hashCode() {
        return this.file.getPath().hashCode();
    }

    public /* synthetic */ BindingLayout(AndroidFacet facet, String modulePackage, VirtualFile file, BindingXmlData data2, ResourceItem resource, DefaultConstructorMarker $constructor_marker) {
        this(facet, modulePackage, file, data2, resource);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/databinding/BindingLayout$BindingClassName;", "", "packageName", "", "className", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getPackageName", "()Ljava/lang/String;", "getClassName", "qualifiedClassName", "getQualifiedClassName", "intellij.android.databinding"})
    private static final class BindingClassName {
        @NotNull
        private final String packageName;
        @NotNull
        private final String className;

        public BindingClassName(@NotNull String packageName, @NotNull String className) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            this.packageName = packageName;
            this.className = className;
        }

        @NotNull
        public final String getPackageName() {
            return this.packageName;
        }

        @NotNull
        public final String getClassName() {
            return this.className;
        }

        @NotNull
        public final String getQualifiedClassName() {
            return this.packageName + "." + this.className;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/databinding/BindingLayout$Companion;", "", "<init>", "()V", "tryCreate", "Lcom/android/tools/idea/databinding/BindingLayout;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "resource", "Lcom/android/ide/common/resources/ResourceItem;", "intellij.android.databinding"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final BindingLayout tryCreate(@NotNull AndroidFacet facet, @NotNull ResourceItem resource) {
            Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            Module module = facet.getModule();
            Intrinsics.checkNotNullExpressionValue((Object)module, (String)"getModule(...)");
            String string = BindingLayoutToken.Companion.isTestModule(module) ? ProjectSystemUtil.getModuleSystem(facet).getTestPackageName() : ProjectSystemUtil.getModuleSystem(facet).getPackageName();
            if (string == null) {
                return null;
            }
            String modulePackage = string;
            VirtualFile virtualFile = IdeResourcesUtil.getSourceAsVirtualFile(resource);
            if (virtualFile == null) {
                return null;
            }
            VirtualFile file = virtualFile;
            Project project = facet.getModule().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            BindingXmlData bindingXmlData = BindingXmlIndex.Companion.getDataForFile(project, file);
            if (bindingXmlData == null) {
                return null;
            }
            BindingXmlData data2 = bindingXmlData;
            if (data2.getViewBindingIgnore() || data2.getLayoutType() == BindingLayoutType.PLAIN_LAYOUT && !ViewBindingUtil.isViewBindingEnabled(facet)) {
                return null;
            }
            return new BindingLayout(facet, modulePackage, file, data2, resource, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

