/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding.util;

import com.android.tools.idea.databinding.util.DataBindingUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BrUtil {
    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(BrUtil.class);
    }

    @NotNull
    public static Set<String> collectIds(@NotNull Collection<? extends PsiModifierListOwner> psiElements) {
        HashSet<String> properties = new HashSet<String>();
        for (PsiModifierListOwner psiModifierListOwner : psiElements) {
            String key = null;
            if (psiModifierListOwner instanceof PsiField) {
                key = DataBindingUtil.stripPrefixFromField((PsiField)psiModifierListOwner);
            } else if (psiModifierListOwner instanceof PsiMethod) {
                key = BrUtil.stripPrefixFromMethod((PsiMethod)psiModifierListOwner);
            }
            if (key == null) continue;
            properties.add(key);
        }
        return properties;
    }

    @Nullable
    private static String stripPrefixFromMethod(@NotNull PsiMethod psiMethod) {
        CharSequence propertyName;
        String name2 = psiMethod.getName();
        if (DataBindingUtil.isGetter(psiMethod) || DataBindingUtil.isSetter(psiMethod)) {
            propertyName = name2.subSequence(3, name2.length());
        } else if (DataBindingUtil.isBooleanGetter(psiMethod)) {
            propertyName = name2.subSequence(2, name2.length());
        } else {
            BrUtil.getLog().warn("@Bindable associated with a method must follow JavaBeans convention: " + psiMethod.getName());
            return null;
        }
        char firstChar = propertyName.charAt(0);
        return String.valueOf(Character.toLowerCase(firstChar)) + String.valueOf(propertyName.subSequence(1, propertyName.length()));
    }
}

