/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms;

import com.android.ddmlib.IDevice;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.tools.idea.ddms.DeviceNameProperties;
import com.android.tools.idea.ddms.DeviceNamePropertiesProvider;
import com.android.tools.idea.ddms.DeviceNameRendererEx;
import com.android.tools.idea.ddms.DevicePropertyUtil;
import com.google.common.collect.Sets;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import icons.StudioIcons;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.JList;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceRenderer {
    private DeviceRenderer() {
    }

    public static void renderDeviceName(@NotNull IDevice d, @NotNull DeviceNameProperties deviceProperties, @NotNull ColoredTextContainer component, boolean showSerialNumber) {
        DeviceRenderer.renderDeviceName(d, deviceProperties, component, showSerialNumber, null);
    }

    public static void renderDeviceName(@NotNull IDevice d, @NotNull DeviceNameProperties deviceNameProperties, @NotNull ColoredTextContainer component, boolean showSerialNumber, @Nullable AvdManager avdManager) {
        component.setIcon(d.isEmulator() ? StudioIcons.DeviceExplorer.VIRTUAL_DEVICE_PHONE : StudioIcons.DeviceExplorer.PHYSICAL_DEVICE_PHONE);
        String name2 = d.isEmulator() ? DeviceRenderer.getEmulatorDeviceName(d, avdManager) : DeviceRenderer.getDeviceName(deviceNameProperties);
        component.append(name2, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        IDevice.DeviceState deviceState2 = d.getState();
        if (deviceState2 != IDevice.DeviceState.ONLINE) {
            String state2 = String.format("%1$s [%2$s] ", d.getSerialNumber(), d.getState());
            component.append(state2, SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        } else if (showSerialNumber) {
            String state3 = String.format("%1$s ", d.getSerialNumber());
            component.append(state3, SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        }
        if (deviceState2 != IDevice.DeviceState.DISCONNECTED && deviceState2 != IDevice.DeviceState.OFFLINE) {
            component.append(DevicePropertyUtil.getBuild(deviceNameProperties.getBuildVersion(), null, deviceNameProperties.getApiLevel()), SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    @NotNull
    private static String getEmulatorDeviceName(@NotNull IDevice d, @Nullable AvdManager avdManager) {
        AvdInfo info;
        String avdName = d.getAvdName();
        if (avdManager != null && (info = avdManager.getAvd(avdName, true)) != null) {
            avdName = (String)info.getProperties().get("avd.ini.displayname");
        }
        if (avdName == null) {
            avdName = d.getSerialNumber();
        }
        return String.format("%1$s %2$s ", "Emulator", avdName);
    }

    @NotNull
    private static String getDeviceName(@NotNull DeviceNameProperties deviceNameProperties) {
        String manufacturer = DevicePropertyUtil.getManufacturer(deviceNameProperties.getManufacturer(), false, "");
        String model = DevicePropertyUtil.getModel(deviceNameProperties.getModel(), "");
        if (model.toUpperCase(Locale.US).startsWith(manufacturer.toUpperCase(Locale.US))) {
            return String.format("%1$s ", model);
        }
        return String.format("%1$s %2$s ", manufacturer, model);
    }

    public static boolean shouldShowSerialNumbers(@NotNull List<IDevice> devices2, @NotNull DeviceNamePropertiesProvider provider) {
        HashSet myNames = Sets.newHashSet();
        for (IDevice currentDevice : devices2) {
            if (currentDevice.isEmulator()) continue;
            String currentName = DeviceRenderer.getDeviceName(provider.get(currentDevice));
            if (myNames.contains(currentName)) {
                return true;
            }
            myNames.add(currentName);
        }
        return false;
    }

    public static class DeviceNameRenderer
    extends ColoredTableCellRenderer {
        private final DeviceNameRendererEx[] myRenderers = (DeviceNameRendererEx[])DeviceNameRendererEx.EP_NAME.getExtensions();
        private final AvdManager myAvdManager;
        private final DeviceNamePropertiesProvider myDeviceNamePropertiesProvider;

        public DeviceNameRenderer(@Nullable AvdManager avdManager, @NotNull DeviceNamePropertiesProvider deviceNamePropertiesProvider) {
            this.myAvdManager = avdManager;
            this.myDeviceNamePropertiesProvider = deviceNamePropertiesProvider;
        }

        protected void customizeCellRenderer(@NotNull JTable table2, Object value2, boolean selected, boolean hasFocus, int row, int column2) {
            if (!(value2 instanceof IDevice)) {
                return;
            }
            IDevice device2 = (IDevice)value2;
            for (DeviceNameRendererEx renderer2 : this.myRenderers) {
                if (!renderer2.isApplicable(device2)) continue;
                renderer2.render(device2, (ColoredTextContainer)this);
                return;
            }
            DeviceRenderer.renderDeviceName(device2, this.myDeviceNamePropertiesProvider.get(device2), (ColoredTextContainer)this, false, this.myAvdManager);
        }
    }

    static final class DeviceComboBoxRenderer
    extends ColoredListCellRenderer<IDevice> {
        @NotNull
        private String myEmptyText;
        private boolean myShowSerial;
        private DeviceNamePropertiesProvider myDeviceNamePropertiesProvider;

        DeviceComboBoxRenderer(@NotNull String emptyText2, boolean showSerial, @NotNull DeviceNamePropertiesProvider deviceNamePropertiesProvider) {
            this.myEmptyText = emptyText2;
            this.myShowSerial = showSerial;
            this.myDeviceNamePropertiesProvider = deviceNamePropertiesProvider;
        }

        public void setShowSerial(boolean showSerial) {
            this.myShowSerial = showSerial;
        }

        protected void customizeCellRenderer(@NotNull JList<? extends IDevice> list, IDevice value2, int index, boolean selected, boolean focused) {
            if (value2 == null) {
                this.append(this.myEmptyText, SimpleTextAttributes.ERROR_ATTRIBUTES);
                return;
            }
            DeviceRenderer.renderDeviceName(value2, this.myDeviceNamePropertiesProvider.get(value2), (ColoredTextContainer)this, this.myShowSerial);
        }
    }
}

