/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.debug;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.debug.DebuggerUtilsKt;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.D8;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.DexIndexedConsumer;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.ProgramConsumer;
import com.android.tools.r8.origin.Origin;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a?\u0010\u0000\u001a\u0004\u0018\u00010\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\"\u00020\tH\u0002\u00a2\u0006\u0002\u0010\n\u001a5\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\"\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u000e\u001a\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0002\u001a \u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002\u001a\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\u0017"}, d2={"loadClasses", "Lcom/sun/jdi/ClassType;", "cls", "Ljava/lang/Class;", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "inMemoryClassLoader", "additionalClassesToLoad", "", "", "(Ljava/lang/Class;Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;Lcom/sun/jdi/ClassType;[Ljava/lang/String;)Lcom/sun/jdi/ClassType;", "getBytes", "", "", "(Ljava/lang/Class;[Ljava/lang/String;)Ljava/util/Collection;", "fullyQualifiedClassNameToBinaryName", "name", "dex", "classesBytes", "findOrLoadInMemoryClassLoaderSafe", "wrapToByteBuffer", "Lcom/sun/jdi/ObjectReference;", "bytes", "intellij.android.debuggers"})
@SourceDebugExtension(value={"SMAP\nAndroidJdiHelperClassLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidJdiHelperClassLoader.kt\ncom/android/tools/idea/debug/AndroidJdiHelperClassLoaderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,185:1\n1563#2:186\n1634#2,2:187\n1636#2:190\n1#3:189\n*S KotlinDebug\n*F\n+ 1 AndroidJdiHelperClassLoader.kt\ncom/android/tools/idea/debug/AndroidJdiHelperClassLoaderKt\n*L\n113#1:186\n113#1:187,2\n113#1:190\n*E\n"})
public final class AndroidJdiHelperClassLoaderKt {
    private static final ClassType loadClasses(Class<?> cls, EvaluationContextImpl context, ClassType inMemoryClassLoader, String ... additionalClassesToLoad) {
        Method method2 = inMemoryClassLoader.concreteMethodByName("<init>", "(Ljava/nio/ByteBuffer;Ljava/lang/ClassLoader;)V");
        if (method2 == null) {
            return null;
        }
        Method constructorMethod = method2;
        Collection<byte[]> collection2 = AndroidJdiHelperClassLoaderKt.getBytes(cls, Arrays.copyOf(additionalClassesToLoad, additionalClassesToLoad.length));
        if (collection2 == null) {
            return null;
        }
        Collection<byte[]> classesBytes = collection2;
        byte[] byArray = AndroidJdiHelperClassLoaderKt.dex(context, classesBytes);
        if (byArray == null) {
            return null;
        }
        byte[] dexBytes = byArray;
        ObjectReference dexByteBuffer = AndroidJdiHelperClassLoaderKt.wrapToByteBuffer(dexBytes, context);
        Object[] objectArray = new ObjectReference[]{dexByteBuffer, context.getClassLoader()};
        ObjectReference objectReference = context.getDebugProcess().newInstance((EvaluationContext)context, inMemoryClassLoader, constructorMethod, CollectionsKt.listOf((Object[])objectArray));
        ClassLoaderReference classLoaderReference = objectReference instanceof ClassLoaderReference ? (ClassLoaderReference)objectReference : null;
        if (classLoaderReference == null) {
            return null;
        }
        ClassLoaderReference classLoader = classLoaderReference;
        context.keep((Value)classLoader);
        ReferenceType referenceType = context.getDebugProcess().findClass((EvaluationContext)context, cls.getName(), classLoader);
        return referenceType instanceof ClassType ? (ClassType)referenceType : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Collection<byte[]> getBytes(Class<?> cls, String ... additionalClassesToLoad) {
        void $this$mapTo$iv$iv;
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)cls.getName());
        spreadBuilder.addSpread((Object)additionalClassesToLoad);
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object;
            Collection collection2;
            block10: {
                block9: {
                    byte[] byArray;
                    void name2;
                    String string = (String)item$iv$iv;
                    collection2 = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)name2);
                    String resource = AndroidJdiHelperClassLoaderKt.fullyQualifiedClassNameToBinaryName((String)name2);
                    object = cls.getResourceAsStream(resource);
                    if (object == null) break block9;
                    Closeable closeable = (Closeable)object;
                    Throwable throwable = null;
                    try {
                        InputStream it = (InputStream)closeable;
                        boolean bl2 = false;
                        byArray = ByteStreamsKt.readBytes((InputStream)it);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    object = byArray;
                    if (byArray != null) break block10;
                }
                return null;
            }
            collection2.add(object);
        }
        List classesBytes = (List)destination$iv$iv;
        return classesBytes;
    }

    private static final String fullyQualifiedClassNameToBinaryName(String name2) {
        return "/" + StringsKt.replace$default((String)name2, (char)'.', (char)'/', (boolean)false, (int)4, null) + ".class";
    }

    private static final byte[] dex(EvaluationContextImpl context, Collection<byte[]> classesBytes) {
        try {
            D8Command.Builder builder = D8Command.builder();
            var consumer2 = new DexIndexedConsumer(){
                private byte[] encodedBytes;

                public final byte[] getEncodedBytes() {
                    return this.encodedBytes;
                }

                public final void setEncodedBytes(byte[] byArray) {
                    this.encodedBytes = byArray;
                }

                public void accept(int fileIndex, byte[] data2, Set<String> descriptors, DiagnosticsHandler handler2) {
                    Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                    Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
                    Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
                    if (this.encodedBytes != null) {
                        throw new IllegalStateException("Only one dex file is supported");
                    }
                    this.encodedBytes = data2;
                }

                public void finished(DiagnosticsHandler handler2) {
                    Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
                }
            };
            for (byte[] bytes2 : classesBytes) {
                builder.addClassProgramData(bytes2, Origin.unknown());
            }
            builder.setMode(CompilationMode.RELEASE);
            builder.setProgramConsumer((ProgramConsumer)consumer2);
            DebugProcessImpl debugProcessImpl = context.getDebugProcess();
            Intrinsics.checkNotNullExpressionValue((Object)debugProcessImpl, (String)"getDebugProcess(...)");
            IDevice iDevice = DebuggerUtilsKt.getConnectedDevice((DebugProcess)debugProcessImpl);
            builder.setMinApiLevel(iDevice != null && (iDevice = iDevice.getVersion()) != null && (iDevice = iDevice.getAndroidApiLevel()) != null ? iDevice.getMajorVersion() : 26);
            D8.run((D8Command)((D8Command)builder.build()));
            return consumer2.getEncodedBytes();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final ClassType findOrLoadInMemoryClassLoaderSafe(EvaluationContextImpl context) {
        ReferenceType referenceType;
        try {
            referenceType = context.getDebugProcess().findClass((EvaluationContext)context, "dalvik.system.InMemoryDexClassLoader", context.getClassLoader());
            referenceType = referenceType instanceof ClassType ? (ClassType)referenceType : null;
        }
        catch (Exception exception) {
            referenceType = null;
        }
        return referenceType;
    }

    private static final ObjectReference wrapToByteBuffer(byte[] bytes2, EvaluationContextImpl context) {
        ArrayReference arrayReference = DebuggerUtilsEx.mirrorOfByteArray((byte[])bytes2, (EvaluationContext)((EvaluationContext)context));
        Intrinsics.checkNotNullExpressionValue((Object)arrayReference, (String)"mirrorOfByteArray(...)");
        ArrayReference bytesMirror = arrayReference;
        DebugProcessImpl debugProcessImpl = context.getDebugProcess();
        Intrinsics.checkNotNullExpressionValue((Object)debugProcessImpl, (String)"getDebugProcess(...)");
        DebugProcessImpl debugProcess2 = debugProcessImpl;
        Mirror mirror = debugProcess2.findClass((EvaluationContext)context, "java.nio.ByteBuffer", context.getClassLoader());
        ClassType classType = mirror instanceof ClassType ? (ClassType)mirror : null;
        if (classType == null) {
            return null;
        }
        ClassType byteBufferClass = classType;
        Method method2 = byteBufferClass.concreteMethodByName("wrap", "([B)Ljava/nio/ByteBuffer;");
        if (method2 == null) {
            return null;
        }
        Method wrapMethod = method2;
        mirror = debugProcess2.invokeMethod((EvaluationContext)context, byteBufferClass, wrapMethod, CollectionsKt.listOf((Object)bytesMirror));
        return mirror instanceof ObjectReference ? (ObjectReference)mirror : null;
    }

    public static final /* synthetic */ ClassType access$findOrLoadInMemoryClassLoaderSafe(EvaluationContextImpl context) {
        return AndroidJdiHelperClassLoaderKt.findOrLoadInMemoryClassLoaderSafe(context);
    }

    public static final /* synthetic */ ClassType access$loadClasses(Class cls, EvaluationContextImpl context, ClassType inMemoryClassLoader, String ... additionalClassesToLoad) {
        return AndroidJdiHelperClassLoaderKt.loadClasses(cls, context, inMemoryClassLoader, additionalClassesToLoad);
    }
}

