/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.device.explorer;

import com.android.adblib.ConnectedDevice;
import com.android.adblib.ConnectedDeviceKt;
import com.android.annotations.concurrency.UiThread;
import com.android.sdklib.deviceprovisioner.DeviceHandle;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.concurrency.AndroidDispatchers;
import com.android.tools.idea.concurrency.CoroutineUtilsKt;
import com.android.tools.idea.device.explorer.DeviceExplorerModel;
import com.android.tools.idea.device.explorer.common.DeviceExplorerControllerListener;
import com.android.tools.idea.device.explorer.common.DeviceExplorerSettings;
import com.android.tools.idea.device.explorer.common.DeviceExplorerTabController;
import com.android.tools.idea.device.explorer.ui.DeviceExplorerView;
import com.android.tools.idea.device.explorer.ui.DeviceExplorerViewListener;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.DeviceExplorerEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0002#$B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0006\u0010\u0017\u001a\u00020\u0013J\u000e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001aJ\u0012\u0010\u001d\u001a\u00020\u00132\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/device/explorer/DeviceExplorerController;", "Lcom/intellij/openapi/Disposable;", "Lcom/android/tools/idea/device/explorer/common/DeviceExplorerControllerListener;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/android/tools/idea/device/explorer/DeviceExplorerModel;", "view", "Lcom/android/tools/idea/device/explorer/ui/DeviceExplorerView;", "tabControllers", "", "Lcom/android/tools/idea/device/explorer/common/DeviceExplorerTabController;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/device/explorer/DeviceExplorerModel;Lcom/android/tools/idea/device/explorer/ui/DeviceExplorerView;Ljava/util/List;)V", "uiThreadScope", "Lkotlinx/coroutines/CoroutineScope;", "viewListener", "Lcom/android/tools/idea/device/explorer/ui/DeviceExplorerViewListener;", "dispose", "", "packageFilterToggled", "isActive", "", "setup", "reportErrorFindingDevice", "message", "", "selectActiveDevice", "serialNumber", "setActiveDevice", "deviceHandle", "Lcom/android/sdklib/deviceprovisioner/DeviceHandle;", "trackAction", "action", "Lcom/google/wireless/android/sdk/stats/DeviceExplorerEvent$Action;", "ViewListener", "Companion", "intellij.android.device-explorer"})
@SourceDebugExtension(value={"SMAP\nDeviceExplorerController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceExplorerController.kt\ncom/android/tools/idea/device/explorer/DeviceExplorerController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1869#2,2:133\n1869#2,2:135\n*S KotlinDebug\n*F\n+ 1 DeviceExplorerController.kt\ncom/android/tools/idea/device/explorer/DeviceExplorerController\n*L\n63#1:133,2\n97#1:135,2\n*E\n"})
public final class DeviceExplorerController
implements Disposable,
DeviceExplorerControllerListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DeviceExplorerModel model;
    @NotNull
    private final DeviceExplorerView view;
    @NotNull
    private final List<DeviceExplorerTabController> tabControllers;
    @NotNull
    private final CoroutineScope uiThreadScope;
    @NotNull
    private final DeviceExplorerViewListener viewListener;
    @NotNull
    private static final Key<DeviceExplorerController> KEY;

    public DeviceExplorerController(@NotNull Project project, @NotNull DeviceExplorerModel model, @NotNull DeviceExplorerView view, @NotNull List<? extends DeviceExplorerTabController> tabControllers) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter(tabControllers, (String)"tabControllers");
        this.model = model;
        this.view = view;
        this.tabControllers = tabControllers;
        this.uiThreadScope = CoroutineUtilsKt.AndroidCoroutineScope((Disposable)this, (CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread()));
        this.viewListener = new ViewListener();
        Disposer.register((Disposable)((Disposable)project), (Disposable)this);
        this.view.addListener(this.viewListener);
        project.putUserData(KEY, (Object)this);
    }

    public void dispose() {
        this.view.removeListener(this.viewListener);
    }

    @Override
    public void packageFilterToggled(boolean isActive) {
        DeviceExplorerSettings.Companion.getInstance().setPackageFilterActive(isActive);
        this.trackAction(DeviceExplorerEvent.Action.APPLICATION_ID_FILTER_TOGGLED);
        this.trackAction(isActive ? DeviceExplorerEvent.Action.APPLICATION_ID_FILTER_TOGGLED_ON : DeviceExplorerEvent.Action.APPLICATION_ID_FILTER_TOGGLED_OFF);
        Iterable $this$forEach$iv = this.tabControllers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DeviceExplorerTabController it = (DeviceExplorerTabController)element$iv;
            boolean bl = false;
            it.setPackageFilter(isActive);
        }
    }

    public final void setup() {
        BuildersKt.launch$default((CoroutineScope)this.uiThreadScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ DeviceExplorerController this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$forEach$iv;
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                        DeviceExplorerController.access$getView$p(this.this$0).setup();
                        Iterable iterable = DeviceExplorerController.access$getTabControllers$p(this.this$0);
                        DeviceExplorerController deviceExplorerController = this.this$0;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            DeviceExplorerTabController it = (DeviceExplorerTabController)element$iv;
                            boolean bl = false;
                            it.setup();
                            it.setControllerListener(deviceExplorerController);
                            DeviceExplorerController.access$getView$p(deviceExplorerController).addTab(it.getViewComponent(), it.getTabName());
                        }
                        BuildersKt.launch$default((CoroutineScope)$this$launch, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ DeviceExplorerController this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = DeviceExplorerController.access$getView$p(this.this$0).trackDeviceListChanges((Continuation<? super Unit>)((Continuation)this));
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        BuildersKt.launch$default((CoroutineScope)$this$launch, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ DeviceExplorerController this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = DeviceExplorerController.access$getView$p(this.this$0).trackActiveDeviceChanges((Continuation<? super Unit>)((Continuation)this));
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void reportErrorFindingDevice(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.view.reportErrorGeneric(message, new IllegalStateException());
    }

    public final void selectActiveDevice(@NotNull String serialNumber) {
        Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
        BuildersKt.launch$default((CoroutineScope)this.uiThreadScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, serialNumber, null){
            int label;
            final /* synthetic */ DeviceExplorerController this$0;
            final /* synthetic */ String $serialNumber;
            {
                this.this$0 = $receiver;
                this.$serialNumber = $serialNumber;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var3_2 = (Iterable)DeviceExplorerController.access$getModel$p(this.this$0).getDevices().getValue();
                        var4_3 = this.$serialNumber;
                        var5_4 = var3_2;
                        for (T var7_6 : var5_4) {
                            it = (DeviceHandle)var7_6;
                            $i$a$-find-DeviceExplorerController$selectActiveDevice$1$device$1 = false;
                            v0 = it.getState().getConnectedDevice();
                            if (!Intrinsics.areEqual((Object)(v0 != null ? ConnectedDeviceKt.getSerialNumber((ConnectedDevice)v0) : null), (Object)var4_3)) continue;
                            v1 = var7_6;
                            ** GOTO lbl17
                        }
                        v1 = null;
lbl17:
                        // 2 sources

                        device = v1;
                        if (device == null) {
                            this.this$0.reportErrorFindingDevice("Unable to find device with serial number " + this.$serialNumber + ". Please retry.");
                        } else {
                            DeviceExplorerController.access$setActiveDevice(this.this$0, device);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void setActiveDevice(DeviceHandle deviceHandle) {
        this.model.setActiveDevice(deviceHandle);
        this.trackAction(DeviceExplorerEvent.Action.DEVICE_CHANGE);
        Iterable $this$forEach$iv = this.tabControllers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DeviceExplorerTabController it = (DeviceExplorerTabController)element$iv;
            boolean bl = false;
            it.setActiveConnectedDevice(deviceHandle);
        }
    }

    private final void trackAction(DeviceExplorerEvent.Action action2) {
        AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.DEVICE_EXPLORER).setDeviceExplorerEvent(DeviceExplorerEvent.newBuilder().setAction(action2));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setDeviceExplorerEvent(...)");
        UsageTracker.log((AndroidStudioEvent.Builder)builder);
    }

    @JvmStatic
    @Nullable
    public static final DeviceExplorerController getProjectController(@Nullable Project project) {
        return Companion.getProjectController(project);
    }

    public static final /* synthetic */ DeviceExplorerView access$getView$p(DeviceExplorerController $this) {
        return $this.view;
    }

    public static final /* synthetic */ List access$getTabControllers$p(DeviceExplorerController $this) {
        return $this.tabControllers;
    }

    public static final /* synthetic */ DeviceExplorerModel access$getModel$p(DeviceExplorerController $this) {
        return $this.model;
    }

    static {
        Key key = Key.create((String)DeviceExplorerController.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        KEY = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\t\u001a\u0004\u0018\u00010\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/device/explorer/DeviceExplorerController$Companion;", "", "<init>", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/android/tools/idea/device/explorer/DeviceExplorerController;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getProjectController", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.device-explorer"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final DeviceExplorerController getProjectController(@Nullable Project project) {
            Project project2 = project;
            return project2 != null ? (DeviceExplorerController)project2.getUserData(KEY) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/device/explorer/DeviceExplorerController$ViewListener;", "Lcom/android/tools/idea/device/explorer/ui/DeviceExplorerViewListener;", "<init>", "(Lcom/android/tools/idea/device/explorer/DeviceExplorerController;)V", "noDeviceSelected", "", "deviceSelected", "deviceHandle", "Lcom/android/sdklib/deviceprovisioner/DeviceHandle;", "intellij.android.device-explorer"})
    private final class ViewListener
    implements DeviceExplorerViewListener {
        @Override
        public void noDeviceSelected() {
            DeviceExplorerController.this.setActiveDevice(null);
        }

        @Override
        public void deviceSelected(@NotNull DeviceHandle deviceHandle) {
            Intrinsics.checkNotNullParameter((Object)deviceHandle, (String)"deviceHandle");
            DeviceExplorerController.this.setActiveDevice(deviceHandle);
        }
    }
}

